// Anime4K_Restore_CNN_UL
// Ported from https://github.com/bloc97/Anime4K/blob/4ba94b179a144200cb6b3052e690fe2ca5c6914c/glsl/Restore/Anime4K_Restore_CNN_UL.glsl

//!MAGPIE EFFECT
//!VERSION 4
//!SORT_NAME Anime4K_Restore_4


//!TEXTURE
Texture2D INPUT;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
Texture2D OUTPUT;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex1;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex2;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex3;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex4;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex5;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex6;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex7;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D tex8;

//!SAMPLER
//!FILTER POINT
SamplerState sam;


//!PASS 1
//!DESC Conv-4x3x3x3
//!IN INPUT
//!OUT tex1, tex2, tex3
//!BLOCK_SIZE 16
//!NUM_THREADS 64

void Pass1(uint2 blockStart, uint3 threadId) {
	uint2 gxy = (Rmp8x8(threadId.x) << 1) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	
    uint i, j;

	float3 src[4][4];
	[unroll]
	for (i = 0; i <= 2; i += 2) {
		[unroll]
		for (j = 0; j <= 2; j += 2) {
			float2 tpos = (gxy + uint2(i, j)) * inputPt;
			const float4 sr = INPUT.GatherRed(sam, tpos);
			const float4 sg = INPUT.GatherGreen(sam, tpos);
			const float4 sb = INPUT.GatherBlue(sam, tpos);

			// w z
			// x y
			src[i][j] = float3(sr.w, sg.w, sb.w);
			src[i][j + 1] = float3(sr.x, sg.x, sb.x);
			src[i + 1][j] = float3(sr.z, sg.z, sb.z);
			src[i + 1][j + 1] = float3(sr.y, sg.y, sb.y);
		}
	}

	[unroll]
	for (i = 1; i <= 2; ++i) {
		[unroll]
		for (j = 1; j <= 2; ++j) {
			uint2 destPos = gxy + uint2(i - 1, j - 1);

			if (i != 1 || j != 1) {
				if (destPos.x >= inputSize.x || destPos.y >= inputSize.y) {
					continue;
				}
			}

			float4 target1 = mul(src[i - 1][j - 1], float3x4(-0.28293434, -0.10095658, -0.013867814, 0.08509398, -0.31489053, -0.26828897, 0.01152665, 0.18905516, -0.23013242, -0.18878274, -0.17923735, -0.32707638));
			target1 += mul(src[i - 1][j], float3x4(-0.3519405, -0.12639853, 0.0981044, -0.23800656, -0.1666394, 0.2548722, -0.09458217, 0.17642984, -0.0016840132, -0.12355663, -0.13711694, 0.25234836));
			target1 += mul(src[i - 1][j + 1], float3x4(-0.14581299, -0.060752276, 0.06813433, 0.32616982, -0.29410994, 0.28217724, -0.2221963, -0.051627193, 0.10754401, 0.31993762, 0.25542948, -0.4268778));
			target1 += mul(src[i][j - 1], float3x4(0.2716687, -0.13160354, -0.056812827, -0.00881874, 0.3249303, 0.05037425, -0.117648534, -0.26370025, 0.032854702, -0.14214379, 0.10036965, 0.17808898));
			target1 += mul(src[i][j], float3x4(0.004323515, 0.37651265, -0.39865002, -0.18153298, 0.5224921, -0.11810103, 0.56151056, -0.063698344, -0.17272837, -0.053013492, 0.062254835, 0.28695017));
			target1 += mul(src[i][j + 1], float3x4(0.2776938, 0.22578415, 0.110299006, 0.27424663, 0.012712999, -0.22353122, -0.0010140019, 0.08163494, 0.3611274, 0.014346184, -0.26426178, -0.26777005));
			target1 += mul(src[i + 1][j - 1], float3x4(-0.09010997, 0.19958799, 0.22421049, 0.054506898, -0.11822318, 0.23656984, 0.11197124, -0.4646639, 0.17118955, 0.33748102, 0.20479581, 0.6810799));
			target1 += mul(src[i + 1][j], float3x4(0.2121316, -0.08664465, 0.2507115, -0.223455, 0.22042283, -0.20352642, 0.42714027, -0.5048447, -0.10270271, 0.11400399, -0.019575266, 0.40490857));
			target1 += mul(src[i + 1][j + 1], float3x4(0.091496244, -0.24679382, -0.3801941, -0.08482344, -0.17183328, -0.09308921, -0.059639163, 0.3321586, -0.19797249, -0.17941834, 0.015049101, -0.13793056));
			target1 += float4(-0.02313247, 0.016216148, -0.053347506, -0.023317637);

			float4 target2 = mul(src[i - 1][j - 1], float3x4(-0.44157687, 0.1715858, -0.11000502, 0.062367063, 0.21790773, 0.15507151, 0.14760862, -0.2598815, 0.14098467, 0.14019097, -0.26298222, 0.10975315));
			target2 += mul(src[i - 1][j], float3x4(0.15774319, -0.16769339, -0.49734345, -0.3935963, 0.115124024, -0.08045373, 0.55867237, 0.48593813, 0.058544844, -0.2705686, 0.3303555, 0.4181385));
			target2 += mul(src[i - 1][j + 1], float3x4(0.16588609, -0.013389144, 0.06600297, -0.09309111, -0.36321074, -0.13877828, 0.4099233, 0.20805255, 0.31892648, 0.16856939, -0.23898357, 0.11751563));
			target2 += mul(src[i][j - 1], float3x4(0.39999864, 0.46407622, -0.12249342, -0.09798957, 0.122675434, 0.18265116, 0.030651823, 0.14682484, -0.42969155, 0.2486042, 0.13566706, -0.13458017));
			target2 += mul(src[i][j], float3x4(-0.12757893, -0.19025628, -0.16728874, -0.10162156, -0.1577721, -0.174548, 0.29329458, 0.17963637, -0.43279588, 0.088979766, 0.06334896, -0.047701746));
			target2 += mul(src[i][j + 1], float3x4(-0.14359929, -0.12800618, -0.15429202, 0.034745168, 0.15794043, -0.086441815, -0.06520017, 0.26176664, -0.022253495, -0.34480432, -0.009120493, 0.08706416));
			target2 += mul(src[i + 1][j - 1], float3x4(-0.1994137, 0.070990525, 0.3388379, 0.37502727, -0.116911314, 0.2160554, -0.1831974, -0.04184975, 0.2545874, -0.083908126, -0.19057468, -0.13382773));
			target2 += mul(src[i + 1][j], float3x4(-0.46475947, -0.23414738, -0.036689937, 0.018558737, -0.32609373, 0.15265512, -0.055894423, -0.3676328, 0.24501368, 0.12390915, 0.13458043, -0.30162823));
			target2 += mul(src[i + 1][j + 1], float3x4(0.12621075, 0.046852987, 0.17333286, 0.18997045, 0.3245911, -0.28809196, -0.3660882, -0.5916272, -0.11456223, -0.030912774, 0.17037971, -0.12640971));
			target2 += float4(0.42778614, 0.054881692, -0.23388587, -0.031204376);

            float4 target3 = mul(src[i - 1][j - 1], float3x4(0.18228084, 0.25933146, 0.1764313, 0.23183075, -0.061067093, 0.34710985, -0.1785006, -0.06471029, -0.23235676, -0.43409523, -0.06639704, 0.30396065));
			target3 += mul(src[i - 1][j], float3x4(0.31676784, 0.21897513, 0.06466065, 0.42289257, 0.12306216, -0.3928633, 0.09720577, -0.10426061, -0.030383142, 0.03775265, 0.34221298, 0.3827705));
			target3 += mul(src[i - 1][j + 1], float3x4(-0.13229136, 0.37214845, -0.07046923, -0.17644346, 0.5591967, -0.5409525, 0.08944645, -0.047717415, 0.3754216, 0.2979604, -0.14149979, -0.1743562));
			target3 += mul(src[i][j - 1], float3x4(0.07603316, 0.10389099, 0.07042061, 0.24759614, 0.05822713, 0.29799607, -0.21219468, 0.3884128, -0.010661014, -0.5209726, 0.20311587, -0.39393));
			target3 += mul(src[i][j], float3x4(-0.17486575, -0.22572622, -0.13514778, 0.12839775, -0.25754005, 0.13090849, -0.16364887, 0.37675568, -0.05928962, 0.049174402, -0.37935108, -0.14333783));
			target3 += mul(src[i][j + 1], float3x4(0.15858985, -0.47485206, 0.4509964, 0.3877553, -0.04848657, 0.22396515, 0.33325925, -0.20703658, 0.14929648, 0.25580746, 0.2795224, -0.0158565));
			target3 += mul(src[i + 1][j - 1], float3x4(0.030926622, 0.16219522, -0.26666775, -0.27920142, -0.2693319, -0.29130983, -0.2795281, 0.22597994, 0.32512712, 0.16784063, -0.0113234315, -0.10118217));
			target3 += mul(src[i + 1][j], float3x4(-0.32426193, 0.0072339224, 0.08070994, -0.07735796, -0.09247539, 0.23327915, 0.09039661, -0.11836084, -0.2726992, -0.16031814, -0.28027415, -0.029263943));
			target3 += mul(src[i + 1][j + 1], float3x4(-0.20109104, -0.43383566, -0.33850962, -0.13422257, 0.040343326, -0.0819253, 0.26943803, -0.46652415, -0.3474102, 0.41198114, 0.14404535, 0.076806836));
			target3 += float4(-0.032911904, -0.0050934837, 0.021853646, -0.17256187);

			tex1[destPos] = target1;
			tex2[destPos] = target2;
            tex3[destPos] = target3;
		}
	}
}

//!PASS 2
//!DESC Conv-4x3x3x24
//!IN tex1, tex2, tex3
//!OUT tex4, tex5, tex6
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass2(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	float4 a1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d1 = tex1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e1 = tex1.SampleLevel(sam, pos, 0);
	float4 f1 = tex1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na1 = max(-a1, 0);
	float4 nb1 = max(-b1, 0);
	float4 nc1 = max(-c1, 0);
	float4 nd1 = max(-d1, 0);
	float4 ne1 = max(-e1, 0);
	float4 nf1 = max(-f1, 0);
	float4 ng1 = max(-g1, 0);
	float4 nh1 = max(-h1, 0);
	float4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	float4 a2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d2 = tex2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e2 = tex2.SampleLevel(sam, pos, 0);
	float4 f2 = tex2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na2 = max(-a2, 0);
	float4 nb2 = max(-b2, 0);
	float4 nc2 = max(-c2, 0);
	float4 nd2 = max(-d2, 0);
	float4 ne2 = max(-e2, 0);
	float4 nf2 = max(-f2, 0);
	float4 ng2 = max(-g2, 0);
	float4 nh2 = max(-h2, 0);
	float4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    float4 a3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d3 = tex3.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e3 = tex3.SampleLevel(sam, pos, 0);
	float4 f3 = tex3.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na3 = max(-a3, 0);
	float4 nb3 = max(-b3, 0);
	float4 nc3 = max(-c3, 0);
	float4 nd3 = max(-d3, 0);
	float4 ne3 = max(-e3, 0);
	float4 nf3 = max(-f3, 0);
	float4 ng3 = max(-g3, 0);
	float4 nh3 = max(-h3, 0);
	float4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	float4 target1 = mul(a1, float4x4(0.08648221, 0.012940912, 0.0694797, 0.021795172, 0.19547985, 0.019256733, -0.099714816, 0.08773751, 0.06443286, 0.08462334, 0.02924696, -0.07673487, 0.061156925, 0.12037308, -0.04778231, 0.010492923));
	target1 += mul(b1, float4x4(0.00033161003, -0.19050376, -0.14713565, -0.20729654, -0.122199036, 0.0044957534, 0.19240627, -0.1515226, 0.05051369, -0.08790857, -0.05331543, -0.13356556, -0.019020412, 0.06989371, -0.07270814, 0.06541199));
	target1 += mul(c1, float4x4(0.086689815, 0.08965917, 0.38167384, 0.31010604, 0.04204608, 0.095588356, -0.22810745, 0.112243816, 0.016992478, -0.16491304, -0.08901814, -0.038421903, -0.00041658967, -0.03551529, 0.097966395, -0.06240607));
	target1 += mul(d1, float4x4(0.13955353, -0.27422932, 0.14655617, -0.07651906, -0.07335902, -0.05214342, 0.35741827, 0.043639295, 0.041774176, -0.08277867, -0.028840896, -0.14434154, 0.029840615, -0.1444494, 0.0417388, -0.05095746));
	target1 += mul(e1, float4x4(-0.06985613, 0.036354948, -0.22372876, -0.268865, -0.07852222, -0.20930836, 0.06419149, 0.19363879, -0.00020227236, 0.04876036, 0.16503128, -0.05324255, 0.06806321, 0.2646995, -0.04032264, 0.06421368));
	target1 += mul(f1, float4x4(-0.16930926, 0.10122267, 0.0043684123, 0.14429477, -0.026909696, 0.028725943, 0.20114274, 0.09308162, -0.21070556, -0.13116634, 0.12419461, 0.29118228, -0.052020956, 0.18702126, 0.049802206, 0.09010561));
	target1 += mul(g1, float4x4(0.08972355, -0.076947, 0.2612936, 0.1700236, 0.21013896, -0.033608798, -0.16835962, -0.17834496, 0.050899435, -0.031109938, 0.066931866, 0.20528825, -0.024127234, -0.23103325, -0.14034404, 0.036399297));
	target1 += mul(h1, float4x4(0.058897257, 0.24295428, 0.5273254, -0.075384885, -0.03951092, 0.01945271, 0.2180824, -0.10192471, 0.04884028, 0.10811269, -0.056086104, -0.0177891, -0.15046783, -0.02886977, 0.012827891, -0.06317297));
	target1 += mul(i1, float4x4(0.08919534, 0.0142748635, 0.010994716, -0.116783954, -0.04848956, 0.12802334, -0.42647192, -0.047026183, -0.105416335, 0.014229579, -0.16081032, -0.1652654, 0.04367904, -0.21464449, 0.019457433, -0.053815585));
	target1 += mul(a2, float4x4(-0.033339895, -0.30358142, 0.03728797, -0.019257398, 0.041582108, -0.042878296, -0.16212925, 0.015385118, 0.1854467, -0.14912623, -0.10073306, 0.029578004, 0.0026831278, -0.1968894, -0.1447477, 0.013980874));
	target1 += mul(b2, float4x4(0.097215526, -0.27501073, 0.14077966, 0.07402363, 0.14528856, 0.26862413, -0.23837885, -0.19667485, 0.052117366, 0.012212545, 0.1311111, -0.05480854, 0.02206756, -0.09732581, -0.095444106, -0.12949228));
	target1 += mul(c2, float4x4(-0.0737551, -0.35384682, 0.13346575, -0.12573321, 0.12401249, -0.19727409, -0.022039715, -0.36438647, -0.17826872, -0.097721264, 0.10780637, -0.06372213, 0.078226656, -0.2319627, 0.06871096, -0.35198233));
	target1 += mul(d2, float4x4(0.016558306, -0.10755727, 0.07563601, 0.10631563, 0.006885377, 0.1507541, 0.028258704, 0.1609311, -0.026250815, 0.033572774, -0.0988431, 0.19565049, 0.024507977, 0.16839874, -0.19923483, 0.08130833));
	target1 += mul(e2, float4x4(-0.061187252, 0.09036177, -0.12626763, 0.036544666, 0.10568191, 0.087079406, 0.08745061, -0.10461285, 0.15552549, 0.25184712, -0.026420163, 0.028266618, 0.2387882, 0.20997152, -0.08588654, 0.19732232));
	target1 += mul(f2, float4x4(-0.057315756, 0.04398266, -0.203559, -0.10253955, -0.0009475058, -0.0786754, -0.051641934, -0.4047696, -0.057758473, -0.04819636, 0.053755116, -0.13864025, -0.165071, -0.14622927, 0.16270354, -0.11281594));
	target1 += mul(g2, float4x4(-0.023654325, 0.113905154, 0.0714336, 0.11184515, 0.12235184, 0.081852525, 0.2880535, 0.1926254, -0.01012154, 0.08924707, -0.06123374, 0.33078554, -0.14329071, 0.043857813, -0.09043615, 0.029145587));
	target1 += mul(h2, float4x4(0.023949241, 0.10680816, -0.07771331, 0.0008638595, 0.00088304427, 0.00707631, -0.029150054, 0.20421802, -0.051493708, 0.3196773, -0.0046316544, -0.08402997, -0.0020283381, 0.092219375, -0.21898057, 0.043405924));
	target1 += mul(i2, float4x4(0.10192696, 0.22852643, 0.024926228, 0.004321374, 0.1759848, -0.05959089, 0.03108929, -0.04175589, -0.032808244, -0.002723809, 0.11427024, -0.11884058, 0.085039005, -0.11861457, -0.041716687, 0.0049884217));
	target1 += mul(a3, float4x4(-0.08531041, 0.031572983, -0.010317835, -0.058514126, -0.028372116, 0.3587181, 0.07155074, -0.018486004, 0.11271158, 0.12346037, 0.14474016, -0.091422975, 0.046279423, -0.19440787, -0.040767148, -0.11089926));
	target1 += mul(b3, float4x4(-0.118612625, 0.036904, 0.040823236, 0.0006029242, -0.055478334, 0.065328576, -0.26563334, 0.14299026, 0.039150115, 0.17624554, 0.085402936, -0.007749703, 0.045554906, -0.051315133, -0.0989155, 0.023874454));
	target1 += mul(c3, float4x4(-0.08904957, 0.13246936, -0.1362266, 0.075549126, 0.015976984, -0.078003414, 0.27895245, -0.1714908, 0.05061789, 0.05510105, -0.011142018, 0.13279557, 0.122630805, 0.12880847, 0.2334916, 0.450533));
	target1 += mul(d3, float4x4(0.13635479, 0.12008325, 0.13332775, -0.1923403, 0.061475966, 0.12471921, 0.1438346, -0.30003113, 0.16227812, -0.011259031, -0.15664785, 0.082009956, 0.15664162, -0.14316271, 0.10871211, -0.23067066));
	target1 += mul(e3, float4x4(-0.17403863, -0.100490384, -0.056628566, 0.056505267, 0.03132433, 0.02990612, -0.023741463, -0.2221617, -0.023024872, -0.17946845, -0.014884968, 0.09488175, -0.08467482, -0.18569513, -0.08882533, -0.096383005));
	target1 += mul(f3, float4x4(0.036448594, 0.008876679, 0.082974724, -0.07486944, -0.1466638, -0.17435108, -0.08396226, 0.05346215, -0.13232903, -0.07391497, 0.19908291, 0.059030067, -0.017662045, 0.020650625, -0.20734224, 0.20043914));
	target1 += mul(g3, float4x4(-0.03861711, 0.06406407, 0.05915599, -0.0029750194, 0.046107147, -0.23294666, 0.019285874, 0.11214502, -0.05762434, -0.043726444, 0.010243058, -0.013164875, 0.033796065, -0.027231356, 0.18135343, -0.06158567));
	target1 += mul(h3, float4x4(-0.0061139134, 0.08773726, 0.05263668, -0.017488463, -0.021532185, -0.06330985, 0.03339514, 0.29500782, 0.19531941, -0.0625388, -0.0988155, 0.029160276, -0.14122078, -0.18272889, 0.035498794, -0.09119196));
	target1 += mul(i3, float4x4(0.21229745, -0.13745296, -0.02434639, 0.018458553, 0.1591066, 0.057361145, -0.034690984, -0.06146371, -0.2245296, -0.14576864, 0.053850707, -0.08887415, -0.17651638, 0.14863127, -0.07008009, 0.009406358));
	target1 += mul(na1, float4x4(-0.09558068, 0.08203744, 0.09736194, -0.08479601, -0.07671097, -0.13729817, 0.15081742, -0.107025385, -0.13094948, -0.11489214, 0.08040859, 0.18286897, -0.06001431, -0.16890974, -0.034702767, 0.06418509));
	target1 += mul(nb1, float4x4(-0.057768498, 0.121774144, 0.09370627, 0.04913383, 0.07690142, 0.0735232, 0.22072591, 0.023539443, 0.05777623, 0.32322824, 0.3281115, 0.08541682, 0.027571213, 0.08204197, -0.036617927, -0.11496138));
	target1 += mul(nc1, float4x4(0.10667931, 0.060036145, 0.17550562, 0.0036066761, -0.1475781, -0.0125017725, 0.1585272, -0.30022824, 0.020694837, 0.041336745, 0.34374732, 0.11649956, 0.0702352, 0.10661717, -0.018115027, 0.066765435));
	target1 += mul(nd1, float4x4(-0.031910367, 0.08394783, -0.12302906, 0.080788575, 0.056613773, 0.13485114, 0.14046827, -0.0015214924, -0.27299604, 0.043092493, 0.0110908365, 0.0120844785, 0.13837345, 0.14274547, -0.07037318, 0.073410094));
	target1 += mul(ne1, float4x4(0.11933822, -0.019749384, -0.14604573, 0.23067194, 0.07458434, 0.19018115, -0.09794594, -0.028165665, 0.34246337, -0.15636346, 0.2909177, 0.049812693, 0.002857417, -0.15300918, 0.28885588, -0.017372042));
	target1 += mul(nf1, float4x4(0.017289294, -0.034632802, 0.21390542, -0.010042412, -0.041615892, -0.08253338, -0.30123362, -0.19299945, 0.25370637, 0.093409844, -0.09362771, -0.17982802, -0.031628486, -0.09360746, 0.13314822, -0.034462616));
	target1 += mul(ng1, float4x4(0.106429726, 0.016680025, -0.0529926, -0.17085713, -0.22584449, -0.07722329, 0.30886117, 0.10528744, 0.010045352, 0.099818386, -0.1433606, -0.24887395, -0.04677741, 0.113051936, -0.062035765, -0.03359467));
	target1 += mul(nh1, float4x4(-0.10257249, -0.16084161, -0.058020744, 0.096825816, 0.19502446, -0.12214713, 0.078723475, 0.124732524, -0.15987179, -0.110849984, 0.1198203, 0.018647604, 0.114340924, -0.027776286, -0.07801131, 0.022275787));
	target1 += mul(ni1, float4x4(0.20298952, -0.069290765, 0.018832127, -0.17501442, 0.32367796, -0.20510589, 0.15283914, 0.16110845, 0.23468657, 0.12490908, 0.0031354423, 0.33064207, -0.089915626, 0.16466871, -0.2302326, 0.008596628));
	target1 += mul(na2, float4x4(0.07267445, 0.13096274, -0.22805755, -0.03723183, 0.055223588, -0.005618507, -0.022076515, -0.07149474, -0.121041514, 0.22917031, 0.066897914, -0.07756685, 0.024709817, 0.009276744, 0.014564059, 0.057168677));
	target1 += mul(nb2, float4x4(0.12088462, -0.21629183, -0.01628627, 0.13085558, 0.09959188, -0.26857927, 0.099242754, -0.014361698, -0.06972168, 0.01484912, -0.14507025, 0.036060054, 0.010170308, -0.038049888, -0.009749429, 0.02627631));
	target1 += mul(nc2, float4x4(0.014381424, -0.08200522, 0.016342247, -0.05138454, -0.048430134, 0.14594877, -0.3555319, 0.031946313, 0.10650339, 0.18046476, -0.24730566, 0.1373742, -0.119868465, 0.09006262, -0.043326948, 0.14803706));
	target1 += mul(nd2, float4x4(0.041357175, 0.018529125, -0.10729679, -0.048498925, -0.10630771, -0.1541114, -0.033143718, -0.22726057, -0.07868649, -0.13653874, 0.17372914, -0.12425049, 0.20172423, -0.13046068, 0.043416902, 0.022640392));
	target1 += mul(ne2, float4x4(0.0996741, -0.2517156, 0.19852571, -0.0021035601, 0.10721118, -0.05211148, -0.19747794, -0.09467657, -0.023530629, -0.3026388, 0.18776762, -0.083951, -0.23070371, -0.29687774, 0.19042933, 0.082099915));
	target1 += mul(nf2, float4x4(-0.14246128, -0.11360154, 0.042512555, 0.050347224, 0.15101464, 0.096761174, -0.09809747, 0.18949512, 0.08265103, 0.10818854, -0.06522224, 0.20080575, 0.04467876, 0.16536511, -0.17993684, 0.00630444));
	target1 += mul(ng2, float4x4(-0.06804489, -0.08932311, 0.11452633, -0.1371827, -0.038583722, -0.044566132, 0.11590918, 0.06928946, 0.09499521, -0.28891554, -0.039033752, -0.24065344, -0.008447823, -0.22869939, -0.1481265, -0.14827704));
	target1 += mul(nh2, float4x4(-0.040538706, -0.16607454, 0.066053875, -0.13771453, -0.26502058, -0.090013534, 0.10899838, 0.035818875, -0.025965845, -0.38602746, 0.11832495, -0.05114795, -0.0024577992, -0.131609, 0.031598363, 0.03701916));
	target1 += mul(ni2, float4x4(-0.058901474, -0.32447273, -0.009171959, 0.0660178, -0.060969505, 0.032002755, 0.1673554, 0.08129589, -0.027818324, 0.11499822, 0.047595307, 0.1351946, -0.10076986, 0.109632365, -0.15808961, -0.082471184));
	target1 += mul(na3, float4x4(0.11876087, 0.01871506, -0.15440665, 0.030330261, 0.0027066949, -0.14246738, 0.07165973, 0.01423915, -0.06284659, -0.21748444, -0.09141415, 0.0077323355, 0.0007271684, 0.1327971, 0.021298295, 0.029493187));
	target1 += mul(nb3, float4x4(-0.10310914, -0.07170663, -0.2685449, -0.15668112, 0.10965974, -0.027063346, 0.15944144, -0.16771634, -0.08454698, -0.12480185, 0.17647612, 0.17139068, -0.09694541, 0.14676706, 0.1353608, 0.11373892));
	target1 += mul(nc3, float4x4(-0.0808586, -0.02986483, 0.23335268, -0.05220655, -0.21456684, 0.089947656, -0.2306551, 0.23438993, -0.26377395, -0.00432009, -0.002377239, -0.0024554976, -0.11019007, -0.0772975, -0.119338326, -0.42517295));
	target1 += mul(nd3, float4x4(0.10294163, -0.024664093, 0.019653833, 0.034689307, 0.05632113, -0.31289428, -0.08254052, 0.13217352, 0.15772913, -0.09128828, -0.012524978, -0.06561359, -0.13107683, 0.23463258, -0.18762761, 0.22209615));
	target1 += mul(ne3, float4x4(0.06301127, 0.12489633, 0.025658585, -0.09527329, 0.009095258, -0.2463554, -0.0047031543, 0.119088694, 0.14065374, 0.19576642, 0.26679346, 0.03845879, 0.13757762, 0.10764672, -0.046270162, -0.11690896));
	target1 += mul(nf3, float4x4(-0.04519331, 0.002319274, -0.0704514, 0.029526047, 0.13251334, 0.2868927, -0.06838931, 0.11092056, 0.15345666, 0.16911614, 0.06869024, -0.03073747, 0.065442406, 0.018865792, 0.081815384, -0.20803072));
	target1 += mul(ng3, float4x4(0.06323602, -0.010242011, 0.10209268, -0.04929, -0.006704608, 0.30939466, 0.1744392, -0.10929571, -0.493058, -0.13673118, -0.12486283, -0.41315997, -0.036514506, 0.0937269, -0.16995876, 0.15627468));
	target1 += mul(nh3, float4x4(-0.13764359, -0.028645532, 0.006338959, 0.058005866, 0.08327983, 0.17576805, 0.17758359, -0.16738725, -0.26176876, 0.07402525, -0.02212828, 0.16919926, 0.3348425, 0.032946147, 0.09707724, 0.10009711));
	target1 += mul(ni3, float4x4(-0.2091657, 0.068191156, 0.09357867, -0.05217846, -0.1104997, 0.05062617, 0.016883407, -0.053662494, 0.24314725, 0.19810323, -0.065943204, 0.25030002, 0.08373754, -0.16690144, 0.03141188, -0.101124324));
	target1 += float4(-0.08736043, 0.2861529, -0.005863071, -0.004482026);
	
	float4 target2 = mul(a1, float4x4(0.04347682, -0.042527717, 0.057372455, 0.25276724, -0.057298373, 0.16023909, 0.21286428, -0.022668337, -0.21247427, -0.14335708, 0.19040126, 0.08368367, 0.0033008587, 0.03252031, -0.1777948, -0.082336985));
	target2 += mul(b1, float4x4(-0.12568378, -0.08425814, 0.004957988, -0.12844385, 0.055799566, 0.21515216, -0.20364483, -0.05265174, -0.011742827, -0.053792574, -0.15443824, 0.007910115, -0.045762774, 0.03763922, 0.014743974, -0.07495264));
	target2 += mul(c1, float4x4(0.095623426, 0.118021496, -0.3646953, 0.22952312, -0.06988015, 0.07823983, 0.10331074, 0.18235193, 0.10575183, 0.017832384, 0.099051595, -0.16202737, -0.065919116, -0.027154202, 0.19286686, -0.41187564));
	target2 += mul(d1, float4x4(-0.18027067, -0.15459284, -0.5194294, 0.15895993, -0.19545266, 0.11350413, 0.08665067, 0.053280413, -0.07407145, -0.04798788, -0.13345626, 0.1258462, 0.047066033, -0.040642574, 0.08591159, -0.10039696));
	target2 += mul(e1, float4x4(-0.080157764, 0.22366004, 0.17739227, 0.033781976, -0.045201484, -0.047641475, -0.07896631, -0.08679443, 0.10642969, 0.06992287, 0.041175313, -0.16435929, 0.15798622, -0.004883945, 0.08247824, -0.056977544));
	target2 += mul(f1, float4x4(-0.05262759, 0.015417186, 0.108641304, 0.005705979, -0.013303744, -0.016400715, -0.24967128, -0.13471037, 0.07906222, 0.07200451, 0.12428817, -0.05694691, -0.022635266, -0.08490837, -0.01682493, 0.08025121));
	target2 += mul(g1, float4x4(0.4013514, -0.09885115, -0.13964225, 0.0066076894, 0.035656366, -0.061563164, 0.005582264, 0.03445424, -0.0898461, 0.07694695, -0.06430643, 0.26156837, -0.045181878, -0.16155554, -0.008806556, 0.023297746));
	target2 += mul(h1, float4x4(0.014314168, 0.03040408, 0.079562426, 0.104040965, 0.15035652, -0.11237077, -0.04587703, 0.0664186, 0.011188344, 0.27792045, 0.03491885, 0.047752786, -0.02133782, 0.19199622, 0.03265004, 0.112835735));
	target2 += mul(i1, float4x4(-0.22900657, 0.19636537, 0.024062308, 0.004805258, 0.19197865, -0.26876372, 0.22812407, -0.13273205, 0.1163973, -0.016603881, 0.11751584, 0.07571751, -0.016665185, -0.020726109, -0.15382238, -0.05721929));
	target2 += mul(a2, float4x4(0.047688257, -0.04328092, 0.00020037305, -0.0030449564, 0.21016575, -0.3156827, 0.109759815, -0.012477153, -0.037765514, -0.19186607, 0.11098016, -0.122981705, 0.030443244, -0.27449754, 0.12108516, 0.14917934));
	target2 += mul(b2, float4x4(-0.015644934, 0.017102094, 0.068102054, 0.11661995, -0.13552219, 0.030102659, 0.14208834, 0.034298997, 0.06434777, -0.16380474, -0.10679716, -0.052865673, 0.03549326, -0.116048254, 0.16329505, 0.19959521));
	target2 += mul(c2, float4x4(-0.007844256, -0.033616025, 0.040885374, 0.0077286726, -0.057888485, 0.05796843, 0.0665138, -0.189592, -0.02662338, 0.022530284, 0.08647752, 0.054335136, 0.031057479, 0.03635868, 0.0933932, 0.064375274));
	target2 += mul(d2, float4x4(0.15531783, -0.21395409, -0.124851726, 0.049151056, -0.17787859, 0.07594992, 0.048780512, 0.0029584337, 0.013994473, -0.34576252, -0.05831177, 0.030209891, 0.009173122, -0.32105917, 0.026620382, 0.27054143));
	target2 += mul(e2, float4x4(0.031326182, 0.11699003, -0.1819442, -0.30510914, -0.21830374, 0.06375399, -0.11343298, 0.20248312, -0.032249533, 0.1300983, -0.23744828, -0.03899525, 0.095936954, 0.075583026, -0.18192224, 0.016086053));
	target2 += mul(f2, float4x4(-0.24321534, 0.1016422, 0.084550686, -0.007922614, -0.16052304, -0.09632171, 0.09476528, 0.03964334, -0.00061841257, 0.11085015, 0.16789092, 0.058375813, -0.021924267, 0.26049414, -0.04622306, 0.03622448));
	target2 += mul(g2, float4x4(0.05655466, -0.10016316, -0.026551498, 0.12944251, 0.06387257, 0.08759442, -0.040214762, -0.05403373, -0.001911277, -0.045361456, -0.29783988, -0.11533991, 0.07864674, -0.03580795, 0.09282203, 0.18479614));
	target2 += mul(h2, float4x4(-0.019557253, -0.01953009, 0.1073159, -0.077327915, -0.3287939, 0.08561906, -0.16314861, -0.14830309, -0.031493217, -0.050918207, 0.13767132, -0.25257835, 0.029513458, 0.1548974, -0.048502877, 0.0022710229));
	target2 += mul(i2, float4x4(0.0022606663, 0.048681643, -0.06014017, 0.23443368, -0.086114794, 0.017463014, -0.073657446, -0.0013138334, -0.053271778, 0.29075313, 0.07355574, 0.14009497, -0.15303768, 0.21335968, -0.17516625, 0.03268628));
	target2 += mul(a3, float4x4(-0.012742161, -0.041635115, 0.168062, -0.028525194, -0.030566072, -0.027266532, 0.0359287, -0.07139233, 0.061290823, -0.04036332, 0.04897623, 0.13846754, 0.039383594, 0.12339301, -0.026180696, -0.0051744552));
	target2 += mul(b3, float4x4(-0.03748404, -0.026544569, 0.11102617, -0.22780292, 0.06731992, -0.15827416, 0.09802122, 0.11640033, 0.00039111794, 0.072100006, -0.053455148, 0.06592366, -0.09381082, 0.13634324, -0.08554314, 0.016439624));
	target2 += mul(c3, float4x4(0.10113021, 0.08261971, -0.16603, -0.009958334, 0.03756299, -0.004461027, 0.08559942, -0.012674885, -0.03848595, 0.002108679, 0.021565402, -0.046234082, 0.04603834, 0.09276165, -0.29686695, -0.015194743));
	target2 += mul(d3, float4x4(0.053909358, 0.0835715, -0.116176985, 0.22114189, 0.17204702, -0.17098549, -0.08065474, -0.015051904, 0.14268506, -0.117853105, -0.0038547963, -0.099558994, -0.12031682, 0.11549271, 0.0201697, 0.093561895));
	target2 += mul(e3, float4x4(-0.056914307, 0.18547982, -0.09208387, -0.00943169, -0.024476565, 0.020612689, 0.04417863, 0.14231037, -0.05794176, 0.19624077, -0.10561953, -0.1312564, -0.09621997, -0.055228855, -0.06481115, 0.07939849));
	target2 += mul(f3, float4x4(-0.09013716, -0.12869088, -0.14419042, -0.021643816, -0.123301044, 0.1077149, -0.058566347, 0.010407963, 0.009403472, -0.07660888, 0.09947006, -0.07434618, -0.014246012, -0.24914171, 0.0034662948, -0.05013118));
	target2 += mul(g3, float4x4(-0.070962735, 0.06716404, -0.15136454, 0.02027541, -0.107001044, 0.50334495, -0.039790098, 0.08286825, -0.0010944081, 0.1031829, -0.011431386, -0.08257687, -0.18531963, -0.14856398, 0.024649108, 0.047142852));
	target2 += mul(h3, float4x4(0.049574193, 0.07180735, 0.047850125, -0.051012892, -0.00040669146, 0.4140869, -0.088046245, -0.036824025, -0.03582775, 0.26769164, -0.06151275, -0.09666011, 0.2566442, -0.09799407, 0.097338095, -0.026725585));
	target2 += mul(i3, float4x4(0.1490444, -0.06516709, 0.10439169, -0.034240134, -0.041965652, -0.2079741, -0.09079767, 0.15088585, 0.022063766, -0.07552733, 0.0012785956, -0.16747397, 0.10525993, -0.09890853, 0.10660105, 0.21784192));
	target2 += mul(na1, float4x4(0.07042895, 0.16030453, 0.0030912263, -0.027933247, -0.3086125, -0.28822276, -0.400802, 0.2096595, 0.08857404, 0.34754908, -0.15951826, -0.35737038, -0.038460553, 0.007917597, 0.2774085, -0.08004489));
	target2 += mul(nb1, float4x4(-0.038472448, -0.0174679, -0.107170366, -0.037775494, -0.054595813, -0.21341673, 0.21892805, 0.12125601, 0.058354914, -0.35335168, -0.21329384, -1.0650489, 0.059367847, -0.02849481, 0.001276761, -0.30784246));
	target2 += mul(nc1, float4x4(-0.050561953, 0.0007092989, -0.13955325, -0.07106547, 0.12613517, -0.0822321, 0.14023048, -0.20781253, 0.0041748453, 0.157751, -0.14171253, -0.9330524, -0.0035482922, -0.17769572, -0.1528532, -0.32141888));
	target2 += mul(nd1, float4x4(-0.040014382, 0.24272937, 0.12577556, -0.10304328, 0.12054429, -0.14819793, -0.46691173, 0.12551397, 0.21042542, 0.040414993, 0.2664476, -0.0624471, -0.10776527, 0.03234498, -0.14870068, -0.05700082));
	target2 += mul(ne1, float4x4(-0.15521951, -0.099391945, -0.31356367, -0.006449893, 0.059501357, 0.16860132, 0.2637131, -0.035344128, -0.20164591, -0.0771766, 0.22611247, -0.40267792, -0.060890198, 0.060215253, 0.093219444, -0.3483));
	target2 += mul(nf1, float4x4(0.03416117, -0.1827499, -0.15668888, -0.10794011, -0.075220324, 0.12177839, -0.07486823, 0.21677534, -0.039297394, -0.14563735, 0.05120258, -0.00035666916, 0.12478138, 0.04741504, 0.2288785, -0.17462626));
	target2 += mul(ng1, float4x4(-0.02980817, 0.087366745, 0.043035574, 0.040445086, 0.07882225, 0.030239558, -0.117186725, 0.19092828, -0.037465222, -0.10581845, -0.055081632, -0.15845117, 0.07946355, 0.14760616, -0.022140944, 0.11649563));
	target2 += mul(nh1, float4x4(-0.19723393, 0.024121622, -0.27199838, 0.07334678, -0.07288629, 0.17650653, -0.22066317, -0.13322048, 0.0069257803, -0.24415702, 0.09925061, 0.33271804, 0.0033860113, -0.18174358, -0.13197216, -0.018403139));
	target2 += mul(ni1, float4x4(-0.093481295, -0.28051332, -0.032411367, -0.14152545, 0.18546024, 0.26412115, 0.07146612, 0.036084935, -0.27073604, -0.010888752, -0.13251275, 0.052145492, -0.0332615, 0.06561024, -0.12152722, 0.25903332));
	target2 += mul(na2, float4x4(-0.14281613, 0.07859564, 0.0066864006, -0.15937181, -0.12278831, 0.311999, 0.025959859, 0.02308115, -0.03229773, 0.2645761, -0.13995989, 0.10817364, 0.07908819, 0.42388916, -0.17739546, 0.10429196));
	target2 += mul(nb2, float4x4(0.2201895, -0.2196956, 0.14305998, -0.3301203, 0.16685095, 0.09164033, 0.031294953, -0.05854433, -0.06691493, 0.1518185, 0.038523998, 0.05256842, -0.047954578, 0.1683237, 0.0048684916, -0.10664451));
	target2 += mul(nc2, float4x4(-0.026817175, -0.029176721, 0.24391933, 0.017680334, 0.15134846, -0.15139282, 0.29651865, 0.12128057, 0.044055674, 0.023059618, -0.054705862, -0.025505943, -0.019943522, -0.032058105, -0.30078474, 0.28300348));
	target2 += mul(nd2, float4x4(-0.15246257, 0.16519837, 0.030530507, 0.0019738604, -0.09898821, -0.10236442, -0.15473707, 0.1960111, 0.08083462, 0.1931143, 0.053789698, 0.063627414, -0.10000871, 0.1890801, -0.039166793, -0.035554815));
	target2 += mul(ne2, float4x4(-0.008138058, -0.090632096, 0.09218409, -0.1870409, 0.006966406, -0.036867052, -0.1109265, 0.15594107, -0.06334745, -0.025499493, 0.16426682, 0.024393357, 0.0060975226, 0.08250694, -0.022282967, -0.09879987));
	target2 += mul(nf2, float4x4(0.06807879, 0.127161, -0.20435798, -0.11276813, -0.035021268, -0.019755092, -0.17415504, 0.060618974, 0.12325889, -0.12290322, -0.05086793, 0.14947659, 0.023935383, -0.032783996, -0.029157335, -0.006670329));
	target2 += mul(ng2, float4x4(-0.14423427, 0.07715571, 0.06842541, -0.24895051, -0.06428334, -0.07863047, 0.23238844, 5.274231e-05, 0.048996497, 0.17647398, 0.413201, -0.31975266, -0.030216858, 0.04867342, -0.30262446, -0.15375552));
	target2 += mul(nh2, float4x4(0.23534048, 0.092139505, 0.012503786, 0.116008915, -0.0898572, -0.17778875, 0.16141091, 0.3644637, 0.043014687, -0.031378243, 0.11754703, -0.38509452, 0.1001422, 0.036844354, -0.0051652407, 0.036642574));
	target2 += mul(ni2, float4x4(0.08065526, -0.14093323, -0.027013494, -0.112644374, -0.019306205, -0.10695108, -0.21220952, -0.039872676, -0.09730943, -0.47728395, -0.28284085, -0.07133749, -0.04755162, -0.14241156, -0.01632541, -0.009647049));
	target2 += mul(na3, float4x4(0.07490686, -0.06242466, 0.15567005, -0.16337247, -0.2887383, 0.2881797, -0.121348776, 0.060069725, -0.03536951, -0.24556357, -0.35177758, -0.11175104, -0.0073047564, -0.06645475, 0.014323825, 0.058212377));
	target2 += mul(nb3, float4x4(0.03256386, -0.05097925, 0.27179804, -0.09543428, 0.161455, 0.023938831, 0.10773267, -0.10486564, 0.076764554, 0.06358945, -0.18258472, 0.08324786, 0.06467844, -0.20269682, 0.046431858, -0.08359799));
	target2 += mul(nc3, float4x4(-0.086718775, 0.029116197, -0.020623617, -0.010007143, -0.0062927944, 0.028177656, -0.07210879, 0.06786677, 0.023476062, 0.17860489, -0.06256401, 0.061757386, -0.046495005, -0.055532746, 0.15595034, 0.12336579));
	target2 += mul(nd3, float4x4(0.08569872, -0.03291618, 0.18875046, -0.080043204, 0.19672358, 0.0756269, 0.02688733, 0.16277955, -0.060868777, -0.037449554, 0.020366343, -0.28260133, 0.30251002, -0.08898951, 0.002503838, -0.031098645));
	target2 += mul(ne3, float4x4(0.09120409, -0.04983847, 0.07688438, 0.008763123, -0.09732479, 0.21332602, -0.13068666, -0.030675085, 0.31382635, 0.0012199014, -0.18128653, 0.30740625, -0.100602135, 0.08708379, 0.112137444, -0.03682313));
	target2 += mul(nf3, float4x4(0.0709511, -0.04224951, -0.05609049, -0.0006408909, -0.030565612, -0.012263292, -0.009747451, -0.07244236, 0.054749947, -0.01405017, 0.009567654, -0.074202195, -0.06860078, 0.13089342, -0.06874847, -0.03219275));
	target2 += mul(ng3, float4x4(0.1576853, -0.2683739, -0.025735255, -0.06460345, 0.075857066, -0.59675205, 0.11202596, 0.14385986, -0.06844365, -0.23115703, 0.12929395, -0.12881753, 0.009042129, 0.105781116, -0.055749435, -0.081277415));
	target2 += mul(nh3, float4x4(0.13527077, -0.03984972, 0.018804315, 0.12699783, -0.17789197, -0.30242765, 0.09397843, 0.090828404, -0.059823766, 0.044621762, 0.25259614, -0.19707985, -0.13368398, 0.20000716, -0.009788325, -0.20149179));
	target2 += mul(ni3, float4x4(-0.041884087, -0.059512906, -0.0896845, 0.06103581, 0.110947184, 0.10910047, -0.0047273464, 0.079314105, -0.121069044, 0.10926088, 0.13192393, 0.13567427, 0.109372094, 0.06015443, 0.100631915, -0.224153));
	target2 += float4(0.022030555, -0.05006568, 0.014002339, 0.023597209);
	
	float4 target3 = mul(a1, float4x4(-0.09202538, -0.081250995, 0.13399354, -0.09287109, 0.075870514, -0.046435528, 0.06888035, 0.07559372, 0.047911238, 0.1541559, 0.016089845, -0.020714905, 0.034469247, 0.09413617, -0.06726056, 0.04964387));
	target3 += mul(b1, float4x4(0.22596729, 0.02889021, -0.048012562, 0.14605793, -0.086510226, 0.09049988, -0.0024043226, 0.07370351, -0.02844908, 0.056516882, -0.12932102, -0.080092, -0.014557861, 0.2417015, 0.24414025, -0.08637478));
	target3 += mul(c1, float4x4(-0.08709868, -0.15894723, 0.051107977, -0.007953947, -0.005816434, 0.15406336, -0.08382943, 0.06931645, 0.10049424, -0.10653088, 0.2009932, 0.15972902, 0.02209797, -0.008090025, 0.058555678, 0.044184227));
	target3 += mul(d1, float4x4(-0.14687128, 0.08516212, -0.090116605, -0.053017177, -0.09254908, -0.043845087, -0.02666236, -0.12203544, -0.043807525, 0.14893356, -0.11529748, -0.06253818, -0.010695381, -0.10081673, -0.0314329, -0.044264063));
	target3 += mul(e1, float4x4(0.021610646, -0.16695172, -0.31326374, 0.05392923, 0.12519042, 0.12159836, -0.07893999, -0.10245254, 0.10427483, -0.042931017, -0.18065664, 0.01107328, 0.110220656, -0.06329314, -0.044132728, -0.004572783));
	target3 += mul(f1, float4x4(0.01665856, 0.121704906, -0.2353256, 0.16223833, 0.04024997, -0.01792505, 0.14950873, -0.06683434, 0.004776299, 0.011929818, 0.07254882, 0.03820532, 0.31055966, 0.08748786, 0.0073042163, 0.2684048));
	target3 += mul(g1, float4x4(-0.23074506, -0.06215829, 0.053791784, 0.22733828, -0.11443747, -0.15169612, 0.040388454, -0.007505497, 0.005672369, 0.0026797412, -0.001197972, 0.007488197, -0.0024618902, 0.10131061, -0.07500523, -0.013001146));
	target3 += mul(h1, float4x4(-0.0776098, -0.060467657, 0.063401155, -0.3178554, 0.046797205, -0.10740315, 0.02085142, 0.101416804, -0.1198098, -0.02295822, 0.039581314, -0.048711125, -0.06259446, -0.11206371, -0.0053890026, -0.070524804));
	target3 += mul(i1, float4x4(-0.12901165, 0.21051991, -0.1142095, 0.22749256, -0.023643937, -0.046942696, -0.060973406, -0.057919096, -0.22156318, -0.051061176, 0.0916328, 0.012217941, -0.17102586, -0.18390712, 0.006507473, -0.029991195));
	target3 += mul(a2, float4x4(-0.2522444, -0.03696223, -0.18561353, 0.13687257, 0.073648125, 0.13678576, 0.16931336, 0.00949838, -0.038437508, -0.059626862, 0.05821261, -0.07623236, -0.08685592, -0.17067757, 0.174131, -0.025060346));
	target3 += mul(b2, float4x4(0.104338415, -0.096368395, -0.029887693, 0.032492615, 0.041827764, 0.24553889, 0.099045165, 0.059192423, 0.023159435, -0.043454442, 0.10354106, 0.17867453, -0.1752651, 0.16507833, -0.09264873, 0.038281262));
	target3 += mul(c2, float4x4(0.06404952, 0.014349881, -0.08079635, -0.18684097, -0.021107968, 0.1474591, 0.02128032, 0.052345317, 0.19520657, -0.18109623, 0.12578261, 0.034501765, -0.1369868, -0.05843081, 0.16561405, -0.06775279));
	target3 += mul(d2, float4x4(0.08673276, 0.14922544, 0.12579706, 0.12474029, -0.06912261, -0.104719676, 0.27239847, -0.13122962, -0.05688415, 0.1428628, 0.00895786, -0.032757584, 0.019906566, -0.17429581, -0.10528849, 0.13250664));
	target3 += mul(e2, float4x4(0.1025883, 0.16903317, 0.24479683, 0.08272392, -0.12168113, 0.09135378, 0.06919754, -0.24658537, 0.014526622, 0.08442609, -0.30363482, -0.03433778, 0.037446275, 0.030086113, -0.07519447, -0.068841174));
	target3 += mul(f2, float4x4(0.024311058, -0.08233637, -0.16022089, -0.1597245, 0.050970588, -0.10577119, -0.1112992, -0.052199256, -0.0849103, -0.3776085, -0.21930903, -0.20542654, -0.01871536, 0.10911211, 0.07675561, -0.024964388));
	target3 += mul(g2, float4x4(0.12411877, -0.00519536, 0.0480481, -0.10641975, -0.0010129698, -0.049957395, 0.0066010677, -0.07925235, 0.1930976, 0.5361102, -0.056495357, -0.05665149, -0.1270014, 0.041294765, -0.15627688, 0.018746065));
	target3 += mul(h2, float4x4(0.13720295, 0.085025266, 0.05471863, 0.038614765, -0.06960719, 0.16281144, -0.21186842, -0.1941425, 0.095628515, 0.084828205, 0.02530074, 0.11415585, 0.10537103, -0.0586968, 0.019073522, -0.055825945));
	target3 += mul(i2, float4x4(-0.21141429, 0.01108361, -0.14758278, 0.08792016, -0.0016714301, -0.0030396983, -0.12766738, -0.08827425, -0.07848207, -0.13752016, 0.013766901, 0.09635439, -0.079080686, -0.14922711, 0.06670641, -0.080326416));
	target3 += mul(a3, float4x4(0.20643076, -0.00499668, 0.23666923, -0.17106888, 0.12709226, 0.00981184, 0.028967496, 0.016210513, 0.12393452, 0.0043048155, 0.05266705, -0.094970286, 0.005504978, -0.050391, 0.10117381, 0.09549521));
	target3 += mul(b3, float4x4(0.04931849, -0.0065390305, 0.08863048, -0.0947855, 0.15617795, -0.17475569, 0.10392811, 0.035971895, 0.03656791, -0.12339292, 0.010653483, 0.08514984, 0.15630373, 0.15763232, -0.012078789, -0.026336702));
	target3 += mul(c3, float4x4(0.13140163, 0.07304222, 0.03644733, 0.09648337, -0.017975705, -0.072331324, 0.0029975558, -0.021666657, -0.020042133, 0.044821594, 0.037660487, 0.09642576, 0.06416202, 0.014092053, -0.043693382, -0.051554378));
	target3 += mul(d3, float4x4(-0.23793697, -0.0014973939, -0.08946259, 0.067851745, -0.019646896, -0.19535433, 0.10289966, 0.0010244731, -0.20782173, 0.0020514326, -0.16879739, 0.17888409, -0.124513365, -0.07472942, -0.0588901, -0.2092017));
	target3 += mul(e3, float4x4(0.060483094, 0.059208773, 0.08345, 0.0010649676, -0.23659356, 0.3603475, 0.0053207604, -0.03345199, 0.020284697, -0.01113311, 0.11211144, 0.053414755, 0.1895607, -0.15760773, -0.23431808, 0.043709636));
	target3 += mul(f3, float4x4(0.080154695, -0.064768635, -0.12550141, -0.08824165, -0.07509624, -0.0713246, -0.22137038, 0.0921876, -0.025354594, -0.24898566, -0.028864942, -0.16679515, -0.08982522, 0.029950809, -0.06993633, 0.12565832));
	target3 += mul(g3, float4x4(-0.20841017, 0.06321075, -0.04099131, 0.07732559, -0.08110228, 0.20876545, -0.11388175, 0.27826598, -0.15344119, 0.09446656, 0.2735643, 0.079110265, -0.043845385, 0.029875547, 0.12783948, -0.10298459));
	target3 += mul(h3, float4x4(0.08580364, -0.08134692, -0.085382804, -0.09634259, -0.07509618, -0.12689087, 0.05720452, -0.1819075, 0.11217614, -0.16592574, -0.101749554, -0.018963661, 0.14723873, 0.12904182, -0.052782595, 0.05793788));
	target3 += mul(i3, float4x4(-0.0056530046, 0.05674741, 0.014994733, 0.11958239, 0.16446747, -0.049534798, -0.016570516, -0.21063349, -0.07496503, 0.0055008507, 0.11419655, 0.048011355, -0.04684853, 0.042691138, 0.09421025, 0.12923399));
	target3 += mul(na1, float4x4(-0.083864704, 0.07605092, -0.047560036, 0.16445905, -0.029962407, 0.18134072, -0.22724763, 0.023675185, -0.03332916, -0.04249084, 0.15973917, 0.007322849, -0.087714255, -0.153021, 0.030236037, -0.100231044));
	target3 += mul(nb1, float4x4(-0.17441258, -0.028744312, 0.05915575, -0.11824928, -0.04179886, -0.14449957, 0.04891911, -0.21351086, 0.3303812, 0.07433166, 0.503379, 0.2470829, 0.1322803, -0.04928455, -0.15583721, 0.106110215));
	target3 += mul(nc1, float4x4(-0.08065278, -0.00050983805, 0.027161239, 0.12555373, 0.017745659, 0.0479513, 0.10691591, -0.13202804, 0.38873398, 0.046141643, 0.07307728, 0.13692193, 0.18681903, 0.11005239, 0.15744549, 0.21892804));
	target3 += mul(nd1, float4x4(0.03978365, -0.023494922, -0.039753728, 0.27451408, 0.02140033, -0.013376269, 0.028383363, 0.059702866, -0.0071658283, -0.13848262, -0.1019017, -0.16829433, -0.018539641, 0.013991451, 0.099338084, -0.05775615));
	target3 += mul(ne1, float4x4(-0.065350726, 0.11001335, 0.11902446, -0.21104746, 0.095098086, 0.02739781, -0.26015705, 0.22157612, -0.15288728, 0.2722011, 0.27105704, -0.24145271, -0.051725585, 0.06605028, -0.012332871, -0.17540309));
	target3 += mul(nf1, float4x4(-0.2189158, -0.05287219, -0.04915249, -0.05357751, -0.12871711, -0.0061132344, -0.1406079, -0.18074436, -0.14702965, -0.22242828, 0.08177444, 0.3396842, -0.2632696, -0.06403873, -0.008123073, -0.030273361));
	target3 += mul(ng1, float4x4(0.11255844, -0.057998642, -0.07679987, 0.049385145, 0.13984528, -0.07007145, 0.11060764, 0.12331489, -0.05268373, -0.15397486, 0.054913905, -0.1393604, 0.020389834, -0.17137636, 0.067205, 0.084197655));
	target3 += mul(nh1, float4x4(0.27258077, -0.10924528, -0.1159478, 0.05647175, 0.13014089, 0.12746723, 0.0045503005, 0.07131271, 0.081193194, 0.018001271, -0.056847095, 0.19587554, -0.018607333, 0.1416207, -0.03856229, -0.0888815));
	target3 += mul(ni1, float4x4(0.0946241, 0.059010573, 0.013680293, -0.042248886, -0.2995221, -0.095081195, 0.06510416, 0.043059137, 0.10425443, -0.1222804, -0.16180466, -0.3628854, -0.01679748, 0.112195894, -0.004974211, -0.055885002));
	target3 += mul(na2, float4x4(0.11798436, 0.1390635, 0.142733, -0.16162498, 0.034902234, -0.13497733, 0.097894885, 0.10681201, -0.047284793, 0.015005336, -0.09031815, 0.12383599, -0.091548845, -0.013705567, 0.049403854, 0.18155518));
	target3 += mul(nb2, float4x4(0.1806166, 0.08396095, -0.17600271, -0.029499372, 0.17163202, 0.18944095, -0.1755662, -0.008431973, -0.057935216, 0.1584788, -0.059633583, -0.1950766, -0.03091734, -0.045874756, -0.0051801866, -0.20533004));
	target3 += mul(nc2, float4x4(0.004201836, -0.15968263, 0.015041736, 0.17407048, -0.03530788, 0.09062685, 0.050316375, -0.058444653, -0.12015508, 0.11712405, -0.031137828, -0.049205493, 0.05515115, 0.06733773, 0.03607973, 0.05056488));
	target3 += mul(nd2, float4x4(0.006330765, -0.17457847, -0.021863922, -0.16448942, 0.059458453, 0.1486118, -0.22728927, 0.0058831032, -0.00180954, -0.34799471, -0.017039202, 0.03939159, -0.033589013, 0.32948977, 0.087067194, -0.113632225));
	target3 += mul(ne2, float4x4(0.042377464, -0.030939378, -0.08917448, 0.2585585, -0.28696018, -0.04419827, 0.0057377038, 0.08444518, -0.009464956, -0.03967168, 0.05095106, -0.04785119, -0.05805417, -0.07269471, -0.18795604, -0.23612237));
	target3 += mul(nf2, float4x4(-0.026615486, 0.1219551, 0.17111751, 0.12014681, -0.10403522, 0.13139823, 0.28612077, -0.17874514, 0.030061528, 0.31433544, 0.16948178, 0.10126, 0.0582159, -0.13620348, -0.026327167, 0.11529438));
	target3 += mul(ng2, float4x4(-0.10999408, -0.1642254, -0.09659326, -0.085699454, 0.05962901, -0.07562989, 0.042366143, -0.1533413, -0.09869005, -0.21281542, 0.020441674, 0.17866766, -0.26933256, 0.049314983, 0.10039448, -0.13316467));
	target3 += mul(nh2, float4x4(-0.22610307, -0.0013520997, 0.16817398, 0.037943725, -0.067527935, -0.15105802, -0.0973126, -0.05843863, 0.19214404, 0.092337616, -0.024034662, -0.007926626, -0.32222804, 0.082673185, 0.069847725, 0.027493093));
	target3 += mul(ni2, float4x4(0.0014049035, -0.058899652, 0.060463455, -0.052001078, 0.19716045, 0.12879235, -0.026990427, 0.23919769, 0.0034248075, -0.0157977, -0.06720619, -0.013757762, -0.101808615, 0.029667001, 0.07381132, 0.092393965));
	target3 += mul(na3, float4x4(0.053514812, 0.14120969, -0.056737684, 0.017708244, -0.05407678, 0.103361025, -0.0924985, 0.053643283, -0.28559983, -0.12866977, -0.06750911, 0.027970003, 0.06481888, 0.06773354, -0.07627304, -0.07058017));
	target3 += mul(nb3, float4x4(0.10564813, 0.1891429, -0.085196435, 0.0073824013, 0.0039014777, 0.14679071, 0.09327677, -0.030248597, 0.18063113, -0.3115451, 0.06560229, -0.03190648, -0.1619295, -0.112393744, -0.10004008, 0.0023948452));
	target3 += mul(nc3, float4x4(-0.033827845, -0.12089327, 0.042195093, 0.025078757, -0.044261515, 0.09103579, -0.19070679, -0.1600237, 0.13683122, -0.072529055, 0.062436976, -0.29964364, -0.114442796, -0.047068417, -0.07223064, 0.05781626));
	target3 += mul(nd3, float4x4(-0.04086473, 0.029395554, 0.05157983, 0.013322953, -0.001428512, -0.103283875, 0.15795463, 0.21691218, 0.23493949, -0.18836173, 0.28818855, -0.07839693, -0.043874815, -0.011829423, 0.0825803, 0.18832965));
	target3 += mul(ne3, float4x4(0.087384604, 0.2075869, 0.012306303, -0.06356627, -0.019742407, -0.256092, -0.089735925, 0.026248232, -0.22160976, -0.4420786, 0.033200428, -0.1376953, -0.3315224, 0.17343274, 0.3179911, 0.012785637));
	target3 += mul(nf3, float4x4(-0.14358811, 0.052979786, 0.13841373, 0.07362653, 0.050186664, 0.11735455, 0.0032370305, -0.16536471, -0.005521641, 0.1040989, -0.07086791, 0.13729815, 0.0840539, 0.06547088, 0.22857827, -0.2079967));
	target3 += mul(ng3, float4x4(-0.11850976, -0.026047882, 0.00785038, -0.19955018, 0.040088244, -0.10139797, 0.08621738, -0.26192454, 0.3888625, 0.33236128, 0.1412189, 0.10097289, 0.07574426, -0.15459102, -0.1557534, 0.03405655));
	target3 += mul(nh3, float4x4(-0.15693793, -0.03326048, 0.110803954, 0.07044277, 0.1380442, -0.029729376, -0.26033366, 0.040598683, -0.23744181, 0.043091178, 0.18325818, 0.05989088, 0.099216335, -0.012825024, 0.20831011, -0.08420897));
	target3 += mul(ni3, float4x4(0.031240137, -0.034582928, 0.0022927374, -0.06525183, -0.15711913, -0.04604516, 0.0605175, 0.15128267, 0.072712876, -0.015489105, -0.20996843, -0.24177326, 0.053063773, -0.08747667, 0.24771367, 0.1244199));
	target3 += float4(0.07754665, -0.09230884, 0.019135362, 0.035482828);

	tex4[gxy] = target1;
	tex5[gxy] = target2;
	tex6[gxy] = target3;
}

//!PASS 3
//!DESC Conv-4x3x3x24
//!IN tex4, tex5, tex6
//!OUT tex1, tex2, tex3
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass3(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	float4 a1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d1 = tex4.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e1 = tex4.SampleLevel(sam, pos, 0);
	float4 f1 = tex4.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na1 = max(-a1, 0);
	float4 nb1 = max(-b1, 0);
	float4 nc1 = max(-c1, 0);
	float4 nd1 = max(-d1, 0);
	float4 ne1 = max(-e1, 0);
	float4 nf1 = max(-f1, 0);
	float4 ng1 = max(-g1, 0);
	float4 nh1 = max(-h1, 0);
	float4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	float4 a2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d2 = tex5.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e2 = tex5.SampleLevel(sam, pos, 0);
	float4 f2 = tex5.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na2 = max(-a2, 0);
	float4 nb2 = max(-b2, 0);
	float4 nc2 = max(-c2, 0);
	float4 nd2 = max(-d2, 0);
	float4 ne2 = max(-e2, 0);
	float4 nf2 = max(-f2, 0);
	float4 ng2 = max(-g2, 0);
	float4 nh2 = max(-h2, 0);
	float4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    float4 a3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d3 = tex6.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e3 = tex6.SampleLevel(sam, pos, 0);
	float4 f3 = tex6.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na3 = max(-a3, 0);
	float4 nb3 = max(-b3, 0);
	float4 nc3 = max(-c3, 0);
	float4 nd3 = max(-d3, 0);
	float4 ne3 = max(-e3, 0);
	float4 nf3 = max(-f3, 0);
	float4 ng3 = max(-g3, 0);
	float4 nh3 = max(-h3, 0);
	float4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	float4 target1 = mul(a1, float4x4(0.15677336, 0.18937011, -0.15614599, 0.15203404, 0.098624565, 0.023782162, -0.045496363, -0.014783688, 0.07303875, -0.075132, -0.019847363, -0.088889055, -0.11558432, -0.08860719, 0.16452459, -0.018188732));
	target1 += mul(b1, float4x4(0.026749048, -0.0376324, -0.0994071, -0.00093872234, 0.014682955, 0.008369919, -0.046362195, -0.21044572, -0.013911088, -0.117338374, 0.14585997, -0.11355687, 0.04094843, -0.11326298, 0.08555518, 0.076577775));
	target1 += mul(c1, float4x4(0.04918652, 0.10098061, -0.097193845, 0.011482707, -0.015221698, -0.06306758, 0.09985586, -0.0011515089, -0.09592504, 0.11805872, -0.053774815, 0.093555175, 0.11237289, -0.20694147, 0.255737, 0.0149322525));
	target1 += mul(d1, float4x4(0.06269537, -0.28116295, 0.1405942, 0.00218229, -0.012810465, 0.11574089, 0.060055815, -0.14248852, 0.03755387, 0.03748404, 0.04481931, 0.086039774, -0.0707909, -0.053917676, -0.009349141, -0.06623982));
	target1 += mul(e1, float4x4(-0.002837983, -0.0649247, -0.14890024, 0.0011222209, 0.12083026, -0.16136795, -0.04910086, 0.060653802, 0.020444075, 0.0024171378, 0.06839313, -0.21157807, -0.1678213, -0.27503422, 0.0063047423, 0.03292154));
	target1 += mul(f1, float4x4(0.14229529, -0.002042125, -0.022892606, 0.08743759, 0.035437252, -0.12997083, -0.1851374, 0.33951423, -0.037205234, 0.03710803, 0.018455725, -0.052581675, -0.16795224, -0.14008522, 0.011014682, 0.07038518));
	target1 += mul(g1, float4x4(0.105874196, -0.21320704, -0.08445409, 0.052140422, -0.13498448, -0.0737051, -0.027274717, -0.06932614, -0.017584193, -0.13111684, -0.049095873, 0.08269069, -0.017520722, -0.08716905, 0.25897968, -0.1412353));
	target1 += mul(h1, float4x4(-0.016677873, -0.024665434, -0.11711789, 0.16085778, 0.017375777, 0.15644072, 0.11040864, 0.23371918, 0.10210983, 0.0039968346, -0.007850634, -0.026810693, 0.08863099, 0.094195805, 0.10420045, -0.19671428));
	target1 += mul(i1, float4x4(-0.016842589, -0.15904509, -0.038347725, 0.1279937, -0.00045717083, 0.13132372, -0.13027431, -0.058826704, -0.0029436084, 0.008283112, 0.10262298, -0.05013397, -0.02922706, 0.14453132, 0.18946488, -0.0966266));
	target1 += mul(a2, float4x4(-0.00050655927, 0.2318558, 0.025141997, -0.058849655, 0.05127902, -0.056867033, -0.06191942, -0.028451841, 0.038166817, -0.14328304, 0.06050816, -0.12157533, 0.058556214, -0.13964172, 0.026282474, 0.03329027));
	target1 += mul(b2, float4x4(-0.06520211, 0.21877246, 0.017677024, -0.053116243, -0.018621214, -0.0063418522, -0.10306368, -0.07627847, -0.0035643768, -0.05579889, 0.07386847, -0.0084178485, 0.005625732, 0.10204069, -0.08501438, -0.013451101));
	target1 += mul(c2, float4x4(-0.067369066, 0.17327416, 0.062035594, -0.1340041, 0.10289677, -0.0868232, 0.023330351, -0.072417624, -0.12027732, 0.11592929, 0.05090798, -0.06895359, -0.04391116, 0.18919718, 0.064172365, -0.051173057));
	target1 += mul(d2, float4x4(-0.022913774, -0.021000199, -0.01890946, -0.079307556, -0.16522343, -0.3152304, -0.21007383, 0.01858985, 0.003152245, -0.009094366, -0.023845399, -0.06635666, 0.041294664, 0.12883614, -0.06389087, 0.005710572));
	target1 += mul(e2, float4x4(0.032583844, 0.16247992, 0.06764235, -0.2240413, -0.15760922, 0.20196813, 0.13201368, 0.106440805, -0.070570394, -0.19261852, 0.28010008, -0.0048360736, -0.14080645, -0.02105434, 0.023814693, -0.13861166));
	target1 += mul(f2, float4x4(0.071627796, 0.20605852, -0.2676727, -0.39509574, 0.22782667, 0.13424493, 0.08930976, 0.13314968, 0.045536704, -0.06271722, 0.01703984, 0.13352728, -0.07089344, 0.14776441, 0.11804898, -0.027061034));
	target1 += mul(g2, float4x4(-0.011638248, -0.016760292, 0.0593982, -0.100421235, 0.030956578, 0.13813019, 0.022237146, -0.091211095, 0.010232882, 0.0010010025, 0.16789608, -0.030847551, 0.027778173, -0.005418129, -0.16441783, 0.07580936));
	target1 += mul(h2, float4x4(0.08137598, -0.008976606, 0.00023393384, -0.19671111, -0.0068668523, 0.097364455, -0.0026000517, -0.11201763, 0.047109667, -0.043774106, 0.12344897, -0.13232613, 0.026984906, -0.13614078, 0.06604853, 0.10752554));
	target1 += mul(i2, float4x4(0.00047561026, 0.12248177, 0.05146918, -0.3956014, -0.12263068, 0.22729336, 0.03597535, 0.09500604, 0.06894016, 0.061162107, 0.13561803, -0.047466908, -0.0013999783, -0.068306796, -0.031758398, -0.046261873));
	target1 += mul(a3, float4x4(0.12310386, -0.046108138, -0.08357388, 0.02034243, 0.0024922634, 0.029359696, -0.04329755, -0.034257423, 0.08229037, -0.11810178, -0.1079754, 0.13327998, -0.09608102, -0.26294786, -0.056677792, -0.1958781));
	target1 += mul(b3, float4x4(0.007982684, 0.020604203, -0.12702446, -0.02264998, -0.034644246, -0.00025684707, 0.037761245, -0.0041598473, -0.047972955, 0.039201785, -0.016598722, -0.044081174, 0.11861525, 0.01239671, -0.12192053, 0.08865015));
	target1 += mul(c3, float4x4(-0.0018564354, -0.07618631, -0.09212719, 0.092056714, -0.16783315, 0.08645543, 0.24669226, -0.023520375, -0.04045034, -0.0023428998, -0.01612943, 0.014919031, 0.16028026, -0.020104371, -0.16949941, 0.18713622));
	target1 += mul(d3, float4x4(0.19490379, -0.07592651, -0.200843, 0.07704469, -0.02736559, -0.054601975, -0.07240532, -0.03120134, -0.038438305, -0.12783389, -0.057655185, -0.009752765, 0.07110615, 0.033978693, -0.023724876, 0.11998657));
	target1 += mul(e3, float4x4(0.18834178, 0.23053586, -0.14430945, 0.32287082, -0.32185385, -0.15306619, -0.1573794, 0.005030648, 0.06912159, 0.009656687, -0.20743106, 0.03814172, 0.104378454, -0.07221508, -0.11348173, -0.019581677));
	target1 += mul(f3, float4x4(-0.017694198, 0.028853144, 0.1263284, 0.1820403, -0.05317991, -0.057951134, -0.04575081, 0.05769411, -0.11807033, 0.06413361, 0.06063185, 0.19433405, 0.0032539407, 0.021501997, -0.14744627, -0.095206425));
	target1 += mul(g3, float4x4(-0.0463219, -0.13988416, 0.07200895, -0.13444373, -0.2447483, -0.024709478, -0.08591721, -0.09281996, -0.046719797, -0.11321926, -0.061532497, -0.0044461554, -0.03174407, -0.0056026108, 0.0056006387, 0.08828445));
	target1 += mul(h3, float4x4(0.060374547, 0.062058832, -0.0390557, -0.047456663, -0.2227052, -0.03193117, -0.025358196, 0.08565629, 0.03657194, 0.13427348, -0.09266081, 0.23655434, 0.024580589, 0.01999063, -0.038653534, -0.023600115));
	target1 += mul(i3, float4x4(-0.0522313, 0.079263784, 0.10858985, -0.031472187, 0.072964184, -0.065342486, -0.03705779, 0.12809205, 0.09141905, 0.042783994, -0.028724866, -0.08221137, 0.13597457, 0.029334683, -0.12261823, -0.0052482346));
	target1 += mul(na1, float4x4(0.018523648, -0.21706165, -0.14580801, 0.038885653, -0.030849187, -0.06640324, 0.0011639405, 0.097421385, -0.10876752, 0.14631185, 0.014579094, 0.13907033, 0.1310694, -0.1287285, 0.03553917, 0.025316685));
	target1 += mul(nb1, float4x4(0.22148734, 0.01278849, -0.1596892, 0.17187239, -0.04219283, -0.064526156, 0.011610614, -0.0094766095, 0.028804665, 0.16347663, -0.09309108, 0.07097134, -0.014338763, 0.051742412, 0.059907336, -0.17768253));
	target1 += mul(nc1, float4x4(-0.06295463, -0.118564956, -0.016017804, 0.050398786, -0.07136999, 0.25657415, -0.035830878, -0.084443375, 0.12151532, -0.089734256, -0.064030536, 0.048108097, -0.01340212, -0.16572993, -0.093480445, 0.088874646));
	target1 += mul(nd1, float4x4(-0.059600584, -0.0052702287, 0.029479535, 0.20121074, -0.07113247, 0.1561413, 0.25110185, -0.060266465, -0.34369025, 0.14528714, 0.060928173, 0.008688357, 0.034280702, -0.004796254, 0.15269074, 0.056567237));
	target1 += mul(ne1, float4x4(0.05273782, -0.10539872, -0.07192354, -0.083380386, 0.097994, -0.20134969, -0.5062206, 0.30952695, -0.041553877, -0.055801403, -0.037597038, -0.13394146, 0.027271803, 0.17738731, 0.3336375, -0.0035211574));
	target1 += mul(nf1, float4x4(0.009962762, 0.11503034, 0.027571376, -0.018972939, 0.057955634, -0.039739445, -0.0676937, 0.09477686, 0.17910802, -0.28064108, -0.12184129, -0.028407406, 0.056930028, 0.024252843, 0.08959171, -0.027298026));
	target1 += mul(ng1, float4x4(-0.010729545, -0.048747167, 0.03880723, -0.006755044, -0.011909068, 0.008659933, 0.0800407, -0.040333465, -0.25750905, 0.29087406, 0.04864783, 0.118413374, -0.03514928, -0.17206238, 0.2095635, 0.039926212));
	target1 += mul(nh1, float4x4(0.0073815766, -0.030507097, 0.13367772, 0.04863103, -0.067190245, 0.039960794, -0.013012274, 0.15617093, -0.33983988, -0.05671963, 0.22061184, -0.03684452, 0.06304772, -0.08322253, 0.1117871, -0.2006011));
	target1 += mul(ni1, float4x4(0.119437724, -0.009319272, -0.07218167, -0.20269917, 0.10248017, -0.009564983, -0.016272334, -0.042979773, 0.11264571, -0.15697405, 0.015802475, 0.11154868, -0.073011585, -0.07225136, 0.15061282, 0.027214698));
	target1 += mul(na2, float4x4(0.03921657, -0.0154446345, -0.01855873, -0.15813923, 0.11489257, -0.10245685, 0.090572976, -0.072605945, -0.069270656, 0.05171411, 0.045471992, -0.028802622, -0.19419885, 0.18310049, 0.06882923, -0.0005851153));
	target1 += mul(nb2, float4x4(0.04575681, -0.020910552, 0.051311508, -0.0004904971, 0.04239284, 0.024153773, 0.030940467, -0.107036866, -0.099398546, 0.30524835, 0.03902779, -0.05217122, 0.14969619, 0.084496036, -0.14226931, -0.07463564));
	target1 += mul(nc2, float4x4(0.05297294, 0.15384737, -0.0069473814, 0.055046722, 0.11697162, 0.2424236, 0.021053674, -0.004738062, 0.014129249, -0.2909751, -0.048418947, 0.014277387, 0.053296436, -0.12475984, 0.07531274, -0.022512587));
	target1 += mul(nd2, float4x4(-0.04752641, 0.0006545224, -0.00589135, -0.026285272, -0.043745905, 0.24044664, 0.027723765, -0.023630425, 0.00869218, 0.028710615, -0.013863237, 0.0809765, 0.06708566, 0.013517718, 0.0012386752, -0.022743834));
	target1 += mul(ne2, float4x4(-0.12600644, 0.0116939265, 0.0491542, 0.06871389, -0.2096317, 0.050711762, -0.0455067, -0.11994795, -0.05030036, 0.20621927, 0.10951404, -0.05465143, 0.09614336, -0.22954291, 0.15239881, 0.04559428));
	target1 += mul(nf2, float4x4(0.020940155, 0.16499193, 0.17525958, -0.051628407, -0.3068143, -0.14576466, 0.00672593, -0.1308778, 0.00072586804, -0.067010164, -0.093788825, 0.005219908, -0.020126363, -0.083521724, -0.0650657, 0.01836861));
	target1 += mul(ng2, float4x4(0.072675996, 0.10010303, -0.1263988, -0.13888146, 0.13648619, 0.09535094, -0.0038582503, 0.10240531, -0.0014882578, -0.21053605, 0.16676606, -0.024605514, -0.06614438, 0.09575527, 0.116414934, -0.18538997));
	target1 += mul(nh2, float4x4(-0.013467567, 0.11274834, 0.07675635, -0.054812886, -0.024862224, 0.044424616, -0.12858495, -0.120611496, -0.1295857, -0.029304063, -0.06629468, -0.22211547, 0.12577437, -0.015624684, -0.10307795, 0.09404936));
	target1 += mul(ni2, float4x4(0.11430831, 0.11486887, -0.06219608, -0.018371167, 0.091516815, 0.0041821343, -0.043150745, -0.11775014, 0.07794832, -0.01944774, -0.031383686, 0.077408955, -0.124252975, 0.062118705, 0.009199536, 0.06538969));
	target1 += mul(na3, float4x4(0.22154011, -0.098727904, -0.08378975, -0.04167056, 0.019208338, -0.02245709, 0.13298267, -0.104098395, 0.053671844, 0.12845491, -0.003814564, 0.0665341, -0.07084713, 0.26803628, 0.09472736, 0.16825765));
	target1 += mul(nb3, float4x4(-0.21349828, -0.14917591, 0.12592548, -0.12721801, 0.086323306, -0.15409322, 0.07365807, 0.00620922, -0.0280901, 0.0957864, 0.10711525, 0.1165179, -0.08383744, 0.14757137, 0.024865197, -0.17536579));
	target1 += mul(nc3, float4x4(-0.044920437, -0.00016428503, 0.035227478, -0.026525848, -0.17628764, 0.044141084, 0.025941433, 0.18698089, 0.0069334265, 0.097304195, -0.08945912, -0.007168394, -0.054236215, -0.2604089, -0.14738831, -0.074961744));
	target1 += mul(nd3, float4x4(-0.043119818, -0.012245711, 0.030121213, -0.0032237277, -0.033457555, 0.052158665, 0.046546284, -0.0047129868, -0.08133807, 0.037123546, 0.08634659, 0.120436855, -0.02609943, 0.11368193, -0.06750012, 0.0007624448));
	target1 += mul(ne3, float4x4(-0.20511842, 0.1999221, 0.099944666, -0.14691514, 0.012555328, -0.22190604, 0.12456348, 0.05391116, 0.031001683, -0.33920962, 0.13921735, 0.101068705, 0.28788915, 0.13809694, -0.10081831, -0.05679542));
	target1 += mul(nf3, float4x4(-0.019705083, 0.08693377, 0.06884471, 0.032386675, 0.10256849, 0.22142375, 0.07398588, 0.03336761, 0.19134827, 0.12654771, -0.39008364, -0.29602188, -0.04149512, 0.018968705, 0.080247656, 0.0480814));
	target1 += mul(ng3, float4x4(0.09539717, -0.10946926, -0.048939522, 0.030059233, -0.17243776, 0.021580435, 0.15642153, -0.10282692, -0.020257011, 0.060849674, 0.040640093, 0.05628088, -0.11358645, -0.16440971, 0.1787329, -0.02685428));
	target1 += mul(nh3, float4x4(0.14034219, 0.21827984, -0.16170599, 0.03681219, -0.051667843, 0.019152328, 0.033406716, -0.025032328, 0.13413768, -0.09349573, 0.10037219, -0.0105256345, -0.17372406, -0.07619186, 0.068273135, 0.088958755));
	target1 += mul(ni3, float4x4(-0.015460073, -0.04781314, -0.008159705, 0.117226824, -0.20293492, 0.019126927, 0.1074034, -0.10307512, 0.1356002, 0.108166546, -0.1275016, -0.023100886, -0.09334954, -0.14509954, 0.1668647, 0.13371155));
	target1 += float4(0.004647682, -0.04675001, -0.041206088, 0.07870823);
	
	float4 target2 = mul(a1, float4x4(-0.0116784945, -0.25090152, -0.17868316, 0.036498535, 0.015182224, 0.2023079, 0.011117134, 0.15237965, -0.015316299, 0.088544175, -0.06572522, -0.08057326, -0.22271864, -0.30610234, -0.12208543, -0.22944431));
	target2 += mul(b1, float4x4(-0.11143165, -0.077543005, -0.061455075, -0.037597977, -0.0023224957, -0.10979736, -0.034990564, -0.008420816, -0.094636045, -0.030254573, -0.06455877, -0.020989688, 0.018324712, -0.3669934, -0.350233, 0.037510827));
	target2 += mul(c1, float4x4(0.104956195, 0.015602951, -0.051957965, 0.13510315, 0.010418954, -0.054195777, 0.018231759, 0.045083612, 0.09856977, -0.10220956, -0.029939203, 0.01315078, -0.29208857, 0.0017958464, 0.08760539, -0.09646556));
	target2 += mul(d1, float4x4(0.046938017, 0.08242743, 0.13486576, -0.087577604, 0.1157099, 0.101392664, 0.14847688, 0.037801757, 0.018798033, -0.25906846, 0.097656235, -0.009259822, 0.10044328, 0.33434513, -0.15681681, -0.07497045));
	target2 += mul(e1, float4x4(0.113606565, 0.15215175, 0.056206945, 0.03135906, -0.06457102, 0.028175417, -0.06261949, -0.015601963, -0.048961632, 0.07163545, 0.0147160115, 0.037389677, 0.092339285, 0.26372424, 0.1122662, -0.058904216));
	target2 += mul(f1, float4x4(-0.21457312, 0.1408831, -0.08713026, -0.06950515, 0.006483218, 0.028784987, -0.02613041, -0.06227427, 0.024932534, -0.02103815, 0.080908604, 0.078669965, 0.19956729, -0.035375793, -0.046653055, 0.07523847));
	target2 += mul(g1, float4x4(-0.11979529, -0.15300119, -0.06692378, 0.0982862, -0.05148871, -0.16330053, -0.045053672, 0.022939514, -0.013373179, 0.38319084, 0.11172139, -0.07044107, 0.09208871, -0.07254955, -0.03284103, 0.05421524));
	target2 += mul(h1, float4x4(-0.09024579, 0.022398917, -0.084611446, 0.1254619, -0.0028836168, -0.092541836, -0.06697658, -0.09709128, 0.10234711, -0.1247404, 0.031691026, 0.0087786, -0.09046125, 0.059536055, 0.2076767, 0.15046969));
	target2 += mul(i1, float4x4(-0.18603326, 0.0022851937, -0.10218833, 0.18102962, 0.030617537, -0.005931309, -0.06299933, -0.13356128, -0.03377612, -0.009710565, -0.10352098, -0.20960933, 0.10586698, 0.018833099, 0.16208176, -0.048466753));
	target2 += mul(a2, float4x4(-0.004165509, -0.112526424, -0.1481008, -0.09386717, 0.017359056, -0.16117403, 0.065114655, 0.15273894, 0.0850914, -0.6033039, -0.102531776, -0.09553129, 0.06812466, -0.17199127, 0.009345428, -0.117129266));
	target2 += mul(b2, float4x4(0.19360402, -0.2172338, -0.025270093, 0.041762922, -0.06813442, -0.1315374, -0.03864256, -0.083543435, -0.14600715, -0.10248121, -0.039856248, 0.034162194, -0.06736031, 0.07872902, -0.06577812, -0.07003804));
	target2 += mul(c2, float4x4(0.2596632, -0.06779467, -0.061247632, 0.09280383, 0.15697475, -0.06379218, 0.117600165, 0.19564915, -0.043823496, 0.2113048, 0.1236739, 0.05126704, 0.0036669953, 0.059754487, -0.031676155, 0.07585315));
	target2 += mul(d2, float4x4(0.2750924, 0.07154958, -0.043717247, 0.11531165, 0.07236982, 0.112787254, 0.024018776, -0.0073595895, 0.037517104, -0.06963889, -0.13254988, -0.1347438, 0.08744426, 0.036659624, -0.010376286, -0.0011054546));
	target2 += mul(e2, float4x4(0.21909392, -0.15014122, -0.1724268, -0.11459151, 0.07886104, -0.039391857, -0.086656936, -0.18109863, 0.13549148, 0.24947289, -0.11073447, -0.012388639, -0.06299071, 0.094953805, -0.018513478, 0.11858225));
	target2 += mul(f2, float4x4(0.14019133, 0.289657, -0.13005698, 0.08418524, -0.15852125, 0.2049765, -0.18946235, -0.03330375, 0.057983503, 0.17226145, -0.16830897, -0.047264732, 0.027640691, -0.010081246, 0.14454436, 0.081710726));
	target2 += mul(g2, float4x4(0.1674246, 0.28778687, 0.19290589, 0.086525135, 0.09838388, 0.1437797, 0.18871532, -0.31380877, -0.13105413, -0.15920939, -0.049839422, 0.025027066, -0.042670842, -0.07288023, -0.03385935, 0.03853164));
	target2 += mul(h2, float4x4(0.26396382, -0.09383774, 0.10738164, 0.058519054, 0.01883401, 0.023963995, -0.09510717, 0.25038752, 0.004994643, 0.26613802, 0.11163109, -0.09746982, -0.08012294, 0.092731714, 0.024274494, 0.040725235));
	target2 += mul(i2, float4x4(0.024282128, 0.07086445, 0.04124535, -0.04565769, -0.043728314, -0.15438943, 0.06610379, 0.07666126, -0.046235953, 0.04901646, -0.045347054, -0.0908177, 0.03715751, -0.09512116, 0.024934331, 0.019330366));
	target2 += mul(a3, float4x4(-0.0610446, -0.00039494174, 0.11040924, 0.09711379, -0.033694427, 0.042628422, 0.04497454, -0.08639888, -0.006714255, -0.1956921, -0.07696048, -0.1440855, -0.036684107, 0.08872227, -0.014518533, -0.081829615));
	target2 += mul(b3, float4x4(0.03242377, 0.2742694, 0.15646815, 0.12491848, -0.097658925, 0.04652564, -0.20971832, -0.22238888, -0.045453016, -0.10306553, -0.14868681, -0.03697577, 0.037367497, 0.106009305, 0.0006840817, -0.06331295));
	target2 += mul(c3, float4x4(-0.09252423, -0.260707, 0.060529877, 0.1422387, 0.13040084, 0.060533516, -0.15988415, 0.093058884, -0.063219644, 0.16596133, -0.0858158, 0.0010563346, -0.05912638, -0.14902595, -0.0055698613, -0.19287406));
	target2 += mul(d3, float4x4(0.050616026, 0.027293183, 0.1349355, 0.06430556, -0.0017233352, 0.05913591, 0.111860454, 0.05829484, -0.036098555, 0.065207146, -0.049812254, -0.14549483, -0.12424656, 0.1472102, 0.031858474, 0.017159335));
	target2 += mul(e3, float4x4(0.018377563, 0.13093959, 0.15379103, 0.12314944, 0.040771928, -0.066829674, -0.05734121, 0.105038896, 0.29102528, -0.015173645, -0.004220056, -0.13141808, -0.20211789, 0.16278313, 0.09339586, -0.06485214));
	target2 += mul(f3, float4x4(-0.000521399, -0.3693901, 0.17483166, 0.16742888, -0.06343791, 0.042411476, 0.13772172, 0.064281724, -0.034507953, 0.03691756, 0.13490774, 0.10946845, 0.12370677, -0.03205938, -0.02645649, -0.15375873));
	target2 += mul(g3, float4x4(0.023370143, 0.11848177, 0.005112462, 0.026092546, 0.034971926, -0.08103188, -0.20400497, 0.06226299, -0.060475063, 0.035214186, -0.13627078, 0.045491677, -0.07321337, -0.10956125, 0.056908336, -0.0032308386));
	target2 += mul(h3, float4x4(0.076967224, 0.117254384, 0.03186256, 0.2218116, 0.05217254, -0.13943173, 0.058474854, 0.13177274, -0.019476373, 0.14138101, -0.012791203, 0.12705484, -0.013589421, -0.10622012, -0.0021916716, 0.015177393));
	target2 += mul(i3, float4x4(-0.061352234, -0.032728117, -0.16315818, 0.08222588, 0.013996033, 0.057500184, -0.11674498, -0.10170402, -0.03012877, -0.14447689, 0.032117244, 0.11841102, -0.0070680035, -0.15353645, 0.14097273, -0.12609388));
	target2 += mul(na1, float4x4(-0.1366668, 0.022588843, -0.06960645, -0.019482136, 0.008831277, 0.005849642, -0.042811397, -0.10104664, -0.21647254, -0.055100426, 0.10582604, 0.091224626, 0.16348936, -0.04480947, -0.08394584, 0.14027816));
	target2 += mul(nb1, float4x4(-0.05215042, -0.22153285, -0.07402603, -0.1395589, -0.26351386, 0.060670085, 0.12676051, 0.0018233472, 0.09564221, -0.14353068, 0.23205271, -0.026433198, -0.04914892, 0.09260728, 0.016136972, -0.037016835));
	target2 += mul(nc1, float4x4(-0.09228144, 0.028619789, -0.011197684, 0.043782573, 0.061469227, 0.019487167, 0.046048775, -0.060745444, -0.24178508, -0.11117579, 0.1313642, -0.20273723, 0.081280276, -0.015113924, -0.008701512, 0.038079187));
	target2 += mul(nd1, float4x4(-0.092076614, -0.14906341, -0.013150191, -0.1445046, 0.023577487, -0.088496424, -0.03039066, -0.028063597, 0.033408202, 0.105900854, -0.098281376, 0.09988187, -0.04934366, 0.1647861, 0.15974896, 0.0484809));
	target2 += mul(ne1, float4x4(0.043313354, -0.079856, -0.29574707, -0.23970212, -0.23463657, -0.061711017, -0.12481534, 0.21037807, -0.010700073, 0.14672308, 0.15071099, -0.03755617, 0.072450034, 0.083081506, -0.001196162, -0.055120632));
	target2 += mul(nf1, float4x4(0.20737736, 0.008907195, -0.11623631, -0.038137514, 0.037122898, -0.10322798, -0.065684326, -0.010471773, -0.12765402, -0.117699586, -0.012870391, 0.071912766, -0.03260932, 0.12864828, -0.035069928, -0.08712889));
	target2 += mul(ng1, float4x4(-0.05578123, 0.056912176, 0.01512389, -0.14807466, -0.012101421, 0.10860546, 0.034598228, 0.07160875, 0.15761101, -0.4777804, -0.24159615, -0.006523453, -0.28167522, -0.14714232, -0.1693888, -0.111417554));
	target2 += mul(nh1, float4x4(0.25981572, 0.1301148, -0.01769167, -0.10818973, 0.16135831, 0.024396034, -0.06722463, -0.032221332, -0.12383674, 0.038760092, 0.052030306, 0.077312715, -0.007761604, -0.12031171, 0.018808518, -0.103885494));
	target2 += mul(ni1, float4x4(0.048577465, 0.025990447, -0.07106119, 0.15832591, 0.019197416, 0.044232063, -0.030652093, 0.011447957, 0.18041368, -0.28076535, 0.022676598, -0.15350787, -0.1514482, -0.2362105, 0.14161605, 0.030001758));
	target2 += mul(na2, float4x4(0.2541123, 0.050012548, 0.1707829, 0.025630053, 0.078972176, 0.17645672, -0.020095231, 0.03378738, -0.1328695, 0.04409738, -0.23381121, -0.013347802, -0.049448222, 0.07035769, 0.105488785, 0.08659344));
	target2 += mul(nb2, float4x4(0.10455444, 0.28242826, 0.16516706, -0.046555575, 0.13230863, 0.07463435, -0.14748469, 0.11881527, 0.2279376, 0.14795774, 0.21520549, -0.05650647, 0.11728158, 0.048864357, 0.040869843, 0.1442246));
	target2 += mul(nc2, float4x4(0.21203394, -0.06565692, 0.03824069, 0.011281014, -0.033808656, 0.12499576, -0.13186213, -0.043884885, 0.017813649, 0.18413112, 0.046354674, -0.05213395, -0.051737677, -0.07141214, 0.03402196, -0.06220277));
	target2 += mul(nd2, float4x4(0.05735565, -0.12864622, 0.051514987, 0.03940558, -0.08701596, -0.1948226, 0.034218855, -0.03742723, 0.15607446, 0.0327541, 0.04040029, 0.0028771486, -0.08412264, -0.016660625, -0.058885157, 0.09373861));
	target2 += mul(ne2, float4x4(0.069591254, 0.018901952, 0.008289076, 0.08653302, -0.009072406, -0.11095817, 0.20987292, 0.016384758, 0.05693833, -0.118542574, 0.11310585, 0.073924355, 0.10250452, -0.043420166, -0.07558694, -0.10898524));
	target2 += mul(nf2, float4x4(-0.030319573, -0.3339516, -0.0689396, 0.01270701, 0.2504168, -0.08088952, 0.048351087, 0.013527536, -0.04373888, -0.27049688, 0.052563794, 0.010002367, 0.038096514, 0.0740455, -0.17847466, -0.1106183));
	target2 += mul(ng2, float4x4(-0.041473575, 0.036192052, -0.20958827, 0.09255741, 0.043088675, -0.07332803, -0.1566315, 0.19757885, 0.04752265, 0.14642613, 0.021630943, -0.105035484, 0.015669389, 0.015701298, 0.124771506, 0.028875854));
	target2 += mul(nh2, float4x4(-0.0017878636, 0.06815434, 0.03952396, 0.0008930589, 0.10052908, -0.010179957, 0.090537265, 0.26063922, -0.027913721, -0.27610707, -0.0935186, 0.103001356, -0.013015698, -0.13290603, -0.036786307, -0.120041944));
	target2 += mul(ni2, float4x4(0.008112194, 0.101246096, 0.10216113, 0.012162128, 0.16638301, 0.03442679, -0.013482703, 0.22639573, -0.106342115, 0.16007386, 0.1562559, 0.031520694, -0.04781568, 0.061812893, 0.063238494, -0.112484284));
	target2 += mul(na3, float4x4(-0.07636386, 0.02620731, -0.04784259, -0.0068134456, -0.098476306, -0.25026417, -0.26229498, 0.07999187, 0.08054805, -0.13999973, 0.038135037, -0.017274393, -0.07507948, -0.19170132, -0.111937724, -0.07482982));
	target2 += mul(nb3, float4x4(-0.102867655, 0.041831665, -0.26580745, 0.072875075, 0.122495115, -0.24738726, 0.01103763, 0.010455935, 0.10415628, 0.071636476, 0.24413374, 0.036024485, -0.14325532, -0.028743692, 0.09872556, 0.019074876));
	target2 += mul(nc3, float4x4(-0.08356808, 0.031134086, -0.0018714333, 0.052166995, -0.050258227, 0.015659487, -0.010771479, -0.094513185, 0.120308846, -0.16520835, 0.24742663, 0.0097768335, -0.26430902, 0.00096495246, -0.010277926, -0.03203841));
	target2 += mul(nd3, float4x4(-0.08886612, 0.045868922, -0.23351108, -0.11945227, -0.08114231, 0.1866038, -0.014666174, 0.10560594, 0.23003237, -0.031111564, 0.08909732, -0.004926665, 0.14808343, 0.012070922, 0.26077467, -0.13846008));
	target2 += mul(ne3, float4x4(0.02067818, 0.010505095, 0.1236986, 0.004310499, -0.23058774, 0.4539795, -0.1107521, 0.2687594, -0.088774115, 0.08556259, -0.28480148, 0.16472621, 0.22381066, 0.04922506, 0.03720699, -0.019955777));
	target2 += mul(nf3, float4x4(0.02878623, 0.08478639, 0.2798358, 0.08889886, 0.094446555, 0.022878725, 0.04060367, 0.008747965, 0.074154414, -0.36745515, -0.22710432, -0.17041051, 0.16977836, 0.18033457, -0.1422643, -0.06097858));
	target2 += mul(ng3, float4x4(-0.1882957, 0.07039768, 0.012633585, 0.0782871, 0.03383675, -0.07504364, -0.006248557, -0.0551174, 0.075581536, 0.091343425, 0.07753647, -0.0019186279, -0.016886314, 0.16758795, -0.060557626, -0.16569303));
	target2 += mul(nh3, float4x4(-0.13320294, -0.055567943, 0.05735829, 0.12787667, 0.04922832, -0.012577599, -0.13878204, -0.014323274, 0.06648109, -0.026210563, 0.019616883, -0.27789673, 0.051355522, -0.13060455, 0.039109703, 0.036932684));
	target2 += mul(ni3, float4x4(-0.10139845, -0.22758122, 0.044597298, 0.07907936, -0.025654264, -0.10633203, 0.04071873, 0.22363085, 0.12398309, 0.36964926, 0.21903247, -0.3217227, 0.030226095, 0.07867376, 0.045920413, 0.102684624));
	target2 += float4(-0.06939391, 0.017302405, 0.023963664, -0.011060264);
	
	float4 target3 = mul(a1, float4x4(-0.12172707, 0.08510432, 0.016999101, -0.03837886, -0.071940385, -0.028869554, -0.073142946, -0.018426571, -0.16583674, 0.02999741, -0.045404267, 0.07544135, -0.015742308, 0.051709145, 0.07165505, 0.15298915));
	target3 += mul(b1, float4x4(-0.18608806, -0.08503095, -0.05690552, 0.20230335, 0.03255425, -0.07374758, 0.02050966, -0.0322938, 0.029025763, 0.045261286, 0.040862788, 0.0007141505, -0.040648397, -0.09871272, 0.06639088, -0.10357326));
	target3 += mul(c1, float4x4(0.1160622, -0.021342635, -0.039825406, -0.19480887, 0.13462403, -0.06567422, 0.04279539, -0.012501501, -0.06882412, 0.24730788, -0.11261373, 0.15826169, -0.1942516, -0.011018759, -0.006282914, 0.15791936));
	target3 += mul(d1, float4x4(-0.24771467, -0.029817501, -0.0072410326, 0.0049591805, 0.002406374, 0.06705227, 0.0746882, -0.021962378, 0.02235974, -0.09111428, 0.046035543, -0.05091351, 0.12882613, -0.0052345973, 0.20476472, -0.035007346));
	target3 += mul(e1, float4x4(0.07206948, 0.007837054, 0.004716684, 0.032783184, -0.1640229, 0.09656901, -0.024538686, -0.13850725, 0.0020381159, -0.119971916, -0.03598378, 0.098396435, 0.11248338, 0.013638009, -0.13411912, -0.091735974));
	target3 += mul(f1, float4x4(0.012680958, 0.0073848446, -0.15104567, -0.086190425, 0.017306415, -0.12165865, -0.030102974, -0.06412363, -0.048320986, 0.066044435, -0.037102707, -0.05550032, -0.022057295, -0.016380537, -0.023064991, 0.04324733));
	target3 += mul(g1, float4x4(0.014645644, 0.029250145, -0.19020447, 0.06094981, 0.06021305, 0.033002753, -0.08270684, -0.13078806, -0.078915745, 0.03234919, 0.0033177685, 0.025673114, -0.10040817, -0.11726593, 0.26478398, -0.021515043));
	target3 += mul(h1, float4x4(-0.03930199, -0.007856709, -0.010699159, -0.03138408, -0.25258276, -0.051078923, -0.17284779, 0.115362965, 0.20981595, -0.12642711, -0.07527823, -0.21674243, -0.05171349, -0.032929346, -0.11959963, 0.021577986));
	target3 += mul(i1, float4x4(-0.12679584, -0.00971076, -0.2065375, -0.10207124, 0.1189984, 0.13061368, 0.048184898, 0.009846873, 0.08049477, -0.052818604, 0.024915429, -0.089877605, 0.028596658, -0.049394336, 0.15412825, -0.25427133));
	target3 += mul(a2, float4x4(-0.042340282, 0.15739791, -0.0058195787, 0.11638454, -0.29605922, 0.04940588, -0.12277728, 0.06556332, -0.15141304, -0.007342225, -0.015176599, 0.19668026, -0.029852653, 0.1131092, 0.06274694, 0.19488528));
	target3 += mul(b2, float4x4(0.17317021, 0.12034029, 0.023154281, -0.035767153, 0.023895182, 0.08562897, 0.010849429, 0.15511833, -0.071655706, 0.06762927, 0.110938646, -0.11194944, 0.088547744, 0.01826857, 0.10635028, 0.00079735904));
	target3 += mul(c2, float4x4(0.1724684, 0.072277844, -0.07157608, 0.014533819, 0.21083286, -0.10260293, -0.042641845, -0.022131564, 0.15609416, -0.012785209, 0.1689822, 0.08156936, -0.05814626, 0.12873544, 0.013016528, 0.07162671));
	target3 += mul(d2, float4x4(0.10265145, -0.15034834, -0.020390334, 0.051008113, 0.13483785, -0.036995072, 0.10197256, 0.07332627, 0.24034818, 0.041877862, 0.101294585, -0.038894523, -0.036132984, -0.09265928, -0.056219723, -0.02888855));
	target3 += mul(e2, float4x4(0.2652024, -0.01230703, 0.23594856, 0.0742723, 0.09739247, 0.0483161, 0.023852533, 0.17482124, -0.09551598, 0.07907358, 0.09280555, 0.27893403, -0.016893778, -0.15504459, 0.07111864, 0.17860727));
	target3 += mul(f2, float4x4(0.009993413, -0.034769267, 0.06733924, -0.026964549, 0.30227652, 0.0139632225, 0.049200308, -0.07578955, 0.061411507, 0.1924837, -0.008919774, -0.02543576, 0.08537961, 0.01291466, 0.07587885, -0.19892685));
	target3 += mul(g2, float4x4(0.079757795, -0.021056721, -0.119849935, -0.1829519, 0.25801504, 0.08255822, 0.09422877, -0.26859275, -0.17237917, 0.030880162, -0.073090166, 0.045552216, -0.15178613, 0.046667624, 0.05506945, 0.120318785));
	target3 += mul(h2, float4x4(0.13899504, 0.2106589, 0.09166694, -0.06926149, 0.13418478, 0.017007234, 0.027100448, -0.062565625, -0.021934774, 0.067251615, -0.10328445, 0.033577222, -0.050557505, -0.035202354, -0.062489368, -0.02470738));
	target3 += mul(i2, float4x4(0.15340589, 0.11806747, 0.20874004, 0.048173226, -0.05472843, 0.084544346, -0.043854542, -0.07571899, 0.036645986, 0.05016359, -0.074323095, -0.2529282, 0.13572234, -0.008771343, 0.11274458, 0.18037859));
	target3 += mul(a3, float4x4(0.021645557, 0.08299124, -0.051362146, 0.09342637, 0.0665058, 0.09216755, -0.0164684, 0.07281118, -0.0053016874, 0.032470454, 0.004089323, 0.009884544, -0.0046753073, -0.037279285, 0.12613527, 0.022236153));
	target3 += mul(b3, float4x4(-0.06745298, -0.15038055, 0.11176774, -0.06209666, 0.017843692, 0.09113945, 0.10990877, -0.021071523, -0.111020654, 0.066645324, 0.04690986, -0.011084726, -0.15171939, 0.084783286, 0.24798997, -0.042696327));
	target3 += mul(c3, float4x4(-0.05915715, -0.22595185, 0.061333664, -0.0924661, -0.013238295, 0.12872066, 0.076126665, 0.18921073, 0.01155994, 0.092524104, 0.07423282, 0.09467482, 0.070056126, -0.06073076, 0.030242696, -7.544676e-05));
	target3 += mul(d3, float4x4(0.110107556, 0.0036358358, -0.013859793, 0.008409858, -0.021337144, -0.2092404, 0.054274913, 0.013595842, 0.058993395, 0.029181428, 0.15061715, -0.046964824, 0.044353873, -0.036482453, 0.22763032, -0.018364066));
	target3 += mul(e3, float4x4(0.20778932, -0.049483854, 0.24778971, -0.3266631, -0.11545233, -0.093305275, -0.4550674, 0.2352049, 0.0052719507, -0.045975342, -0.35826904, -0.058102172, -0.096291795, -0.11218896, 0.23879842, -0.03641578));
	target3 += mul(f3, float4x4(-0.109331824, 0.00814177, -0.08803353, 0.06688425, -0.09283131, 0.031705324, 0.040918272, 0.18237656, -0.07152109, 0.12277652, -0.059865803, -0.06869673, 0.11195339, -0.1325457, 0.1912906, -0.08553347));
	target3 += mul(g3, float4x4(-0.10984097, 0.15747224, -0.019459615, 0.24969575, -0.01159421, -0.027474519, -0.004108195, -0.062133413, -0.06384389, -0.08368246, 0.0023778875, 0.13171864, -0.05652675, 0.14332311, -0.15735596, 0.20150533));
	target3 += mul(h3, float4x4(0.078031205, -0.12403856, 0.04191835, -0.16050112, 0.11339027, 0.074540265, -0.15324953, -0.093895815, -0.0614043, -0.013293006, -0.12348063, 0.026803058, -0.1773178, -0.083579265, -0.054864556, 0.296814));
	target3 += mul(i3, float4x4(-0.053263642, -0.048648115, -0.010281689, 0.20099847, 0.190146, -0.0023872026, -0.010445226, -0.04350378, -0.017980015, -0.04147092, -0.08261166, -0.031094978, -0.046422567, 0.120881446, -0.054973155, -0.058380593));
	target3 += mul(na1, float4x4(-0.16745642, 0.07924586, -0.16717474, 0.06620602, 0.16495655, 0.0293633, 0.07890249, -0.30954084, 0.03467237, -0.20190205, 0.0014116743, -0.32280523, -0.14156029, -0.06447037, -0.21021147, 0.0687274));
	target3 += mul(nb1, float4x4(-0.04360317, 0.14327015, -0.06630513, -0.09011326, -0.0919624, -0.09085504, 0.024597472, 0.23315085, 0.039139662, -0.17370877, 0.048785537, -0.10094988, 0.010336257, -0.016844554, -0.05375775, -0.041789643));
	target3 += mul(nc1, float4x4(-0.04296336, -0.093379766, 0.005651271, -0.090673715, 0.021506978, -0.08289978, 0.16281237, -0.0939677, -0.10273288, -0.22043118, 0.062697254, -0.027947478, -0.08711271, 0.0077892793, -0.10296665, 0.049631704));
	target3 += mul(nd1, float4x4(-0.09388834, -0.02609863, -0.043841925, -0.020223266, -0.023729876, 0.07854283, -0.19361661, -0.02297985, -0.003995974, 0.03295993, -0.07480908, -0.03279157, 0.20216386, -0.06685853, -0.22405225, -0.22138701));
	target3 += mul(ne1, float4x4(-0.041702025, 0.03686083, 0.051558632, 0.08093031, 0.0004725686, 0.0050831046, -0.31346506, 0.24020754, -0.012426937, 0.24121699, 0.0522848, 0.0524269, 0.0041041574, 0.20183508, 0.30658904, -0.099001035));
	target3 += mul(nf1, float4x4(0.0057143304, 0.07863334, 0.030834159, -0.20045337, -0.14132334, -0.019685036, -0.041891463, 0.04859716, -0.19865768, -0.16805026, -0.21894583, 0.08326542, 0.1381732, 0.06524222, 0.14627486, 0.105718866));
	target3 += mul(ng1, float4x4(-0.06811638, -0.07022535, -0.08053529, -0.019539276, -0.0013508294, -0.067808755, 0.14990425, -0.020371182, 0.2161962, 0.012578056, -0.07941276, -0.29615018, -0.11092915, 0.10959083, -0.38344857, -0.04684961));
	target3 += mul(nh1, float4x4(0.05912716, -0.007058617, 0.0053731226, -0.20157285, -0.0039983774, 0.1626744, -0.15158534, -0.0880334, -0.095339596, -0.102986366, 0.16870484, 0.37301186, 0.046958193, -0.018308617, 0.2801249, -0.1583765));
	target3 += mul(ni1, float4x4(0.03710428, 0.12427524, -0.15491271, 0.0521613, -0.104145944, -0.11358381, -0.11450005, -0.03948202, -0.022532975, 0.013648349, -0.05297846, -0.05551, 0.012648896, 0.013729304, 0.004389595, 0.033111174));
	target3 += mul(na2, float4x4(0.092548154, 0.12822087, 0.03935411, -0.03887123, 0.18817197, -0.010538254, -0.13670439, -0.073919185, 0.020497803, 0.030874884, 0.023953672, 0.0029225757, 0.1144403, -0.08691024, 0.05340699, -0.10702303));
	target3 += mul(nb2, float4x4(0.1613281, 0.05971506, 0.042405322, 0.005931725, -0.09373433, -0.06380234, -0.064201795, -0.014180793, 0.0671638, -0.01367733, 0.14260428, -0.11077721, -0.045686133, 0.056600757, -0.15297161, -0.005997308));
	target3 += mul(nc2, float4x4(0.24641256, 0.06483951, 0.060505014, -0.009762036, -0.04572455, 0.03593092, 0.03415938, -0.14721255, -0.107680336, 0.09697482, 0.016876915, 0.18656448, 0.016999245, -0.08490942, -0.040251363, -0.074220374));
	target3 += mul(nd2, float4x4(0.25207043, 0.11133333, 0.13421617, -0.10310646, -0.22712758, 0.11617119, 0.06397493, -0.011858522, -0.115762815, -0.050787542, 0.06386407, -0.1579078, -0.12903711, 0.084837236, 0.07354705, 0.02250288));
	target3 += mul(ne2, float4x4(0.14158289, 0.07666087, -0.20075443, -0.010602763, -0.02820616, 0.0944957, 0.15453936, -0.15856305, 0.1749605, -0.12841891, -0.017792901, -0.10751241, -0.059640024, 0.13478336, -0.35048804, -0.20975049));
	target3 += mul(nf2, float4x4(0.18300997, 0.0895379, 0.084789746, 0.092567876, -0.16524926, 0.1414963, -0.15058212, 0.13400394, -0.113864176, -0.05660036, -0.0001961134, 0.14347304, 0.16637255, -0.18054125, 0.009827294, 0.21254125));
	target3 += mul(ng2, float4x4(0.11330536, 0.020117162, 0.049111363, 0.059246156, -0.17288256, -0.07703511, -0.064532675, 0.10420442, 0.100950584, -0.11876045, 0.013643637, -0.060119864, 0.16402918, -0.0701684, 0.10797075, 0.15408994));
	target3 += mul(nh2, float4x4(0.034557853, -0.09076456, -0.06957025, 0.11215256, 0.09526117, -0.0033204784, -0.11551807, -0.03458551, -0.025462642, 0.0434891, 0.3050603, 0.053797644, 0.10751034, 0.060085565, 0.15370789, -0.2315563));
	target3 += mul(ni2, float4x4(-0.046833776, -0.006102459, 0.1123578, 0.24187551, 0.03283197, -0.11041104, 0.20806998, 0.008368949, -0.1924367, 0.03361783, -0.045319956, -0.08859883, -0.2011492, 0.0912345, 0.048245467, -0.005335901));
	target3 += mul(na3, float4x4(-0.18253306, -0.0011128648, -0.044692483, -0.057080504, -0.05725425, -0.19065356, -0.03155062, 0.06648306, -0.014216424, -0.0038765708, -0.017490484, -0.15456702, -0.010514629, -0.08982491, 0.10435141, 0.030280044));
	target3 += mul(nb3, float4x4(0.01791952, 0.1946834, 0.16822097, 0.18846266, -0.075084575, -0.10975577, -0.12906383, 0.20190994, 0.10143081, -0.2725471, -0.035883784, -0.22165625, -0.15959083, -0.34200552, 0.15872408, -0.021841785));
	target3 += mul(nc3, float4x4(0.029525736, 0.04896955, -0.011629367, 0.011558814, 0.00933636, -0.12728998, 0.0053133606, 0.019774856, 0.099030845, -0.27376446, -0.08325353, -0.20274483, -0.26426545, -0.17067485, -0.14366214, -0.21118636));
	target3 += mul(nd3, float4x4(-0.009527981, -0.033085525, -0.00047734487, -0.040472545, 0.071459636, 0.0954099, -0.060635693, 0.036283012, 0.1324083, 0.050335824, -0.2460094, -0.04979816, -0.09456389, 0.09053007, 0.11540641, -0.21168198));
	target3 += mul(ne3, float4x4(0.004067291, 0.1497142, 0.100381024, 0.083456755, 0.10807039, -0.05651095, 0.021606952, -0.005951023, -0.067543074, 0.21499002, -0.021271145, 0.20417792, 0.05860774, 0.20977509, -0.10931411, 0.16582364));
	target3 += mul(nf3, float4x4(-0.05491801, 0.0055349297, 0.03950427, 0.007250093, -0.062947564, -0.14126986, -0.06730335, -0.034683496, -0.03981397, -0.21181524, 0.21769942, -0.103150204, -0.17016284, 0.048786215, -0.014319224, 0.17676318));
	target3 += mul(ng3, float4x4(-0.14126709, -0.032334052, 0.05638739, 0.11381126, 0.30596843, -0.12634167, 0.23541147, 0.08096712, 0.09152563, 0.18567194, -0.25563926, -0.21220013, -0.10782045, -0.044764172, 0.14415121, 0.10968688));
	target3 += mul(nh3, float4x4(-0.034708634, -0.037528913, -0.0846457, -0.24652602, -0.09284069, -0.103932016, 0.09996971, 0.04605858, 0.06597961, 0.06697364, -0.028432503, -0.032057744, 0.052634656, 0.02281619, 0.17896608, -0.1521084));
	target3 += mul(ni3, float4x4(-0.0043455027, -0.07276675, 0.03043292, 0.07712516, -0.20799218, -0.25933886, -0.11458076, -0.0025673904, 0.08385744, 0.33315855, -0.035151098, -0.19899674, -0.005009251, 0.056176793, 0.045722242, 0.17721124));
	target3 += float4(-0.020202361, -0.0016936217, 0.023388062, 0.10373034);

	tex1[gxy] = target1;
	tex2[gxy] = target2;
	tex3[gxy] = target3;
}

//!PASS 4
//!DESC Conv-4x3x3x24
//!IN tex1, tex2, tex3
//!OUT tex4, tex5, tex6
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass4(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	float4 a1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d1 = tex1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e1 = tex1.SampleLevel(sam, pos, 0);
	float4 f1 = tex1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na1 = max(-a1, 0);
	float4 nb1 = max(-b1, 0);
	float4 nc1 = max(-c1, 0);
	float4 nd1 = max(-d1, 0);
	float4 ne1 = max(-e1, 0);
	float4 nf1 = max(-f1, 0);
	float4 ng1 = max(-g1, 0);
	float4 nh1 = max(-h1, 0);
	float4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	float4 a2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d2 = tex2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e2 = tex2.SampleLevel(sam, pos, 0);
	float4 f2 = tex2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na2 = max(-a2, 0);
	float4 nb2 = max(-b2, 0);
	float4 nc2 = max(-c2, 0);
	float4 nd2 = max(-d2, 0);
	float4 ne2 = max(-e2, 0);
	float4 nf2 = max(-f2, 0);
	float4 ng2 = max(-g2, 0);
	float4 nh2 = max(-h2, 0);
	float4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    float4 a3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d3 = tex3.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e3 = tex3.SampleLevel(sam, pos, 0);
	float4 f3 = tex3.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na3 = max(-a3, 0);
	float4 nb3 = max(-b3, 0);
	float4 nc3 = max(-c3, 0);
	float4 nd3 = max(-d3, 0);
	float4 ne3 = max(-e3, 0);
	float4 nf3 = max(-f3, 0);
	float4 ng3 = max(-g3, 0);
	float4 nh3 = max(-h3, 0);
	float4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	float4 target1 = mul(a1, float4x4(-0.2582688, 0.116867825, 0.009512264, -0.0022509228, 0.13270317, 0.019233711, 0.014508687, 0.01733284, -0.121534936, 0.2637504, -0.16833198, 0.08360115, 0.09262769, -0.09723933, -0.08402722, -0.06326682));
	target1 += mul(b1, float4x4(0.32656944, 0.035490595, 0.014057071, 0.08615446, -0.001598092, 0.16362181, -0.10130158, 0.16792357, 0.03340437, 0.037359558, 0.09397945, 0.11016778, 0.08567979, 0.31809476, 0.085573055, -0.15427281));
	target1 += mul(c1, float4x4(0.16257697, -0.03590016, -0.19049743, -0.13342945, 0.013655946, -0.11739747, -0.008941973, 0.015134444, -0.17258401, 0.17935902, 0.06434015, -0.06638789, 0.17013264, -0.171608, 0.07526482, 0.29814368));
	target1 += mul(d1, float4x4(-0.14037174, -0.060715932, 0.012513121, 0.05294183, -0.05479372, -0.13937469, 0.01836811, -0.133735, -0.29546124, -0.14349708, 0.14202882, -0.03247825, -0.054209106, 0.002391278, -0.024334526, -0.10866433));
	target1 += mul(e1, float4x4(-0.098666176, 0.009357217, 0.14404769, -0.03864725, -0.21861532, 0.24275939, 0.3084927, -0.17814654, -0.06785066, -0.20976599, -0.010328756, -0.0075252843, -0.1265569, -0.3896638, -0.07620251, -0.17581807));
	target1 += mul(f1, float4x4(-0.028447198, 0.088148355, -0.11362386, 0.032440383, -0.017401151, 0.2062452, -0.1613577, -0.07957526, 0.31136703, -0.06775296, -0.019393584, -0.063142054, -0.12292114, 0.010548703, 0.03203177, -0.053964596));
	target1 += mul(g1, float4x4(0.108504035, -0.20656614, -0.04412517, -0.047383796, 0.038306333, -0.20189808, -0.07821153, -0.0229348, 0.10628414, -0.015934726, -0.08728048, -0.17359804, 0.17790003, 0.085666224, -0.11872538, -0.007298351));
	target1 += mul(h1, float4x4(0.024346102, -0.0066076764, -0.011155871, -0.057157155, -0.04878886, 0.121565156, 0.094774745, -0.021847744, 0.04866778, 0.07184023, 0.26012063, -0.07480458, -0.29240155, 0.12562081, 0.01449463, -0.028680477));
	target1 += mul(i1, float4x4(-0.12557116, 0.034923933, -0.095903516, -0.03958003, 0.26028237, -0.017168928, -0.13332075, 0.15662631, 0.065815985, -0.035664845, 0.045483954, -0.015463682, -0.093050554, 0.17345443, 0.069853716, 0.012629484));
	target1 += mul(a2, float4x4(-0.06156731, 0.07782055, -0.10174533, -0.020296015, -0.11969389, -0.060097698, 0.13305716, 0.16102178, 0.024139002, -0.02605331, -0.07594407, 0.19671421, -0.12202574, 0.14988048, 0.015957702, -0.04196926));
	target1 += mul(b2, float4x4(-0.34706548, 0.043015823, 0.13185433, 0.10132207, 0.007556987, -0.043371882, -0.08854469, 0.1748955, -0.1481482, 0.031284038, 0.120617144, 0.21384451, -0.08435913, -0.049537454, 0.049118094, 0.01525446));
	target1 += mul(c2, float4x4(0.09368386, -0.057292625, -0.17107973, 0.102038346, -0.21283975, 0.29275435, -0.039638165, -0.14761256, -0.0026279686, -0.1902631, -0.14120182, 0.26573882, 0.0017522989, -0.06337007, 0.14134108, -0.015992256));
	target1 += mul(d2, float4x4(0.04090445, -0.15472308, 0.0086197965, -0.08812333, 0.079468906, -0.16199878, 0.15031399, -0.03220131, -0.08283918, 0.18892156, -0.11201425, 0.143803, 0.027449837, -0.15672483, -0.09222757, -0.0074415365));
	target1 += mul(e2, float4x4(0.10325783, 0.01752857, 0.10529392, -0.04568797, 0.017125184, -0.18414256, 0.109236374, -0.05950773, -0.07963555, 0.22193272, 0.009846993, -0.028046092, -0.28534588, -0.040712982, -0.018419487, 0.040993705));
	target1 += mul(f2, float4x4(-0.07601499, 0.14913873, -0.11738921, -0.21686155, -0.09468833, -0.10593258, -0.13899745, -0.08376532, -0.21147677, 0.0016611695, -0.12994987, 0.06078483, 0.007183634, 0.22829083, 0.054238643, 0.025317933));
	target1 += mul(g2, float4x4(-0.020357948, -0.06775977, 0.04134854, -0.19611607, 0.21193837, 0.19103523, 0.1623303, -0.07516307, 0.09373488, -0.18499903, 0.122855246, 0.06162072, -0.06930552, 0.040520284, 0.066090606, 0.06882486));
	target1 += mul(h2, float4x4(0.07091698, 0.027023822, 0.014318926, -0.096747, 0.2213003, -0.26515988, 0.027153777, -0.06498218, -0.1544758, -0.072314575, 0.060353238, 0.0008735325, 0.10359162, -0.040275127, 0.03365087, 0.067658685));
	target1 += mul(i2, float4x4(-0.010807538, -0.032808676, 0.0016953531, -0.07662512, 0.0726062, -0.018007128, -0.10622275, -0.25853804, 0.059124377, 0.1262254, -0.093686275, 0.013412181, 0.17268743, -0.0634091, -0.2380408, 0.061805595));
	target1 += mul(a3, float4x4(0.0589103, -0.13791196, -0.054214116, -0.10432153, -0.009462091, -0.06466445, -0.10792851, 0.0046791825, 0.034062322, 0.0810174, 0.112342946, 0.14306374, 0.0536091, -0.056520145, -0.14358906, 0.1730281));
	target1 += mul(b3, float4x4(0.102546036, -0.0005907261, 0.06815491, 0.054100085, 0.012063651, 0.13010375, 0.076584436, 0.10106609, 0.07464082, 0.12651648, -0.13567902, 0.12329812, 0.036417592, -0.030062713, -0.07439, -0.06734716));
	target1 += mul(c3, float4x4(-0.06956145, -0.0320128, 0.0069283135, 0.0010382348, -0.15168677, -0.07246775, -0.1870489, 0.081376776, -0.12240719, 0.040261835, -0.114711486, 0.11216043, 0.039739948, 0.064421944, -0.11448801, -0.11656052));
	target1 += mul(d3, float4x4(-0.029262811, 0.07973898, 0.014937532, 0.17416446, -0.13320738, 0.09951435, -0.09681337, 0.24465284, 0.0027678797, 0.054772142, 0.11334623, -0.062660255, 0.06494805, -0.014957246, -0.016339006, 0.0065059843));
	target1 += mul(e3, float4x4(-0.19118161, 0.24356417, -0.17327957, 0.06050448, -0.097790115, -0.38453653, 0.045624297, 0.04574299, -0.15803054, -0.5270604, -0.04556698, -0.13112716, -0.026057608, 0.13840397, -0.04413626, -0.06273916));
	target1 += mul(f3, float4x4(0.029510414, -0.005691187, 0.05228498, 0.028585492, 0.18082422, -0.032805815, 0.007563971, 0.08991763, 0.105824, 0.02457178, 0.055056915, -0.060770642, -0.011407322, -0.11525285, -0.04518266, -0.04449915));
	target1 += mul(g3, float4x4(0.14025277, -0.18081227, 0.014395497, -0.09138814, -0.09448127, 0.2532618, 0.08094696, 0.050620202, 0.040627994, 0.17808948, 0.0933771, -0.04734779, -0.025526097, 0.0038422223, 0.05230542, -0.101145774));
	target1 += mul(h3, float4x4(-0.07215562, -0.058965042, 0.038303573, 0.0009963732, -0.059399143, 0.15957262, 0.035185594, 0.0719169, 0.08515627, 0.09775558, 0.13178122, -0.0837824, 0.014349278, 0.038491696, 0.071876876, 0.0345376));
	target1 += mul(i3, float4x4(0.040965024, -0.030738113, -0.05919069, -0.14155431, 0.09109957, -0.099060595, -0.10192779, 0.033825647, 0.11551892, -0.04282345, 0.020072978, 0.035168435, 0.10797329, -0.0584945, -0.024158757, -0.03585887));
	target1 += mul(na1, float4x4(0.11656172, -0.03488785, 0.090906724, -0.0032958854, 0.11268224, 0.070826046, 0.008982598, -0.14222313, 0.0025792273, -0.07585458, -0.021171344, -0.10144507, 0.24918565, 0.004032981, 0.032430686, -0.012328044));
	target1 += mul(nb1, float4x4(-0.22021858, 0.06875914, 0.004574366, -0.0694593, 0.11509186, -0.25873652, -0.08872615, -0.024206636, 0.15076822, -0.14054653, -0.045519873, -0.04547437, -0.22077747, -0.054121707, 0.049612578, 0.10545096));
	target1 += mul(nc1, float4x4(-0.069911204, 0.078573205, -0.073091984, 0.015637126, -0.23398215, 0.12185918, 0.08496631, -0.063231654, 0.14004779, 0.07965737, 0.14457273, -0.057528477, -0.0971965, 0.10445598, -0.054162677, -0.11529022));
	target1 += mul(nd1, float4x4(-0.12595661, 0.16308525, 0.09465576, -0.05046868, 0.1799443, 0.115778774, -0.13534002, 0.09609113, 0.107355125, -0.07263705, -0.04365324, 0.10355821, -0.023942605, 0.026093582, 0.009621531, 0.06096017));
	target1 += mul(ne1, float4x4(0.1272364, -0.07220049, 0.041847665, 0.17912698, -0.03009012, 0.06394436, -0.03263169, -0.04573203, -0.07620046, 0.42576316, 0.042653862, 0.13744949, 0.23633486, 0.10078774, -0.121353894, 0.12101121));
	target1 += mul(nf1, float4x4(0.03558598, -0.1297437, -0.05971473, 0.17683595, 0.1725135, 0.052228056, 0.08043958, -0.09891566, 0.03620246, -0.07612062, 0.0671727, 0.037559096, -0.14037324, 0.021277385, -0.04257818, 0.17619017));
	target1 += mul(ng1, float4x4(-0.11092632, -0.00013030393, 0.12967736, -0.22887622, -0.08721344, 0.054407217, 0.07632402, -0.08394438, -0.071129434, 0.11594225, -0.058196247, 0.020942273, -0.123769015, -0.114318974, 0.03252267, 0.07218774));
	target1 += mul(nh1, float4x4(-0.11842664, -0.044281907, 0.07725646, -0.09330976, -0.028858917, -0.10954367, 0.04575166, -0.026068112, -0.06559436, -0.2284913, -0.19561197, -0.0016185943, 0.11867088, -0.038570896, 0.08526274, 0.019519364));
	target1 += mul(ni1, float4x4(0.0822196, -0.0037142867, 0.08382291, -0.013849318, -0.13749887, 0.044966772, 0.04564233, -0.00618037, -0.052107867, 0.033819627, -0.03494537, 0.024765901, -0.10504158, -0.028348709, -0.0089757275, 0.030026745));
	target1 += mul(na2, float4x4(0.053351242, 0.056979094, -0.060212657, 0.14301975, 0.17891912, -0.032538075, 0.011639607, 0.035919394, 0.04533616, -0.12939154, -0.041703038, 0.0071665174, -0.19303554, 0.018363694, 0.08923668, 0.020215489));
	target1 += mul(nb2, float4x4(0.038452573, 0.1614918, -0.022068001, 0.0030016324, -0.2680856, 0.21928017, 0.085351996, 0.049881425, 0.058913168, -0.044736963, 0.016097903, 0.21123125, 0.079624146, -0.16535924, 0.06877731, 0.1305827));
	target1 += mul(nc2, float4x4(0.05783186, -0.219528, 0.0816723, 1.3595931e-05, -0.02902699, -0.12913156, -0.40516803, -0.028480045, 0.12000909, 0.081304125, 0.053406257, -0.08878543, 0.02251961, 0.12547138, -0.20464425, -0.05598181));
	target1 += mul(nd2, float4x4(-0.15702735, 0.21000047, 0.08434562, 0.27938238, -0.03068116, -0.004006084, 0.19768693, 0.066732645, -0.055060755, -0.16314429, 0.028655436, 0.021063909, -0.028578848, -0.008238495, 0.12807982, -0.0071345936));
	target1 += mul(ne2, float4x4(-0.17309058, -0.18169925, -0.14182782, 0.107684694, -0.1117235, 0.19443877, 0.101682656, 0.030993309, -0.12313995, -0.048883304, -0.11149261, 0.12847972, 0.28405818, 0.20219465, 0.015797788, 0.123306856));
	target1 += mul(nf2, float4x4(-0.07962997, 0.06323938, 0.045708194, 0.0020409136, -0.0022456956, 0.010837137, 0.014872806, -0.060870074, 0.13772255, 0.005320253, 0.05848208, 0.14984395, -0.037590872, -0.07464743, -0.16873243, 0.019905593));
	target1 += mul(ng2, float4x4(0.13775061, 0.032707028, 0.13456069, 0.05904891, 0.046821773, -0.22715594, 0.056300808, -0.15724476, -0.07337338, 0.19666758, -0.013393664, 0.04086994, 0.12254266, -0.08695188, -0.11076954, -0.15678991));
	target1 += mul(nh2, float4x4(0.07177161, 0.01181348, -0.07497793, -0.085427515, 0.039396375, -0.0035293372, 0.20881353, -0.057439566, 0.15257393, 0.16040947, -0.027684899, 0.16330487, -0.054777898, 0.07572324, -0.03833461, -0.017093522));
	target1 += mul(ni2, float4x4(0.000963837, -0.00780663, -0.023343472, 0.18377425, 0.32722053, -0.08156815, -0.11247523, -0.12714005, 0.18326895, -0.16434003, 0.052783884, 0.2168339, 0.03372009, 0.024008008, -0.1949321, -0.11585071));
	target1 += mul(na3, float4x4(0.07887302, -0.043003492, -0.16841368, 0.023287356, -0.15838705, 0.21706697, 0.16976407, 0.11461476, -0.062454503, 0.08966307, 0.10723603, -0.029792916, -0.03903073, -0.06255455, 0.025979951, -0.09530182));
	target1 += mul(nb3, float4x4(-0.0917689, 0.12646815, -0.11529587, 0.06925059, -0.18619959, -0.05243984, 0.16720963, -0.07121025, -0.04476961, 0.0074207215, 0.16076323, -0.14866208, 0.042807475, -0.08767046, -0.005694572, -0.11727041));
	target1 += mul(nc3, float4x4(-0.0062040854, -0.00097002264, -0.058491956, -0.035364915, 0.040115915, -0.10968144, 0.046607487, 0.23429875, -0.11210956, 0.034507494, -0.07195393, -0.16490693, 0.047223017, -0.044811487, -0.11060463, -0.14174072));
	target1 += mul(nd3, float4x4(-0.14469296, 0.0862561, 0.027785733, 0.005940194, -0.0062618204, -0.015266768, -0.067160904, -0.17241345, -0.060631767, 0.024863401, 0.056833714, -0.063885145, -0.14061876, -0.042549785, 0.036430426, 0.14348027));
	target1 += mul(ne3, float4x4(0.3022943, -0.19899924, 0.19672908, -0.09840718, 0.14039348, 0.105976574, -0.14415087, -0.06547584, 0.3070416, 0.40989116, 0.009514016, 0.018336622, 0.08806178, 0.07710675, -0.03551256, -0.04064369));
	target1 += mul(nf3, float4x4(0.16016869, -0.12516344, -0.011240568, -0.1443897, -0.009084668, -0.1618983, 0.06672594, -0.30417737, -0.09547601, -0.09057253, 0.08657728, 0.036226142, -0.0022018533, 0.12780087, 0.0029589643, 0.12111095));
	target1 += mul(ng3, float4x4(-0.1765741, 0.03653064, -0.03139237, 0.057462048, 0.16041194, -0.2303424, -0.11946362, -0.1788824, 0.098096356, -0.18419504, 0.021373387, -0.1157983, 0.079671614, -0.03361971, 0.06394305, -0.0101026185));
	target1 += mul(nh3, float4x4(-0.01576709, 0.11476761, -0.041474868, 0.13242105, -0.056526344, 0.024517184, -0.21629438, -0.010624098, -0.0053918827, -0.19187245, -0.12927179, -0.08489797, 0.055730473, -0.043147404, -0.03800261, 0.048107833));
	target1 += mul(ni3, float4x4(-0.0014053301, -0.046847776, 0.004571536, 0.18300104, -0.053145096, 0.057801194, 0.2322556, 0.22864385, 0.0040904162, -0.037985127, 0.041369, -0.065972395, 0.16685532, -0.091719486, -0.1425869, -0.10230388));
	target1 += float4(0.00803133, -0.020707153, 0.0056995153, -0.052884795);
	
	float4 target2 = mul(a1, float4x4(-0.12893085, -0.12928686, 0.12365234, -0.021265296, 0.15424967, -0.0063038417, -0.027432516, -0.10297197, 0.118751466, -0.058228746, -0.10025376, 0.0027489034, 0.0073948866, 0.040659092, 0.08120041, -0.12702137));
	target2 += mul(b1, float4x4(-0.02242042, 0.114516795, -0.042158883, -0.14150862, -0.18976203, 0.109531336, 0.03548168, -0.1681465, -0.13782959, 0.07437085, -0.045712702, -0.09431652, -0.0029079607, 0.05180383, 0.07098421, -0.2149384));
	target2 += mul(c1, float4x4(0.3218102, 0.0013506162, 0.12795919, -0.10901241, -0.08859676, -0.06861104, -0.014102381, 0.0051467894, -0.16305672, 0.022653125, -0.019810826, -0.05701206, 0.1842382, -0.074959196, -0.07368022, -0.046023685));
	target2 += mul(d1, float4x4(-0.099247254, -0.2161521, -0.095611826, -0.0179061, -0.0067561218, 3.99846e-05, 0.01254028, -0.056954045, -0.0075805853, -0.082335606, -0.053469665, 0.25761604, -0.049429264, -0.08763215, 0.051362507, -0.030518934));
	target2 += mul(e1, float4x4(0.13518652, 0.05463841, -0.07654066, 0.023629244, -0.23324661, 0.04781438, -0.20902736, 0.10330495, -0.16452856, 0.235407, -0.022236459, 0.036046103, -0.08613043, -0.012954787, 0.043111194, 0.021807853));
	target2 += mul(f1, float4x4(0.11316856, -0.027803158, -0.026492868, -0.0030439082, 0.063926555, -0.09612654, -0.22492981, -0.13748476, 0.06954571, -0.008035041, -0.04846681, -0.23352449, -0.06676289, 0.13268302, 0.037954323, -0.0342029));
	target2 += mul(g1, float4x4(-0.18148762, -0.06975972, -0.21924862, -0.03831989, 0.09057307, -0.06784279, 0.05716139, 0.032582354, 0.32728904, 0.03561464, -0.06930132, 0.13582717, -0.04723415, 0.053298444, -0.1580453, 0.029922115));
	target2 += mul(h1, float4x4(-0.13381054, 0.06294187, 0.04273711, -0.089835554, -0.042215306, 0.04515037, -0.01970211, 0.07447383, -0.12915656, 0.087721184, 0.122159, 0.17817122, 0.05233303, 0.053456925, -0.22769327, 0.17450784));
	target2 += mul(i1, float4x4(0.062324032, 0.056449406, 0.070776984, 0.070366256, 0.15072031, -0.20342071, 0.118405774, -0.11357599, 0.23603258, -0.17724364, 0.028237892, 0.07491812, 0.015638597, 0.20543055, -0.05863285, 0.06565301));
	target2 += mul(a2, float4x4(-0.07647028, 0.2292153, 0.019423103, -0.06965646, -0.107311614, -0.19989595, -0.06673964, -0.027954143, 0.0017375473, -0.048038438, 0.052211836, -0.042501964, -0.1372413, -0.2437919, -0.15933524, -0.07229055));
	target2 += mul(b2, float4x4(-0.023719285, 0.05654754, 0.09026341, 0.020072227, -0.12716366, -0.013687293, -0.1312343, -0.06847118, 0.016806766, -0.10526531, -0.011248162, 0.12535807, -0.12538499, -0.042496204, -0.076355785, -0.0017766576));
	target2 += mul(c2, float4x4(0.039450683, -0.049502935, -0.009162741, 0.015372251, -0.14449993, -0.06564991, -0.093242005, -0.018039258, -0.2410318, 0.020259766, -0.040783074, -0.05092842, -0.023994599, -0.037968505, 0.052206438, -0.10967312));
	target2 += mul(d2, float4x4(0.13721816, -0.1571525, 0.09432105, 0.023277072, -0.073701076, -0.13941942, -0.02705892, 0.06508469, -0.17687775, -0.07433723, -0.11237514, -0.015321937, -0.31670073, -0.09665636, -0.11843665, -0.030077526));
	target2 += mul(e2, float4x4(-0.09092922, 0.088340946, 0.1001261, 0.05962185, 0.07731374, -0.09623944, -0.03218285, 0.04484794, -0.10394964, 0.111483194, -0.07343945, 0.15182221, 0.27208853, 0.024986237, -0.058641106, -0.039870527));
	target2 += mul(f2, float4x4(0.03685333, -0.014777545, -0.0064948527, 0.060336027, -0.04251398, -0.004589828, -0.025893224, -0.075040996, 0.007964778, 0.22512783, -0.033568367, 0.052608117, 0.2143682, 0.21318182, -0.06253117, -0.055562623));
	target2 += mul(g2, float4x4(0.07906376, -0.015447189, -0.045265637, 0.066810004, 0.07202818, -0.07874254, -0.071680374, 0.009017687, 0.07042464, 0.016754108, 0.017237889, 0.0106343115, -0.042138606, -0.11085673, 0.14738452, -0.10718694));
	target2 += mul(h2, float4x4(-0.07745664, 0.16073377, -0.01899363, 0.07030874, 0.058903817, -0.065876774, 0.020186676, 0.09385477, 0.14517148, 0.053237557, -0.16942556, -0.04716224, 0.13748227, 0.17071299, 0.12176032, 0.07409275));
	target2 += mul(i2, float4x4(0.09208682, 0.029487375, -0.057159107, 0.025398627, 0.12468226, 0.034707896, 0.010541767, -0.032418035, 0.11508723, 0.050812677, -0.08127881, 0.0052238777, 0.15403835, -0.17993934, 0.071115926, 0.0059663));
	target2 += mul(a3, float4x4(-0.053597223, -0.00758354, -0.011711322, 0.12876037, -0.022196915, 0.045487616, 0.02135921, 0.010447794, 0.063635394, 0.09686383, -0.05077074, 0.072695896, -0.02443565, -0.045984466, -0.025993166, -0.08304488));
	target2 += mul(b3, float4x4(0.1321831, 0.017644621, 0.16513684, 0.0659792, 0.09676037, -0.07867503, 0.04669573, -0.04401741, 0.23034973, 0.10561144, -0.1184282, 0.13691261, -0.18894893, 0.21760973, 0.08807475, -0.19776659));
	target2 += mul(c3, float4x4(-0.053137053, -0.07991928, -0.09902317, 0.017081713, -0.021857716, 0.011578801, -0.0009752623, 0.043588534, 0.11997389, 0.0027668865, -0.09973271, 0.065404624, -0.07151649, -0.017840967, -0.0188252, -0.14957094));
	target2 += mul(d3, float4x4(0.13721272, 0.04459704, -0.0069692475, 0.07410797, -0.13855937, 0.021286163, -0.04160423, -0.05980007, 0.027626112, 0.092742406, -0.032267787, -0.00358655, 0.12470872, 0.09738248, 0.06565896, -0.1076945));
	target2 += mul(e3, float4x4(0.12965658, -0.110055126, -0.08762725, 0.031792786, 0.11524638, -0.09530289, 0.07955128, 0.0049232226, 0.07190261, -0.010207877, -0.26513076, 0.045152593, -0.16932993, 0.091321826, 0.11550899, -0.100929074));
	target2 += mul(f3, float4x4(-0.1674921, 0.0907835, -0.033396322, -0.03168371, 0.013580539, 0.047018647, 0.028963672, 0.04756761, -0.08714202, -0.2602012, -0.12279786, 0.18663418, -0.07781514, -0.013219039, 0.006731288, 0.005795019));
	target2 += mul(g3, float4x4(0.01206949, -0.047031406, -0.060451232, 0.027200127, -0.1178311, 0.14014901, 0.25840858, -0.14889579, -0.11640469, -0.01811908, -0.09255012, -0.08351582, 0.086520575, -0.021090247, 0.08717082, 0.043429427));
	target2 += mul(h3, float4x4(0.020278929, -0.15339202, 0.041678756, 0.07180138, -0.0635027, -0.088976234, -0.04092133, 0.07997308, -0.134963, -0.015960857, -0.060887713, -0.07916197, 0.20483045, -0.12640053, 0.10478231, 0.04803776));
	target2 += mul(i3, float4x4(-0.03549656, 0.033666074, 0.20228225, -0.096664, -0.00096604426, 0.20793179, 0.09613217, -0.053552672, 0.051677585, -0.018252494, 0.07543575, 0.006295734, 0.046456967, -0.16520908, 0.0120992735, -0.015491354));
	target2 += mul(na1, float4x4(0.09486195, 0.0862073, 0.04189838, 0.0026638226, 0.09820532, 0.1007168, -0.022186898, -0.05491984, -0.13535279, 0.046514615, 0.09563633, 0.021364952, -0.23145446, 0.05070801, -0.022965223, -0.18874952));
	target2 += mul(nb1, float4x4(0.05885208, -0.022751214, -0.015712557, 0.157172, 0.05131988, -0.09524327, -0.045114886, 0.05928359, -0.001745961, -0.035245676, -0.010552595, -0.06321781, -0.15489094, 0.017822266, -0.06018634, 0.06429225));
	target2 += mul(nc1, float4x4(0.1243866, 0.014742004, -0.07896682, 0.2792386, -0.08055696, -0.0067778644, 0.0407617, 0.1389886, -0.02221008, 0.07494927, -0.11067403, 0.026464086, -0.009520921, 0.015791653, 0.021943323, 0.12500213));
	target2 += mul(nd1, float4x4(-0.08929889, 0.09244356, 0.130978, -0.03720041, 0.07869226, 0.13067861, 0.104627624, -0.01922214, 0.03561331, -0.031736456, 0.15136853, 0.0128885005, -0.16457924, -0.028147755, 0.13005957, -0.07908654));
	target2 += mul(ne1, float4x4(-0.020705838, 0.0936515, -0.026146421, 0.030703338, 0.032063864, 0.14091234, -0.021708539, -0.056303035, -0.007502981, -0.1276548, -0.15350288, -0.04722333, -0.049264792, -0.016106946, 0.035777904, 0.10648118));
	target2 += mul(nf1, float4x4(0.16387826, -0.059457906, 0.009808255, 0.030755969, 0.05709708, 0.0025975339, 0.021356652, -0.023887865, -0.15327913, -0.03702513, -0.041953377, 0.0049483287, 0.1434395, 0.08557114, -0.07722993, 0.22481233));
	target2 += mul(ng1, float4x4(-0.20757784, -0.05194353, -0.17085314, -0.12557504, -0.056353815, 0.06583933, 0.005532102, -0.0040489454, 0.23847903, -0.08254601, -0.20940065, 0.1251241, 0.14838001, -0.12861559, -0.04664337, 0.07232125));
	target2 += mul(nh1, float4x4(-0.010124613, -0.07096996, -0.1366236, 0.0018079067, -0.041023795, 0.12729517, 0.24600507, -0.07845422, 0.31226948, -0.023518091, -0.0023672595, 0.058046557, 0.1718256, -0.05916957, 0.0067618093, 0.08826252));
	target2 += mul(ni1, float4x4(-0.0013852714, -0.02530485, 0.12499248, -0.047640886, 0.06515882, 0.009700978, -0.005210036, -0.0332508, -0.135034, 0.07050036, 0.06152617, 0.02243357, 0.20835938, 0.041327897, 0.047491845, -0.017284496));
	target2 += mul(na2, float4x4(-0.2511675, 0.2016235, -0.22534974, -0.29850873, -0.014898309, 0.034321953, -0.14487329, 0.029454721, 0.05068056, -0.09661999, 0.00070758525, 0.06925706, -0.19870853, -0.0871149, 0.13158658, -0.09995704));
	target2 += mul(nb2, float4x4(-0.22352318, -0.073506966, -0.11625505, 0.0049028546, 0.029848805, -0.06952766, -0.043236732, 0.13255614, 0.093998544, 0.17581578, -0.0004033081, -0.12263665, -0.17329359, -0.11587317, 0.059647266, -0.02954624));
	target2 += mul(nc2, float4x4(-0.057583325, 0.056015383, 0.11960743, 0.033696633, -0.14805156, -0.10933173, -0.08482661, 0.07473009, 0.040999115, -0.0995941, -0.005304712, 0.04729056, -0.09739792, 0.07000572, -0.12560466, 0.023240168));
	target2 += mul(nd2, float4x4(-0.1967497, 0.093729794, -0.05857918, -0.12817049, -0.034558292, 0.016039368, -0.12012142, -0.017481307, 0.0391479, -0.10992257, 0.015143992, 0.01391454, 0.051010676, 0.012996939, 0.041216355, 0.08623047));
	target2 += mul(ne2, float4x4(0.21069938, -0.066038206, -0.015458416, -0.097732425, 0.051942978, -0.03459923, -0.05756448, 0.14080645, 0.055423364, -0.06490901, -0.07402898, -0.16263707, -0.07290088, -0.058713708, 0.06723124, 0.069584474));
	target2 += mul(nf2, float4x4(0.09618103, 0.055036288, 0.09001422, 0.027986465, -0.018399306, -0.07295329, 0.06687392, 0.06653489, -0.06524778, -0.11760177, -0.004764932, -0.10559294, 0.16195896, -0.22127731, -0.0060094665, -0.0073161777));
	target2 += mul(ng2, float4x4(-0.006081162, 0.09074974, 0.1387847, -0.012516454, 0.040442165, 0.024901407, 0.019887343, -0.012545043, 0.040630046, 0.06390039, -0.088361576, -0.07775115, -0.016567666, -0.048221476, 0.00507668, 0.00015517596));
	target2 += mul(nh2, float4x4(0.27623588, -0.29454315, -0.09558771, 0.016047282, 0.12541397, 0.06766668, 0.012096932, -0.051367834, -0.20859776, -0.20424904, 0.1920475, -0.12987578, 0.08319857, -0.05495395, 0.043287907, -0.027431363));
	target2 += mul(ni2, float4x4(0.1666435, -0.10736637, -0.039772738, 0.06555994, 0.06329126, -0.004524732, 0.027252503, -0.018687485, -0.0827318, -0.17353283, -0.17264223, 0.0050896755, 0.08507919, -0.19379872, 0.14229794, -0.0837528));
	target2 += mul(na3, float4x4(0.10103022, 0.2500691, 0.11863092, 0.04184915, 0.07104669, 0.11822421, 0.040399753, -0.05503637, -0.03777729, -0.0552892, -0.0367129, -0.07652974, -0.06387571, 0.09680754, 0.030113626, 0.07385613));
	target2 += mul(nb3, float4x4(0.21662953, -0.047714498, -0.100133225, 0.14122888, -0.053247962, -0.13878773, 0.043139406, 0.10316825, -0.050836936, -0.1023108, 0.07342308, -0.013418398, 0.1517183, -0.038232815, 0.16094449, 0.18475303));
	target2 += mul(nc3, float4x4(0.10745382, 0.14385694, 0.16242811, -0.022071859, -0.06788635, 0.09044915, -0.09642871, -0.032185104, -0.15011486, 0.06751199, -0.0030307414, 0.045759566, 0.17598514, 0.069681115, 0.18387364, 0.15741494));
	target2 += mul(nd3, float4x4(0.0355877, -0.01989782, -0.021107944, 0.1195755, 0.04636706, 0.15067361, -0.03446434, 0.091468826, -0.054333266, -0.091928974, 0.077975504, 0.051997006, -0.2611878, 0.012728117, 0.038493883, 0.062820844));
	target2 += mul(ne3, float4x4(-0.09769422, 0.0486323, -0.09317317, -0.09185559, -0.30752286, -0.11381268, -0.053577766, -0.17922285, -0.14485466, 0.10500625, 0.22108263, -0.12928547, 0.33743355, 0.13309081, 0.13873322, 0.05503852));
	target2 += mul(nf3, float4x4(-0.19131194, -0.10878378, -0.04047478, -0.024106042, -0.25611252, 0.10455126, -0.0774767, -0.005242356, 0.14342257, 0.096795335, 0.11119688, -0.06816075, 0.045405596, 0.11205132, 0.22008072, 0.010171907));
	target2 += mul(ng3, float4x4(0.03641146, 0.025730135, 0.088947766, 0.09581084, 0.18514295, 0.05196274, -0.09955554, 0.043848306, 0.09665611, -0.05949442, -0.037989084, 0.043330964, -0.046047594, 0.090160884, 0.06574573, -0.018593606));
	target2 += mul(nh3, float4x4(-0.26031247, -0.05067085, -0.07451936, -0.01263683, 0.13966191, -0.25842324, -0.115060754, -0.08976801, 0.028517777, 0.045588367, 0.2297454, 0.023451945, -0.13475016, 0.048971854, 0.04935944, -0.10817461));
	target2 += mul(ni3, float4x4(-0.044189412, 0.12302195, 0.05076291, -0.072933994, 0.22576593, 0.12513146, -0.020687684, -0.0017186786, 0.056137685, 0.07280331, -0.0060697175, 0.017558591, -0.19459185, -0.08931442, 0.03579924, -0.00051510497));
	target2 += float4(-0.088215575, 0.02001751, -0.0013112888, -0.0031276105);
	
	float4 target3 = mul(a1, float4x4(0.055708, -0.15470836, -0.18314275, -0.018972168, 0.0008025653, -0.04802735, 0.0037216125, -0.008888557, -0.044309124, 0.1032128, -0.09535111, 0.1075431, -0.061698865, -0.136952, -0.08298975, -0.03202739));
	target3 += mul(b1, float4x4(0.047130957, -0.13275343, 0.10046242, 0.14484632, -0.18798989, -0.01724291, -0.095696434, -0.06524662, -0.12395302, -0.057923865, 0.013821919, -0.19095008, -0.10312008, -0.067719445, 0.03039217, 0.002102062));
	target3 += mul(c1, float4x4(0.07914871, 0.03840256, -0.11512143, -0.19842817, -0.17087726, -0.117287606, 0.26407588, -0.028159037, -0.16280699, -0.1019244, 0.026774779, -0.06759367, 0.0024644772, 0.033856, -0.007847236, 0.028765628));
	target3 += mul(d1, float4x4(-0.07034455, 0.076142974, -0.22090098, -0.0905723, -0.06417895, 0.119223125, -0.26432338, -0.04371924, 0.16288432, 0.026691884, -0.017952124, 0.08947346, -0.1286289, -0.01910609, 0.04351911, 0.0340226));
	target3 += mul(e1, float4x4(0.14330725, 0.090986304, -0.1424256, 0.054584663, 0.043702085, -0.08414303, 0.001994348, -0.022233546, 0.03748274, 0.12121618, 0.26035795, 0.13496856, 0.3061306, 0.019047879, -0.043746773, 0.18116328));
	target3 += mul(f1, float4x4(-0.051031455, 0.0696392, 0.04753365, -0.20600007, 0.08226225, -0.055646114, 0.15932508, 0.0419586, -0.11326543, 0.027461074, -0.041595474, -0.10200617, 0.004414234, -0.085846625, 0.1470303, 0.15096648));
	target3 += mul(g1, float4x4(0.101050586, 0.15982646, 0.008072791, -0.11342946, 0.08270196, 0.08548463, 0.042926773, 0.06380147, 0.11114159, 0.07615307, -0.01628438, -0.082144625, 0.029875848, -0.020052845, 0.014533401, -0.027843053));
	target3 += mul(h1, float4x4(-0.0279601, -0.09164763, 0.11475252, 0.04266532, 0.17664109, -0.044317525, 0.038787685, 0.00897195, -0.065523826, 0.013996353, -0.109297335, -0.029989313, -0.025986332, -0.09013683, 0.24884683, 0.06528543));
	target3 += mul(i1, float4x4(-0.09584907, -0.15118982, -0.015254367, -0.12179126, -0.12146391, 0.15733819, -0.033256296, -0.061760996, -0.036719803, 0.16471127, 0.18006523, -0.056930948, 0.03617248, 0.07113426, -0.069748655, -0.081067815));
	target3 += mul(a2, float4x4(0.1271724, -0.082678355, 0.07997786, 0.06285082, 0.02332232, 0.05007377, -0.094914205, -0.06553253, -0.10122091, 0.012112823, -0.11796572, 0.021247976, 0.0654767, -0.091576956, 0.08175131, -0.010552305));
	target3 += mul(b2, float4x4(0.12505153, -0.037628997, -0.022449989, 0.06686099, -0.25006896, 0.13324498, 0.041733105, 0.2241118, 0.024380242, 0.09950468, 0.078383565, 0.11634127, 0.077024244, -0.07780778, 0.07760342, 0.06282892));
	target3 += mul(c2, float4x4(-0.13915282, 0.16686817, 0.030251533, -0.0035493453, -0.13203144, 0.033648454, 0.0024875028, -0.0007983041, -0.105395414, 0.1536483, 0.050240528, 0.11495208, -0.026644144, -0.05793395, -0.12098678, -0.065910175));
	target3 += mul(d2, float4x4(0.02292821, 0.030319002, -0.1293214, -0.0096194055, -0.01278381, -0.00087727525, 0.19325659, 0.025518872, -0.05107456, -0.14991362, -0.05873866, 0.12859605, -0.20932005, -0.11987684, -0.051870637, 0.001319446));
	target3 += mul(e2, float4x4(-0.022754941, 0.043839425, -0.08278873, -0.21222612, 0.0015371124, -0.010085336, 0.09510605, 0.07335702, -0.106798455, -0.12928678, 0.015216733, 0.031399984, -0.07811234, -0.119671986, 0.17570181, 0.029809073));
	target3 += mul(f2, float4x4(-0.11764911, -0.16164766, 0.08784963, -0.019233093, -0.076887585, -0.058506478, 0.08077385, -0.16966046, -0.24188527, -0.07365656, 0.09544133, 0.19833234, 0.09107925, -0.020520048, -0.05825717, -0.09854415));
	target3 += mul(g2, float4x4(0.03600886, -0.029253786, 0.048200432, 0.022130603, 0.13826382, -0.13885193, 0.20007242, 0.14829256, -0.017307537, 0.03851602, 0.020379594, 0.07832595, -0.07762187, 0.096413285, -0.079333976, -0.0061714468));
	target3 += mul(h2, float4x4(0.0413019, -0.07368758, 0.13919644, -0.12122368, -0.029388634, 0.10483587, -0.051654328, 0.015226432, -0.04520832, -0.026331404, 0.20372365, 0.06359042, -0.013045257, -0.10666548, 0.08962036, 0.20432319));
	target3 += mul(i2, float4x4(0.013157089, -0.034036867, 0.0819, 0.014009891, -0.03467534, -0.12812413, 0.18123335, -0.0781033, -0.2039025, -0.16503748, 0.02498213, 0.023839379, -0.13192852, -0.09351754, -0.045935795, -0.088439226));
	target3 += mul(a3, float4x4(0.17598471, -0.16652712, 0.04906223, 0.07156945, -0.019004462, -0.07228772, -0.030515088, 0.12137358, 0.049442984, 0.003075852, 0.0820677, 0.09503947, 0.15167919, 0.03480622, 0.055544864, 0.108532205));
	target3 += mul(b3, float4x4(0.06424813, 0.0047392054, -0.06604298, 0.065024786, -0.027760155, 0.013289014, -0.05930856, -0.22680816, -0.12812522, 0.046711236, 0.11081086, 0.12093126, 0.08999833, 0.09398781, -0.00391463, -0.013292052));
	target3 += mul(c3, float4x4(0.078218855, -0.096875966, -0.1891451, -0.075190805, 0.045807663, 0.038455345, 0.1420045, 0.1738224, 0.06848118, 0.18028922, -0.07149378, -0.16228504, -0.15232347, -0.032611012, -0.07023075, -0.12920822));
	target3 += mul(d3, float4x4(0.04663347, 0.0988432, 0.052362353, -0.112998225, -0.20248835, -0.19879234, 0.11022756, 0.10454231, -0.13743615, 0.047722638, 0.06637239, 0.016583467, 0.11989917, 0.0125074675, 0.053077225, -0.006272926));
	target3 += mul(e3, float4x4(-0.08468045, 0.047544964, 0.04363399, 0.086961746, 0.08489796, 0.12409043, -0.13015386, 0.10092822, 0.14706169, -0.102444105, -0.074901864, -0.11254591, 0.029065747, 0.14046147, 0.07324801, -0.015313643));
	target3 += mul(f3, float4x4(-0.0032504771, -0.025116406, -0.027151806, 0.04037948, -0.029422142, 0.053333733, 0.050427776, 0.2249123, -0.040938333, 0.05139012, -0.021061108, -0.21729107, 0.020586135, 0.04293995, 0.01888572, -0.15284136));
	target3 += mul(g3, float4x4(-0.050343722, -0.08038014, 0.033975042, -0.078313686, -0.025870735, -0.10589425, 0.11806239, 0.11905227, -0.030429581, -0.10916684, -0.08828011, -0.032881964, 0.005728985, -0.14882843, -0.058584355, 0.07463933));
	target3 += mul(h3, float4x4(-0.16999933, -0.027314415, 0.07264002, -0.013310814, -0.12945375, 0.016093813, -0.09084507, -0.12522581, 0.075081155, -0.012983989, 0.11086466, -0.020709865, -0.034555092, -0.13049836, -0.069538176, 0.120410606));
	target3 += mul(i3, float4x4(-0.041815765, -0.1464541, -0.112602025, -0.17897187, 0.023695359, -0.007984221, -0.09087018, 0.03442271, 0.03562612, -0.022015946, -0.0067399153, 0.038907483, -0.11839428, -0.029512445, 0.032437507, -0.13424557));
	target3 += mul(na1, float4x4(0.071081854, 0.064600624, 0.06933874, -0.00823228, -0.06739624, -0.05190142, -0.0063528903, -0.0056084343, -0.00883983, -0.1393001, 0.053884078, 0.024325706, 0.05893945, -0.075403966, 0.21418992, 0.099977955));
	target3 += mul(nb1, float4x4(-0.08398666, 0.06117285, 0.018424282, 0.13809077, -0.07201819, 0.051259644, -0.04685134, -0.017006194, 0.05818578, -0.11379136, -0.07999673, 0.23295905, 0.007356084, -0.020284122, 0.01972096, -0.13002637));
	target3 += mul(nc1, float4x4(-0.06733669, 0.13325273, -0.0074489512, -0.052333828, 0.10027424, 0.065753184, -0.14192791, 0.09388921, -0.01242138, -0.14718066, -0.014753866, -0.065210566, 0.0699064, 0.06399467, 0.022925656, 0.06504557));
	target3 += mul(nd1, float4x4(0.101876445, 0.060120665, -0.0039521665, 0.12171173, 0.08321828, -0.008348968, 0.21899523, 0.058748752, 0.05547674, 0.16084124, -0.30695668, -0.10121366, 0.038653154, -0.044442136, -0.13552639, -0.019972218));
	target3 += mul(ne1, float4x4(-0.07638072, 0.050575085, 0.07061123, -0.18657742, -0.012248586, 0.019414622, 0.03041808, 0.033964135, -0.17578666, -0.023182971, -0.08965867, -0.13880058, -0.16309536, 0.17266575, -0.17651099, -0.24348558));
	target3 += mul(nf1, float4x4(-0.14318372, -0.002566858, -0.08960772, -0.025085822, -0.002079447, 0.010120887, -0.09830438, -0.11765062, 0.022343377, -0.025783114, -0.029105041, -0.1690584, 0.054205775, 0.02676286, 0.016028486, 0.120592885));
	target3 += mul(ng1, float4x4(0.14526334, 0.09275921, -0.12105369, -0.038859725, -0.10460921, -0.07294215, -0.15117784, -0.009182169, -0.0074104583, -0.12306472, 0.10073853, -0.08833498, 0.12785646, 0.0477829, -0.03402452, -0.07908741));
	target3 += mul(nh1, float4x4(-0.025889793, 0.014548265, 0.029771648, -0.07727682, 0.041268997, 0.08237273, -0.07722456, -0.036970172, 0.09158823, 0.044813015, -0.019759692, -0.112869464, -0.04357199, -0.07405958, -0.124406114, 0.20240584));
	target3 += mul(ni1, float4x4(-0.08556598, -0.01543713, 0.026491836, 0.018786263, 0.0418143, 0.0678302, -0.11946711, 0.09875955, 0.032350425, 0.007956311, -0.017798368, 0.1994804, -0.027886698, -0.17802258, 0.099619284, -0.011239122));
	target3 += mul(na2, float4x4(-0.36927477, 0.0397264, 0.14609286, 0.065389656, -0.017865075, 0.113564, 0.14015609, 0.054612216, -0.0342091, -0.030581282, -0.0124170035, 0.03166654, 0.0691441, 0.032685474, -0.16473754, -0.10027306));
	target3 += mul(nb2, float4x4(-0.027898287, 0.037473463, -0.10177491, -0.15948737, -0.08981485, 0.0764328, -0.06419195, -0.085592985, -0.015740823, -0.052377183, 0.07003385, -0.065375, 0.051523235, 0.04340368, 0.10867685, -0.16211551));
	target3 += mul(nc2, float4x4(0.007090963, -0.02692243, 0.05383495, 0.14827509, -0.105507806, 0.17903765, 0.13615972, 0.0051062405, 0.08153507, 0.05720539, 0.08144471, 0.0929691, 0.09873174, 0.015049897, 0.23769383, 0.22297786));
	target3 += mul(nd2, float4x4(-0.08985236, -0.076104425, -0.01007519, 0.034048676, -0.0079994, -0.033355482, 0.16036998, -0.053786088, -0.093155414, 0.05777472, -0.13322827, -0.0813691, 0.24432959, 0.08388064, -0.04998493, -0.021753525));
	target3 += mul(ne2, float4x4(-0.016286949, -0.013190527, 0.053851254, 0.046217382, -0.21881466, 0.07689005, -0.12487547, -0.10310683, -0.02934103, -0.084740095, -0.054879915, -0.06519303, -0.15657778, 0.029417856, -0.13291313, -0.103854224));
	target3 += mul(nf2, float4x4(0.11695019, 0.0132304765, -0.07342763, 0.051626842, -0.115028076, 0.060695976, 0.030592902, 0.07832676, -0.033096768, -0.010105935, -0.0968592, -0.17071666, -0.10127668, -0.026590502, 0.05544078, -0.22503363));
	target3 += mul(ng2, float4x4(0.053587623, 0.013554916, 0.0018153706, 0.0050241053, 0.007109888, 0.049959134, -0.05311281, -0.09651782, -0.15021992, 0.041716605, 0.031055149, -0.04614386, 0.1668338, -0.15733725, 0.05505452, -0.04836756));
	target3 += mul(nh2, float4x4(-0.077188395, -0.058547955, 0.03399098, 0.09912107, -0.03275195, -0.13739568, -0.08232234, 0.06831293, -0.070714585, -0.046675168, -0.11615044, -0.119989395, -0.03131107, -0.09919153, 0.003835856, -0.014355857));
	target3 += mul(ni2, float4x4(-0.036215, 0.018938174, -0.2277618, -0.13956094, -0.07911919, -0.063870676, 0.08332067, 0.061556723, 0.038459476, 0.15356061, 0.007937132, 0.049789228, -0.0977846, -0.06580731, -0.092308916, 0.12081035));
	target3 += mul(na3, float4x4(0.2513099, 0.2640892, -0.073300436, 0.0054640956, 0.021276288, 0.117054164, -0.10756317, -0.10598032, -0.045152083, 0.08731703, -0.18050396, -0.047249332, -0.073264845, 0.2116926, -0.114557505, -0.037215512));
	target3 += mul(nb3, float4x4(0.050166927, -0.04862805, 0.12805791, 0.0045228424, 0.056160565, 0.16115089, -0.07979352, -0.13011862, 0.05441418, 0.05797822, -0.13112345, -0.025642958, 0.05028941, -0.03776722, -0.030840462, 0.1557417));
	target3 += mul(nc3, float4x4(-0.13133498, 0.18729036, 0.09921492, 0.08116472, -0.045803983, 0.26691306, -0.074901216, 0.27606857, -0.008125972, 0.042414363, 0.13946676, 0.08842948, 0.08357318, -0.03671059, -0.16490772, 0.1321214));
	target3 += mul(nd3, float4x4(-0.065409325, -0.0521094, -0.16489594, 0.13398097, 0.059531994, 0.12008558, -0.3398136, 0.1359767, 0.19906406, -0.07998507, 0.030024389, 0.07742193, -0.17542136, -0.009348887, -0.07117329, 0.03772329));
	target3 += mul(ne3, float4x4(-0.058133047, -0.16653563, -0.0063957074, -0.095268235, -0.17482235, 0.059023783, 0.122984484, -0.34188032, -0.20109126, 0.18325296, 0.14055713, -0.10793852, 0.011646871, -0.061308336, -0.061341055, -0.021440659));
	target3 += mul(nf3, float4x4(0.078113094, -0.09492607, 0.08023962, -0.12604296, 0.109075874, -0.0154309245, 0.06649317, 0.06254269, 0.07463966, -0.073904, 0.05772617, 0.26408893, -0.006501864, -0.07582579, -0.10127933, -0.12402614));
	target3 += mul(ng3, float4x4(-0.042008914, 0.09461804, -0.072341286, 0.080054514, 0.14365824, 0.04930919, -0.099516146, -0.008121477, -0.0093559455, 0.10470606, 0.02927817, 0.021877058, -0.054930143, 0.060183078, -0.0445749, -0.01106447));
	target3 += mul(nh3, float4x4(-0.0011625461, -0.0009088538, -0.023627708, 0.027977956, -0.11017806, -0.26268825, -0.011429036, -0.03145088, 0.020097682, -0.029126195, -0.06067577, 0.069737315, -0.059665915, 0.0012559243, 0.010016551, -0.09414456));
	target3 += mul(ni3, float4x4(0.11869016, 0.20854239, 0.0059952354, -0.05854996, -0.019913383, 0.111083195, -0.110878445, -0.09330779, -0.09355048, -0.023232793, -0.028993065, -0.016969083, -0.046021197, 0.120301165, -0.016181333, 0.121419206));
	target3 += float4(0.13923971, 0.015290389, 0.012198976, 0.04480318);

	tex4[gxy] = target1;
	tex5[gxy] = target2;
	tex6[gxy] = target3;
}

//!PASS 5
//!DESC Conv-4x3x3x24
//!IN tex4, tex5, tex6
//!OUT tex1, tex2, tex3, tex7
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass5(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	float4 a1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d1 = tex4.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e1 = tex4.SampleLevel(sam, pos, 0);
	float4 f1 = tex4.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na1 = max(-a1, 0);
	float4 nb1 = max(-b1, 0);
	float4 nc1 = max(-c1, 0);
	float4 nd1 = max(-d1, 0);
	float4 ne1 = max(-e1, 0);
	float4 nf1 = max(-f1, 0);
	float4 ng1 = max(-g1, 0);
	float4 nh1 = max(-h1, 0);
	float4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	float4 a2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d2 = tex5.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e2 = tex5.SampleLevel(sam, pos, 0);
	float4 f2 = tex5.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na2 = max(-a2, 0);
	float4 nb2 = max(-b2, 0);
	float4 nc2 = max(-c2, 0);
	float4 nd2 = max(-d2, 0);
	float4 ne2 = max(-e2, 0);
	float4 nf2 = max(-f2, 0);
	float4 ng2 = max(-g2, 0);
	float4 nh2 = max(-h2, 0);
	float4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    float4 a3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d3 = tex6.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e3 = tex6.SampleLevel(sam, pos, 0);
	float4 f3 = tex6.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na3 = max(-a3, 0);
	float4 nb3 = max(-b3, 0);
	float4 nc3 = max(-c3, 0);
	float4 nd3 = max(-d3, 0);
	float4 ne3 = max(-e3, 0);
	float4 nf3 = max(-f3, 0);
	float4 ng3 = max(-g3, 0);
	float4 nh3 = max(-h3, 0);
	float4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	float4 target1 = mul(a1, float4x4(0.027190452, 0.0060910345, -0.008547152, 0.17320672, 0.06733503, -0.08989388, -0.11381129, -0.13119508, 0.17610823, 0.14008744, 0.11026499, -0.21357119, -0.12159518, 0.06601897, -0.034462526, -0.06805842));
	target1 += mul(b1, float4x4(0.032029126, -0.17226543, -0.041954145, 0.0048979674, 0.07860925, 0.014572411, 0.028136868, 0.023380699, 0.08869984, 0.066781156, 0.054681987, -0.2045243, -0.08229035, 0.034414835, -0.059059203, 0.123423755));
	target1 += mul(c1, float4x4(0.06395383, -0.17036091, -0.09632937, 0.012491044, 0.023212979, 0.0016467012, -0.14969939, -0.0054716296, -0.023756625, -0.17073572, 0.052645937, -0.046952818, -0.16187616, 0.016573654, -0.14689016, 0.01019834));
	target1 += mul(d1, float4x4(0.08193712, -0.07631574, -0.034434203, -0.014776324, 0.042278692, -0.1091839, -0.10186231, -0.08016388, -0.036329824, -0.27691782, -0.060328513, -0.21892257, 0.039156485, -0.015808448, 0.063398294, -0.045008957));
	target1 += mul(e1, float4x4(-0.1413053, -0.04867498, -0.06696859, -0.19319332, 0.06924486, 0.10097274, 0.027635809, -0.25744498, 0.043045916, 0.0080625275, -0.078129664, 0.07637907, 0.08766779, 0.009869328, -0.04087825, -0.107835));
	target1 += mul(f1, float4x4(0.03251173, -0.088434696, -0.17404701, -0.047607604, 0.19409397, -0.011666368, -0.055492543, -0.06779062, 0.18695107, 0.12933761, 0.009486838, 0.1311912, -0.115678646, -0.15206106, -0.0692949, -0.2093353));
	target1 += mul(g1, float4x4(-0.024145309, -0.049262546, -0.13907287, 0.079473436, -0.042634737, -0.08339864, 0.10169023, -0.035110317, -0.07373649, -0.013395292, 0.040008895, -0.10978444, -0.11845739, -0.037593327, -0.06392299, -0.16472307));
	target1 += mul(h1, float4x4(-0.004245749, -0.017990965, -0.16623773, 0.058491312, 0.09169293, 0.095187806, -0.13777736, -0.058859553, 0.12717004, -0.21097647, 0.022213815, -0.060391422, 0.24919353, 0.027743122, -0.046835132, 0.05116896));
	target1 += mul(i1, float4x4(-0.031152543, -0.006675389, -0.20609254, 0.059274126, 0.057716113, 0.010372987, -0.09142726, 0.21968524, 0.1961135, -0.123708576, 0.16263476, 0.0062686265, 0.014965539, -0.007153107, -0.11750436, -0.1819159));
	target1 += mul(a2, float4x4(-0.0060456856, 0.19447032, 0.020056425, 0.11960106, -0.32920054, 0.015612619, 0.26585084, 0.10356409, -0.14553185, 0.00058173627, 0.05271928, -0.1452066, -0.060218733, -0.020830099, -0.10317562, 0.052465137));
	target1 += mul(b2, float4x4(-0.27812362, 0.058981895, 0.08322605, -0.0032075725, -0.15221997, 0.09520731, 0.04914796, 0.11785509, 0.013318352, -0.10878859, -0.15916938, -0.18263555, -0.05563399, 0.014653972, 0.14075124, -0.057639994));
	target1 += mul(c2, float4x4(-0.0041990946, 0.0977939, -0.10445638, 0.020671595, -0.051427394, -0.026315004, -0.17141542, -0.19342242, 0.18054874, -0.15474714, 0.13021101, 0.11164268, 0.09080831, 0.036626425, -0.082300276, 0.04107306));
	target1 += mul(d2, float4x4(-0.039793264, 0.14146407, 0.09102857, 0.03839708, 0.3213411, -0.037526935, 0.26050022, 0.05215784, 0.09104371, 0.1189446, 0.1516196, -0.06040828, 0.06444251, 0.03769561, -0.05992374, -0.09555435));
	target1 += mul(e2, float4x4(-0.3158521, -0.09743379, -0.16136461, 0.12563957, -0.047199205, 0.14175804, 0.26343465, 0.26441336, -0.08041752, 0.12452204, 0.00063982303, -0.13609244, 0.2354998, 0.00049649493, 0.015294863, -0.2654468));
	target1 += mul(f2, float4x4(-0.08709678, 0.15577738, 0.05169841, 0.07911614, -0.024321338, -0.015250634, -0.021416046, -0.081399545, 0.0089286, -0.2259574, -0.05061959, 0.065474294, -0.030742366, -0.03538435, -0.055524804, 0.15507819));
	target1 += mul(g2, float4x4(0.045065995, 0.023564292, -0.037309248, 0.06847233, 0.056869928, 0.028326921, -0.17528678, 0.12857448, 0.035632227, -0.032293174, 0.104832776, 0.017997067, -0.114497125, 0.16921379, 0.12497218, 0.036903612));
	target1 += mul(h2, float4x4(0.075956464, 0.09397675, 0.052031025, -0.105377, -0.12632053, 0.024217378, -0.07852874, 0.11461346, -0.04082505, -0.108691104, -0.04474934, -0.29607844, 0.034042932, 0.12287652, -0.052040536, 0.041936204));
	target1 += mul(i2, float4x4(-0.038337763, -0.018111536, 0.06151811, 0.05389662, -0.028443024, 0.08706589, -0.073154494, 0.05447222, 0.07653834, -0.19515261, -0.037622564, 0.08052142, -0.045269065, -0.0609327, -0.100833364, 0.10981602));
	target1 += mul(a3, float4x4(0.094026454, -0.0031063687, -0.21620432, 0.13547292, 0.20105883, -0.025618935, 0.11542153, 0.10962974, 0.113429956, -0.14227262, 0.0060875076, -0.14874603, 0.09162232, -0.053849343, 0.04125156, 0.032826412));
	target1 += mul(b3, float4x4(0.013978522, -0.13269992, -0.07810451, 0.070542224, -0.04335991, 0.13381198, -0.027735049, -0.15146035, 0.22838825, -0.064607605, 0.09653002, -0.12548994, 0.13875695, -0.07963269, 0.17691031, -0.09219512));
	target1 += mul(c3, float4x4(-0.3725075, -0.10551151, -0.015794966, 0.11881437, 0.032990977, -0.08120358, -0.028089223, 0.07270803, 0.09375988, -0.19002074, 0.042594276, -0.14296396, 0.058286652, 0.027516257, -0.06983339, -0.21678405));
	target1 += mul(d3, float4x4(-0.07584593, -0.030345742, -0.102612115, -0.008622554, 0.19179675, -0.007445088, -0.0055725924, 0.045661647, 0.15045294, 0.05527889, -0.16074698, -0.11140143, -0.10332519, 0.0775829, 0.3479224, -0.09605363));
	target1 += mul(e3, float4x4(0.24224567, -0.10463845, -0.004708288, -0.037463564, -0.174914, -0.12728058, -0.09033664, -0.07400692, -0.14376171, 0.047589123, 0.12197598, 0.10113545, 0.27015212, -0.034403134, 0.1424642, 0.160263));
	target1 += mul(f3, float4x4(-0.13663313, -0.1106191, 0.011357531, -0.22931215, -0.019929864, -0.10682277, -0.055398542, 0.066238664, -0.085308366, 0.04024022, 0.12161912, 0.08610841, 0.09498895, -0.06681962, 0.13027692, -0.0019338574));
	target1 += mul(g3, float4x4(-0.03641036, -0.011318962, 0.110239714, 0.11487314, -0.0893917, 0.15007862, 0.027590204, 0.09350642, 0.024954673, 0.12835681, 0.03920746, 0.09515919, -0.1465032, -0.030845147, -0.1298204, -0.13092597));
	target1 += mul(h3, float4x4(-0.053689882, -0.013590492, 0.14078104, -0.02906744, -0.028918952, -0.05751785, -0.15884842, -0.26478568, 0.13566354, 0.12888497, -0.07389985, -0.10991238, -0.04350177, 0.056619987, -0.007795586, 0.20150684));
	target1 += mul(i3, float4x4(-0.24407062, 0.21552294, -0.00949639, 0.06383184, -0.021686498, -0.3234789, 0.00095171423, 0.16604368, 0.21007693, -0.23288599, 0.14941412, -0.23804995, -0.041001838, 0.122981116, -0.08457904, 0.31631222));
	target1 += mul(na1, float4x4(-0.03347639, -0.11116802, -0.024119927, -0.13334364, -0.06425279, 0.034693595, -0.042770308, -0.17312396, -0.067923695, 0.016072923, -0.11040154, -0.17093144, 0.0015578474, -0.29394698, 0.107074894, 0.27303827));
	target1 += mul(nb1, float4x4(-0.0611658, 0.019790849, 0.06787951, 0.10454345, -0.015665758, 0.0151002975, 0.03526049, -0.103849605, 0.18519226, 0.13797036, -0.061827153, 0.049401954, -0.14499283, -0.019294523, -0.059974186, 0.08248854));
	target1 += mul(nc1, float4x4(-0.10331019, 0.013611227, 0.06224777, 0.051212363, 0.07831132, 0.10166972, 0.06203761, -0.18489413, 0.15709174, 0.10225166, -0.047563914, 0.07839388, 0.111176215, -0.17445758, -0.025798218, 0.039074145));
	target1 += mul(nd1, float4x4(-0.0126109915, 0.1351571, -0.036555156, 0.010697993, -0.13778222, 0.03346138, -0.0049093324, -0.15003881, -0.03876987, 0.07914351, 0.047344975, 0.11449459, 0.063460924, -0.08697232, 0.10283146, 0.051968753));
	target1 += mul(ne1, float4x4(0.23186366, -0.06041623, -0.16257766, 0.24217394, -0.023535172, -0.101410136, -0.108250454, 0.107450925, 0.034496274, -0.028800279, 0.021022853, 0.03616355, 0.02028369, -0.08332956, 0.10570706, 0.09971033));
	target1 += mul(nf1, float4x4(0.04147743, 0.015145005, 0.120189026, -0.068185546, 0.046765327, 0.06456099, -0.1020187, 0.021370325, -0.040851895, -0.03208752, 0.048594363, -0.1198498, 0.068069115, 0.041555826, -0.17036118, -0.01932193));
	target1 += mul(ng1, float4x4(0.056585032, 0.08170861, 0.16936389, 0.12775362, -0.06250441, 0.003437123, -0.1626591, -0.044595372, 0.05609032, -0.013985337, 0.12408558, -0.023731874, 0.06669848, 0.015816472, 0.02028663, 0.15866788));
	target1 += mul(nh1, float4x4(0.08446122, 0.18007189, -0.029043732, -0.011163938, -0.07911146, -0.08956735, 0.01947308, -0.14794883, 0.006629651, 0.038349632, -0.00968828, -0.025770634, -0.0773972, 0.005243162, -0.024193848, 0.13965817));
	target1 += mul(ni1, float4x4(0.11081664, 0.014651672, 0.17688385, -0.105908446, 0.10568161, -0.0114132725, -0.07771328, -0.07368131, -0.08784887, 0.000283126, -0.062638454, 0.10225453, 0.03358641, 0.022887172, -0.05419985, 0.13735344));
	target1 += mul(na2, float4x4(0.10541027, 0.020751795, -0.09398483, -0.005489149, -0.29769272, 0.23499025, -0.006691222, -0.053000394, 0.010389082, 0.17603737, -0.00460357, 0.022672169, 0.184428, -0.05348439, -0.056355994, -0.09495365));
	target1 += mul(nb2, float4x4(0.0008888126, -0.07352942, -0.115427524, 0.039416842, 0.035075482, 0.064889066, -0.0403974, -0.16294649, 0.15031078, 0.15975513, 0.050580446, 0.17225175, -0.15042374, 0.1044681, -0.020698681, 0.02006514));
	target1 += mul(nc2, float4x4(-0.04267897, 0.013600698, -0.06688994, 0.06905151, 0.0050800233, 0.074999094, -0.013612523, 0.24658114, 0.09293767, -0.025656242, -0.12935342, -0.053077035, -0.10818674, 0.10712919, 0.10325497, 0.026742944));
	target1 += mul(nd2, float4x4(0.057898734, -0.079083994, -0.014326936, -0.012377722, -0.081788406, 0.15159677, 0.009859493, -0.17867896, -0.15591973, 0.052071776, 0.08789029, -0.07519902, -0.05066772, -0.062322497, 0.115281776, 0.036021948));
	target1 += mul(ne2, float4x4(0.18813054, 0.08132526, 0.13596503, -0.048313983, 0.38620186, 0.2359013, 0.037454955, -0.1447747, 0.067145094, -0.0005996448, 0.1840271, 0.05323988, -0.23532471, -0.0116497595, 0.2535536, 0.061556816));
	target1 += mul(nf2, float4x4(0.0129419975, -0.17229463, -0.09436541, 0.10180941, 0.11799404, 0.031389806, -0.07010608, 0.0046768254, 0.10469505, 0.17582805, -0.22139175, -0.14195564, -0.02746759, 0.1141511, -0.029968468, 0.07361169));
	target1 += mul(ng2, float4x4(-0.0769514, 0.017098518, 0.082954735, 0.025435448, -0.21867949, -0.07731593, 0.031622138, -0.013084908, 0.053551342, 0.08035211, -0.06418101, -0.14921196, 0.18860011, 0.029326573, -0.0472363, -0.011997928));
	target1 += mul(nh2, float4x4(-0.01178925, -0.07107687, -0.09878797, 0.1556755, -0.055202577, -0.040342607, -0.1087109, 0.22202995, -0.02957374, 0.063299805, -0.0226507, 0.09204488, 0.08155232, -0.022691648, 0.061842438, -0.003388257));
	target1 += mul(ni2, float4x4(-0.0058287196, -0.013047009, -0.15424606, -0.056314673, -0.06388496, 0.0222499, -0.11188726, 0.2635107, -0.05954232, 0.1667741, -0.12295786, -0.15182652, 0.1224556, -0.1186777, -0.011522621, -0.09436076));
	target1 += mul(na3, float4x4(0.07150499, -0.07419667, 0.16062357, -0.13254762, -0.010069923, 0.09393101, 0.035834856, -0.043301247, 0.059349176, 0.015473052, 0.06563933, -0.013041895, 0.029431, 0.11289305, 0.08899771, 0.16794808));
	target1 += mul(nb3, float4x4(-0.113425404, 0.14999859, 0.06650979, 0.036482334, 0.018955054, -0.10026139, 0.11925662, 0.114249855, 0.06869671, 0.052254554, -0.004852112, 0.0565278, 0.078193806, 0.05062573, 0.03250799, 0.19846839));
	target1 += mul(nc3, float4x4(0.021927554, -0.1345216, -0.0016766218, -0.13956897, -0.045278247, -0.0069249924, 0.006003127, 0.07814754, 0.10342034, 0.06784387, -0.069491945, 0.19103162, 0.14311132, -0.022440588, -0.06932795, 0.030535521));
	target1 += mul(nd3, float4x4(-0.04036147, 0.054757025, 0.017254664, -0.12124264, -0.1816484, 0.15580839, -0.09062968, -0.0048705437, -0.029410018, 0.038827926, 0.057098128, -0.018173074, -0.10805557, -0.14378877, -0.2585165, 0.172119));
	target1 += mul(ne3, float4x4(-0.1310388, 0.18337108, 0.19657819, -0.010367786, -0.04445844, -0.24680386, -0.04328972, -0.0399127, 0.12341645, -0.08352961, 0.011123786, -0.083505794, -0.09089909, 0.060027592, -0.23706149, 0.03521439));
	target1 += mul(nf3, float4x4(0.01557783, 0.010480741, 0.0434283, 0.16624042, -0.15881334, -0.04636994, -0.0038111496, 0.03575316, -0.08781109, 0.12979223, 0.06802427, 0.08255704, 0.37816545, -0.058951244, -0.102753684, 0.1256413));
	target1 += mul(ng3, float4x4(-0.10425998, -0.071307346, -0.11617004, -0.13080333, 0.1492051, 0.054852143, 0.07140254, -0.064901225, 0.0023687668, 0.012650793, -0.1390397, -0.09889024, 0.19282119, -0.04274883, 0.1678261, 0.10092644));
	target1 += mul(nh3, float4x4(0.052412614, -0.016467815, -0.08627941, 0.21175376, -0.037298422, 0.009408156, 0.09253116, 0.22531977, -0.09862147, 0.012014097, -0.00088612316, 0.10639377, 0.21262354, -0.36476177, 0.1831788, -0.18416084));
	target1 += mul(ni3, float4x4(0.10780807, -0.049085826, -0.035806093, 0.089742415, -0.121957704, -0.07614303, 0.1122783, -0.1417334, -0.11307489, -0.099186234, -0.09983688, -0.08203866, 0.18696213, -0.10846918, 0.022843426, 0.17075616));
	target1 += float4(-0.10820368, 0.052109707, 0.02658453, -0.089495786);
	
	float4 target2 = mul(a1, float4x4(-0.06560893, -0.038288042, -0.0021071879, -0.030108955, 0.145761, 0.0029613946, 0.051950503, -0.015247062, 0.44679, 0.114423126, -0.006614156, -0.085114725, -0.17392384, -0.1525023, 0.00087433326, -0.0061209374));
	target2 += mul(b1, float4x4(-0.038765047, 0.023672441, 0.07686677, 0.1169065, 0.057648882, -0.04956052, 0.18272647, 0.074001, 0.0148019185, -0.17424357, -0.15635398, -0.11640745, -0.044930972, 0.17733482, -0.118420936, 0.0034517103));
	target2 += mul(c1, float4x4(-0.03843906, 0.14669247, -0.0016725688, -0.05404641, -0.010653548, -0.14568646, 0.01552742, 0.0075000613, -0.11138789, 0.12747082, -0.0019283098, 0.15637173, 0.17695609, 0.11176842, 0.037749417, 0.038456965));
	target2 += mul(d1, float4x4(0.011113179, -0.033781096, 0.10000893, 0.09236021, 0.05682521, 0.047795758, 0.082160555, -0.06516607, 0.021327825, 0.123461336, 0.16531587, -0.017066834, -0.17193775, 0.0088722, 0.11325116, -0.008696895));
	target2 += mul(e1, float4x4(-0.1559535, -0.027437076, -0.06791055, 0.0076806503, -0.105000794, -0.013547857, 0.044852357, -0.072031856, 0.03666842, -0.09417821, 0.044465255, -0.021518283, 0.075612575, 0.12548204, 0.0053096185, -0.081135504));
	target2 += mul(f1, float4x4(-0.032854624, -0.04636654, 0.08900102, -0.006676651, -0.17161772, -0.11203611, -0.08199468, -0.09992361, 0.20184253, -0.1002281, -0.1186801, 0.07690125, 0.10468101, -0.034323484, 0.05079439, 0.05624683));
	target2 += mul(g1, float4x4(0.098402895, 0.21312171, -0.09616754, -0.0022171456, 0.13993289, 0.020528518, 0.14474267, -0.10080646, -0.1283229, 0.1904186, -0.040573347, -0.14794436, 0.054999832, -0.11960501, -0.061369505, 0.09603712));
	target2 += mul(h1, float4x4(-0.10725682, 0.06215029, 0.089609645, 0.018108908, 0.021400819, 0.031146, -0.22904995, -0.01076689, -0.105205126, 0.012291847, -0.048588227, -0.049485933, 0.114158444, -0.091215335, -0.027073242, -0.11835295));
	target2 += mul(i1, float4x4(-0.102791235, -0.029520744, -0.19900851, -0.029541757, -0.031764254, -0.008002707, -0.017105635, -0.07239135, 0.14740342, 0.05648717, 0.077909015, -0.14993371, 0.120271415, -0.10764749, 0.024895139, -0.06620364));
	target2 += mul(a2, float4x4(0.23614062, 0.17541821, -0.008834044, 0.18276002, 0.0081810225, 0.08408151, -0.13527961, -0.018539876, 0.014361589, -0.027012244, -0.17484863, -0.019362496, -0.037048925, 0.094974704, 0.018246485, 0.109574154));
	target2 += mul(b2, float4x4(-0.1533575, 0.19374342, -0.027817149, 0.16140993, -0.06192059, 0.045258347, -0.09625185, -0.026630063, -0.0050361003, 0.020038875, 0.17793919, 0.059639167, 0.079904884, 0.03772698, 0.07656081, 0.21176697));
	target2 += mul(c2, float4x4(0.03496418, -0.07980854, -0.022122597, -0.15199453, -0.029270291, 0.02720027, 0.10541389, -0.020044396, 0.031097332, 0.00533792, -0.07936573, 0.0767852, -0.052802965, 0.044324324, 0.1331397, 0.09737042));
	target2 += mul(d2, float4x4(-0.09404921, -0.12238693, -0.15260863, -0.037168942, 0.101774864, -0.12818033, -0.19276977, 0.060901154, 0.3669953, -0.08837079, 0.09483071, 0.0039528203, 0.114874505, 0.11380748, -0.0675627, 0.099314205));
	target2 += mul(e2, float4x4(-0.18921007, 0.11088719, -0.03879293, 0.24393363, 0.024074616, -0.055593442, -0.038904842, 0.093477115, -0.074254654, 0.023504809, 0.0015475574, 0.06922074, -0.02201723, 0.04952918, -0.12691462, -0.04520855));
	target2 += mul(f2, float4x4(-0.015887981, 0.13304926, -0.006745367, 0.08113083, 0.14956935, -0.115906075, -0.14784655, 0.030012615, 0.031657662, -0.065392576, 0.26881677, 0.060661886, -0.022231037, -0.04828739, 0.09894193, -0.14562485));
	target2 += mul(g2, float4x4(-0.047161587, -0.017991489, -0.0075016962, -0.034034126, -0.061112147, 0.13156408, 0.16217458, 0.076580904, 0.1459869, 0.11071404, -0.043128885, 0.0338223, 0.21686563, 0.008266244, 0.058333807, 0.02561811));
	target2 += mul(h2, float4x4(-0.018609803, 0.0234848, 0.040451016, -0.08435358, -0.009784489, -0.008065147, -0.053126886, 0.011366649, -0.084467, -0.1788947, -0.12264094, -0.18014608, 0.059439298, 0.03542411, 0.078848965, -0.13048537));
	target2 += mul(i2, float4x4(0.078216806, 0.013697004, -0.15663616, -0.049786724, -0.13391373, -0.08318028, 0.06794668, 0.09373982, -0.083461255, 0.061056722, -0.2251907, -0.06139379, -0.20027658, -0.09285312, 0.039336286, 0.09701935));
	target2 += mul(a3, float4x4(-0.16103904, -0.102670334, 0.0012198326, -0.22724585, 0.23467462, 0.044629287, 0.0045051533, 0.08221795, 0.13965432, -0.025059564, 0.009324332, 0.17598952, 0.10017599, 0.043154277, 0.09106905, 0.004035487));
	target2 += mul(b3, float4x4(-0.044398602, -0.02080209, 0.07439402, -0.0837648, -0.09127961, -0.16654146, -0.028559506, 0.063172385, 0.02517883, -0.2839795, -0.011589502, -0.07898659, -0.013581755, -0.18534079, -0.0017158306, 0.105475046));
	target2 += mul(c3, float4x4(0.104462, 0.27500334, -0.16876803, -0.067298174, -0.011149543, 0.026384255, -0.10175635, -0.2548854, -0.1283541, -0.16410558, 0.07503598, -0.02121285, -0.0064750114, -0.09670444, 0.08300398, 0.19831792));
	target2 += mul(d3, float4x4(-0.009554492, -0.095104635, 0.08615534, -0.10154481, 0.11020224, -0.1011952, 0.061394565, 0.050413556, 0.19796023, 0.11560851, 0.033866078, 0.23405328, -0.0060241343, -0.050427623, -0.18293521, -0.031680096));
	target2 += mul(e3, float4x4(0.058735132, 0.026442906, -0.23102848, -0.07569987, -0.26244682, -0.20584835, 0.2259608, 0.06885029, 0.035959512, 0.075910114, -0.17818634, 0.053924832, -0.0046540634, -0.02363428, -0.0501489, 0.07347372));
	target2 += mul(f3, float4x4(-0.0733894, 0.10715639, 0.28019708, 0.100572936, -0.07274408, 0.072782665, -0.056028996, 0.06478587, -0.031222489, 0.043191776, -0.10039772, -0.21392053, -0.04606884, -0.16641788, 0.0065926304, 0.055378567));
	target2 += mul(g3, float4x4(-0.118616246, -0.13528953, -0.19563872, 0.23483656, 0.02614144, 0.19605434, -0.05274385, -0.08863971, 0.16891058, 0.1366527, 0.09084148, 0.100328505, 0.034491546, 0.08647768, 0.21777217, -0.049174547));
	target2 += mul(h3, float4x4(0.1357159, -0.012445991, 0.3096013, 0.181176, -0.010390439, 0.14459321, -0.10700577, -0.011389145, 0.09287424, 0.07787938, -0.096365124, 0.017783955, -0.09306514, 0.15694624, -0.14705794, -0.13922045));
	target2 += mul(i3, float4x4(0.13941582, 0.19728883, -0.151456, 0.10526561, -0.09251345, 0.11684088, 0.1303061, 0.14257613, -0.20296581, 0.00048331724, 0.2851077, -0.20377511, -0.057946853, 0.031233812, -0.15364504, -0.009259494));
	target2 += mul(na1, float4x4(-0.098066, -0.08288004, -0.06673981, -0.06435033, 0.034342356, 0.015804073, 0.023787297, 0.10401755, -0.19141194, -0.16482951, -0.0056575392, 0.0093797995, -0.28313008, 0.0048112553, -0.017099613, 0.02518723));
	target2 += mul(nb1, float4x4(-0.030270405, -0.038700357, -0.013410372, -0.004442315, -0.12467148, 0.08281559, -0.1605282, 0.069578275, 0.10012911, 0.01924674, -0.021857055, 0.07991313, 0.00801384, 0.13677774, 0.013247758, 0.03188123));
	target2 += mul(nc1, float4x4(-0.17157516, -0.08176375, -0.089773096, -0.0405298, -0.085242964, -0.03426719, 0.054874644, 0.066589154, 0.04864499, -0.18212035, -0.11903994, 0.04277644, -0.24286698, 0.14560008, 0.1412366, -0.049351584));
	target2 += mul(nd1, float4x4(-0.0020793858, 0.13244559, 0.022845006, -0.056293562, 0.025595138, 0.12697968, 0.0062493416, 0.10955782, -0.02731004, -0.04970028, 0.0558574, 0.013929665, -0.030912375, -0.07561133, -0.31270868, 0.027562078));
	target2 += mul(ne1, float4x4(0.072941735, 0.021501537, -0.0630067, -0.10351342, 0.0041823885, 0.13891226, -0.070387594, 0.052334826, -0.003547599, 0.19354597, -0.020180183, -0.037713047, 0.06751014, -0.17405544, -0.020440113, 0.25509283));
	target2 += mul(nf1, float4x4(0.005987273, -0.08264425, -0.019549685, -0.06343352, -0.005718748, 0.05226893, 0.07570872, -0.030717341, -0.18217428, -0.0039694863, 0.1455871, -0.0977504, -0.15671553, -0.006649227, -0.1283491, 0.100330345));
	target2 += mul(ng1, float4x4(-0.057930637, -0.114826396, 0.06898038, -0.13852106, 0.024047598, 0.20633829, -0.12503678, 0.022534683, -0.18774416, -0.31502175, -0.10984795, -0.018557208, 0.17580375, 0.25652558, 0.22530238, -0.0028108188));
	target2 += mul(nh1, float4x4(0.023331782, -0.01088776, -0.0052380436, 0.00686383, 0.026780738, 0.03749848, 0.22947483, -0.103271484, 0.012644287, -0.0142970905, 0.098855376, 0.0055474946, 0.032439362, 0.027143423, -0.14876749, -0.06213873));
	target2 += mul(ni1, float4x4(-0.03750828, 0.010431886, 0.17416674, -0.090744555, -0.17330858, 0.013979898, 0.03489776, -0.13337487, 0.00858403, -0.037750907, -0.17109399, 0.08273273, -0.14204618, -0.009869641, -0.013496473, 0.076338045));
	target2 += mul(na2, float4x4(-0.043562744, -0.18440323, 0.011339632, -0.14345059, -0.08992258, -0.10230683, -0.10468143, 0.34146136, 0.15978895, -0.0051261852, 0.061601657, 0.09483878, -0.007760578, -0.018336317, 0.044910427, -0.09316569));
	target2 += mul(nb2, float4x4(0.1253627, -0.12310892, 0.016166732, 0.027448155, 0.13965616, -0.13030767, 0.17542621, 0.061852284, 0.16997853, 0.0056183804, -0.18704928, -0.019231116, -0.08086044, 0.09974395, -0.01429541, 0.03184063));
	target2 += mul(nc2, float4x4(0.04526007, 0.030035531, 0.03181006, 0.22173904, -0.1355034, -0.1948648, 0.06783468, 0.038674995, -0.046629447, -0.03462297, 0.09421528, 0.048745953, 0.16898066, 0.13283801, -0.14163011, -0.23105736));
	target2 += mul(nd2, float4x4(0.07269096, -0.06190773, -0.038986176, 0.102121696, 0.14298806, 0.23800415, 0.1370508, 0.0034182875, 0.009464909, 0.073990576, -0.028228868, 0.047769118, -0.11799714, -0.07566264, -0.025975682, 0.06592005));
	target2 += mul(ne2, float4x4(0.1140849, 0.0011444123, 0.13536933, -0.045905575, 0.050907966, -0.065915674, 0.034910467, -0.2681743, 0.10803704, 0.12069119, -0.12347737, -0.06318596, -0.06862493, 0.014980036, 0.22914106, 0.0003237674));
	target2 += mul(nf2, float4x4(-0.09530222, -0.11337397, 0.014516241, 0.0709293, -0.122670494, -0.17343688, -0.09817145, 0.0427696, -0.0035809735, 0.0970125, -0.35413933, -0.13195236, 0.07348421, 0.11037325, 0.056015544, -0.011848703));
	target2 += mul(ng2, float4x4(-0.05069634, -0.032064505, -0.03238415, 0.1735258, 0.25210074, 0.10959535, -0.2741513, 0.13719772, 0.1066583, 0.20128429, -0.008766815, -0.11834798, 0.057237767, 0.017930366, 0.021861222, -0.025086008));
	target2 += mul(nh2, float4x4(-0.000881232, -0.05960106, -0.08985197, 0.14067702, 0.018204128, 0.09699959, -0.05949243, 0.059911992, 0.027270103, 0.06743677, 0.38237867, -0.058599375, -0.047956746, 0.11374969, -0.14632292, -0.005532837));
	target2 += mul(ni2, float4x4(-0.0312775, 0.0031963694, 0.08149806, 0.13988096, -0.0040519754, 0.035389222, 0.0864673, 0.18592173, 0.03735674, -0.054272953, 0.18598364, -0.13443853, 0.085672796, -0.049046505, 0.0057935636, 0.017542645));
	target2 += mul(na3, float4x4(-0.04916441, 0.015665755, 0.08576695, 0.17165792, -0.13008267, 0.04201376, -0.2670682, 0.119378634, -0.100484766, -0.0887232, 0.049034663, -0.039614394, 0.02695341, -0.04374321, -0.106656834, 0.023938615));
	target2 += mul(nb3, float4x4(0.03373819, 0.004977311, -0.0040103244, 0.13545765, 0.06599036, -0.09659661, 0.22132197, -0.116552144, 0.100918315, -0.022979576, 0.07052367, 0.04172229, 0.17585796, 0.05118707, -0.08703159, 0.055033304));
	target2 += mul(nc3, float4x4(-0.18900026, 0.019988917, 0.07693406, 0.28435934, 0.12686001, -0.14701878, -0.09573673, -0.17312722, 0.15025325, 0.12911554, -0.09475629, 0.016428819, 0.082817025, -0.11946521, -0.0013731157, -0.09071587));
	target2 += mul(nd3, float4x4(0.0797976, 0.11099694, -0.05467964, 0.014629147, -0.09720358, 0.04712591, 0.015981004, -0.05535863, 0.03645818, 0.041274335, 0.10671675, -0.11314873, 0.036964905, 0.17811853, 0.08903187, 0.0095582185));
	target2 += mul(ne3, float4x4(0.11976107, 0.004657432, -0.06258394, -0.022577194, 0.17443101, 0.1387175, 0.059126876, 0.032149844, 0.1430801, 0.002375262, -0.12749809, 0.08837332, 0.06466934, 0.13617098, 0.04582338, 0.068308234));
	target2 += mul(nf3, float4x4(0.022942754, -0.09855706, 0.049297135, 0.096298546, 0.1906194, 0.11273925, -0.22720218, 0.003925555, 0.0028442615, -0.12138431, 0.09074982, -0.030113788, 0.00383381, -0.09112362, -0.27005482, 0.022827866));
	target2 += mul(ng3, float4x4(-0.19426541, 0.009114653, 0.11889596, -0.057239886, -0.03998725, -0.1694043, -0.20197673, 0.041406937, 0.020746358, 0.22414313, -0.1622876, -0.11014813, -0.09325455, -0.08461812, -0.021865716, 0.008194336));
	target2 += mul(nh3, float4x4(0.021359676, -0.022532789, -0.10541426, -0.24901268, 0.030835157, -0.034806997, 0.10264721, -0.006528542, -0.03765987, 0.069545716, 0.25284502, 0.04730265, -0.012214816, -0.053018507, 0.13373806, -0.037745554));
	target2 += mul(ni3, float4x4(-0.09582438, -0.18056035, -0.09869147, 0.11321111, -0.10706152, -0.037460733, 0.121544324, -0.11290087, 0.18490471, -0.06921383, -0.19518846, 0.10960292, -0.06263085, 0.13362981, -0.08682174, -0.053608853));
	target2 += float4(-0.019858388, -0.049763262, 0.034831703, -0.12479427);
	
	float4 target3 = mul(a1, float4x4(-0.1652761, 0.13780159, 0.09095229, -0.043444302, -0.06450598, 0.04212247, 0.069517806, 0.09327406, -0.033491675, -0.14936084, 0.009638944, 0.11837384, 0.02686685, 0.037584316, -0.09761867, -0.026200296));
	target3 += mul(b1, float4x4(-0.12561406, 0.12076126, 0.028275209, -0.08543192, -0.099475406, -0.0822321, 0.0920009, 0.06756713, -0.10781483, -0.12923865, 0.032576296, 0.3534597, 0.03224445, -0.015600879, -0.025559058, -0.027278373));
	target3 += mul(c1, float4x4(0.07211016, 0.054111533, 0.13363571, -0.010288602, -0.20603329, 0.0047039236, -0.04776343, 0.25487995, -0.10845931, 0.0972547, -0.10519721, -0.0073581343, -0.10403583, -0.06662798, 0.041069936, -0.11237198));
	target3 += mul(d1, float4x4(-0.011475162, 0.062792905, 0.091312, 0.30339372, -0.11382581, 0.06737181, 0.07341503, 0.16007973, 0.001011511, -0.11274179, -0.006656744, -0.034754373, 0.08876155, 0.014858809, 0.08583179, 0.010586847));
	target3 += mul(e1, float4x4(0.095108636, 0.0049300413, -0.15713759, -0.049208567, 0.14641964, -0.1558201, 0.115891516, -0.06733412, -0.07573838, 0.29731378, 0.108890355, 0.043476757, 0.06507369, 0.035861496, -0.03979463, 0.0009747037));
	target3 += mul(f1, float4x4(0.04926235, -0.037529353, 0.079898834, -0.14147292, -0.08446753, -0.06169593, 0.047313344, 0.26457137, -0.035472378, -0.073560245, 0.14341679, -0.022741733, -0.1525431, -0.01243139, -0.011166588, -0.20521918));
	target3 += mul(g1, float4x4(-0.016135108, 0.011612018, 0.14412925, -0.02519369, 0.09124221, 0.05163101, -0.13721077, 0.028859738, -0.10101291, -0.14688651, 0.15746878, -0.124548726, -0.04213581, -0.01224665, 0.17707069, 0.012810498));
	target3 += mul(h1, float4x4(-0.17663126, -0.07370428, 0.043691028, -0.006832302, -0.050157465, -0.030904332, 0.061489057, -0.009296911, 0.03220379, -0.047700413, -0.029812776, 0.16822562, 0.041632306, 0.11511152, 0.09653043, -0.055198412));
	target3 += mul(i1, float4x4(0.13367188, 0.03333002, 0.008851994, -0.012191224, -0.045508027, 0.08612423, 0.06786381, 0.15179649, -0.031041663, -0.059014346, 0.15675054, -0.08772905, 0.09033015, -0.08435604, 0.07550108, -0.14843665));
	target3 += mul(a2, float4x4(0.14639384, 0.16561817, -0.03261034, -0.03337392, 0.14970617, -0.11748068, -0.12750028, -0.10566866, 0.16191705, -0.08984127, 0.06803522, 0.008120483, 0.10923837, 0.0364358, -0.13485567, 0.14291629));
	target3 += mul(b2, float4x4(-0.02444568, 0.21520157, 0.05191823, 0.17272551, -0.047668163, -0.09192939, -0.020734387, -0.016689759, -0.21506861, -0.038079426, 0.099174924, 0.010456613, -0.20138906, -0.0112631135, 0.08758567, -0.045137912));
	target3 += mul(c2, float4x4(0.060797717, 0.03514636, -0.05460338, -0.095668696, -0.08528851, -0.07811166, 0.12541622, -0.036730994, -0.14369172, -0.010652937, 0.0060692867, -0.1785254, 0.14972189, -0.13451393, -0.04655055, 0.16085984));
	target3 += mul(d2, float4x4(0.05367569, 0.20912962, 0.018910028, -0.10154244, 0.03168856, 0.06779478, -0.088652916, 0.016729023, 0.10557536, -0.099209085, 0.14797546, -0.18952388, 0.07048445, 0.102708265, -0.14564602, 0.12568687));
	target3 += mul(e2, float4x4(-0.049337912, -0.12502758, -0.09065302, 0.19880529, 0.26680514, -0.003136209, -0.11733151, -0.11684242, -0.04335924, 0.30764192, 0.2855104, 0.04156867, -0.08121212, 0.23999381, -0.019614706, 0.027516816));
	target3 += mul(f2, float4x4(-0.04837136, -0.0049304874, 0.006328469, 0.013705871, 0.067017764, -0.03406703, 0.053161882, 0.24689339, -0.02929922, 0.06797918, 0.015713276, -0.17147881, 0.04482974, 0.07526465, 0.019844312, -0.18729854));
	target3 += mul(g2, float4x4(0.030257802, 0.010643463, -0.11703066, -0.015162744, -0.074236035, 0.01591241, 0.061938114, -0.08404092, 0.111995466, -0.13485448, 0.21688463, -0.110088274, 0.079335205, -0.2474801, -0.03824567, -0.018190503));
	target3 += mul(h2, float4x4(-0.11581714, -0.004117979, 0.033883266, -0.13720983, 0.029020213, -0.08154189, -0.0020539986, 0.11715364, 0.17582226, 0.0916048, 0.0750543, 0.06601126, 0.038681798, -0.03606899, 0.08065586, 0.0019443193));
	target3 += mul(i2, float4x4(-0.037615683, 0.12732984, 0.042441927, -0.008004603, 0.11336218, -0.042417236, 0.044717386, -0.13728632, 0.038264424, 0.17234874, -0.02492702, 0.120399185, 0.024329247, 0.024983741, -0.1845697, -0.07284304));
	target3 += mul(a3, float4x4(0.2704137, 0.15812507, 0.060361683, -0.07266647, -0.15354276, -0.04938148, 0.11895455, -0.12520859, -0.07866695, 0.06199223, 0.02046756, 0.16162948, 0.037545823, -0.08195345, -0.02782581, -0.1247714));
	target3 += mul(b3, float4x4(0.058098216, 0.1090351, 0.036994565, -0.14390574, -0.02314059, -0.067219526, -0.08998296, 0.12025692, -0.1035221, 0.05190676, -0.0240437, 0.06639121, -0.039624542, 0.002958745, 0.019561864, 0.12834862));
	target3 += mul(c3, float4x4(0.2211613, -0.1103558, -0.0464588, 0.06874506, -0.32631674, 0.11210603, 0.051548798, -0.34436032, -0.11639206, 0.12327613, 0.051884107, -0.03575669, 0.035892785, -0.06696002, -0.15486757, 0.11983755));
	target3 += mul(d3, float4x4(0.021447798, 0.010329525, 0.013789607, 0.119596116, -0.05871373, 0.055229582, 0.20033267, 0.03858596, -0.10166856, 0.0006909935, 0.0964782, 0.095391914, 0.013319357, -0.13142642, 0.1100771, 0.050889898));
	target3 += mul(e3, float4x4(-0.16984001, -0.16002657, -0.060783282, -0.17456883, 0.2011064, -0.14940733, -0.15602681, 0.14061591, 0.18068549, -0.00217099, -0.024712907, 0.037761874, -0.07138531, -0.0016056405, 0.11756802, 0.18380354));
	target3 += mul(f3, float4x4(0.07733175, -0.17642827, 0.07976922, -0.051280692, 0.16156857, 0.032522928, -0.095040165, -0.0583928, 0.038923588, -0.043146443, -0.10355574, 0.1974055, 0.04354748, 0.09425934, 0.026754672, 0.23734866));
	target3 += mul(g3, float4x4(-0.13585593, 0.14902504, -0.27107853, 0.13296895, -0.2865579, -0.074112825, 0.1409574, -0.0003253808, 0.1733374, -0.16919981, 0.03372848, 0.21644552, -0.00050592434, -0.037268158, 0.1148079, -0.13287376));
	target3 += mul(h3, float4x4(0.005142486, 0.0867682, -0.09227092, -0.10524167, 0.07520852, 0.015542765, 0.016817883, -0.0733789, 0.20560083, -0.1119311, 0.17374502, -0.107678846, -0.09381425, 0.14690572, 0.022286026, -0.19862098));
	target3 += mul(i3, float4x4(-0.20393431, -0.045187343, 0.0095105795, 0.052588273, -0.14538154, 0.18569797, -0.031874318, -0.15881945, -0.08170196, 0.052769475, -0.15122755, 0.090783544, 0.21360469, 0.04577172, 0.05163147, 0.07916663));
	target3 += mul(na1, float4x4(0.14100257, -0.03398819, -0.052019518, -0.08121586, 0.008056087, -0.0931302, -0.19780545, 0.16904305, -0.13034676, 0.08930879, -0.0112331435, 0.029833045, 0.03981243, 0.12613662, -0.2159093, 0.035136405));
	target3 += mul(nb1, float4x4(0.09830958, 0.10535925, -0.08584078, -0.04632737, 0.0022527708, -0.031659063, -0.101096116, 0.063173816, -0.06613251, 0.118981436, -0.003423647, -0.105914734, -0.07703021, -0.07204621, -0.0748016, -0.11777416));
	target3 += mul(nc1, float4x4(0.053663094, 0.07884249, -0.17141959, -0.012647486, 0.08073693, -0.076323204, -0.17775054, 0.10244291, 0.14563464, 0.14345805, -0.18157926, 0.18835878, -0.026068632, 0.023138894, -0.0019046182, -0.00012485609));
	target3 += mul(nd1, float4x4(0.1348711, -0.04699952, 0.15993118, -0.23344111, 0.026501887, -0.14297141, -0.113242336, 0.080124736, -0.03513346, 0.10361922, -0.0922229, 0.07750678, 0.12542203, 0.12729637, -0.092106655, 0.055520497));
	target3 += mul(ne1, float4x4(0.083170444, -0.06302187, 0.0084091, -0.04599831, -0.035450544, -0.19657601, -0.07282212, 0.1447326, 0.11383889, -0.21189907, -0.045117173, -0.07391879, -0.11269967, -0.08903234, -0.032466423, 0.22887331));
	target3 += mul(nf1, float4x4(0.067729145, 0.06700018, -0.18447827, 0.03988203, 0.05277088, 0.033052627, -0.11088279, -0.02169712, 0.019287307, 0.06812, 0.04875055, 0.111010365, -0.14138764, 0.027063884, -0.05214136, 0.16399074));
	target3 += mul(ng1, float4x4(0.004932597, 0.1045028, -0.16486417, 0.010725656, 0.06950409, -0.121699296, 0.010512686, 0.14147647, 0.019202268, 0.17767008, 0.011134318, 0.063502066, -0.13067701, 0.108099535, -0.114125356, -0.046774942));
	target3 += mul(nh1, float4x4(0.15779556, 0.07332346, 0.063827224, 0.008358174, 0.0496721, -0.030757044, -0.050408855, 0.12898293, 0.023491597, 0.045543656, -0.07800668, 0.037886333, 0.17256846, 0.07125766, 0.029893918, -0.02450649));
	target3 += mul(ni1, float4x4(-0.18544081, -0.033090588, -0.05919492, -0.0003458201, 0.14915435, -0.037259944, 0.011946766, -0.16243212, 0.0882922, 0.093222775, -0.11737426, -0.003943405, 0.019537527, 0.0077801496, 0.1317979, -0.09169945));
	target3 += mul(na2, float4x4(-0.091774754, 0.012059926, 0.03165443, 0.14858909, 0.3944464, -0.014972357, -0.12189733, 0.26198938, -0.27252647, -0.026880303, -0.06978548, -0.013632001, -0.0032966428, -0.18498091, -0.0004948639, -0.12478541));
	target3 += mul(nb2, float4x4(-0.02833149, -0.050442036, -0.041132275, -0.07840716, 0.04005613, 0.17621154, -0.13607822, 0.1762098, 0.05282825, 0.0016353457, 0.006173704, -0.067321114, 0.13982886, -0.03623519, -0.087992206, -0.047710747));
	target3 += mul(nc2, float4x4(0.03881576, -0.08746933, -0.011487434, 0.12498892, -0.0017975342, 0.018888952, -0.18913451, 0.08337154, -0.090970725, 0.117090665, 0.1504768, -0.070024244, -0.019629575, -0.091753945, -0.0092930645, -0.15750532));
	target3 += mul(nd2, float4x4(0.017022166, -0.12516023, -0.12154394, 0.11974826, -0.09612418, -0.115943454, 0.24888757, 0.06153447, 0.056513205, -0.11116729, 0.029329464, 0.08975961, 0.10630068, -0.1328722, -0.06946471, -0.13333926));
	target3 += mul(ne2, float4x4(-0.034902636, 0.2483038, 0.14978237, -0.07164234, -0.012161076, 0.023050508, 0.06598259, -0.043513447, 0.10375706, -0.20177342, -0.123048, -0.035172284, -0.07363312, 0.18172532, 0.09612206, 0.19234397));
	target3 += mul(nf2, float4x4(0.029563665, -0.029694784, -0.101416424, -0.030606827, -0.070010245, 0.045257732, 0.05966623, 0.09107148, 0.03758803, 0.026623867, -0.071266346, 0.094123766, -0.059981044, 0.09513772, -0.08400028, 0.02511076));
	target3 += mul(ng2, float4x4(-0.037089724, -0.06322222, 0.1061242, 0.008586227, 0.13214453, 0.035300348, -0.15787113, 0.07151468, -0.12539263, -0.09025181, 0.18832791, -0.033440433, -0.06625288, -0.1530654, -0.005935112, -0.18216603));
	target3 += mul(nh2, float4x4(0.027623197, -0.04890818, -0.061262466, 0.015195151, 0.32218042, 0.19153431, -0.08007639, -0.11445247, 0.00393679, -0.06705804, -0.12879996, -0.1423812, -0.06090306, 0.0036856222, 0.0069346135, 0.043838803));
	target3 += mul(ni2, float4x4(-0.016647626, -0.08680245, -0.060714565, -0.06387184, 0.18913822, 0.10105815, -0.026422933, -0.039242256, -0.06503463, -0.03521194, 0.049169898, -0.06533137, -0.03167689, 0.015587601, -0.08370448, -0.021492135));
	target3 += mul(na3, float4x4(-0.12721944, 0.028729077, 0.10713755, -0.09260985, -0.047840588, 0.022301238, 0.11309327, -0.06745379, -0.004154309, 0.10523564, -0.04239449, -0.017029425, 0.10899646, 0.1546228, -0.07669311, 0.2672058));
	target3 += mul(nb3, float4x4(-0.056850802, -0.05440277, 0.0018135635, 0.09396988, 0.14010292, 0.08741186, -0.12758048, -0.08599669, -0.018672993, 0.05172455, 0.008185248, 0.111759275, -0.06955318, 0.14772479, 0.008665618, 0.0352044));
	target3 += mul(nc3, float4x4(-0.059702516, 0.058782764, -0.12532151, -0.096861176, 0.35831934, 0.0013884759, 0.30706376, -0.101967454, 0.095553055, 0.05883552, 0.06424327, 0.054175656, -0.1484007, 0.13297899, -0.01961164, 0.15321216));
	target3 += mul(nd3, float4x4(0.09578697, -0.20968121, 0.04902802, -0.030943176, -0.009951699, -0.05341875, -0.063387014, -0.0825744, -0.09769999, -0.075733155, 0.14749058, 0.12551898, 0.24074706, 0.16208081, -0.21561289, -0.062474046));
	target3 += mul(ne3, float4x4(0.0017662761, -0.088773146, 0.0043133483, 0.32119426, -0.13667256, 0.043542203, -0.045929775, -0.09663573, -0.136664, -0.19760157, -0.07579348, -0.04397654, 0.15027492, 0.08591492, -0.03781643, -0.1743205));
	target3 += mul(nf3, float4x4(-0.12654322, 0.028860493, 0.12822515, 0.049503203, 0.30117163, -0.03055389, -0.0582901, 0.0019550966, -0.0038878717, 0.0043905065, -0.12589069, -0.22796634, -0.10635117, 0.16903181, 0.16951965, 0.027410017));
	target3 += mul(ng3, float4x4(-0.059951358, -0.20652413, 0.056598257, -0.1811566, 0.2165428, -0.14381465, 0.20429386, 0.025329571, -0.19378977, -0.055971343, -0.0010970832, 0.08035063, 0.077368416, 0.078627735, 0.07322149, -0.14884202));
	target3 += mul(nh3, float4x4(0.041847393, -0.12735637, 0.014505967, 0.10192219, -0.13889207, -0.015992412, -0.17310154, 0.12131598, -0.13452062, -0.00036142246, -0.14270298, 0.14636193, 0.059705302, 0.051249746, 0.015804589, -0.11418885));
	target3 += mul(ni3, float4x4(-0.043562837, -8.029936e-05, -0.007859607, -0.08610097, -0.021267893, -0.011354754, -0.17890069, -0.0485164, -0.1679154, 0.11548207, -0.060171373, -0.24584498, 0.008396757, 0.1078782, 0.12012115, 0.07315681));
	target3 += float4(-0.067701444, -0.05630008, 0.022760866, -0.034229018);

	float3 target4 = mul(e1, float4x3(0.068483055, 0.036389243, 0.04961808, 0.05059915, 0.033048775, 0.029426659, 0.07465462, -0.012659731, -0.024048671, 0.02224484, 0.012289658, 0.008910066));
	target4 += mul(e2, float4x3(-0.10449372, 0.019832065, 0.035194747, 0.039656557, -0.028246421, -0.032626413, 0.10093569, 0.021039873, -0.0120673925, -0.047074273, -0.041248, -0.019464392));
	target4 += mul(e3, float4x3(-0.05256942, 0.0127243735, 0.012813261, -0.03551604, 0.040801138, 0.04893271, -0.0016839011, -0.018044796, -0.027161835, -0.060873054, 0.012360936, 0.020700796));
	target4 += mul(ne1, float4x3(-0.116182, -0.04271438, -0.046686683, -0.09575506, -0.030078743, -0.024359861, -0.04794246, 0.0044337297, 0.013972317, -0.023228236, 0.015726948, 0.0070847897));
	target4 += mul(ne2, float4x3(0.13986528, -0.016787121, -0.015848925, -0.04900687, -0.027417973, -0.027077334, -0.047319725, -0.021533312, -0.018427303, -0.06136185, -0.0051562944, -0.032072));
	target4 += mul(ne3, float4x3(0.070715815, 0.012814227, -0.0003389576, 0.012182037, -0.014952754, -0.019349998, -0.03254603, 0.012881403, 0.016392775, 0.059158217, 0.0055793705, -0.003696545));

	tex1[gxy] = target1;
	tex2[gxy] = target2;
	tex3[gxy] = target3;
	tex7[gxy] = float4(target4, 1);
}

//!PASS 6
//!DESC Conv-4x3x3x24
//!IN tex1, tex2, tex3, tex7
//!OUT tex4, tex5, tex6, tex8
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass6(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	float4 a1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d1 = tex1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e1 = tex1.SampleLevel(sam, pos, 0);
	float4 f1 = tex1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na1 = max(-a1, 0);
	float4 nb1 = max(-b1, 0);
	float4 nc1 = max(-c1, 0);
	float4 nd1 = max(-d1, 0);
	float4 ne1 = max(-e1, 0);
	float4 nf1 = max(-f1, 0);
	float4 ng1 = max(-g1, 0);
	float4 nh1 = max(-h1, 0);
	float4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	float4 a2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d2 = tex2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e2 = tex2.SampleLevel(sam, pos, 0);
	float4 f2 = tex2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na2 = max(-a2, 0);
	float4 nb2 = max(-b2, 0);
	float4 nc2 = max(-c2, 0);
	float4 nd2 = max(-d2, 0);
	float4 ne2 = max(-e2, 0);
	float4 nf2 = max(-f2, 0);
	float4 ng2 = max(-g2, 0);
	float4 nh2 = max(-h2, 0);
	float4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    float4 a3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d3 = tex3.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e3 = tex3.SampleLevel(sam, pos, 0);
	float4 f3 = tex3.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na3 = max(-a3, 0);
	float4 nb3 = max(-b3, 0);
	float4 nc3 = max(-c3, 0);
	float4 nd3 = max(-d3, 0);
	float4 ne3 = max(-e3, 0);
	float4 nf3 = max(-f3, 0);
	float4 ng3 = max(-g3, 0);
	float4 nh3 = max(-h3, 0);
	float4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	float4 target1 = mul(a1, float4x4(0.092447594, -0.10328636, -0.12202365, 0.27040935, 0.052717082, 0.018614411, -0.08485268, -0.07617377, -0.008931799, 0.051284462, 0.051496644, 0.026522819, 0.09565774, 0.18421015, 0.26325333, -0.12989432));
	target1 += mul(b1, float4x4(0.03988519, 0.042028125, -0.07100362, 0.03045228, 0.068984345, 0.03516445, 0.05874817, -0.028063854, 0.5054902, -0.16185366, 0.12543231, 0.07206758, 0.31235528, 0.03843813, 0.1501265, -0.08274924));
	target1 += mul(c1, float4x4(-0.11169874, -0.06681513, -0.00651678, 0.0010351768, 0.051753096, 0.053674143, 0.11657592, 0.12309117, -0.040198836, -0.007768111, 0.10881242, -0.14587292, 0.17091802, -0.087406136, -0.057882708, 0.0078790905));
	target1 += mul(d1, float4x4(0.26830226, -0.01915989, -0.18262567, 0.2194732, 0.13879527, -0.031352315, 0.15241407, 0.0994905, -0.057112038, 0.17008875, 0.037308767, 0.09374541, -0.3188967, 0.01450157, -0.18610804, -0.0793318));
	target1 += mul(e1, float4x4(0.0060915435, 0.06979378, -0.046237, -0.27248916, 0.09547359, -0.07666023, 0.09364251, 0.026975514, 0.16541278, 0.042641494, -0.02498914, 0.15121445, -0.0013431904, -0.06427887, 0.18217684, 0.26087397));
	target1 += mul(f1, float4x4(-0.20825194, -0.11043138, 0.02976852, -0.105722494, 0.0008496603, -0.065933526, 0.06687892, 0.025230588, 0.18294227, -0.03581215, 0.14366323, 0.101520695, 0.25154486, 0.055622917, -0.012970234, 0.054395743));
	target1 += mul(g1, float4x4(0.21373472, -0.030288193, 0.06773853, 0.07427125, -0.0103815105, 0.016129585, 0.038576525, 0.037529152, -0.20739938, -0.05778662, -0.05940614, 0.02449663, 0.23593283, -0.05812938, -0.039888572, -0.057957932));
	target1 += mul(h1, float4x4(0.387659, 0.1274861, 0.28752464, -0.05272344, -0.014581121, 0.0040657013, -0.06632645, -0.107276425, 0.03762339, 0.2742528, 0.028725976, -0.054044764, -0.04273324, -0.06317463, 0.0060703703, 0.053600952));
	target1 += mul(i1, float4x4(-0.1596047, -0.1561146, 0.109226674, -0.0052362215, 0.16038993, 0.10755746, -0.030864978, -0.36270598, 0.17078364, 0.09184639, 0.23489448, 0.026559642, 0.04388386, -0.061411064, 0.028113337, -0.045337155));
	target1 += mul(a2, float4x4(-0.111932576, 0.0021055648, -0.12106931, 0.019196665, 0.033925258, -0.13593148, -0.068236336, 0.107576296, 0.0415075, -0.2336552, -0.052428674, 0.07777366, 0.00816918, 0.2065682, -0.08628869, 0.15342048));
	target1 += mul(b2, float4x4(-0.021824878, -0.04840494, -0.116642684, 0.045604706, 0.008168658, -0.04534853, 0.11214711, -0.10829524, -0.043486122, -0.24905528, -0.07315474, 0.14727196, -0.07264179, 0.065202385, -0.0019039236, -0.08028288));
	target1 += mul(c2, float4x4(0.08439612, 0.008386524, -0.030988367, 0.09697018, -0.049302116, 0.20326442, -0.018234255, -0.20189443, 0.042629667, -0.1409463, -0.050773926, -0.29503027, -0.07123911, -0.046633366, 0.07981456, 0.10374346));
	target1 += mul(d2, float4x4(0.03868367, -0.05526043, -0.106714435, -0.14639367, 0.038107764, 0.069904044, 0.0744559, 0.13862458, 0.09222159, -0.14277418, -0.19073294, -0.03296828, -0.10584655, 0.13311721, -0.24290293, -0.008493607));
	target1 += mul(e2, float4x4(-0.15074006, 0.094411716, -0.058070287, -0.10475867, 0.127535, 0.047796316, 0.033599593, 0.055493813, 0.17686792, -0.23935609, -0.27880296, -0.12433512, 0.049884334, 0.0651521, 0.009873332, -0.039633323));
	target1 += mul(f2, float4x4(0.025122408, 0.16321969, -0.06588295, 0.09563756, -0.115063086, -0.061710395, 0.073383145, 0.09976373, 0.09290709, -0.042226892, -0.22798967, -0.14234817, -0.089538574, 0.022935519, 0.09885692, -0.050982323));
	target1 += mul(g2, float4x4(0.09486296, 0.04397677, 0.04075486, 0.056717344, -0.04711896, 0.04990853, -0.16473778, 0.13175704, 0.12485286, -0.18850122, -0.13122937, -0.102840684, -0.16874318, 0.05348968, -0.017259317, 0.07717163));
	target1 += mul(h2, float4x4(-0.059502125, -0.13897286, -0.03801125, 0.17431264, 0.11680923, -0.12560965, -0.0911302, -0.19165933, -0.121053115, 0.06541917, -0.06419728, -0.19364956, -0.13833821, 0.03234477, -0.09979964, 0.17789067));
	target1 += mul(i2, float4x4(0.067596145, 0.25704458, 0.19766523, 0.108859204, 0.09887382, 0.052284334, -0.07278858, 0.122003525, -0.030752266, -0.04871386, -0.05135825, -0.3072661, -0.033045944, -0.098459914, 0.10718348, -0.13164413));
	target1 += mul(a3, float4x4(0.020737967, 0.24545951, -0.044812705, 0.03566297, 0.095929176, -0.07487561, 0.20496303, 0.037086472, 0.038242895, 0.088189796, 0.021153267, -0.09462902, 0.026548525, -0.21922965, 0.050257247, -0.048741706));
	target1 += mul(b3, float4x4(0.040332116, 0.043284092, 0.24138524, -0.02451653, -0.13059705, 0.0343388, -0.07902276, -0.009631078, -0.0848101, 0.010842163, 0.086510465, -0.012446626, 0.005316944, -0.22108673, 0.14004333, 0.15579557));
	target1 += mul(c3, float4x4(0.022010755, 0.004139463, -0.017926715, 0.04037725, 0.016520657, 0.009780203, -0.14736284, -0.014491211, 0.057596914, -0.23008622, 0.21133287, -0.053522564, -0.18740861, -0.106346205, 0.10276541, 0.043288257));
	target1 += mul(d3, float4x4(0.10575789, 0.019061945, -0.026198203, 0.20347466, 0.07900247, 0.102640145, 0.08666188, -0.05840282, 0.058876745, 0.14216799, -0.11816214, 0.14975895, 0.09833406, -0.1061385, 0.08465644, 0.09426659));
	target1 += mul(e3, float4x4(-0.13777718, -0.28986838, 0.07906812, 0.059411187, 0.09088133, 0.23517007, -0.20900714, 0.011920497, 0.14009877, 0.19299953, -0.028272772, 0.06418091, 0.118590616, -0.111001015, -0.055573206, 0.085596696));
	target1 += mul(f3, float4x4(-0.124967046, -0.23403575, -0.085109934, 0.094934925, 0.15895598, 0.08125505, -0.2215677, 0.10778676, -0.12129276, -0.0019275933, 0.14121452, -0.07975474, -0.057002395, -0.052832086, -0.1850646, -0.100982465));
	target1 += mul(g3, float4x4(0.0710814, 0.20992099, 0.07493418, -0.109678715, -0.18531376, -0.039698873, -0.110102035, 0.16468482, 0.08024999, -0.09387882, -0.13551506, 0.11087316, -0.10608426, -0.13655968, 0.01102362, -0.060193118));
	target1 += mul(h3, float4x4(-0.015583674, -0.06961451, 0.14489253, -0.27566335, -0.17987481, -0.027696218, -0.23948374, 0.028104413, 0.27821308, 0.08043316, -0.05241405, -0.0027138551, -0.13761862, 0.0038414828, 0.010716796, -0.21286957));
	target1 += mul(i3, float4x4(-0.22588563, 0.040290482, -0.13179918, -0.15576197, 0.058554877, 0.10720413, 0.11312613, -0.004625868, 0.03558514, -0.023398632, -0.2564193, -0.045098998, -0.0012908503, 0.01255389, -0.018089779, -0.1334803));
	target1 += mul(na1, float4x4(-0.040578995, 0.14333616, 0.023703935, -0.24532415, -0.017356034, 0.05467018, -0.13556047, -0.051645495, 0.08613384, -0.18583167, 0.023360416, -0.12590869, -0.06778763, -0.06438733, 0.025624113, 0.07671888));
	target1 += mul(nb1, float4x4(0.042797543, 0.076091446, 0.082091615, 0.014681128, -0.09378036, 0.062476482, 0.026251588, 0.16627216, -0.15255791, 0.17601879, 0.042653207, 0.039376315, 0.029179158, -0.0095602125, 0.0705857, 0.011434591));
	target1 += mul(nc1, float4x4(0.012922825, 0.13863216, -0.09220861, -0.005267679, 0.12863027, 0.08068719, -0.07179554, -0.13297969, 0.04991335, -0.01473723, -0.028486373, 0.26253343, -0.052293234, -0.16709994, 0.013800583, 0.060783714));
	target1 += mul(nd1, float4x4(-0.17575453, -0.036046885, 0.17919157, -0.18988807, -0.18178074, -0.058441214, -0.07271548, -0.008791415, 0.18230358, 0.07766667, -0.066274896, -0.15386371, 0.06161233, 0.003612807, 0.20308098, -0.020216005));
	target1 += mul(ne1, float4x4(-0.05010378, 0.018410517, -0.050254025, 0.012066753, -0.12485184, -0.1916662, -0.1278125, 0.06593962, 0.11824467, 0.07994578, 0.05962518, -0.20991555, -0.114382625, 0.07509197, -0.19671203, -0.4580128));
	target1 += mul(nf1, float4x4(0.17728399, -0.15649322, -0.15205286, 0.22968316, 0.037434835, 0.021075314, -0.090972036, -0.17058647, 0.19727467, -0.013115808, -0.08461909, 0.010409278, 0.04355671, 0.08082593, 0.013779581, -0.08425518));
	target1 += mul(ng1, float4x4(-0.31590196, 0.107831545, -0.12198127, 0.00977694, -0.16240558, -0.038805872, 0.037051022, 0.10276969, 0.26788524, -0.072160736, 0.03843579, -0.08990598, -0.04897058, -0.019324914, 0.06016647, -0.015361721));
	target1 += mul(nh1, float4x4(-0.16626236, -0.07336449, -0.11358449, 0.08885961, -0.044137727, 0.057762783, 0.08864482, 0.029383648, -0.08608859, -0.17586444, 0.094455965, -0.054391533, -0.18796252, 0.009314891, -0.014734876, -0.02058656));
	target1 += mul(ni1, float4x4(0.12067889, 0.3618014, -0.17719771, 0.2175122, 0.12890387, 0.20503749, 0.19662304, 0.17338246, 0.1733569, -0.057952117, -0.016951751, -0.057121612, -0.014850513, -0.05018768, 0.20244005, 0.016323887));
	target1 += mul(na2, float4x4(-0.13357711, 0.12105561, -0.030620668, 0.005170665, 0.044319738, 0.12768681, 0.15325043, 0.027631996, -0.080610365, 0.03741198, -0.017102083, -0.0035679936, -0.2243731, 0.16709204, 0.023224674, 0.11311707));
	target1 += mul(nb2, float4x4(0.02376095, 0.027235378, -0.009955967, -0.049886744, -0.08411108, 0.10339928, -0.02877354, 0.12704167, -0.13884954, 0.089170545, -0.0039057198, -0.16050623, -0.05318099, -0.10950255, -0.11412448, 0.042694647));
	target1 += mul(nc2, float4x4(-0.20557326, -0.16362014, -0.090093814, 0.10406815, 0.08791842, 0.013667629, 0.099605836, -0.1062854, -0.07108554, -0.10362472, -0.0647173, 0.12420133, -0.082551, 0.07107792, -0.17423603, -0.048405636));
	target1 += mul(nd2, float4x4(-0.1954154, -0.027208658, -0.03684051, 0.1338225, -0.084645554, 0.06871324, -0.0778811, 0.025083596, -0.19436808, -0.097009145, -0.036444522, -0.17200048, 0.013402397, -0.23984545, -0.018724974, -0.005078688));
	target1 += mul(ne2, float4x4(0.21297796, 0.023222866, -0.069507584, -0.07308915, -0.18444547, 0.016984317, -0.016325353, 0.11981142, -0.12647548, -0.074321784, 0.27461126, -0.111357704, 0.13917843, -0.035653792, 0.052209657, 0.2077564));
	target1 += mul(nf2, float4x4(-0.13399822, 0.013458072, 0.031183472, 0.24100806, 0.025842719, -0.1878651, 0.14646488, -0.12074156, -0.15135823, -0.18367149, 0.14775206, 0.06404863, 0.06884799, 0.19008774, -0.094522566, 0.087253615));
	target1 += mul(ng2, float4x4(-0.2991564, 0.15301964, -0.028454246, 0.10222737, -0.14888696, -0.021354329, -0.26517984, 0.17276473, 0.021648446, -0.17384106, 0.071495906, -0.16509262, -0.029774027, 0.17916657, -0.036435083, 0.1344122));
	target1 += mul(nh2, float4x4(0.043782394, -0.111460604, -0.094103605, -0.024549566, -0.09227317, 0.009563868, -0.11380084, 0.14710943, 0.1623694, -0.2684087, 0.08932176, -0.025791056, 0.10586864, -0.2849578, -0.049896624, -0.07046415));
	target1 += mul(ni2, float4x4(0.06390326, -0.16954753, -0.24643445, -0.06667138, 0.0153694395, 0.1391578, 0.033687413, -0.18783121, -0.061314933, -0.19441758, -0.033504955, 0.1402065, -0.082206115, 0.16466151, -0.07656087, 0.14898944));
	target1 += mul(na3, float4x4(-0.1266701, 0.036555164, -0.4070397, -0.085509166, 0.045745134, -0.0494443, -0.07149184, -0.05286605, -0.022561546, -0.091546714, -0.12706481, 0.1923914, 0.26536146, -0.07096412, -0.16030753, -0.21569426));
	target1 += mul(nb3, float4x4(-0.097307466, 0.15349665, 0.015644126, -0.22425117, 0.21123715, 0.022773454, 0.23383828, -0.07435915, 0.07146555, -0.02743282, 0.14647867, -0.0041729338, 0.12715502, 0.11781688, -0.061080795, 0.0026166402));
	target1 += mul(nc3, float4x4(-0.010103422, -0.087011784, -0.12507296, -0.009202013, -0.0016642559, 0.12229101, 0.012257156, 0.09069687, 0.17266563, 0.04349975, 0.0065761553, -0.071280204, 0.03610506, 0.18303613, -0.02108923, -0.06867508));
	target1 += mul(nd3, float4x4(-0.13150483, -0.060967755, 0.0055990918, 0.037484363, -0.02158257, -0.024784425, 0.23109616, -0.120935716, 0.20638125, -0.072126925, 0.062352557, -0.004980783, 0.19314887, 0.13248818, -0.23808232, 0.014506469));
	target1 += mul(ne3, float4x4(0.18638828, -0.065645434, -0.20713033, 0.09149545, -0.24210495, -0.06484725, 0.08750317, 0.1802478, 0.3541541, -0.06987437, -0.1159385, -0.028150197, -0.23300691, -0.09201996, -0.121867135, -0.13276023));
	target1 += mul(nf3, float4x4(0.09099928, -0.039182268, -0.1400286, 0.010247891, -0.010239972, -0.18701951, -0.1772805, 0.01631285, -0.09500139, 0.2590885, -0.09521566, 0.05752499, -0.1184693, 0.04186501, 0.27024126, 0.08569921));
	target1 += mul(ng3, float4x4(-0.0729032, 0.10695013, -0.18894811, 0.06616699, 0.05852647, 0.03802247, 0.024427114, 0.022371208, 0.28009695, -0.022878911, 0.04645292, 0.060003202, 0.1053563, 0.027735699, 0.007826481, 0.14397411));
	target1 += mul(nh3, float4x4(-0.15458257, 0.12910113, -0.11843165, 0.14065553, -0.19225205, 0.059665926, 0.2690873, -0.1308205, 0.071195096, 0.07672256, 0.1497483, 0.21867657, 0.15143347, -0.16467342, -0.13924904, 0.098136105));
	target1 += mul(ni3, float4x4(0.05049889, 0.069295354, 0.017172134, 0.048614368, -0.19597568, -0.029311683, -0.190372, -0.025514813, -0.24531111, -0.041956335, 0.24628574, 0.15919869, 0.051921643, 0.09549575, 0.025514983, 0.13909552));
	target1 += float4(-0.012342477, -0.20862316, 0.08788906, -0.0010707981);
	
	float4 target2 = mul(a1, float4x4(-0.08156944, 0.10573189, 0.012908232, 0.1657589, -0.038043138, -0.2873211, -0.2046161, -0.09311608, 0.3097668, -0.08111585, -0.17932127, -0.02586952, 0.18931806, -0.13793743, -0.13352883, 0.06681123));
	target2 += mul(b1, float4x4(0.02374499, 0.14342955, 0.2563405, -0.029666856, 0.17285998, -0.1035698, -0.11706357, 0.11584379, 0.21326663, 0.06683621, -0.11183301, 0.092254475, -0.1014067, 0.03412136, -0.040375732, 0.13439587));
	target2 += mul(c1, float4x4(-0.114404246, 0.05252966, 0.00047894646, -0.028747892, 0.0105511965, 0.078781754, 0.029926287, 0.14559107, -0.12780708, -0.08478812, -0.2247857, -0.19385272, -0.13657221, 0.18088628, 0.15612762, 0.037660476));
	target2 += mul(d1, float4x4(0.05799563, 0.059148345, -0.09769129, 0.07772796, -0.09202486, -0.06425981, -0.016873274, 0.0030002298, 0.11275395, -0.08546416, -0.2876964, 0.023335997, -0.010972625, -0.032576468, -0.086281575, -0.070443906));
	target2 += mul(e1, float4x4(0.32762548, -0.06770343, 0.03179402, -0.04613723, -0.06790421, 0.44522998, 0.119118124, -0.11980204, 0.038128957, 0.17468919, 0.076030836, 0.14512211, 0.17252928, -0.047734894, -0.06045679, -0.08920573));
	target2 += mul(f1, float4x4(-0.015262433, 0.15428601, 0.06972416, -0.16334222, -0.08347724, 0.18573803, -0.11517264, -0.0009774134, -0.16686407, -0.10733252, -0.12523252, 0.050293542, 0.11212284, -0.009658616, -0.058349714, -0.014115335));
	target2 += mul(g1, float4x4(-0.056932453, 0.18084419, 0.02166639, 0.13523088, 0.011073456, -0.045516286, 0.003297358, -0.057280444, -0.018760536, -0.15718092, -0.11770054, -0.03166016, -0.19774522, 0.0755463, -0.20558798, 0.15830164));
	target2 += mul(h1, float4x4(0.19655597, 0.03901344, -0.051660974, 0.19494548, 0.034315336, -0.04597924, -0.056954715, -0.19345726, -0.11985197, 0.006047848, 0.12791121, -0.019705713, -0.01501477, 0.117168285, 0.025459006, 0.13246241));
	target2 += mul(i1, float4x4(-0.0023640324, 0.0349994, 0.009396353, 0.0936661, 0.100842424, -0.114130996, 0.038058087, 0.12808813, -0.054103322, 0.027919596, -0.10685234, -0.07498883, -0.06130471, -0.12066764, 0.0029782685, 0.059720848));
	target2 += mul(a2, float4x4(-0.098447025, -0.011071975, 0.16054775, -0.08671137, -0.13293275, 0.05532158, 0.14407343, 0.19340874, -0.20346253, 0.11525113, 0.1687311, 0.098785535, 0.03027443, -0.054430522, 0.022521, 0.19343728));
	target2 += mul(b2, float4x4(-0.084854074, 0.06853468, 0.06792569, 0.029366238, 0.06035099, -0.05761756, -0.033579275, -0.062136766, 0.1649456, 0.049637973, 0.2630636, -0.02261985, -0.18047638, -0.071598716, 0.14448155, -0.055889398));
	target2 += mul(c2, float4x4(-0.024849698, 0.088840574, 0.1503109, -0.004984663, -0.16879597, -0.26041916, -0.3362258, 0.20055196, -0.13901941, 0.042401403, 0.18325137, 0.1716765, -0.016100548, 0.11664664, -0.07838003, -0.16286951));
	target2 += mul(d2, float4x4(-0.16242248, 0.22381666, -0.017743299, 0.07717547, 0.048560552, -0.20423977, 0.30301192, 0.00976561, -0.2708939, -0.092156336, 0.038034424, 0.06372939, 0.06721783, -0.023243327, 0.119849995, 0.15898646));
	target2 += mul(e2, float4x4(0.10859177, -0.05935216, -0.015591001, -0.053253412, 0.071014024, 0.43206415, 0.04865775, 0.069328085, -0.09695977, 0.19359045, 0.016935471, 0.0028954153, -0.08338698, 0.041919734, 0.032975465, 0.11067615));
	target2 += mul(f2, float4x4(0.32948914, -0.04703423, -0.075494416, -0.06948022, -0.18574949, 0.15096106, 0.0067734853, -0.16238153, -0.21330655, 0.25306207, 0.08089956, 0.08108933, 0.056989696, 0.05212022, 0.15835905, 0.00077813526));
	target2 += mul(g2, float4x4(-0.011273352, 0.26307768, -0.04307922, 0.21710183, -0.3902529, -0.46155867, 0.015115735, -0.05384065, -0.07163729, 0.0793938, -0.0985122, 0.06594441, 0.09647775, 0.05617775, 0.07099344, -0.16353689));
	target2 += mul(h2, float4x4(-0.040731885, 0.14055543, -0.07012667, 0.07207971, -0.004641172, -0.06394655, 0.091212526, -0.00019208786, -0.07705868, 0.040352806, -0.07397878, 0.051934645, -0.010726301, 0.23407605, 0.12093579, -0.0406116));
	target2 += mul(i2, float4x4(0.041406166, -0.22172481, 0.22162893, 0.02442143, 0.10592917, 0.1968317, -0.14774016, 0.011944242, -0.12373062, 0.114184484, -0.090167396, 0.022542128, -0.1554341, 0.1371109, 0.13077694, -0.020479746));
	target2 += mul(a3, float4x4(0.123823315, -0.3012641, -0.2841784, 0.014021941, 0.10990905, 0.2764256, -0.075963184, -0.10125788, -0.007879674, -0.08643855, -0.038958456, 0.07453782, -0.48677143, -0.03276048, -0.03156215, -0.09289601));
	target2 += mul(b3, float4x4(-0.10992206, -0.05435893, 0.11743695, 0.17674956, 0.13509355, -0.17421335, -0.100946076, -0.10648024, 0.14750971, 0.21357685, -0.107157655, -0.017665314, 0.2106041, 0.124202386, 0.24976057, -0.09088304));
	target2 += mul(c3, float4x4(-0.26258346, -0.03037757, 0.13096122, 0.13691814, 0.11316644, -0.14852227, 0.008399919, 0.04381969, 0.030872608, 0.45056874, -0.04014858, -0.012530115, 0.21238118, -0.1332986, -0.101533614, 0.077671215));
	target2 += mul(d3, float4x4(0.101686284, -0.21485107, -0.109051324, 0.047709018, 0.018496532, 0.030967599, -0.07855083, 0.05204436, 0.0077558183, 0.080045685, -0.09668984, 0.17999001, -0.15804431, -0.042034358, -0.21375516, 0.001163862));
	target2 += mul(e3, float4x4(-0.14624378, 0.42138338, 0.028315686, -0.20134708, -0.010074609, -0.046433613, -0.050019633, 0.08432513, -0.079346046, -0.27917975, -0.19784799, 0.25092122, 0.21972348, -0.0084989555, 0.11432945, -0.0727637));
	target2 += mul(f3, float4x4(-0.22297074, 0.20484488, 0.17720158, 0.0022023271, -0.034587737, 0.0004995375, -0.027270092, -0.08549106, -0.07970776, 0.14142907, -0.039514165, 0.08021129, 0.262039, 0.08684183, 0.08106768, -0.088322006));
	target2 += mul(g3, float4x4(0.19230787, -0.019139988, 0.100881554, 0.0622476, -0.0073597133, -0.007861123, -0.09819001, -0.035048965, 0.1649283, 0.096261285, -0.0899776, -0.03930426, -0.044506907, 0.20075877, -0.049743377, -0.0076403967));
	target2 += mul(h3, float4x4(0.0043743993, 0.20346396, 0.1655524, -0.025431981, -0.02454905, -0.04476991, 0.020741275, -0.12993908, 0.026805034, -0.0037405565, -0.17931041, 0.09257133, 0.13752705, 0.07889819, -0.037251562, -0.002646608));
	target2 += mul(i3, float4x4(0.038870014, -0.37619725, 0.046597917, -0.15463144, 0.054383356, -0.2925491, 0.0640225, -0.00486844, -0.0016340262, 0.10840749, 0.0993287, 0.17394166, 0.08594391, -0.030945132, 0.025646068, -0.06640845));
	target2 += mul(na1, float4x4(-0.01649855, -0.068216905, -0.027988954, -0.12154563, 0.022097806, -0.1290429, 0.10954417, 0.13157494, -0.1745968, -0.04658394, -0.053029858, -0.0759596, -0.04430781, -0.041724976, -0.056713972, -0.14473973));
	target2 += mul(nb1, float4x4(0.06543556, 0.092009485, -0.08451462, 0.052707452, -0.06780165, -0.088456, -0.025358824, -0.12258837, -0.10129489, -0.059306916, -0.14748581, 0.014620428, -0.038939722, -0.10054172, 0.09494565, -0.07793254));
	target2 += mul(nc1, float4x4(-0.05932573, 0.013406356, 0.26368266, 0.18454649, -0.03142332, -0.01590683, -0.06236948, 0.11061398, 0.025253339, -0.030919848, 0.064894855, 0.13248478, -0.030221257, -0.0986045, -0.034824356, -0.16913392));
	target2 += mul(nd1, float4x4(0.0015110603, 0.2025821, 0.004228453, 0.08477586, -0.03797453, -0.04194356, 0.18174535, -0.06626136, -0.13344109, -0.22612168, 0.02602776, 0.016666876, -0.027019914, 0.119900815, -0.06250115, -0.070262626));
	target2 += mul(ne1, float4x4(-0.14976665, 0.03257234, -0.14965177, 0.073865525, 0.062913194, 0.05034122, 0.03676157, -0.018906, 0.04145618, -0.111236595, -0.20951095, -0.060131762, -0.16541055, -0.08913449, 0.044624332, -0.08443667));
	target2 += mul(nf1, float4x4(-0.21176168, -0.015680272, 0.25104785, 0.28819278, 0.068234585, -0.067152865, 0.18975581, -0.024222756, 0.09343949, 0.107427366, -0.08206377, -0.07970111, -0.10268362, -0.02063304, 0.007915588, -0.1344096));
	target2 += mul(ng1, float4x4(0.061288554, -0.017783957, 0.1759008, -0.096834674, -0.17838398, 0.22331426, -0.027759569, -0.0883247, -0.05435304, -0.099557355, 0.026310958, 0.18467775, 0.07900235, -0.017400427, 0.1453773, 0.033763483));
	target2 += mul(nh1, float4x4(-0.06601715, 0.19832757, 0.10341119, 0.015197309, -0.13140027, 0.06353335, -0.033154953, 0.14772332, 0.053612914, -0.018467115, -0.1992033, 0.17353232, 0.16321027, -0.09609656, -0.12580357, -0.052030507));
	target2 += mul(ni1, float4x4(-0.09335505, 0.099851064, 0.12890811, 0.13102262, -0.07580953, -0.11255671, -0.18570407, -0.14529274, -0.05160979, 0.06461672, -0.038672008, -0.00841868, 0.0029629876, -0.13739161, -0.29193023, -0.081763566));
	target2 += mul(na2, float4x4(0.23590541, 0.009043033, 0.06940084, 0.13891594, -0.010488754, 0.029098868, 0.07929391, -0.07250032, -0.13742201, -0.18533885, 0.2531767, -0.009061109, -0.027644258, 0.10404188, 0.012537389, 0.10293872));
	target2 += mul(nb2, float4x4(0.19354686, 0.15574348, 0.31874457, 0.024332082, 0.06383042, 0.048204664, -0.073850416, 0.032850295, -0.34514645, -0.054682292, -0.054835007, 0.012525943, -0.031569667, -0.093528986, 0.077636436, 0.080878824));
	target2 += mul(nc2, float4x4(-0.061584793, 0.003138571, 0.25193092, 0.09340434, 0.17664844, 0.010498078, 0.18399622, -0.23279727, -0.12833218, 0.15312086, -0.10134878, -0.0025951387, 0.07395745, -0.059028395, 0.1285172, 0.13659331));
	target2 += mul(nd2, float4x4(0.1286127, -0.08862414, 0.123132095, -0.11186987, 0.04064812, 0.1295343, -0.08698302, -0.054833192, -0.06911518, 0.1468998, 0.14806904, 0.0002644252, -0.102448784, 0.0064156754, 0.111383334, -0.07292957));
	target2 += mul(ne2, float4x4(0.05504673, -0.076037504, 0.11776747, -0.07890708, 0.077408485, -0.117229365, 0.0197986, -0.12881358, -0.121706314, 0.008088911, -0.025189465, -0.06471935, 0.111992925, -0.08574453, -0.18029808, 0.057162132));
	target2 += mul(nf2, float4x4(-0.09641628, -0.08636256, 0.07254762, -0.1108583, 0.06322016, 0.04606108, 0.015605975, -0.023462018, 0.077079624, 0.12611854, -0.026314614, -0.021778936, -0.080265954, -0.028592844, 0.1361638, 0.16848429));
	target2 += mul(ng2, float4x4(0.14155127, 0.013242842, 0.04764719, -0.12724996, -0.05762018, 4.4798093e-05, 0.31255975, -0.52083194, -0.18550456, 0.109841965, 0.1860627, 0.11478285, -0.36154944, -0.12439295, 0.3006208, 0.032344274));
	target2 += mul(nh2, float4x4(-0.11564562, -0.034078646, 0.16126357, -0.1936752, -0.2330871, -0.13876866, 0.088089384, -0.021154383, -0.091547124, 0.091753796, 0.18144718, 0.1774146, 0.007724317, 0.097580045, -0.15106232, -0.04128832));
	target2 += mul(ni2, float4x4(0.071651496, 0.18003649, 0.10129018, -0.16904286, -0.2137536, -0.1308051, 0.13850693, 0.04569891, 0.09158717, 0.1749203, -0.032127034, 0.06019649, 0.12735014, -0.19949023, 0.003664079, -0.050514087));
	target2 += mul(na3, float4x4(-0.009363578, 0.083391, -0.08583937, -0.008416162, -0.024429835, 0.008918877, -0.15991227, -0.035743445, -0.040119864, 0.20200913, -0.09585724, 0.039848186, 0.2914714, -0.13199879, -0.04198891, 0.049873233));
	target2 += mul(nb3, float4x4(0.14203294, -0.12218405, -0.1336784, -0.011557518, -0.10419894, -0.047520764, 0.012323197, 0.01812075, -0.15906301, 0.057789516, -0.108339556, 0.035662923, 0.008705645, -0.017022535, -0.11589909, 0.030071909));
	target2 += mul(nc3, float4x4(-0.15126535, 0.116061516, 0.26665378, -0.11970062, -0.192801, 0.021354547, -0.253131, 0.12830788, -0.17019245, 0.06896555, -0.0015308838, -0.0076949615, 0.031619042, -0.14708556, -0.11876281, -0.053292263));
	target2 += mul(nd3, float4x4(-0.14085393, 0.15730241, 0.10422539, 0.025466066, 0.10541659, -0.0012975787, 0.041553672, 0.059082996, -0.154172, 0.08198402, 0.09771777, -0.068264395, 0.047784068, -0.11348507, 0.004380174, -0.089181446));
	target2 += mul(ne3, float4x4(0.04478754, -0.18557417, 0.13422509, 0.15747893, -0.009310171, -0.0116828615, -0.0116161555, -0.0065923473, -0.028874157, 0.17116025, -0.15008302, 0.0864679, -0.10439667, 0.09480786, -0.14620537, -0.12444));
	target2 += mul(nf3, float4x4(-0.10271061, 0.037290677, 0.16068509, -0.0020577735, -0.26431653, 0.0316218, 0.13216278, 0.039026607, 0.114048995, -0.08055903, -0.25474527, 0.03769183, 0.11541464, -0.13846509, -0.23404308, 0.059910618));
	target2 += mul(ng3, float4x4(0.03207741, -0.057938, -0.083276935, -0.08009412, 0.11193717, -0.07672049, -0.16157848, -0.11298354, -0.17304356, 0.08984146, -0.050554533, 0.15308471, -0.05547862, -0.15691018, 0.07320868, -0.042120814));
	target2 += mul(nh3, float4x4(0.048134506, -0.10295267, 0.051832333, -0.13681562, 0.103027515, -0.06026332, 0.06881206, -0.015670486, 0.28807607, 0.03059088, 0.034055263, 0.017337816, 0.05512398, 0.075067505, -0.036354467, 0.06471895));
	target2 += mul(ni3, float4x4(-0.085566096, 0.014341178, -0.08384431, -0.051138613, -0.13172193, -0.10944131, 0.052603673, 0.10315314, 0.13149905, -0.10674123, -0.007911778, -0.028487006, 0.13898246, -0.018405652, 0.04242993, -0.10391517));
	target2 += float4(0.06731381, -0.14791869, -0.15826754, -0.069372416);
	
	float4 target3 = mul(a1, float4x4(-0.0017213221, -0.15371315, -0.092273064, -0.10798677, 0.009334791, 0.22254497, -0.097098924, 0.029816378, 4.457267e-05, -0.1057864, 0.4134007, 0.14368671, -0.004629636, 0.17854625, 0.2903048, -0.06277739));
	target3 += mul(b1, float4x4(-0.046712447, 0.119774394, -0.117091574, 0.09618261, -0.10770648, 0.124485455, 0.075216, -0.28377417, -0.24061379, -0.09114137, 0.23112294, 0.12123567, 0.025058655, 0.093606554, 0.10327309, -0.024526346));
	target3 += mul(c1, float4x4(0.019105028, 0.06630737, 0.032209937, 0.09685681, -0.018223759, 0.04791892, -0.008235882, -0.29300943, 0.25300565, -0.2488416, 0.08808891, 0.23057054, 0.07350692, -0.106139764, -0.063049704, -0.059718538));
	target3 += mul(d1, float4x4(0.0455073, -0.051755026, -0.11883914, 0.20130287, -0.131154, 0.017220428, 0.12068244, 0.070289314, -0.12415149, -0.22242554, 0.08771896, 0.0035022376, 0.24336605, 0.08416074, 0.028170893, -0.03845105));
	target3 += mul(e1, float4x4(0.03242001, 0.102102384, -0.17709577, -0.0109795965, 0.08089789, -0.021498924, 0.06255124, -0.042419348, 0.108601704, -0.05202687, -0.12712812, -0.17035247, 0.17001751, -0.045719698, 0.09703396, 0.037530866));
	target3 += mul(f1, float4x4(-0.09127368, 0.18729141, 0.11323561, 0.12806842, -0.058737166, 0.1974935, -0.1213344, 0.26005578, -0.041523788, -0.0029840702, 0.14748086, -0.10480214, -0.06823255, 0.045274846, 0.078861825, 0.088076524));
	target3 += mul(g1, float4x4(-0.10629749, -0.023263903, -0.082174115, -0.121970475, 0.21234329, 0.0262291, 0.1745219, 0.07722097, -0.12979622, -0.046668485, -0.0027060192, -0.07948489, -0.1455228, -0.1722979, -0.11220583, -0.15050055));
	target3 += mul(h1, float4x4(0.04207767, -0.08237373, 0.07580429, -0.02124768, 0.12718296, 0.053528596, -0.09762217, -0.0045613465, -0.04504155, 0.18147692, -0.13206507, 0.118414916, 0.03825585, -0.23475614, -0.06268228, 0.086768724));
	target3 += mul(i1, float4x4(0.034695115, 0.07061876, 0.04965704, 0.17847943, -0.1437011, 0.15886799, -0.201469, -0.063395016, -0.1750345, 0.11911144, -0.188721, 0.08700757, 0.14036323, -0.08573763, 0.10530263, -0.07726266));
	target3 += mul(a2, float4x4(0.21503586, -0.18479058, 0.0074815084, 0.09756983, 0.037916277, -0.17987613, 0.11589862, -0.028243838, -0.20950282, 0.026752079, 0.10840585, 0.15400405, 0.08625402, -0.07633785, 0.0017439253, -0.072862245));
	target3 += mul(b2, float4x4(0.008905137, 0.106612414, -0.07793345, 0.15220572, -0.0028391609, -0.10614796, -0.17509677, 0.09583197, 0.18518968, 0.005445739, 0.12949161, 0.07129458, 0.06554234, -0.1308029, -0.029664468, 0.010993508));
	target3 += mul(c2, float4x4(-0.054151967, -0.21677336, 0.17064962, 0.06138102, -0.06272079, -0.11186543, -0.02262431, 0.27793702, 0.019080682, 0.121934734, -0.08267019, -0.08607981, 0.10281368, -0.015739575, 0.07353178, 0.10465199));
	target3 += mul(d2, float4x4(0.11974522, 0.044251468, -0.15450975, -0.075565055, -0.04790616, -0.031326365, 0.27381012, -0.094721034, -0.11900706, -0.06368458, 0.10776822, 0.18564561, 0.089738145, -0.0016327037, 0.18722743, 0.09222095));
	target3 += mul(e2, float4x4(-0.02468192, -0.16873443, -0.02480979, -0.13937175, -0.13027008, 0.15577625, -0.01477261, 0.07563496, -0.00062903174, 0.071869016, 0.17108877, 0.00066113746, -0.29290298, 0.07078572, -0.054790854, 0.09035019));
	target3 += mul(f2, float4x4(0.066045515, -0.11800159, -0.0750722, -0.08316888, -0.08140103, -0.107804835, 0.1621138, 0.16997898, -0.04444603, 0.28161287, -0.28550264, -0.17914039, -0.15597315, 0.15387748, -0.047001313, -0.042532828));
	target3 += mul(g2, float4x4(0.025888437, 0.13297214, -0.07546064, -0.06647902, 0.017062671, -0.2597112, 0.13725336, 0.10858415, -0.1160102, 0.13422437, 0.1592752, 0.15240288, 0.03929169, 0.2020017, 0.07010354, 0.028547695));
	target3 += mul(h2, float4x4(-0.0703738, 0.13582481, -0.036476467, -0.096972756, -0.12283295, 0.13071987, -0.056827262, -0.023500688, -0.0075902776, 0.06296815, -0.049109932, 0.16880427, 0.29702982, -0.01992682, 0.013997502, -0.070870094));
	target3 += mul(i2, float4x4(0.108744465, -0.09422798, 0.13146311, -0.250233, 0.016463336, -0.12794453, 0.03931633, 0.17450981, 0.11661872, 0.12163951, -0.1192709, -0.05398837, -0.24910302, 0.19006594, -0.1857664, -0.1205357));
	target3 += mul(a3, float4x4(-0.054634392, 0.052315067, 0.05044536, -0.05177968, 0.21537638, -0.014019764, -0.06632539, 0.030889641, -0.18629341, -0.04575244, -0.07509494, 0.09061459, -0.0686147, -0.1872925, -0.08178069, -0.17149752));
	target3 += mul(b3, float4x4(-0.08697341, 0.15311632, 0.06298225, -0.17094718, -0.0854164, 0.037885193, -0.048915166, -0.010449174, 0.030081013, -0.02462675, -0.105993316, -0.100794375, -0.05364704, -0.120219246, 0.16426747, -0.016683623));
	target3 += mul(c3, float4x4(0.1442815, -0.2285766, 0.14395493, -0.01616554, -0.054909255, -0.06734717, 0.044498604, -0.07669548, 0.06888753, 0.2329823, -0.2728349, -0.06917594, 0.049095903, 0.0144689595, -0.08170211, -0.21154584));
	target3 += mul(d3, float4x4(-0.0032911033, -0.30628094, 0.01655303, -0.12639484, -0.043794096, 0.12097294, 0.10301277, 0.0323829, -0.20977376, -0.2598986, -0.032757662, 0.062723145, 0.065447785, -0.10534467, -0.061504886, -0.25371954));
	target3 += mul(e3, float4x4(-0.062172186, -0.12031234, -0.05312447, -0.07274714, -0.044065587, 0.060389437, -0.011823414, 0.08889303, 0.010290733, -0.056499645, -0.012554047, 0.13659821, 0.062492277, -0.1463726, -0.30616954, -0.048617195));
	target3 += mul(f3, float4x4(-0.05244876, 0.056097146, -0.06787384, 0.09076766, -0.09579352, -0.0066260016, 0.15201993, 0.03254239, 0.021516487, 0.15981875, -0.1432654, 0.17569521, 0.12658277, -0.1530729, -0.14634636, -0.00258191));
	target3 += mul(g3, float4x4(0.19284594, -0.24125227, -0.06610495, -0.22473419, 0.19109339, 0.20509472, 0.022192668, 0.13134679, -0.16711204, 0.03866372, 0.040778622, 0.004792002, 0.06713585, -0.11313002, -0.0494123, 0.16455573));
	target3 += mul(h3, float4x4(0.08695826, 0.03544317, -0.22323117, 0.10693563, -0.060470764, 0.14525974, -0.12502834, -0.10161133, -0.29323998, -0.14850102, 0.0802706, 0.14540558, 0.07584563, -0.105335936, -0.10063164, -0.16825674));
	target3 += mul(i3, float4x4(-0.09106831, -0.054964047, -0.0060697296, 0.1795092, -0.031979155, -0.17847598, 0.02053048, -0.09066955, -0.27984852, 0.11892948, 0.24315885, 0.18758732, 0.16902542, -0.21777025, -0.012130184, -0.060705084));
	target3 += mul(na1, float4x4(0.059577208, 0.060833983, 0.10868721, 0.11276571, -0.2327309, -0.11088089, 0.20807125, -0.021718912, 0.030323144, -0.10312503, -0.22234069, 0.16634466, 0.19398251, -0.0545838, -0.13059108, 0.017868554));
	target3 += mul(nb1, float4x4(-0.07514213, 0.10887309, 0.1218314, -0.18563306, -0.008527813, -0.20459747, -0.030698426, 0.0844588, 0.23686919, 0.03104538, 0.08527714, -0.09642553, -0.08534072, 0.06419827, -0.12806654, -0.11365306));
	target3 += mul(nc1, float4x4(-0.039864887, -0.25141066, 0.13011548, -0.13584746, -0.013512096, -0.17277367, 0.08957357, 0.24380256, -0.033397153, -0.012431397, 0.082527, 0.020838374, 0.016154792, -0.29341805, -0.015195005, 0.022471353));
	target3 += mul(nd1, float4x4(-0.11212281, 0.08150235, 0.0055854055, -0.28806004, -0.09078987, -0.05241604, -0.09806806, -0.2560824, 0.043018572, 0.013310293, -0.018843893, 0.049140453, 0.17483246, 0.12305487, -0.096557006, 0.0123909665));
	target3 += mul(ne1, float4x4(0.09532439, 0.15352365, 0.20087242, 0.08491758, -0.24605502, 0.16663635, -0.13709177, -0.12777333, 0.02181133, 0.036698326, -0.003161005, 0.05891433, -0.055862445, 0.29106724, -0.17064662, -0.14393678));
	target3 += mul(nf1, float4x4(0.0058135563, -0.22420937, 0.07235329, -0.124738544, 0.08238468, -0.2015809, -0.03386368, -0.17470017, 0.057452828, -0.06164105, -0.13776, -0.09869882, -0.0026272335, -0.20054811, 0.019651942, -0.2600821));
	target3 += mul(ng1, float4x4(-0.17325936, -0.05762174, -0.06450132, 0.050736707, 0.045916766, 0.00402603, -0.08697255, 0.12957326, -0.17539512, 0.087370165, -0.004544662, -0.073203914, -0.010898469, 0.12600337, -0.012520381, 0.034228735));
	target3 += mul(nh1, float4x4(-0.10941816, 0.0907973, -0.0004870752, -0.0067486484, -0.0726075, 0.2144327, -0.055393726, -0.023118004, -0.14722143, -0.15563087, -0.06595914, -0.048578046, -0.030177968, 0.20142747, 0.01779709, 0.01655237));
	target3 += mul(ni1, float4x4(-0.08580983, -0.026037404, -0.077059925, -0.087288134, 0.004400565, -0.011133582, 0.17784919, 0.23502137, 0.047681976, -0.11357638, -0.0896771, 0.0067448434, -0.10454412, 0.17173828, 0.02538007, 0.012261617));
	target3 += mul(na2, float4x4(-0.1899917, 0.035758197, 0.09290593, -0.321715, 0.0062465663, 0.0014386866, 0.016894078, -0.115979955, -0.0027755008, 0.06348923, 0.03340955, -0.24005453, 0.049253695, -0.038937677, 0.11952727, 0.0399283));
	target3 += mul(nb2, float4x4(-0.0768814, -0.070920505, 0.32928568, -0.09117129, -0.030737674, -0.10276032, 0.008501685, -0.092094645, -0.119966194, 0.08019844, 0.06642611, -0.061083883, 0.11307649, -0.031231074, -0.032001212, 0.13963008));
	target3 += mul(nc2, float4x4(-0.07274599, 0.0010301028, 0.045785096, -0.010552021, -0.13573211, 0.271882, -0.22248295, -0.28493458, 0.024056, 0.14095017, 0.065386854, 0.06830046, 0.039510656, -0.09839122, 0.20431511, 0.09510801));
	target3 += mul(nd2, float4x4(0.015967855, -0.18058023, 0.18704537, 0.18511131, 0.08232382, 0.0142269125, -0.045059025, 0.09668988, 0.062527284, 0.15584159, -0.19181041, -0.09103482, 0.07462716, 0.08690921, -0.006602257, -0.048261993));
	target3 += mul(ne2, float4x4(0.06590294, 0.03255081, 0.27418908, 0.12957683, -0.056972653, -0.13130698, 0.116743594, -0.021665238, -0.049696703, 0.1355714, -0.034948308, 0.013496893, 0.08264742, -0.040836275, 0.066302836, -0.008282482));
	target3 += mul(nf2, float4x4(-0.031672716, 0.062036, 0.0670039, 0.118378155, 0.16932462, 0.19176582, -0.14296779, -0.07521962, 0.08186631, 0.13872068, 0.2050204, 0.23874411, -0.05187021, -0.14518432, 0.17769787, 0.13543007));
	target3 += mul(ng2, float4x4(0.23216663, -0.07822891, 0.19363302, 0.14644198, 0.23314826, 0.16843605, 0.14231025, 0.39938375, 0.012976297, 0.04872197, -0.056092817, -0.06786196, -0.13020758, -0.16039686, -0.08942605, 0.06917485));
	target3 += mul(nh2, float4x4(0.13809198, -0.07787285, -0.0032761474, 0.08901838, 0.06670918, 0.23262213, 0.19812497, -0.29459605, -0.16106832, -0.089955695, 0.018862866, 0.027937569, -0.068481594, 0.0515106, 0.0076716254, -0.020717952));
	target3 += mul(ni2, float4x4(0.15160611, -0.056448795, -0.01282516, -0.060768176, -0.13858989, 0.070536785, -0.036451727, -0.007100553, -0.06416002, 0.1640014, -0.012680492, 0.089894645, 0.089873075, -0.12290447, 0.07415422, 0.051840447));
	target3 += mul(na3, float4x4(0.049169756, 0.012065099, 0.044702023, 0.41471246, -0.22039439, 0.26710343, 0.03259032, -0.0010071819, 0.122387365, 0.016845915, -0.04162581, 0.16303158, -0.018624788, -0.018498175, 0.119111605, 0.066239804));
	target3 += mul(nb3, float4x4(0.1304685, -0.015543399, 0.09727904, 0.025493689, 0.11235736, -0.024798019, 0.24016461, 0.05678371, 0.29092878, 0.008495527, -0.08145035, 0.1277052, 0.09728953, -0.064336315, 0.018896975, -0.0052928496));
	target3 += mul(nc3, float4x4(-0.22020516, 0.17298244, 0.08216116, 0.13081113, -0.058733664, 0.14459507, 0.1042437, 0.10113822, -0.012354008, 0.21633418, 0.059657548, 0.14173268, 0.026709042, -0.10159428, 0.14287837, 0.16256075));
	target3 += mul(nd3, float4x4(-0.03602925, 0.19763114, 0.14659521, 0.079257175, -0.048765395, -0.04763924, -0.023928326, -0.07900388, 0.13704984, 0.08109074, -0.017959716, 0.0065745655, -0.052421648, -0.03608805, 0.06062624, 0.11137132));
	target3 += mul(ne3, float4x4(0.10591948, 0.0052649123, 0.18899056, 0.0075388527, 0.035225954, -0.062119495, 0.022104654, -0.10452858, 0.03833499, 0.26919907, -0.078174464, 0.0016594962, 0.09164568, -0.05362235, 0.047250915, -0.031277195));
	target3 += mul(nf3, float4x4(0.0244364, -0.06794058, -0.021393122, -0.053156774, 0.15241314, -0.09962311, -0.03456499, -0.016867915, 0.1597494, -0.12681212, -0.010430228, 0.00086353114, 0.027244834, 0.08854933, 0.1284529, -0.05862663));
	target3 += mul(ng3, float4x4(-0.12345045, -0.044616744, -0.04131162, 0.13541003, -0.047810026, -0.12005011, 0.010486988, -0.021923149, 0.11812008, 0.17721419, -0.032736443, -0.15231252, -0.13128845, 0.07795993, 0.047232933, -0.07249807));
	target3 += mul(nh3, float4x4(0.08612666, 0.02928595, 0.24572, 0.1079535, 0.06905186, -0.040503707, 0.08792316, 0.13987797, 0.14096849, -0.026072232, -0.024833977, -0.031660788, -0.07927557, 0.03298344, -0.08978443, 0.112841055));
	target3 += mul(ni3, float4x4(0.15270372, 0.07552049, 0.09564199, -0.13284975, 0.003842602, -0.029099604, 0.0003256477, -0.09769279, 0.12788263, -0.10107807, 0.10767, 0.23706906, -0.059877742, 0.09791839, 0.04538287, 0.16307582));
	target3 += float4(0.07341823, -0.019611815, -0.09007808, -0.022756629);

	float3 target4 = tex7.SampleLevel(sam, pos, 0).rgb;
	target4 += mul(e1, float4x3(0.022627862, -0.020713277, -0.009454221, -0.04352193, 0.058409747, 0.07186154, -0.009326966, 0.034919802, 0.04204233, 0.025182368, -0.039986387, -0.04990386));
	target4 += mul(e2, float4x3(0.0116241425, -0.039915055, -0.050241623, -0.0076204035, 0.050215762, 0.059038218, -0.006659752, -0.0054298495, -0.003807067, 0.011085346, -0.009443587, -0.009128077));
	target4 += mul(e3, float4x3(0.0453952, 0.004603456, 0.006256434, -0.104142666, 0.05726496, 0.069169044, -0.10102446, -0.034291938, -0.013720296, -0.035107866, -0.008388971, -0.0068969135));
	target4 += mul(ne1, float4x3(-0.038070124, -0.015017457, -0.015852718, 0.0607464, -0.052079927, -0.07268223, 0.008773512, -0.026051786, -0.027285712, -0.022916751, 0.048140153, 0.064897746));
	target4 += mul(ne2, float4x3(-0.01670857, 0.012646949, 0.03353705, 0.038032394, -0.044542246, -0.06310885, 0.002600519, -0.00824961, -0.008912322, 0.023435717, 0.021788329, 0.008603494));
	target4 += mul(ne3, float4x3(-0.02889454, -0.0058613745, -0.010699256, 0.12959917, -0.046572708, -0.06832117, 0.028117642, 0.020422146, 0.00869695, 0.035915125, 0.009355984, 0.005175107));

	tex4[gxy] = target1;
	tex5[gxy] = target2;
	tex6[gxy] = target3;
	tex8[gxy] = float4(target4, 1);
}

//!PASS 7
//!DESC Conv-4x3x3x24
//!IN tex4, tex5, tex6, tex8
//!OUT tex1, tex2, tex3, tex7
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass7(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	float4 a1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c1 = tex4.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d1 = tex4.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e1 = tex4.SampleLevel(sam, pos, 0);
	float4 f1 = tex4.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i1 = tex4.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na1 = max(-a1, 0);
	float4 nb1 = max(-b1, 0);
	float4 nc1 = max(-c1, 0);
	float4 nd1 = max(-d1, 0);
	float4 ne1 = max(-e1, 0);
	float4 nf1 = max(-f1, 0);
	float4 ng1 = max(-g1, 0);
	float4 nh1 = max(-h1, 0);
	float4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	float4 a2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c2 = tex5.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d2 = tex5.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e2 = tex5.SampleLevel(sam, pos, 0);
	float4 f2 = tex5.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i2 = tex5.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na2 = max(-a2, 0);
	float4 nb2 = max(-b2, 0);
	float4 nc2 = max(-c2, 0);
	float4 nd2 = max(-d2, 0);
	float4 ne2 = max(-e2, 0);
	float4 nf2 = max(-f2, 0);
	float4 ng2 = max(-g2, 0);
	float4 nh2 = max(-h2, 0);
	float4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    float4 a3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c3 = tex6.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d3 = tex6.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e3 = tex6.SampleLevel(sam, pos, 0);
	float4 f3 = tex6.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i3 = tex6.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na3 = max(-a3, 0);
	float4 nb3 = max(-b3, 0);
	float4 nc3 = max(-c3, 0);
	float4 nd3 = max(-d3, 0);
	float4 ne3 = max(-e3, 0);
	float4 nf3 = max(-f3, 0);
	float4 ng3 = max(-g3, 0);
	float4 nh3 = max(-h3, 0);
	float4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	float4 target1 = mul(a1, float4x4(-0.053204395, 0.2134829, 0.12336964, -0.10227736, 0.13940702, -0.124413736, 0.3020443, -0.2065515, -0.004734049, 0.037971064, -0.17321284, 0.041885074, 0.077058956, 0.12063891, -0.010338445, 0.06337065));
	target1 += mul(b1, float4x4(0.12816934, 0.14948028, -0.09161687, 0.009573578, 0.22003245, 0.044031654, 0.090882175, -0.14265673, 0.06734865, 0.05421324, 0.11106335, -0.020738617, 0.02484326, -0.059336618, -0.009157065, 0.0821956));
	target1 += mul(c1, float4x4(-0.02057381, -0.053952582, -0.05662845, 0.043356568, 0.2431925, -0.117109254, -0.03546069, 0.32747653, -0.0656724, -0.10274332, -0.026182862, 0.16777003, -0.038789105, -0.011600223, -0.06111373, -0.045530178));
	target1 += mul(d1, float4x4(-0.11627616, -0.2680533, 0.010153158, 0.04263144, -0.046353284, -0.05806104, 0.08532106, 0.02319678, -0.12570818, 0.0359389, 0.020782439, 0.10452313, 0.06330789, -0.0086953, -0.03920925, 0.06789389));
	target1 += mul(e1, float4x4(-0.08820413, -0.13917038, -0.049961973, 0.10507677, 0.25912637, 0.048801307, 0.13123387, 0.055866715, -0.055367444, 0.1428978, -0.040858068, 0.20058946, 0.0673469, -0.17162299, 0.15529002, 0.41366217));
	target1 += mul(f1, float4x4(-0.081712715, 0.04338456, -0.0368015, -0.0018422191, 0.16511263, -0.21779254, 0.065223925, 0.4804269, 0.26078546, -0.038037203, -0.2898542, 0.2068737, 0.101655796, -0.12456843, -0.11357212, -0.005879897));
	target1 += mul(g1, float4x4(-0.074044555, 0.07722422, 0.062057327, -0.039013617, 0.12760206, -0.18111233, -0.01114239, 0.1514668, -0.008963988, 0.23631106, 0.18362597, 0.14166053, -0.046458114, 0.16774492, 0.17774823, -0.008998563));
	target1 += mul(h1, float4x4(0.09820194, -0.054974817, -0.015640004, -0.037923157, 0.22821093, -0.03986652, -0.0074655996, 0.04587354, 0.05650628, 0.112482674, 0.023865355, 0.24882393, -0.011221855, 0.13942584, 0.003652544, -0.06288897));
	target1 += mul(i1, float4x4(-0.31229278, -0.10419711, -0.004614452, -0.032103445, -0.00018427879, 0.027711036, 0.028399462, 0.082576215, -0.056645207, 0.038272534, -0.011554511, 0.33454514, -0.21628743, 0.11849716, -0.23067485, -0.087079175));
	target1 += mul(a2, float4x4(-0.14960206, 0.29916358, -0.36191732, -0.096665345, -0.08732554, -0.10081626, 0.10593716, -0.0143145975, 0.12768494, 0.3251397, 0.23868982, -0.08632128, -0.07138096, -0.029475177, 0.07199368, -0.0016260111));
	target1 += mul(b2, float4x4(0.17022541, 0.19862384, 0.0029171365, 0.07225595, 0.08387519, -0.051419877, 0.16522466, -0.04951881, 0.07093068, 0.34544435, 0.08639415, -0.0077871718, 0.07875624, -0.10820802, 0.015711969, 0.1371948));
	target1 += mul(c2, float4x4(0.11947513, 0.03204784, -0.22552966, 0.05517582, 0.13209006, -0.06262761, 0.0719108, -0.083935544, -0.17171475, 0.07105399, 0.013485666, -0.13865131, -0.20124301, -0.10171288, -0.17265166, -0.1650513));
	target1 += mul(d2, float4x4(-0.038657106, -0.11968214, -0.04953467, 0.03988426, 0.18497725, 0.00012608049, -0.014361117, 0.016538745, 0.053768195, 0.21468902, 0.22507563, 0.13274029, 0.09316226, 0.10554355, 0.13079438, -0.020738615));
	target1 += mul(e2, float4x4(0.3934315, -0.14415179, 0.022628346, 0.067308314, 0.06434691, -0.09336087, -0.067665786, 0.05017148, -0.06534398, -0.048088152, -0.037155427, 0.1489594, -0.054163337, 0.2329102, -0.105613016, 0.0012456856));
	target1 += mul(f2, float4x4(0.24050267, -0.0067265374, -0.0153115215, 0.06555275, 0.19129738, 0.0043795216, 0.063948326, -0.13967972, -0.40650475, 0.09109113, 0.07856194, -0.13390535, -0.08199262, 0.17485364, -0.090266995, -0.012882164));
	target1 += mul(g2, float4x4(-0.387764, -0.15284535, -0.269682, 0.063642666, 0.08651869, -0.23153405, -0.10131002, 0.0043905224, 0.220928, 0.17752749, -0.01569877, -0.0686579, 0.21019012, 0.20529252, 0.06952716, -0.058749653));
	target1 += mul(h2, float4x4(-0.293644, 0.036391325, -0.07392813, -0.086678274, 0.2078697, -0.11507264, 0.028548734, -0.16409987, 0.17409426, 0.1885014, 0.084329076, -0.15027794, 0.20641033, 0.06187141, -0.03875406, 0.0032009226));
	target1 += mul(i2, float4x4(0.10790136, 0.1387389, -0.1781791, 0.21425287, 0.12715636, -0.063490026, 0.09555745, -0.10528784, 0.12758408, 0.29311177, 0.0432301, -0.021469813, 0.021922017, 0.082767464, 0.15348153, 0.12735313));
	target1 += mul(a3, float4x4(0.0062385295, 0.11732651, 0.06049321, -0.07607647, 0.17820913, 0.06216857, 0.05036523, 0.008527562, -0.05745378, 0.065337434, -0.04389796, 0.032172143, -0.08650831, -0.13604137, 0.050570212, 0.011036989));
	target1 += mul(b3, float4x4(0.016900355, 0.14422971, -0.106490955, -0.052399695, 0.13446756, 0.07712888, 0.0058913217, 0.07991085, 0.038670607, -0.25514704, 0.12148176, 0.17061579, 0.11421595, 0.022622943, 0.058726758, -0.17090438));
	target1 += mul(c3, float4x4(0.055515286, -0.19921277, -0.0012379233, 0.064982586, 0.26003027, -0.026233593, 0.07716586, -0.025661616, -0.11324887, -0.0035626758, 0.017872687, -0.10889948, -0.09775516, 0.07376668, -0.07696171, -0.2438295));
	target1 += mul(d3, float4x4(0.032405633, -0.05084789, -0.088054694, -0.10841894, -0.0075752116, 0.13531004, -0.1457409, 0.13204673, 0.0792082, 0.12976237, -0.07244278, -0.11369213, 0.06102383, -0.23130623, 0.0485402, 0.06685668));
	target1 += mul(e3, float4x4(-0.13683872, -0.053872824, -0.06719165, -0.070855714, 0.019770421, 0.18132222, 0.027324507, -0.04910738, 0.17011392, 0.057926424, 0.0857354, -0.14427422, -0.066373795, 0.09973484, 0.02194641, 0.17209244));
	target1 += mul(f3, float4x4(-0.07172457, -0.09989123, 0.06346084, 0.007205204, -0.18027657, 0.007516025, -0.0042022206, -0.0091036465, 0.18030393, -0.009558301, 0.12717903, -0.02116024, 0.14172006, 0.012544988, -0.16633627, 0.13234323));
	target1 += mul(g3, float4x4(-0.026680972, 0.26901576, -0.053663265, 0.0021016174, 0.032445803, 0.037003934, 0.05414299, -0.035497934, -0.10569329, 0.050672166, -0.01144387, 0.05000742, -0.057444472, 0.0010797186, 0.018822541, -0.04636653));
	target1 += mul(h3, float4x4(0.135361, -0.058395687, -0.033542126, 0.09484118, -0.07793999, 0.013546507, 0.11820586, 0.14490362, -0.016325314, -0.0062904614, 0.12631275, 0.1394393, -0.049356613, -0.02528993, 0.26334915, -0.032557055));
	target1 += mul(i3, float4x4(0.077839315, -0.052373778, 0.036136296, -0.05023568, -0.07987715, 0.018897712, -0.17742547, 0.18015353, 0.2571155, 0.058656774, 0.013118142, 0.12145675, 0.14177194, 0.099529505, -0.028370513, 0.25136563));
	target1 += mul(na1, float4x4(0.0747753, -0.15949982, 0.076973855, 0.080785476, 0.25431648, -0.120426156, 0.059631538, 0.13541599, -0.006538664, 0.06348775, -0.15413675, -0.011688718, -0.0877202, -0.07138076, -0.20553613, 0.17151853));
	target1 += mul(nb1, float4x4(-0.24562076, -0.31801596, 0.2534939, -0.054888077, 0.23713852, -0.23484352, 0.015403321, 0.28927258, 0.02333135, 0.115237035, 0.051989716, -0.0774211, -0.17619006, -0.042421665, -0.17778155, -0.16379887));
	target1 += mul(nc1, float4x4(-0.15642986, -0.0426825, 0.075349115, -0.13867629, 0.112977736, 0.06540842, 0.0059138774, 0.090976134, 0.102575876, -0.07702354, -0.060852207, -0.07358783, -0.030642396, -0.12437998, 0.19073227, -0.008556629));
	target1 += mul(nd1, float4x4(-0.009600349, 0.19660307, 0.06310739, -0.091261774, 0.1383758, -0.10920792, 0.01987075, 0.10960847, -0.03973851, -0.05378361, -0.053934645, -0.062070217, 0.017768001, -0.109798394, -0.27830756, 0.14825441));
	target1 += mul(ne1, float4x4(0.2253333, 0.04887524, 0.007540527, -0.21392706, 0.28378952, -0.22518088, -0.09280502, 0.25905597, 0.1558124, -0.06532809, -0.052613363, -0.038770456, -0.09479437, 0.39384437, 0.09516288, -0.29169223));
	target1 += mul(nf1, float4x4(0.023066722, -0.20169239, 0.025786614, 0.12992494, -0.0011414116, -0.0023400988, 0.13305776, -0.017615285, -0.06834794, -0.06084079, -0.10924924, 0.039389268, -0.0040167933, 0.049587116, 0.07590412, 0.31464538));
	target1 += mul(ng1, float4x4(-0.1917511, -0.008846332, 0.0914183, -0.06694468, 0.054535903, 0.19732447, 0.17194839, 0.12368525, -0.11447456, -0.10244315, -0.082908966, -0.103707045, 0.06248975, -0.14130668, -0.068753496, 0.23984621));
	target1 += mul(nh1, float4x4(-0.10043509, 0.036193024, 0.017117409, 0.15630378, 0.29531795, -0.20785378, -0.17022829, 0.010861576, -0.052274987, -0.050172083, -0.09687743, 0.025382213, 0.1061047, -0.019923043, 0.1905993, 0.31907213));
	target1 += mul(ni1, float4x4(-0.023860455, 0.013424604, -0.055340413, -0.006086705, 0.26867437, -0.18745743, 0.11919189, 0.05196282, -0.09836886, -0.10949307, -0.064731866, -0.14198364, 0.46431017, -0.14794265, 0.025133874, 0.38547024));
	target1 += mul(na2, float4x4(0.06934901, -0.20738873, 0.14471452, 0.03087651, 0.18033424, 0.16282603, -0.050284263, -0.041595727, -0.11747435, -0.04275445, -0.20998137, -0.056565028, -0.050009515, 0.13573733, -0.08438032, -0.07363902));
	target1 += mul(nb2, float4x4(-0.1109324, -0.08281566, 0.080020756, -0.07565862, 0.16276588, 0.13186535, 0.17810473, 0.051175643, -0.1470848, -0.08119655, 0.22341052, -0.14562707, -0.22091609, 0.08912351, 0.062519215, -0.17822169));
	target1 += mul(nc2, float4x4(-0.02652961, -0.050731696, 0.06761707, -0.070221156, 0.11255305, 0.15729706, 0.18315557, -0.0030489026, 0.08721225, -0.04417, -0.044907395, -0.0631245, -0.010991895, 0.14397791, -0.016412318, -0.016923137));
	target1 += mul(nd2, float4x4(-0.12462993, 0.14335859, 0.08130342, -0.16543365, 0.010432147, 0.019978197, -0.017498186, 0.03631899, 0.057306956, -0.06078837, -0.015008236, -0.24389061, -0.10250533, 0.31660014, 0.33440468, -0.12124798));
	target1 += mul(ne2, float4x4(-0.27909592, 0.21149877, 0.050259847, -0.24782999, 0.07350583, -0.03168507, -0.0206597, 0.07860909, -0.07629377, 0.1713701, 0.24176298, -0.25509474, 0.002090829, 0.051905315, 0.25929084, -0.09076089));
	target1 += mul(nf2, float4x4(-0.13923247, -0.083095506, -0.12958083, 0.008588576, 0.068224825, 0.094012275, 0.1395537, 0.0690222, 0.13958463, -0.02742012, 0.13905828, -0.04970139, -0.0629641, -0.15277445, 0.016491361, -0.13742869));
	target1 += mul(ng2, float4x4(-0.0027394858, -0.07178526, 0.07668042, -0.16290356, 0.10704169, 0.27434343, -0.003009555, -0.0124241095, 0.031501733, -0.10345558, -0.12258338, -0.055458266, 0.08220533, 0.16282788, 0.22585614, -0.04099274));
	target1 += mul(nh2, float4x4(-0.18252786, 0.032287426, 0.03831364, 0.03279567, -0.015436468, 0.16594371, -0.022859711, 0.014286839, -0.020073507, -0.06752274, 0.04850366, -0.03098202, 0.055985507, 0.030877378, -0.12457596, 0.012876079));
	target1 += mul(ni2, float4x4(-0.2959125, 0.12508816, -0.05321822, -0.1051829, 0.16586393, 0.07608049, -0.042397983, -0.0069031697, 0.13237686, -0.07125681, 0.021239927, 0.17826323, -0.14433292, 0.013577087, -0.14554563, -0.2040924));
	target1 += mul(na3, float4x4(0.33643177, -0.09343892, 0.05079197, -0.008774256, -0.002809458, -0.07406135, -0.33292174, 0.026698712, 0.3655136, 0.07260544, 0.3903461, -0.025114482, 0.038028333, 0.104210675, -0.4062275, -0.078964405));
	target1 += mul(nb3, float4x4(0.19767492, -0.1537188, 0.049587816, 0.23333088, -0.3893781, -0.011501175, -0.1826917, -0.12794746, -0.06709039, 0.015785962, -0.18090555, -0.11386157, -0.12038564, 0.011559484, -0.12779875, -0.14214684));
	target1 += mul(nc3, float4x4(-0.15774208, 0.24946158, -0.040942013, -0.1251321, -0.3509982, 0.07450445, -0.14480934, -0.20172012, -0.11019966, -0.07905495, -0.1572328, 0.12654895, 0.119401105, -0.12334677, 0.10720092, -0.06545273));
	target1 += mul(nd3, float4x4(-0.037104636, 0.33563337, 0.20923309, 0.028749982, 0.13854796, -0.13161437, 0.038462456, -0.14479184, 0.15403077, -0.04880203, 0.13780783, 0.06471987, 0.2944117, 0.13432993, -0.31482598, -0.06599348));
	target1 += mul(ne3, float4x4(0.54742974, 0.121937156, -0.07866791, 0.07451098, -0.03663172, -0.1554786, 0.059384037, -0.004000904, -0.04610048, -0.10617931, -0.18522029, 0.03238723, -0.085027255, -0.07754074, 0.22321595, -0.22000736));
	target1 += mul(nf3, float4x4(0.34576082, 0.054670934, -0.006112889, 0.08788217, -0.11128527, 0.016721481, 0.0025457302, 0.10134559, -0.08420967, 0.077211045, 0.04456844, 0.15408081, 0.08043456, -0.03195054, 0.068368874, -0.0011692513));
	target1 += mul(ng3, float4x4(-0.109538294, 0.035212234, -0.068712965, -0.09868468, -0.12186257, 0.122597136, -0.06546314, -0.024811305, -0.018210687, 0.09266877, -0.091002055, -0.05117649, 0.076985, 0.08579534, -0.14370322, -0.08178749));
	target1 += mul(nh3, float4x4(-0.21291538, 0.03441726, -0.01899837, -0.15328759, -0.17070505, 0.151839, 0.15083382, -0.08944362, -0.3224203, 0.012464086, 0.08693216, 0.014108278, -0.13456593, 0.008793197, 0.14650744, -0.04115599));
	target1 += mul(ni3, float4x4(0.12686576, 0.033990897, -0.0039116694, -0.12522134, 0.066877596, 0.09016868, -0.05867825, 0.08331187, -0.018720012, 0.10592668, 0.050558716, 0.35772276, -0.09896201, 0.057353813, -0.106769, 0.028894106));
	target1 += float4(-0.124429956, -0.023968874, -0.009741961, 0.000734556);
	
	float4 target2 = mul(a1, float4x4(-0.056590553, 0.03216381, -0.0666051, 0.19334152, -0.0050108447, -0.22589503, -0.057469424, -0.09344944, -0.1051364, -0.25752833, -0.035817955, -0.29675537, -0.1419535, -0.11206299, -0.005250591, -0.02839156));
	target2 += mul(b1, float4x4(-0.113020144, 0.028738707, 0.052538726, -0.039978653, 0.052219037, 0.057554238, 0.104583465, -0.03326389, 0.12732053, -0.09863676, -0.19774933, 0.10953924, 0.052640375, -0.2623868, -0.055126745, -0.12773202));
	target2 += mul(c1, float4x4(-0.17464705, -0.082161404, -0.18110912, 0.07796715, 0.04916518, 0.11231854, -0.086312726, -0.034675486, -0.19010356, 0.032855187, -0.013579661, 0.37123898, -0.014220876, -0.006728799, 0.08287457, -0.1138056));
	target2 += mul(d1, float4x4(0.13857616, -0.09273926, 0.13864596, 0.18886924, -0.011879785, 0.32183805, -0.051207457, 0.037754197, -0.09221778, -0.02035246, -0.17649348, 0.020960717, -0.07177013, 0.09179843, 0.080085315, 0.122304566));
	target2 += mul(e1, float4x4(-0.16989891, -0.08335691, 0.084998704, 0.11291987, -0.3019433, 0.0076751867, 0.093596675, 0.06530408, 0.1206327, 0.091008104, 0.109547265, 0.25353962, 0.036133915, 0.093532056, 0.061501086, 0.0021566728));
	target2 += mul(f1, float4x4(-0.017881159, -0.13595797, 0.01136082, 0.16003034, 0.10847896, 0.19483434, 0.26643255, -0.13653097, -0.02909977, 0.0048497478, -0.07825304, 0.19495782, 0.051259015, 0.06378301, -0.25297102, 0.12415515));
	target2 += mul(g1, float4x4(0.1937498, -0.054339543, 0.010112153, 0.1686902, -0.010859902, 0.017609913, 0.13538137, 0.21478494, -0.15561095, 0.03826493, 0.030638125, 0.15134248, 0.02018713, 0.09653892, 0.012655936, 0.12929274));
	target2 += mul(h1, float4x4(0.10884013, -0.059027947, 0.09222052, 0.08509775, -0.23504566, 0.10800187, 0.35871732, -0.27244377, 0.1780951, -0.09118458, -0.08485235, 0.18791482, 0.12209446, 0.0061277915, -0.011919617, -0.258573));
	target2 += mul(i1, float4x4(0.08261666, -0.107749484, -0.15589459, 0.23786806, -0.25947818, -0.07595851, 0.19160344, -0.024088206, -0.008799499, -0.17963524, -0.25323853, -0.026271267, 0.108688876, -0.21407057, -0.3583868, 0.09666366));
	target2 += mul(a2, float4x4(0.13808286, -0.04138869, -0.16940956, 0.3419983, 0.055550236, -0.020949477, -0.0067749163, -0.19835842, 0.030675124, 0.075373225, 0.12566806, -0.04334421, -0.102529705, 0.04508018, 0.23232533, 0.0019694006));
	target2 += mul(b2, float4x4(0.15215543, -0.016466457, -0.088040456, 0.17388342, 0.04182113, 0.18802759, 0.064585775, -0.14804406, -0.24339275, 0.17330259, 0.027834702, 0.058299657, -0.031298336, 0.31788856, 0.07080272, 0.24237408));
	target2 += mul(c2, float4x4(0.16990338, 0.3701443, 0.12791218, 0.14076602, 0.20176111, 0.0302564, 0.24510148, -0.13427663, -0.38024938, 0.12371078, -0.01582557, -0.3158842, 0.20104642, 0.07178823, -0.1876278, 0.084532306));
	target2 += mul(d2, float4x4(0.14377905, -0.058295894, 0.18250984, -0.09202952, 0.049288724, 0.06361697, 0.015274134, -0.009651323, -0.042051505, -0.012071234, 0.1326135, 0.019923072, -0.15128869, 0.25043762, -0.13259046, 0.00053170364));
	target2 += mul(e2, float4x4(0.094158195, 0.12379144, 0.19022636, 0.18195347, 0.013914745, 0.061979804, 0.02451591, -0.11115476, -0.17788209, 0.13222231, -0.13186376, -0.1616039, -0.24425243, 0.1886775, 0.0112440875, -0.06601394));
	target2 += mul(f2, float4x4(-0.030136446, 0.2917132, -0.27445439, 0.17572524, 0.041303374, 0.023066396, 0.15800332, -0.2759435, -0.13819514, 0.15358543, -0.20889634, -0.015854366, -0.046221938, -0.029213084, -0.20027846, -0.096412785));
	target2 += mul(g2, float4x4(0.0125947185, 0.0055787223, -0.09309416, 0.076822944, -0.093398675, 0.2956369, 0.06577939, -0.23052916, -0.07925194, -0.072308525, 0.024827626, -0.060508657, -0.12151571, 0.026541036, -0.12048794, -0.07427358));
	target2 += mul(h2, float4x4(-0.10964251, -0.17297563, 0.13372806, 0.049176272, -0.05832845, 0.017144928, -0.048461188, -0.15870371, 0.11398971, -0.107922345, 0.13167588, -0.14817321, -0.10338058, -0.31081274, 0.08330581, -0.29687402));
	target2 += mul(i2, float4x4(0.16665904, -0.2640339, -0.29233927, 0.038875308, -0.05411785, 0.16937009, 0.12490365, -0.124583, -0.07552158, 0.11799862, -0.28171206, -0.00040758983, -0.19385974, -0.06890529, 0.14208162, -0.1088734));
	target2 += mul(a3, float4x4(0.06168567, 0.08464485, 0.051727522, 0.0080752885, -0.024248002, -0.10022553, 0.16323335, 0.023631554, -0.05933269, -0.062205136, -0.18094447, 0.059799075, 0.21466024, 0.008523474, 0.26693302, 0.23969485));
	target2 += mul(b3, float4x4(-0.15529208, -0.011878417, -0.18483245, 0.14569621, 0.063189425, -0.19457999, -0.030479494, -0.06388341, 0.059255358, 0.021795692, -0.18915053, 0.10549042, -0.14347872, 0.035095137, 0.5123671, -0.36842114));
	target2 += mul(c3, float4x4(-0.3129531, 0.18427932, 0.08967258, 0.030795548, -0.062971294, 0.13863337, 0.1719862, -0.12454022, -0.13502273, 0.09999501, -0.08539335, -0.009761404, 0.12899344, 0.13241018, 0.07476177, 0.088581234));
	target2 += mul(d3, float4x4(0.060355544, -0.20497295, -0.056201037, 0.17441384, -0.07366008, 0.0031770081, 0.10340366, -0.065828614, -0.0135689005, 0.0018236408, -0.061976664, 0.2355626, 0.10771512, 0.077624, 0.13811535, -0.07868492));
	target2 += mul(e3, float4x4(-0.17156444, -0.026765984, -0.10527619, 0.03830846, 0.09402895, -0.004862654, 0.076368734, -0.14964046, 0.043011688, -0.23503943, -0.0006939608, 0.14159496, -0.044676844, 0.173952, 0.110504664, 0.0019379692));
	target2 += mul(f3, float4x4(-0.17247017, 0.08168303, 0.17221324, -0.06592961, 0.0044269604, 0.15659723, -0.055933986, -0.042620275, 0.06073025, 0.2532331, 0.10132909, -0.117701456, 0.12096025, 0.10205398, -0.18403697, 0.18307333));
	target2 += mul(g3, float4x4(0.09575911, -0.05598526, -0.00019075947, -0.09576007, 0.20932649, -0.20390967, 0.039013285, -0.0673076, 0.10174375, -0.029520035, 0.08187042, 0.0113893915, 0.2773657, -0.14660437, -0.052826468, -0.066547535));
	target2 += mul(h3, float4x4(0.073659964, 0.11016725, 0.03967363, -0.14039496, 0.14510235, -0.023440665, -0.14824589, 0.040890865, -0.17982483, -0.06410239, 0.1368475, 0.06049977, -0.04931566, 0.16838568, 0.032267325, -0.14558685));
	target2 += mul(i3, float4x4(-0.09795584, 0.042064235, -0.031120127, -0.14744717, 0.027100604, -0.24968515, -0.21389422, 0.04229415, -0.09014897, 0.12878452, 0.25642878, -0.08038266, 0.19971558, 0.11135897, -0.36821046, 0.1422662));
	target2 += mul(na1, float4x4(0.1094647, -0.016677434, -0.028883765, 0.3192714, 0.09875388, 0.063245736, 0.14410317, 0.032648303, -0.06333742, 0.27168024, 0.022700999, -0.24260196, 0.2008466, 0.0035053317, 0.033708334, 0.08848844));
	target2 += mul(nb1, float4x4(0.14528061, -0.15028432, -0.12186915, 0.2541439, 0.10196279, -0.08628881, 0.013626965, 0.0865205, -0.06720443, -0.012042523, 0.2745774, -0.15612917, 0.052762404, -0.048645414, 0.2373206, 0.15480334));
	target2 += mul(nc1, float4x4(0.30316323, 0.13258561, 0.064958744, -0.006462185, -0.18336357, -0.042762443, 0.14428605, 0.0022340214, 0.126048, 0.080833666, 0.009115843, 0.03493862, 0.10809081, -0.16448757, 0.3997175, -0.110012166));
	target2 += mul(nd1, float4x4(0.02458684, -0.057449866, 0.030437991, 0.12050426, 0.09614844, -0.014490843, 0.028539594, 0.04805738, -0.09334032, -0.025414651, -0.08732445, -0.23192073, -0.17476203, -0.09348745, -0.08307593, -0.23019521));
	target2 += mul(ne1, float4x4(0.35522544, -0.079090506, 0.008817837, 0.2532623, 0.34887648, -0.06478506, -0.08268971, -0.01187354, -0.01297639, -0.1617383, -0.08950093, -0.27147245, -0.18539499, -0.025695372, 0.014795757, 0.070290186));
	target2 += mul(nf1, float4x4(0.10833107, -0.04752071, 0.0257186, 0.045938533, -0.17696926, -0.044409238, 0.013435127, -0.026669621, -0.039547954, -0.24273679, -0.11717763, 0.03446355, 0.20519058, 0.14973645, -0.06620626, 0.27608195));
	target2 += mul(ng1, float4x4(-0.05178539, -0.052307468, -0.031603504, 0.087410286, -0.02714207, 0.19870313, -0.07222196, 0.016593033, 0.1256676, -0.0017593893, -0.09573438, 0.06781198, -0.21133266, 0.17265096, -0.18769167, -0.44435498));
	target2 += mul(nh1, float4x4(0.06497008, -0.036607113, -0.044402726, 0.2149976, 0.13416344, 0.042011082, -0.101590805, -0.020510921, -0.06912339, -0.054973233, -0.044747703, 0.14244531, -0.28504518, 0.3040643, -0.09546776, 0.31751406));
	target2 += mul(ni1, float4x4(-0.084402256, 0.09284107, 0.035581376, -0.0062208944, -0.09883153, 0.10322051, 0.1348337, -0.31998435, -0.012351705, -0.1971895, 0.22683385, -0.12512599, -0.07051629, 0.2452453, 0.083472766, -0.20878734));
	target2 += mul(na2, float4x4(-0.20292963, 0.044648554, 0.15208347, -0.08012225, -0.12525047, 0.015525035, 0.09556482, -0.11069662, -0.085732915, 0.011575785, -0.025669998, -0.14913903, -0.04931291, 0.012865525, -0.12986338, -0.01954532));
	target2 += mul(nb2, float4x4(-0.008896974, -0.039155565, 0.027794836, -0.117017545, -0.06935417, -0.026629506, 0.007301185, -0.46567324, 0.037060194, 0.09720974, 0.2845551, -0.3020958, -0.025294555, -0.30916882, 0.18453851, -0.18012975));
	target2 += mul(nc2, float4x4(0.030631881, -0.008507908, -0.09436097, 0.0311627, -0.20561115, 0.11587156, 0.09280758, -0.085967906, 0.3602613, -0.044544138, 0.1323068, -0.009463272, -0.0025823591, -0.15646757, -0.046626896, 0.16452411));
	target2 += mul(nd2, float4x4(-0.0077203126, -0.100717455, -0.2011105, -0.14975028, -0.20319125, 0.10198259, -0.04371703, -0.27115488, 0.027433528, -0.09739682, -0.13802922, -0.26861516, -0.048793945, 0.06584455, 0.06585165, -0.008628782));
	target2 += mul(ne2, float4x4(-0.10281875, 0.040024713, -0.2812408, -0.020755077, 0.013610964, -0.032100085, -0.019541265, 0.08268734, -0.03297649, -0.037923373, -0.18825053, 0.07058112, 0.08730599, 0.03063617, 0.02987196, -0.0043262425));
	target2 += mul(nf2, float4x4(-0.040238652, -0.13039924, 0.14888343, 7.490741e-05, -0.2158812, 0.24641772, 0.006157586, -0.04499295, 0.144089, 0.07224167, 0.17486697, -0.035505384, 0.1524877, 0.14747557, 0.17406234, 0.11407642));
	target2 += mul(ng2, float4x4(0.016506152, -0.010222893, 0.13286552, -0.21776699, -0.09772777, 0.1287599, -0.03898535, -0.16048339, 0.16613074, 0.07386897, 0.010006783, -0.109998874, -0.44924134, -0.10780198, 0.20899624, 0.0225183));
	target2 += mul(nh2, float4x4(-0.009322647, 0.037628874, -0.07781525, 0.096469015, -0.13213164, 0.112819366, -0.009472233, -0.2799395, -0.13030471, 0.15054065, -0.06948136, -0.15108407, 0.15611546, -0.033660483, -0.015103015, -0.11582756));
	target2 += mul(ni2, float4x4(-0.1565792, -0.020967469, 0.18913873, -0.16583163, -0.1238118, 0.09852521, -0.22204556, -0.03933885, -0.0059996913, 0.26517454, 0.029015608, -0.0067967405, 0.12023722, 0.020479612, -0.11405568, 0.09855018));
	target2 += mul(na3, float4x4(-0.100906074, 0.1372623, -0.06694728, 0.24972913, -0.050774068, -0.040847532, -0.2658499, -0.055020068, 0.017677482, -0.10252552, 0.093889, -0.066453, -0.11749236, 0.117650375, -0.009431862, -0.13268448));
	target2 += mul(nb3, float4x4(0.0062916246, 0.11412136, -0.04665643, -0.05716979, -0.3630308, 0.056478713, 0.13907139, -0.46697688, -0.17572168, -0.032978512, -0.25377706, 0.2386579, 0.08279535, -0.078310356, 0.14829971, -0.22042938));
	target2 += mul(nc3, float4x4(0.032816015, -0.30565384, -0.16489638, -0.16715215, 0.19837156, 0.2794504, -0.056615926, -0.15358809, -0.040108953, -0.30223787, 0.23217356, 0.0056255152, -0.018384434, 0.151488, 0.1853468, 0.08032189));
	target2 += mul(nd3, float4x4(0.0664597, -0.20910838, 0.26195124, -0.07578308, 0.13466386, -0.040509395, -0.005630214, -0.10919593, 0.09764661, -0.099661686, 0.105231985, 0.18113208, -0.13830248, -0.16406676, -0.36873665, -0.110502236));
	target2 += mul(ne3, float4x4(-0.009745877, 0.050425317, 0.041368794, 0.34543577, 0.017489558, -0.1383922, 0.02555688, 0.08608152, 0.2675467, -0.14163154, -0.009072096, -0.04938327, 0.02321701, -0.23915094, -0.20346476, 0.02754088));
	target2 += mul(nf3, float4x4(-0.0764608, -0.18401545, 0.18727265, -0.107619025, 0.02815041, 0.14077562, -0.05316665, 0.3057819, 0.033161953, -0.15832557, -0.13877237, 0.1657462, 0.01894343, 0.23329574, -0.14319004, 0.031079128));
	target2 += mul(ng3, float4x4(-0.3142226, 0.09312817, 0.08794322, 0.2222839, -0.06945857, 0.14425695, -0.014134404, 0.005755717, 0.010266066, -0.26988292, 0.04765992, 0.24445806, -0.11784465, 0.028391482, -0.09065907, 0.13896856));
	target2 += mul(nh3, float4x4(-0.17636561, -0.056445003, 0.06597882, 0.020473091, -0.13026594, 0.12097649, -0.060047906, 0.30939278, 0.20875697, 0.074364014, -0.06563088, -0.052628025, -0.07981685, -0.054282684, 0.006551467, 0.08257015));
	target2 += mul(ni3, float4x4(0.1486522, 0.27273872, -0.16233566, 0.08857763, 0.034426562, 0.31791484, -0.11444188, 0.20239855, -0.17699686, 0.40953103, -0.19843663, 0.32758692, -0.017546277, 0.040539514, -0.13233976, 0.054549627));
	target2 += float4(0.0570952, -0.011593155, 0.033286963, 0.00014048154);
	
	float4 target3 = mul(a1, float4x4(-0.028246857, 0.09429872, 0.034600366, 0.022117741, -0.034094583, -0.1416488, 0.114190586, -0.19039942, -0.03329484, 0.054765828, 0.0518203, -0.20784369, -0.11068853, -0.03985197, -0.040889204, -0.15233918));
	target3 += mul(b1, float4x4(0.0034295225, -0.0047144215, -0.13811362, 0.1063775, -0.042283904, -0.11053704, 0.031115215, -0.19094694, -0.07958675, 0.25251713, 0.27887833, 0.032974306, -0.007945948, 0.005038382, -0.018204618, -0.033514593));
	target3 += mul(c1, float4x4(-0.021439308, 0.09934385, 0.06221231, 0.20019929, 0.031433582, 0.10136135, 0.03170799, 0.22528099, -0.13307518, 0.0042947256, 0.12888439, 0.057041943, -0.093636274, -0.098759346, -0.0013004189, -0.11623657));
	target3 += mul(d1, float4x4(-0.12425962, 0.06631687, 0.03538785, 0.12683366, 0.036875088, -0.388709, 0.021293538, -0.06568616, -0.022915881, -0.17667641, -0.21997124, -0.15674002, 0.12193349, 0.05480543, -0.028813047, -0.092471436));
	target3 += mul(e1, float4x4(-0.23961155, -0.10273245, -0.08654801, 0.20536228, 0.15906096, -0.28645602, -0.20196053, -0.24955072, 0.030706927, 0.0390173, -0.18619792, 0.042841963, -0.021935288, 0.18055134, 0.056804277, 0.06829802));
	target3 += mul(f1, float4x4(-0.17750104, 0.060207605, -0.16278192, 0.10637904, 0.09263751, -0.15864064, -0.1921883, 0.15418245, -0.21325666, -0.060680047, -0.17831814, 0.08721947, 0.028428067, 0.110841654, -0.0018111315, -0.14204408));
	target3 += mul(g1, float4x4(-0.05341328, 0.022792514, 0.12271092, 0.10998399, -0.05194629, -0.0019651174, 0.096098036, 0.05388034, -0.09140511, -0.09375859, -0.033423815, -0.051705707, 0.40354738, -0.09664782, -0.16623749, -0.063937105));
	target3 += mul(h1, float4x4(-0.036799524, -0.0768793, -0.13867554, 0.0018584719, -0.1217911, -0.24234816, 0.09708973, -0.011562908, -0.04658245, -0.0382149, -0.06386236, -0.18728544, -0.07053968, 0.022178814, -0.011753032, 0.09338199));
	target3 += mul(i1, float4x4(-0.040192164, -0.042503025, -0.10662553, 0.04789613, -0.14751524, -0.10168207, 0.09263359, -0.042696435, -0.32350782, 0.12660037, -0.004465994, -0.006698753, 0.11897201, -0.046830907, -0.13950327, 0.06639755));
	target3 += mul(a2, float4x4(-0.35137546, 0.16106302, -0.03942045, 0.20408326, -0.21793413, -0.19028474, 0.03843431, 0.16594443, 0.06715659, -0.12361966, 0.09516593, -0.07226092, -0.0021764247, 0.09041338, -0.042596035, 0.17071731));
	target3 += mul(b2, float4x4(-0.1597755, -0.0058896556, -0.14055388, -0.1015749, 0.03897486, -0.14616072, 0.14914623, 0.04983836, 0.19837128, 0.031061351, -0.012111387, -0.14318599, 0.015185477, 0.015783781, 0.0806122, -0.029704068));
	target3 += mul(c2, float4x4(-0.039973997, -0.039424386, -0.00023192639, 0.08071814, 0.096021704, -0.20885538, -0.12213241, -0.023790348, 0.09664941, -0.10268222, 0.13096042, -0.05173415, -0.37291482, 0.07015618, -0.33403385, -0.083771));
	target3 += mul(d2, float4x4(0.03271248, 0.30518225, -0.07270691, 0.028075088, -0.05705947, -0.15325841, 0.100330696, -0.025110118, -0.076902226, 0.14327222, 0.06624428, 0.13375239, 0.37281695, 0.07052823, -0.14584045, -0.21908635));
	target3 += mul(e2, float4x4(0.120670766, 0.31895483, 0.025020262, -0.07187204, 0.12886079, -0.044927042, -0.016122498, -0.042634714, 0.13163976, -0.042178337, 0.1995516, 0.0356841, 0.15696648, 0.08892613, 0.21146311, -0.119200125));
	target3 += mul(f2, float4x4(0.07862659, -0.04457566, 0.026738126, -0.21411496, 0.10438254, -0.18654525, -0.01533368, 0.13947518, 0.10588101, -0.028714191, 0.15771964, 0.121909015, -0.10983157, 0.2185668, -0.068225995, -0.12562555));
	target3 += mul(g2, float4x4(-0.12062531, 0.0967178, 0.09571875, 0.23502766, 0.09096207, -0.21987092, 0.024857553, -0.048271395, 0.14787363, -0.033102654, 0.13895266, -0.04427544, 0.04914057, 0.048905186, -0.057733577, -0.26991108));
	target3 += mul(h2, float4x4(-0.06448222, 0.0056067007, 0.06258581, 0.16081811, 0.11269595, -0.120004445, -0.013984294, -0.13933693, -0.07139989, -0.052229576, 0.14940026, 0.023361623, -0.09279362, -0.18860416, 0.08875797, -0.007527515));
	target3 += mul(i2, float4x4(-0.074545845, 0.030673563, 0.15330285, 0.13776723, 0.10154421, -0.092071116, 0.04683676, -0.06964785, 0.10431926, 0.08699972, 0.23528512, -0.033892516, -0.14641368, 0.117580056, -0.004050138, -0.02582363));
	target3 += mul(a3, float4x4(0.14190136, 0.077225044, 0.09930474, 0.007267315, 0.092006706, 0.037188467, -0.027249279, -0.054990012, -0.03665177, 0.12651706, -0.100975744, -0.09072935, 0.24675299, 0.06761549, -0.05267532, 0.10347854));
	target3 += mul(b3, float4x4(0.10791531, -0.1370413, -0.08286376, 0.03607253, -0.0308955, 0.07522176, 0.018555947, -0.12568206, 0.112782314, 0.28888306, -0.003996075, 0.028732201, 0.25184667, -0.2680978, 0.02647103, -0.046891168));
	target3 += mul(c3, float4x4(-0.016372435, 0.010370288, 0.048521012, 0.17552224, 0.12718126, -0.07016058, 0.07195029, -0.020361308, 0.12597205, 0.08013731, -3.848295e-05, 0.0050118286, -0.009566892, -0.20061424, -0.03470485, -0.006634675));
	target3 += mul(d3, float4x4(-0.014340514, -0.061068784, 0.073101744, -0.026097663, -0.060043298, 0.03856278, -0.06831028, 0.01917565, 0.0030782523, -0.27292702, 0.009022088, -0.0835327, 0.15536709, 0.19875537, -0.04220971, 0.12280315));
	target3 += mul(e3, float4x4(-0.05038896, -0.0450083, 0.11035315, 0.017889546, -0.04486168, 0.02630088, 0.076166764, 0.040405206, 0.101371124, 0.013579925, -0.14421356, 0.10385705, -0.040398728, 0.16730694, 0.21123065, 0.08927596));
	target3 += mul(f3, float4x4(0.14247608, -0.020986153, 0.23048729, 0.016399987, 0.08749712, -0.042591766, 0.10078401, -0.235661, 0.16211063, 0.06193226, -0.074332505, -0.016298788, 0.045263976, 0.15765212, 0.07818007, -0.04620609));
	target3 += mul(g3, float4x4(0.021306554, -0.09750117, 0.08551645, -0.04607957, 0.023408834, -0.023608467, -0.20876807, -0.059991024, 0.073818475, -0.011034656, 0.021592963, 0.2020669, 0.0658326, -0.037186112, -0.12142336, 0.024981985));
	target3 += mul(h3, float4x4(0.14970483, -0.034374855, 0.059193425, -0.053641498, -0.012546929, 0.12899692, -0.14678986, 0.010604312, 0.06670342, -0.16510558, 0.008418653, -0.07479036, 0.18447658, -0.048377503, -0.09458383, 0.0069656954));
	target3 += mul(i3, float4x4(0.058000036, -0.16915704, -0.019119963, -0.045525633, -0.037617203, 0.25589603, -0.25075126, 0.06523698, 0.17653236, -0.061193496, 0.06445885, 0.012287812, 0.102899276, 0.110979825, -0.22975717, 0.1812179));
	target3 += mul(na1, float4x4(0.06707089, -0.20528378, 0.046027422, 0.09201046, -0.026794929, -0.14959913, -0.1530082, -0.11166134, -0.1543093, -0.018212209, 0.1530343, 0.16413027, -0.041838966, 0.10568013, 0.027219504, -0.045931514));
	target3 += mul(nb1, float4x4(0.0007681395, 0.027546167, -0.055535425, -0.16842778, 0.031941716, 0.10155229, -0.15778649, 0.20752658, -0.040377192, -0.30390355, -0.023281433, -0.030623253, -0.09503612, -0.17188235, 0.09639771, 0.006249103));
	target3 += mul(nc1, float4x4(0.06934318, -0.0011609821, -0.1791592, 0.03465803, -0.24253, 0.05893978, 0.13887544, -0.07227747, 0.01218867, 0.029141122, -0.05214466, -0.12778749, -0.1760804, -0.06785066, -0.007493355, 0.14466043));
	target3 += mul(nd1, float4x4(0.018881964, -0.05313997, 0.026167642, -0.11774113, 0.106899664, -0.04816693, -0.032971296, -0.2197493, -0.30351043, 0.41334164, 0.09371295, 0.117004104, -0.32039383, 0.21075623, 0.059145812, 0.22701162));
	target3 += mul(ne1, float4x4(0.15627995, -0.068059504, -0.025623176, -0.099454194, 0.053013522, -0.1204116, -0.019655226, 0.07376517, -0.25296777, -0.08185056, -0.055070046, -0.0901355, -0.11905481, -0.05469155, -0.017616548, -0.081166655));
	target3 += mul(nf1, float4x4(0.13076767, -0.05530982, -0.050112855, -0.12159198, -0.13501246, -0.003588778, -0.13545947, 0.11865785, -0.05613547, -0.068032116, -0.08055732, 0.21331398, 0.004210958, 0.0020068642, 0.028101314, -0.09094483));
	target3 += mul(ng1, float4x4(-0.06359586, 0.13318597, -0.013024477, 0.108700395, 0.11144461, -0.20727357, -0.024350716, -0.22389533, -0.09566586, -0.0131226955, -0.11817035, 0.09054735, -0.27647895, 0.07672232, -0.047891885, 0.071800984));
	target3 += mul(nh1, float4x4(-0.030071015, 0.1333995, 0.031153332, -0.086189225, -0.0019152679, -0.01622374, 0.040289503, -0.15809211, -0.12741992, 0.10740146, -0.051979292, -0.116695315, 0.320744, 0.0039460426, -0.0836046, -0.09634563));
	target3 += mul(ni1, float4x4(-0.09536935, -0.052188914, 0.047246125, 0.015771315, 0.044488825, -0.08132813, -0.27927315, -0.13175185, 0.024771225, -0.24907906, -0.023289192, -0.04971131, 0.05681843, 0.07283831, 0.064641275, -0.26641592));
	target3 += mul(na2, float4x4(-0.027925663, -0.1507286, 0.1326965, 0.016842714, 0.008826637, -0.16630088, 0.057058703, -0.18538098, -0.023735443, 0.032016642, 0.12527052, 0.16732964, 0.086843535, 0.035672616, 0.2063971, 0.09174031));
	target3 += mul(nb2, float4x4(-0.1374101, 0.0033208288, 0.10667102, 0.010594156, 0.046161152, -0.0973723, 0.038522966, 0.021097187, 0.016156282, -0.19751011, 0.28385642, 0.05756371, -0.05513193, -0.2048188, -0.21631682, 0.07647592));
	target3 += mul(nc2, float4x4(0.17377815, 0.15260585, 0.053718828, 0.05137225, -0.022358606, -0.1206224, 0.18654475, -0.36442846, 0.037749466, -0.1104878, -0.11404351, -0.06023782, 0.20938018, 0.07982189, 0.07250349, -0.07269494));
	target3 += mul(nd2, float4x4(-0.21727799, 0.060607027, 0.020804053, 0.18055809, 0.065868735, 0.027194923, 0.07823965, -0.0036479903, -0.00017318636, 0.08600115, -0.025587326, 0.07114245, -0.019529548, -0.13423847, 0.13471194, 0.09455981));
	target3 += mul(ne2, float4x4(-0.0054947184, 0.08912019, -0.0287804, 0.06010462, 0.01399159, 0.06061662, -0.11517458, -0.097311266, 0.050931722, 0.22020856, 0.1323814, -0.04628687, -0.11665284, -0.28899986, -0.24807844, -0.26831678));
	target3 += mul(nf2, float4x4(-0.030188283, -0.03878683, -0.017246237, 0.06085806, -0.018588748, 0.022792742, 0.25868282, -0.07614454, 0.13609566, 0.048479818, 0.1144347, -0.11878534, -0.0087716095, -0.10999109, -0.052827284, 0.05120022));
	target3 += mul(ng2, float4x4(0.13541034, 0.01645716, -0.058492333, -0.038296085, 0.100599736, -0.116733365, 0.04200369, -0.025886245, 0.10077625, -0.16246797, -0.17139618, 0.1154542, 0.048264973, 0.28143618, 0.21083501, 0.1901906));
	target3 += mul(nh2, float4x4(0.17519377, 0.11165914, 0.06639653, 0.07394748, -0.007674659, 0.16630298, 0.19389485, -0.095608205, 0.08834474, -0.014449134, -0.1498579, 0.10741625, -0.15439212, 0.067960866, -0.037635356, -0.15552957));
	target3 += mul(ni2, float4x4(-0.06438933, 0.014048397, 0.10090704, -0.113563396, 0.16256817, 0.05490672, 0.07492557, -0.117161274, 0.21595421, -0.043381806, -0.051558085, 0.1740199, 0.2152678, 0.2786416, 0.16830157, 0.2127052));
	target3 += mul(na3, float4x4(-0.15677509, -0.43225375, 0.060302902, -0.25911507, 0.33240193, -0.042785197, 0.12322616, 0.060724694, 0.19070825, 0.06739152, -0.11829862, -0.29873747, 0.044883754, -0.02737334, 0.35752672, 0.027660733));
	target3 += mul(nb3, float4x4(-0.031477857, -0.061355617, 0.14307205, -0.27185053, 0.0042110113, -0.17895593, 0.18448347, 0.1663187, -0.027779656, -0.038476624, -0.20109327, 0.0049036117, -0.33461937, -0.11617029, 0.16388293, 0.08732086));
	target3 += mul(nc3, float4x4(-0.14116575, -0.2656471, 0.11648339, -0.0032394545, 0.1182878, -0.3112847, 0.022472465, 0.01861419, -0.17598355, 0.09062213, -0.078444645, 0.08435301, -0.076718464, -0.27557522, 0.2719488, -0.2709603));
	target3 += mul(nd3, float4x4(0.27406302, -0.038197294, 0.08674393, -0.1581159, 0.13235791, -0.2564229, 0.1109576, -0.0176378, 0.15548801, -0.0590908, -0.017661547, -0.2397164, -0.13061532, 0.23031203, 0.13042833, -0.1644423));
	target3 += mul(ne3, float4x4(-0.07506608, 0.038386136, -0.079568535, -0.14536263, -0.14519933, 0.049832735, -0.0716522, 0.08434604, -0.12847446, 0.0008543391, -0.14790097, 0.021308336, -0.28987315, 0.2929442, -0.057600517, 0.0779305));
	target3 += mul(nf3, float4x4(-0.026810233, 0.11869411, -0.11281911, -0.14480188, -0.22689806, 0.28260702, 0.08524954, -0.016079135, -0.139977, 0.1590218, 0.24256052, 0.11876038, 0.1039834, 0.10720082, 0.15955658, -0.08241476));
	target3 += mul(ng3, float4x4(-0.0018456473, -0.044888236, 0.2312576, -0.2259125, 0.1552541, -0.10646746, 0.25436193, -0.0140782725, -0.11281806, -0.045578834, 0.089749135, -0.14050213, 0.09813328, -0.5474639, 0.084324725, -0.13670866));
	target3 += mul(nh3, float4x4(-0.18577714, 0.0991832, 0.02898408, 0.04317898, 0.25488335, -0.30257443, 0.0083487155, 0.00078779995, -0.0014885734, -0.116033524, -0.12751958, 0.20800439, -0.13863127, -0.14012383, -0.082795866, 0.07694529));
	target3 += mul(ni3, float4x4(0.124679685, 0.012901697, 0.15855546, -0.031145798, 0.044944238, -0.1519666, -0.015208867, 0.029840399, 0.07195047, 0.17145973, 0.06601934, -0.03358433, 0.16031715, 0.16808309, -0.007914282, -0.19619752));
	target3 += float4(-0.109316595, 0.025873583, 0.05582306, 0.10272255);

	float3 target4 = tex8.SampleLevel(sam, pos, 0).rgb;
	target4 += mul(e1, float4x3(0.037913825, -0.0099191405, -0.018130798, -0.0065440857, 0.004536478, -0.0019739012, -0.014918686, -0.00011652434, 0.0007071924, -0.0033633227, -0.018028691, -0.014883887));
	target4 += mul(e2, float4x3(-0.021300001, -0.039009467, -0.043097164, -0.008222791, 0.057612088, 0.063239105, 0.023676023, -0.0119777955, -0.020785704, 0.03422571, -0.009187399, -0.016286165));
	target4 += mul(e3, float4x3(0.031610258, -0.022373654, -0.04004249, 0.015456217, -0.014708875, -0.017118618, -0.0235428, 0.0103508085, 0.020143243, 0.0044788374, -0.017377898, -0.023227183));
	target4 += mul(ne1, float4x3(-0.036366682, 0.007874863, 0.016618004, 0.0022973057, -0.010600425, -0.012978575, 0.0070587453, 0.005480104, 0.0052379463, -0.02330911, -0.002091681, -0.0004570695));
	target4 += mul(ne2, float4x3(0.0011265673, 0.017461559, 0.01678395, 0.019458788, -0.032603145, -0.042017594, -0.026735391, 0.007520235, 0.01661426, -0.023014631, 0.027602635, 0.040214695));
	target4 += mul(ne3, float4x3(-0.05236764, 0.007274719, 0.023289332, -0.033428065, 0.0054935357, 0.014490033, 0.016193395, -0.012767524, -0.022695007, -0.01161452, 0.015592775, 0.017280621));

	tex1[gxy] = target1;
	tex2[gxy] = target2;
	tex3[gxy] = target3;
	tex7[gxy] = float4(target4, 1);
}

//!PASS 8
//!DESC Conv-4x3x3x24, Conv-3x1x1x120
//!IN INPUT, tex1, tex2, tex3, tex7
//!OUT OUTPUT
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass8(uint2 blockStart, uint3 threadId) {
	uint2 gxy = Rmp8x8(threadId.x) + blockStart;
	
	const uint2 outputSize = GetOutputSize();
	if (gxy.x >= outputSize.x || gxy.y >= outputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	float4 a1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c1 = tex1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d1 = tex1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e1 = tex1.SampleLevel(sam, pos, 0);
	float4 f1 = tex1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i1 = tex1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na1 = max(-a1, 0);
	float4 nb1 = max(-b1, 0);
	float4 nc1 = max(-c1, 0);
	float4 nd1 = max(-d1, 0);
	float4 ne1 = max(-e1, 0);
	float4 nf1 = max(-f1, 0);
	float4 ng1 = max(-g1, 0);
	float4 nh1 = max(-h1, 0);
	float4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	float4 a2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c2 = tex2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d2 = tex2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e2 = tex2.SampleLevel(sam, pos, 0);
	float4 f2 = tex2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i2 = tex2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na2 = max(-a2, 0);
	float4 nb2 = max(-b2, 0);
	float4 nc2 = max(-c2, 0);
	float4 nd2 = max(-d2, 0);
	float4 ne2 = max(-e2, 0);
	float4 nf2 = max(-f2, 0);
	float4 ng2 = max(-g2, 0);
	float4 nh2 = max(-h2, 0);
	float4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

    float4 a3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	float4 b3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	float4 c3 = tex3.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	float4 d3 = tex3.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	float4 e3 = tex3.SampleLevel(sam, pos, 0);
	float4 f3 = tex3.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	float4 g3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	float4 h3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	float4 i3 = tex3.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	float4 na3 = max(-a3, 0);
	float4 nb3 = max(-b3, 0);
	float4 nc3 = max(-c3, 0);
	float4 nd3 = max(-d3, 0);
	float4 ne3 = max(-e3, 0);
	float4 nf3 = max(-f3, 0);
	float4 ng3 = max(-g3, 0);
	float4 nh3 = max(-h3, 0);
	float4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	float4 target1 = mul(a1, float4x4(0.03482331, -0.14944118, 0.046244163, -0.05941585, -0.07728179, 0.06265427, -0.045520462, 0.0871402, 0.0897178, -0.16006349, 0.008391846, -0.16923702, 0.25602654, 0.051176835, 0.011442495, -0.24914353));
	target1 += mul(b1, float4x4(-0.114224955, -0.048990358, 0.0317376, 0.19175068, -0.112552375, 0.037553445, -0.095972225, 0.123118624, 0.12175324, 0.030322522, 0.054718968, -0.39031324, 0.28009677, 0.07727779, 0.16123495, -0.2772586));
	target1 += mul(c1, float4x4(-0.06794576, 0.2141763, 0.1750928, 0.12166446, -0.13643269, 0.24814922, 0.037389282, 0.0035949312, -0.06241508, 0.041635923, -0.08047354, 0.010511207, 0.11825532, -0.28878912, 0.17174155, -0.25881785));
	target1 += mul(d1, float4x4(-0.0143542895, -0.010602584, -0.04226417, -0.04447678, -0.24656619, -0.053967457, -0.16034846, 0.04648599, 0.18855657, -0.20268312, 0.03610814, 0.022015022, -0.056165848, 0.17901546, -0.044555657, -0.089903764));
	target1 += mul(e1, float4x4(-0.05440948, 0.12527943, -0.08222082, -0.035428505, 0.2267783, 0.08257505, 0.056446668, -0.016560426, 0.17754072, -0.12249645, 0.15439054, -0.03524935, -0.481085, -0.0961953, -0.3649979, 0.17484458));
	target1 += mul(f1, float4x4(0.04679537, 0.15213947, -0.018560365, -0.027304955, 0.012417035, 0.033497352, -0.09031395, -0.28588498, 0.15779394, -0.014294813, 0.13411845, 0.07399604, 0.05855495, -0.15351114, -0.06195114, -0.033846762));
	target1 += mul(g1, float4x4(0.023053877, 0.09145102, -0.056014817, -0.103127845, -0.19463558, 0.009014216, 0.045743883, 0.105235375, 0.148088, -0.071407385, 0.1755759, 0.012725914, 0.04554227, -0.10347383, 0.23475589, -0.039336383));
	target1 += mul(h1, float4x4(0.015826384, -0.042269874, 0.056471203, 0.009655403, 0.020275326, 0.33224702, 0.009298279, 0.17336445, -0.018828178, 0.10215806, 0.049400896, 0.17038062, 0.057019416, 0.07406004, 0.03215971, 0.12004367));
	target1 += mul(i1, float4x4(-0.04070164, 0.027889524, 0.02177609, -0.16229889, -0.062548086, -0.027596086, -0.12423675, 0.09836905, 0.059131406, -0.047028925, -0.057379283, -0.104133494, 0.14117907, 0.065780245, -0.023410192, 0.061447598));
	target1 += mul(a2, float4x4(-0.0021021653, 0.077328384, -0.06821109, -0.19499542, -0.20052336, 0.12387703, 0.055179324, 0.19800851, -0.120995775, 0.42741755, 0.091175236, 0.020587375, 0.0042481394, 0.12762432, -0.06114739, 0.32906154));
	target1 += mul(b2, float4x4(-0.019685917, -0.040947627, 0.18565354, -0.46952146, -0.05437026, -0.026286738, -0.07812705, -0.006736804, 0.008634472, 0.23204291, -0.11855498, -0.12303054, 0.38381273, 0.52490336, -0.3265505, 0.21160527));
	target1 += mul(c2, float4x4(-0.18054116, 0.0051548174, 0.4753756, 0.17605813, -0.073726274, 0.15002227, -0.1850507, 0.0990851, 0.00921903, 0.13224806, 0.2253796, -0.20556282, -0.109973975, 0.046794172, 0.16226935, 0.08110087));
	target1 += mul(d2, float4x4(0.010205323, -0.09720397, 0.029996833, -0.10599145, -0.052096535, -0.053859178, -0.07132246, -0.040684257, -0.0064441697, 0.20659602, 0.26825082, 0.05841878, -0.102910444, -0.19080183, 0.0009101689, 0.31210572));
	target1 += mul(e2, float4x4(-0.10222517, -0.2537438, 0.17752838, -0.08470953, 0.06963046, -0.010764146, -0.033626176, 0.15240349, -0.20436993, -0.100720614, 0.0444932, 0.20770444, 0.031174636, -0.010206393, 0.09037244, -0.55185884));
	target1 += mul(f2, float4x4(-0.26993337, -0.020421378, 0.18469644, -0.21327373, 0.06911363, 0.014826783, 0.056256857, -0.06809406, -0.083685525, -0.0984942, -0.0171533, -0.22855683, -0.08748469, -0.1396983, -0.11391806, -0.072031595));
	target1 += mul(g2, float4x4(0.058208484, -0.091674164, 0.12105436, 0.10939658, -0.031674437, -0.05118359, -0.22271338, 0.028467823, -0.17376278, -0.123112075, -0.071464434, 0.17473213, -0.3117644, -0.18276823, 0.07496323, 0.1509144));
	target1 += mul(h2, float4x4(-0.05188268, 0.15533312, 0.22820903, 0.17042106, -0.089846164, -0.005064528, 0.04796515, 0.026351674, 0.04572985, 0.09318132, -0.038517136, -0.074062705, -0.036520045, 0.10455916, 0.14278695, 0.14136232));
	target1 += mul(i2, float4x4(-0.14247061, 0.08110525, -0.075231634, 0.31358016, -0.18515967, 0.06256364, -0.0484006, -0.017976558, -0.02657821, -0.028635541, 0.012627999, 0.054765414, -0.0019829564, 0.15433973, -0.14973663, 0.12542003));
	target1 += mul(a3, float4x4(-0.17475623, 0.073300175, -0.18943344, 0.13311169, -0.026332445, 0.14347847, 0.20637734, 0.19913399, 0.24245638, -0.01550613, -0.09732818, -0.3588367, -0.11411046, -0.15500076, -0.09746209, -0.14517665));
	target1 += mul(b3, float4x4(0.17039534, -0.20694748, 0.07940825, -0.29572237, -0.26519805, 0.126274, -0.22870643, 0.064273715, -0.22092016, -0.03348832, -0.08794688, -0.006346166, -0.14190583, -0.16601795, 0.15920593, 0.097251594));
	target1 += mul(c3, float4x4(-0.08191819, -0.010720725, -0.10248115, -0.066204295, 0.13338344, 0.1886245, -0.1326061, -0.107134834, -0.06729155, -0.1295641, -0.09283412, -0.1643324, 0.06636283, 0.35525218, 0.0003396009, 0.04252375));
	target1 += mul(d3, float4x4(0.018834922, 0.09374041, -0.04844811, -0.086488485, 0.36477897, -0.035175197, 0.10250587, 0.009436049, 0.09109528, 0.25697815, 0.12989257, -0.10460797, 0.13357025, -0.15341914, -0.14009036, -0.27027166));
	target1 += mul(e3, float4x4(-0.046186987, -0.04721098, -0.10386561, 0.042765476, 0.10490874, -0.14259604, 0.03565186, 0.11228278, -0.1333764, 0.111047596, -0.20885478, 0.19843856, -0.07459371, -0.054204836, 0.0895249, 0.053722855));
	target1 += mul(f3, float4x4(0.057206515, -0.016081734, 0.04002097, 0.09536414, 0.27507696, 0.009611371, 0.2858957, 0.016278412, 0.091774575, -0.020857088, -0.1354684, -0.046553783, -0.10013868, 0.059088446, 0.1768699, 0.02272152));
	target1 += mul(g3, float4x4(0.028798534, 0.21127033, 0.01716753, 0.020965017, -0.08091736, -0.15006042, -0.29822782, 0.019595081, -0.029534074, -0.0653482, 0.11786061, -0.047803946, 0.011680036, 0.010721205, -0.2639438, 0.15042429));
	target1 += mul(h3, float4x4(-0.098251216, 0.050176363, -0.0426328, -0.037756715, -0.20687164, -0.3096553, -0.2210454, -0.03763596, -0.022159807, 0.044400796, 0.09344259, -0.05465652, -0.039273985, -0.096617654, -0.19118373, 0.1643556));
	target1 += mul(i3, float4x4(-0.11874077, 0.021691876, 0.15513967, -0.012177898, -0.1298149, -0.08811524, 0.017105984, -0.047422726, -0.033107523, 0.0058112773, -0.08017183, -0.020971343, -0.41264817, 0.075800754, 0.1080831, -0.082354255));
	target1 += mul(na1, float4x4(0.0032239188, -0.28178176, -0.19482347, 0.054150533, 0.40856144, -0.23284851, 0.020973913, -0.09307241, 0.4258893, -0.034946837, -0.043585345, 0.16226469, 0.045328375, 0.03566808, 0.0712809, 0.12283043));
	target1 += mul(nb1, float4x4(-0.15139721, -0.2489635, 0.2122619, -0.08517609, 0.23784684, -0.070994906, 0.3132446, -0.36519074, -0.048850738, -0.36088645, 0.2145936, 0.19312155, -0.2579365, -0.12489612, -0.075510584, 0.16864875));
	target1 += mul(nc1, float4x4(0.01884723, -0.2775977, 0.0007072475, 0.30131263, 0.01366198, -0.18196137, 0.38918743, -0.03999786, -0.075060904, -0.12210868, 0.14701048, 0.18474291, -0.023507686, 0.13071437, -0.036284998, 0.26304045));
	target1 += mul(nd1, float4x4(-0.08185283, -0.09152341, -0.13410091, -0.13518219, 0.10747411, 0.007974842, 0.11000113, 0.19898382, -0.18449086, 0.058887243, -0.02379909, -0.038734827, 0.041931048, 0.081884705, 0.015872778, 0.08416657));
	target1 += mul(ne1, float4x4(0.05272478, -0.06669923, 0.007233672, 0.039665744, 0.021820793, -0.14690521, -0.26392132, 0.007352069, -0.04682333, -0.028595299, -0.34463075, -0.14347489, 0.00084401644, -0.030389901, 0.022279145, 0.14215061));
	target1 += mul(nf1, float4x4(0.17942588, 0.27815622, 0.39199513, 0.17727011, -0.14894293, -0.1705316, 0.038263746, 0.025509953, -0.12031536, 0.15371376, -0.30855826, 0.2394013, -0.20185183, 0.121072985, 0.070580006, -0.12321835));
	target1 += mul(ng1, float4x4(0.043464154, -0.4329999, 0.12176987, 0.1863519, -0.14952634, -0.03741596, 0.3588594, 0.015720207, 0.07319453, 0.04202827, 0.19699398, -0.18537244, -0.040319767, 0.081377335, 0.045191478, -0.070804425));
	target1 += mul(nh1, float4x4(0.14033453, -0.13302796, -0.058896482, 0.14912021, 0.25856513, -0.10442178, 0.3958381, -0.08528721, 0.3291926, -0.0024321752, 0.017541584, -0.31020027, 0.13845283, -0.24636552, -0.07630463, -0.32314765));
	target1 += mul(ni1, float4x4(0.005189076, 0.20132092, 0.069775395, 0.086517565, 0.2727916, -0.079313666, 0.14164488, -0.16358389, -0.103817366, -0.11717267, 0.019068012, 0.016953465, 0.2551057, 0.14430785, 0.00088051375, -0.23318093));
	target1 += mul(na2, float4x4(-0.008894086, 0.03201216, -0.13398862, 0.06335705, 0.13424714, -0.06514535, -0.19045971, -0.23764557, 0.05714849, -0.30345356, 0.0092409095, 0.16878125, -0.07465451, -0.015541787, 0.033304304, -0.113849334));
	target1 += mul(nb2, float4x4(0.12612185, -0.0715257, 0.16217476, -0.024476554, 0.10614049, 0.03700835, 0.08482953, -0.08358318, 0.098786205, -0.009351742, -0.15457323, 0.113223985, -0.011500662, -0.13529003, -0.058090385, 0.11290306));
	target1 += mul(nc2, float4x4(0.050260257, -0.056368183, 0.21489042, 0.14299081, -0.113755986, -0.22816344, 0.27275258, -0.0015117057, 0.14195545, -0.16299947, 0.049762867, 0.22725838, 0.06814647, -0.049368583, -0.08577855, -0.097503126));
	target1 += mul(nd2, float4x4(-0.0083364155, -0.052837223, -0.0846245, 0.053218696, 0.28152695, 0.19495425, -0.19180301, -0.26389152, -0.12953846, -0.102649055, -0.19722337, -0.15851225, 0.1725756, 0.056898903, 0.01023057, -0.033678));
	target1 += mul(ne2, float4x4(-0.044510186, 0.033060472, 0.26517934, -0.25734264, 0.11998833, -0.05369093, 0.19721112, -0.15774135, 0.061851945, -0.03981009, -0.034191426, -0.23678938, -0.013630672, -0.114661574, 0.096060224, 0.17892191));
	target1 += mul(nf2, float4x4(-0.14728574, -0.031724717, 0.13967156, 0.03676961, -0.09500629, -0.09584641, -0.3221665, 0.14028065, -0.09116274, -0.08160823, -0.03841335, 0.21315134, -0.025303967, -0.081841856, 0.024239374, 0.004911813));
	target1 += mul(ng2, float4x4(-0.16211908, -0.07225985, -0.06955749, 0.025049562, 0.016382609, 0.20329225, 0.23490642, 0.04267578, -0.008350769, 0.0037089891, 0.09515623, -0.06105943, 0.13584909, 0.09705268, -0.062350716, -0.074614085));
	target1 += mul(nh2, float4x4(0.025970146, -0.14939465, -0.08123037, -0.008690572, 0.16139375, 0.052395687, -0.03863909, 0.0953437, -0.103880964, -0.04672169, -0.078161545, 0.04628746, -0.019205566, -0.006394265, -0.009116098, 0.024979865));
	target1 += mul(ni2, float4x4(0.15779239, 0.009630995, -0.06269132, -0.11111548, 0.11478004, -0.0780718, -0.24617292, 0.05763241, 0.02476824, 0.0631411, -0.2777113, -0.010855008, 0.10766442, 0.020561088, -0.029775767, -0.060535327));
	target1 += mul(na3, float4x4(0.6058991, -0.29998928, -0.09883167, -0.36967963, 0.104703955, -0.1886391, 0.07915164, -0.02375336, 0.041111898, 0.09216705, 0.046296816, 0.24895348, -0.015484279, 0.06852782, 0.04170421, -0.008594877));
	target1 += mul(nb3, float4x4(-0.29542375, -0.11578118, -0.047219444, -0.10781526, 0.13507344, 0.09601799, 0.08975014, 0.09067836, 0.1565405, 0.082328156, 0.09181261, 0.04524675, -0.08546339, 0.107942745, 0.057727177, 0.15223116));
	target1 += mul(nc3, float4x4(-0.013349778, 0.15176241, -0.08432594, 0.10960892, 0.081638165, -0.13559791, -0.06557744, 0.01141079, 0.10179259, 0.35195625, 0.23831062, 0.13698545, -0.0073695974, -0.020154724, -0.2515228, 0.030157704));
	target1 += mul(nd3, float4x4(0.20604958, -0.09164565, 0.049274493, -0.111016676, -0.046125744, -0.22138667, -0.10698992, 0.07003299, 0.09432274, 0.13457412, 0.08988733, 0.16862586, -0.16797546, -0.0130331, -0.009054985, -0.01443074));
	target1 += mul(ne3, float4x4(-0.17840317, -0.079730295, 0.11214133, -0.015679857, 0.07462782, 0.1700189, -0.03588104, -0.055766776, 0.2527381, -0.040385213, 0.18867272, 0.15786001, -0.03973228, -0.053887095, -0.001591716, -0.050709404));
	target1 += mul(nf3, float4x4(0.24581482, 0.09119475, 0.049080588, 0.25806418, -0.005062941, 0.10484669, 0.05778071, 0.23681131, -0.09603774, 0.009163983, 0.19752978, 0.104258336, 0.13455175, -0.0034275826, -0.080408186, 0.10462319));
	target1 += mul(ng3, float4x4(0.07782564, -0.2789083, -0.13887207, -0.019308591, 0.25710207, -0.21921843, 0.0015911289, 0.080053106, -0.014144128, 0.074144535, 0.043883692, 0.2513407, 0.10068346, -0.17853074, 0.20460746, 0.04092755));
	target1 += mul(nh3, float4x4(-0.048100162, 0.042697787, -0.04842476, 0.18837112, 0.051532917, 0.088649124, -0.014739274, -0.023566334, 0.44025096, -0.10545216, -0.19667506, 0.097041525, 0.0008772463, -0.05555525, 0.069248185, 0.1176431));
	target1 += mul(ni3, float4x4(-0.01590801, 0.016883895, -0.09720278, 0.14969985, -0.099172674, -0.04525934, 0.13815412, 0.024430253, 0.0247448, 0.015865842, -0.10956577, 0.22523156, 0.22455531, -0.100728914, -0.053454183, 0.13590883));
	target1 += float4(-0.06673833, 0.01457202, -0.036676105, -0.06303146);
	
	float4 target2 = mul(a1, float4x4(0.23879923, 0.040317934, 0.22145784, -0.08336839, -0.16966912, 0.08528278, 0.2684323, 0.17057978, 0.1467542, -0.041414198, 0.03689633, 0.10483362, 0.04390369, 0.2617799, 0.13374175, 0.21909657));
	target2 += mul(b1, float4x4(0.013090143, 0.010181773, -0.022144144, -0.038787983, 0.17343685, 0.06579225, 0.036516637, -0.18973681, 0.11963511, 0.111920275, 0.13276073, 0.04570385, -0.009538788, -0.028358553, 0.06043411, 0.14202546));
	target2 += mul(c1, float4x4(0.2273523, 0.086418256, 0.058296323, -0.023292154, -0.016248869, 0.08703014, -0.14549017, 0.15725356, 0.26235282, 0.13655783, 0.06703612, -0.0746187, 0.18931058, -0.009649255, 0.27345505, 8.478176e-05));
	target2 += mul(d1, float4x4(-0.033401724, -0.064518325, -0.15034138, 0.05246805, 0.058772895, -0.176813, 0.078342214, -0.0020414025, 0.06217457, -0.20738979, -0.16368344, 0.03266785, 0.04921403, 0.112299785, -0.123247504, 0.0994201));
	target2 += mul(e1, float4x4(-0.2553642, 0.14918567, -0.14866059, -0.03617286, 0.032998353, -0.15592867, 0.087743975, -0.00049046543, -0.32823107, -0.107454315, 0.002674161, -0.01887908, 0.0833454, -0.03806806, -0.14595793, -0.20520253));
	target2 += mul(f1, float4x4(0.02986423, 0.028604368, -0.011768948, 0.10195398, -0.102379754, 0.1362889, -0.041802816, -0.084387876, -0.008137814, 0.09726054, 0.10758101, 0.09259081, -0.07889878, -0.07312139, 0.17478421, -0.033481717));
	target2 += mul(g1, float4x4(0.058965955, 0.024142284, 0.22129168, 0.04082889, 0.15887728, 0.103434056, -0.21192761, 0.06533756, 4.1846484e-05, -0.24297993, 0.17849778, -0.115734324, -0.11500629, 0.15694802, 0.04261307, 0.17415777));
	target2 += mul(h1, float4x4(0.01345909, 0.017319864, -0.0520044, 0.06891368, 0.078165226, -0.07047419, -0.013746107, -0.058885146, -0.10569072, -0.032166608, -0.02835551, -0.09911323, -0.062442902, 0.13147296, 0.1815978, -0.0042537497));
	target2 += mul(i1, float4x4(0.1606494, 0.05220283, 0.13166267, 0.10574164, -0.19102532, 0.03446111, -0.055919666, 0.057688963, 0.26081654, 0.03648174, 0.03616491, 0.046591155, 0.21643688, 0.052122388, 0.050889883, 0.29552755));
	target2 += mul(a2, float4x4(-0.024097791, -0.080628626, 0.12568358, 0.12252691, -0.16359662, 0.0051886803, -0.01954068, 0.02195983, -0.18788633, -0.030897139, -0.09377947, 0.15688346, -0.14129396, -0.11748491, -0.3835284, -0.022647042));
	target2 += mul(b2, float4x4(0.11930519, 0.24957322, 0.015541883, -0.11232224, -0.058490105, -0.049757216, 0.075522415, 0.09442181, 0.076607205, 0.037432365, -0.08629132, 0.008422209, -0.013450555, 0.10305229, -0.04537291, -0.08230579));
	target2 += mul(c2, float4x4(-0.050578903, -0.20879799, -0.04393353, 0.0015126837, -0.23416555, 0.01141535, -0.009691543, 0.06217469, -0.10707423, 0.20022671, 0.15437399, -0.04760398, -0.14287886, 0.2682982, -0.2561911, 0.033707578));
	target2 += mul(d2, float4x4(0.11812356, -0.29858422, 0.09146616, 0.052722417, -0.023986591, 0.0933364, 0.14801602, -0.10148, -0.15320316, -0.0028770058, -0.103183694, -0.006425709, 0.021735031, -0.47796893, -0.18304059, 0.084628224));
	target2 += mul(e2, float4x4(-0.09104168, 0.03286581, 0.04459324, -0.22438659, 0.12870388, -0.1360097, -0.15926069, 0.071017005, 0.074596204, -0.09715285, -0.07479851, -0.20799732, -0.29060403, -0.107118085, 0.25210482, 0.16397184));
	target2 += mul(f2, float4x4(-0.12460523, 0.16706169, 0.30230346, 0.054767944, -0.116781175, 0.19446343, -0.21735692, -0.026413433, 0.052394047, 0.020679068, -0.15584053, 0.061340448, 0.04663544, 0.27504724, 0.20286065, 0.3490867));
	target2 += mul(g2, float4x4(0.21607491, -0.21738917, -0.009051781, -0.07276944, 0.3103053, 0.15334722, 0.28409463, -0.17096485, 0.031179685, 0.2009012, -0.26543948, -0.19882691, 0.032035686, -0.35383067, -0.17236927, -0.113232605));
	target2 += mul(h2, float4x4(-0.11165131, -0.2941282, -0.029304054, 0.106581636, 0.21548472, -0.21285897, -0.043579012, -0.047211695, 0.027249131, 0.28340155, 0.082085736, -0.04485162, -0.24723412, -0.0007002699, 0.19643609, 0.2518287));
	target2 += mul(i2, float4x4(-0.1854792, -0.008842361, -0.08581101, 0.16760491, -0.10669554, 0.21352866, 0.1252966, -0.04194005, -0.07666296, 0.07259658, 0.10786684, -0.03364238, 0.1547786, -0.018965635, -0.13252488, 0.23715465));
	target2 += mul(a3, float4x4(0.1451508, 0.10011578, 0.07156718, 0.04740723, -0.19702536, 0.06286184, -0.29180148, -0.30204237, -0.07179627, 0.056043524, 0.27749023, -0.07051612, 0.1010544, -0.008737285, -0.13163415, -0.066848055));
	target2 += mul(b3, float4x4(0.07561846, -0.14928432, 0.027951663, -0.07524044, 0.10025779, -0.21305043, 0.008214884, 0.16192347, 0.04002263, -0.10425787, 0.018522112, -0.08742078, 0.039168026, 0.010691633, 0.0025965972, -0.016103525));
	target2 += mul(c3, float4x4(-0.045149434, 0.033272427, 0.06018518, -0.068993434, 0.017645787, 0.27027842, -0.25670657, 0.04577214, 0.002479582, -0.051434338, 0.25425145, -0.093131274, 0.09688695, 0.14416668, -0.1216349, 0.0229849));
	target2 += mul(d3, float4x4(0.030369451, 0.020748299, 0.034542933, 0.09359397, -0.37202555, 0.2808392, -0.2659807, -0.01941035, -0.22399698, 0.08132304, -0.0014507625, -0.017793491, 0.037623137, -0.029477628, -0.0720025, -0.15816812));
	target2 += mul(e3, float4x4(0.33115733, -0.013734702, 0.0101467, -0.12268663, 0.43017596, -0.32643738, -0.3273918, 0.1109477, 0.10758731, 0.070155494, -0.24037434, -0.0016639809, -0.06652544, 0.13758285, -0.072496586, -0.10106904));
	target2 += mul(f3, float4x4(0.19126198, -0.14967397, -0.18345782, -0.08460439, 0.13229868, -0.21144699, -0.058821946, -0.5039749, 0.24892776, 0.20228972, -0.06919527, -0.15942183, 0.12435562, -0.012193792, -0.2627704, 0.13625085));
	target2 += mul(g3, float4x4(-0.10896958, 0.044015855, -0.0181369, 0.10650041, -0.24092299, 0.18979153, -0.26630878, 0.06806665, -0.17771733, -0.2699458, -0.1144395, 0.014184961, -0.288627, -0.19622655, 0.39838296, -0.11162213));
	target2 += mul(h3, float4x4(-0.084831044, -0.02721028, 0.109261006, 0.087307416, -0.33783588, 0.08306577, -0.027817784, -0.10534335, -0.15593721, -0.013186225, -0.011052375, 0.10786937, -0.00060474424, 0.00431786, 0.38164118, 0.14728197));
	target2 += mul(i3, float4x4(-0.26669395, -0.09910907, 0.03960142, -0.21382816, -0.5042419, -0.12542717, 0.07396011, -0.24485987, -0.1770452, -0.00011720843, 0.11425563, 0.07332528, -0.06640686, -0.11683248, 0.003071298, 0.05543171));
	target2 += mul(na1, float4x4(-0.16784829, -0.031949766, -0.043842897, -0.09577157, 0.16381639, -0.33382246, -0.10782627, 0.07903589, 0.04620696, -0.04180326, -0.09783348, 0.3095548, 0.06762379, 0.021955997, -0.14974354, -0.143973));
	target2 += mul(nb1, float4x4(-0.14442697, -0.044818707, 0.025801856, 0.08461569, -0.20247138, 0.060513508, -0.1674155, 0.13058512, -0.08026784, -0.3141148, -0.04791329, -0.14586422, 0.16113773, -0.035697844, 0.21863447, -0.099939525));
	target2 += mul(nc1, float4x4(-0.298011, -0.053686857, -0.31031471, 0.11162896, 0.22341007, -0.052881762, 0.13043529, 0.15810435, -0.37888956, -0.31480342, 0.33116004, 0.06646278, -0.05665705, -0.03861846, 0.083101824, 0.003781792));
	target2 += mul(nd1, float4x4(-0.08649798, -0.1088245, 0.32511878, -0.16572024, 0.050254185, -0.252013, -0.040132295, 0.17312634, -0.016653338, -0.43009317, 0.5093538, 0.06922151, 0.08760091, -0.14250961, 0.4053319, -0.10107622));
	target2 += mul(ne1, float4x4(0.083406106, -0.16932109, 0.06787343, -0.05178522, -0.20603026, -0.09058593, 0.16128129, -0.22712888, 0.05429396, -0.15098302, 0.3041655, -0.07668127, -0.15419695, 0.4462755, 0.1874267, 0.17312653));
	target2 += mul(nf1, float4x4(0.19148338, 0.052311547, -0.13830717, 0.2996034, 0.05850986, 0.05484371, 0.0361025, 0.20699011, 0.0057291416, -0.12026241, 0.02678267, 0.12696257, -0.019684052, -0.09031823, 0.15297134, 0.13705085));
	target2 += mul(ng1, float4x4(-0.20881316, 0.14526081, -0.41917932, -0.16191165, 0.1262819, -0.23026188, -0.2561112, 0.049415354, -0.1497713, -0.009612483, -0.070241526, -0.039475128, 0.093497746, -0.1318667, -0.105637155, -0.21147394));
	target2 += mul(nh1, float4x4(0.042843655, -0.11218648, 0.013391185, 0.06646476, -0.24418473, -0.037722886, 0.08446243, -0.0018849184, 0.030670485, 0.27686, -0.15015033, 0.21402857, 0.10094001, 0.3145764, -0.17310384, -0.10199286));
	target2 += mul(ni1, float4x4(-0.14084649, 0.0033693435, -0.34370998, 0.1079324, 0.28795156, 0.14933614, 0.10669996, 0.12305359, -0.040551323, -0.07330404, -0.15179317, 0.069975436, 0.2920918, 0.020814283, -0.13944869, 0.09579582));
	target2 += mul(na2, float4x4(0.10180969, -0.021659529, -0.13541374, 0.0908069, 0.11346961, -0.0011830843, -0.19612141, -0.11018402, 0.12915576, -0.095653616, -0.13800405, -0.18932076, 0.12277476, 0.09764832, 0.114954636, -0.1578187));
	target2 += mul(nb2, float4x4(-0.07191152, -0.053082727, -0.067936264, 0.045203943, 0.13166252, 0.23256709, -0.288239, -0.08163785, -0.020897634, 0.15756424, -0.17083916, -0.13654962, -0.021136044, -0.14208466, -0.0040715886, 0.03707775));
	target2 += mul(nc2, float4x4(0.15754776, -0.042640373, -0.033360127, -0.06743833, -0.06533689, -0.16307046, -0.018182967, -0.060084824, -0.087093055, 0.036133945, -0.23553473, -0.40821072, -0.053628575, 0.026669571, 0.19045922, -0.035846557));
	target2 += mul(nd2, float4x4(0.07448724, 0.067469016, -0.066770956, 0.0030078532, -0.1173964, -0.012352791, -0.19451907, -0.021427047, 0.19994271, -0.0029543424, -0.034913633, 0.13859013, 0.048614684, 0.193721, -0.09548589, -0.026358109));
	target2 += mul(ne2, float4x4(-0.3411652, 0.23141026, 0.10978134, 0.07787867, -0.18412182, 0.15478246, 0.25846902, -0.13144507, -0.28535685, 0.086631864, 0.12785226, 0.0033878016, 0.03504869, -0.034950025, -0.17758164, 0.024054492));
	target2 += mul(nf2, float4x4(-0.019755604, -0.21744813, 0.14325249, 0.21274537, -0.04985571, -0.24407099, -0.02035735, 0.21803972, -0.16886176, -0.05224696, 0.20342873, -0.18543948, 0.0096319495, -0.1624773, 0.14216544, -0.081235185));
	target2 += mul(ng2, float4x4(0.20382723, -0.16942358, -0.15685835, 0.024889609, -0.3226424, -0.10469345, -0.46887016, 0.016228858, -0.1362387, -0.13054538, -0.0783913, -0.06385014, -0.08139782, 0.12035177, 0.21293128, -0.045476373));
	target2 += mul(nh2, float4x4(0.13462923, 0.1384135, -0.055161975, -0.099216595, -0.16864173, -0.15129986, -0.2535725, 0.22653887, -0.11102492, -0.09068262, -0.0044067153, -0.0603752, -0.095367156, -0.056415606, 0.0075126593, -0.009610249));
	target2 += mul(ni2, float4x4(0.1393697, 0.13611916, 0.090671785, 0.08593501, 0.07983876, -0.0068050954, -0.28696343, -0.17570612, -0.075322844, 0.06774856, -0.086022906, 0.09080408, 0.022836372, 0.018536389, 0.042727504, -0.043635663));
	target2 += mul(na3, float4x4(-0.0050578844, -0.04774735, 0.004759578, 0.09087925, 0.16171533, 0.01599633, 0.08316812, -0.09584462, 0.119889505, 0.003919012, -0.21555036, 0.2426096, -0.12047291, 0.10978759, -0.33754483, 0.15740488));
	target2 += mul(nb3, float4x4(-0.11716536, 0.08724526, -0.023726968, -0.12922543, -0.05567669, -0.021379862, -0.2031672, -0.023840401, -0.024058433, -0.081542544, -0.19171208, 0.051525865, -0.008789576, -0.16808029, -0.049115162, 0.052190997));
	target2 += mul(nc3, float4x4(0.13842055, -0.13871577, 0.0954928, 0.19763501, -0.049218517, -0.21299022, -0.14797242, -0.0996971, 0.004526675, -0.107513115, -0.31193256, -0.13720018, 0.01550265, 0.017279146, -0.03583415, 0.053429827));
	target2 += mul(nd3, float4x4(-0.0723815, 0.034265626, 0.20389315, -0.14053439, 0.18389022, 0.033574764, -0.039723963, -0.14978175, -0.084361784, -0.15831995, 0.49169922, -0.09837507, 0.0017199022, -0.09433373, 0.13506836, -0.06360633));
	target2 += mul(ne3, float4x4(-0.1265364, 0.24196059, 0.21346883, -0.035202276, -0.16924065, -0.039915517, 0.15855956, -0.00046526943, -0.30319792, 0.47292793, 0.19538064, -0.046434846, 0.0041063935, 0.026737224, 0.14377008, -0.086429365));
	target2 += mul(nf3, float4x4(-0.052318633, 0.01695744, 0.073576115, 0.2596724, -0.062066127, -0.051519766, -0.051504273, 0.05866547, -0.08328452, -0.28105405, 0.078826845, 0.18008032, 0.18682955, 0.0076535186, -0.05532054, -0.20601955));
	target2 += mul(ng3, float4x4(0.11029233, 0.16958456, 0.06657061, -0.019656291, 0.11484087, -0.044068743, 0.24364337, -0.0065622316, 0.28941217, 0.18499708, -0.19709894, -0.19475468, 0.03503256, -0.05113357, 0.10653205, 0.01789133));
	target2 += mul(nh3, float4x4(0.23000862, 0.21053173, -0.18862817, 0.17935936, -0.15975583, -0.05371, -0.012876548, 0.16915809, 0.048503194, 0.16087084, 0.013947819, -0.2625692, -0.07422495, 0.12091095, -0.07861796, -0.10306009));
	target2 += mul(ni3, float4x4(0.22752777, 0.25302207, -0.12559423, 0.32303494, 0.048354533, -0.09707823, -0.08385863, 0.14718369, 0.08453127, -0.12578502, 0.2255726, 0.28436616, 0.11673125, -0.109367356, -0.024817433, -0.061155386));
	target2 += float4(0.09436162, 0.053628888, -0.037304673, 0.07278107);

	float4 target3 = mul(a1, float4x4(-0.06848254, 0.17351831, 0.08460523, -0.04292461, 0.16476814, 0.12880002, -0.2188432, -0.14287443, -0.03620956, 0.03190214, -0.048488446, 0.13175257, -0.03531708, 0.25060365, -0.06213195, 0.12620556));
	target3 += mul(b1, float4x4(-0.002136314, 0.14399742, 0.033703934, 0.04852668, 0.044694893, 0.044961825, -0.049827278, -0.043917865, 0.13977914, -0.08126432, -0.14917606, 0.04644499, -0.14825742, 0.14075856, 0.03092348, -0.093371935));
	target3 += mul(c1, float4x4(-0.10156521, 0.17292573, 0.12147806, 0.058286913, 0.036107652, 0.11812006, -0.052188348, -0.018111996, -0.033433035, 0.13158733, 0.11174768, 0.3135695, -0.031843673, 0.14830989, 0.094200954, 0.046325628));
	target3 += mul(d1, float4x4(-0.020032655, -0.07413829, 0.08400475, -0.096378304, 0.018955225, 0.022839474, 0.0059678215, -0.1027026, -0.028222635, -0.14191163, 0.1683382, 0.12842403, -0.0019999016, -0.10452298, -0.00084425067, 0.21517049));
	target3 += mul(e1, float4x4(0.01772144, -0.055037472, -0.26999003, 0.08729775, -0.36895162, 0.011868349, 0.09449699, -0.098540016, -0.12167021, -0.14711088, 0.12771331, -0.23740645, 0.15759817, -0.19454266, 0.16208373, 0.24910314));
	target3 += mul(f1, float4x4(-0.01581086, 0.055212107, 0.09454114, 0.04507513, 0.06458917, 0.07870699, 0.043557264, -0.057501283, 0.20402664, 0.22241214, 0.04460486, 0.08704935, 0.16451277, -0.13080528, 0.039666496, -0.026260905));
	target3 += mul(g1, float4x4(0.052181657, 0.027077725, 0.06572071, 0.031183861, 0.10252249, -0.08605668, 0.041842632, -0.103617065, -0.10870241, 0.04929309, -0.036834683, 0.035595864, 0.05496096, -0.067191675, -0.021810448, 0.040137228));
	target3 += mul(h1, float4x4(0.12943552, 0.027362846, -0.04002257, 0.06176385, 0.03362332, -0.10467882, 0.33771384, -0.002079538, -0.14528175, 0.14312474, 0.02974133, -0.06945553, -0.33208638, -0.1682957, 0.08194348, -0.072072215));
	target3 += mul(i1, float4x4(-0.10689992, 0.0904542, 0.13820268, 0.13239543, -0.15937562, -0.123537876, -0.33618236, -0.081022464, 0.024027856, 0.26380306, -0.09225592, 0.040485747, -0.01705172, -0.049895052, -0.07952754, 0.030036716));
	target3 += mul(a2, float4x4(-0.1259129, 0.018831972, -0.1832129, 0.01803401, 0.033666562, -0.17717862, 0.087922215, -0.10147714, 0.045267824, -0.25754488, -0.08662288, 0.10354607, 0.10469745, 0.19675997, -0.20195517, 0.24481302));
	target3 += mul(b2, float4x4(-0.094946206, 0.015489291, -0.1777193, 0.037065975, 0.024963535, -0.3277457, -0.08534422, -0.08319194, -0.18495774, -0.09883332, -0.053772286, 0.08554662, -0.1215341, 0.15887743, -0.2965043, -0.11656119));
	target3 += mul(c2, float4x4(-0.34576485, -0.14033535, 0.07531725, -0.14229001, 0.08308607, -0.31519765, -0.15306507, -0.072686926, -0.12345635, -0.08589443, 0.015977165, -0.0041419766, -0.49153492, 0.3021553, 0.16130814, -0.17035122));
	target3 += mul(d2, float4x4(-0.08059237, -0.18008304, 0.23508278, -0.08894493, 0.11107956, 0.23715645, 0.091440715, -0.033679005, 0.23545177, 0.011845169, 0.0054449392, -0.30073527, 0.2796674, -0.1411897, -0.014096338, 0.115184374));
	target3 += mul(e2, float4x4(0.19655375, 0.027063202, -0.3324798, 0.29343468, -0.10879405, 0.16780332, -0.019309124, 0.04614956, 0.15054315, 0.19951852, 0.14648122, 0.28885373, 0.037958838, -0.34874088, -0.025065463, -0.19422896));
	target3 += mul(f2, float4x4(-0.18047136, 0.060818356, -0.13610844, -0.018481744, -0.09979387, 0.0477093, 0.032326147, -0.10137375, -0.059743475, 0.05039489, 0.17306165, -0.005998121, -0.009583858, -0.14829919, 0.24446519, -0.22378124));
	target3 += mul(g2, float4x4(0.45342392, 0.19783214, -0.042264447, 0.11951815, 0.017209506, 0.119354434, -0.089858785, 0.03950267, -0.19266395, -0.07500372, -0.02151692, -0.008635288, -0.14962971, -0.00780355, 0.18662006, -0.0046807216));
	target3 += mul(h2, float4x4(-0.13184623, -0.04977233, -0.08034406, -0.08663693, -0.06438305, -0.06699197, 0.15878884, 0.014209137, -0.018352475, -0.12698355, -0.18104841, -0.03212089, -0.31992742, 0.13199449, -0.039823674, -0.18864588));
	target3 += mul(i2, float4x4(-0.22096959, -0.06594324, -0.093964286, -0.069787376, -0.05717438, 0.18509367, -0.19014412, -0.11233723, -0.043684576, -0.04049064, -0.015180749, 0.04026833, -0.09723803, -0.014410513, -0.14038773, -0.20472965));
	target3 += mul(a3, float4x4(-0.020113828, 0.06306164, 0.1133604, -0.03264297, -0.019580074, -0.28136805, 0.046105113, -0.104369484, 0.047211405, -0.11510891, -0.2610411, -0.24363835, -0.15579234, 0.13080037, -0.2414289, -0.21552382));
	target3 += mul(b3, float4x4(-0.030723298, 0.10005462, -0.046389453, -0.42023477, -0.0900144, -0.3300974, 0.2023873, 0.47113106, -0.10733436, 0.13536386, 0.11873528, 0.075008325, -0.092727005, 0.16694772, -0.12538053, -0.019201787));
	target3 += mul(c3, float4x4(-0.020229753, 0.0050342986, -0.09015966, -0.23845413, 0.14204682, -0.24106354, 0.007471734, 0.21428482, -0.059586413, -0.07984075, 0.1474898, -0.12583902, -0.34393194, 0.08484377, -0.40459237, 0.32322514));
	target3 += mul(d3, float4x4(-0.11741491, -0.083517544, 0.04531866, -0.048355322, 0.15782192, 0.07919051, -0.34528416, -0.17551522, -0.20325756, -0.13701133, -0.09564707, -0.03711687, 0.030484512, -0.107849605, -0.09412398, -0.28914952));
	target3 += mul(e3, float4x4(-0.013266804, -0.035421904, 0.081956826, 0.15579522, 0.12775496, 0.1479336, 0.46652517, 0.21593826, -0.23207328, -0.13872643, 0.09056148, 0.1257084, 0.40673763, 0.14669922, 0.14093073, -0.31729355));
	target3 += mul(f3, float4x4(-0.03632805, 0.06513459, -0.13029967, 0.24914533, 0.08398421, -0.12399063, 0.15374567, 0.003005163, -0.03301567, 0.010896424, -0.10409926, -0.031162843, -0.080630526, 0.313793, -0.04112272, 0.06908576));
	target3 += mul(g3, float4x4(0.056705862, 0.04045318, -0.13523346, -0.12563162, 0.030291703, -0.22721136, -0.19567032, -0.22538094, -0.078549854, 0.16844983, -0.09419901, 0.1000363, -0.052691363, -0.14642943, -0.17214452, -0.23522456));
	target3 += mul(h3, float4x4(0.09823313, -0.16931288, 0.2667816, 0.019992903, 0.09905936, -0.14416765, 0.022824166, -0.02994203, 0.05482313, 0.0073759295, -0.087138794, -0.10250613, 0.22704037, -0.33540174, 0.059272785, -0.08828277));
	target3 += mul(i3, float4x4(0.05405852, 0.0015277737, 0.15057512, 0.008105634, 0.26466554, 0.021303358, 0.21576874, -0.055405084, 0.20417419, -0.1829464, 0.19177821, -0.10549947, -0.10019333, -0.04373452, 0.3086124, -0.030007664));
	target3 += mul(na1, float4x4(0.18547705, 0.015533089, -0.17023557, -0.14218459, -0.109183766, -0.21892494, -0.08033779, 0.1279889, 0.21425895, 0.31563443, 0.055812337, 0.035239376, 0.04874699, -0.03926052, 0.25620237, 0.05620038));
	target3 += mul(nb1, float4x4(0.17809738, -0.090085454, 0.086938836, 0.21705364, 0.057283174, 0.022287775, -0.21651776, -0.0027429194, 0.04257827, 0.17341158, 0.32710707, -0.029889492, 0.23903793, -0.038499728, 0.208562, 0.18147011));
	target3 += mul(nc1, float4x4(-0.02671488, -0.2577291, -0.101831675, -0.043231912, -0.08192727, -0.09351345, 0.10333126, 0.42192927, 0.11358276, 0.17070638, 0.11954223, -0.31113386, 0.21822956, 0.040758308, 0.18557602, -0.04927389));
	target3 += mul(nd1, float4x4(0.016825153, -0.16034372, 0.13393559, 0.0031862713, -0.07210358, 0.12088922, 0.18472868, 0.19526374, -0.098638535, -0.26882744, 0.01246303, -0.023679085, -0.07282684, 0.10335254, 0.11371582, -0.11949346));
	target3 += mul(ne1, float4x4(-0.0077989995, -0.06316807, -0.037497815, 0.010178734, -0.028329156, -0.109135084, -0.18357074, 0.40579423, -0.05144428, -0.28490487, -0.11653807, 0.22959495, -0.109780535, 0.22878933, -0.29027545, 0.17875119));
	target3 += mul(nf1, float4x4(-0.15628323, -0.07819484, -0.22514449, 0.065008484, -0.0055398177, -0.07419974, 0.09902451, 0.35817552, -0.0862891, -0.2973468, -0.10211232, 0.09778022, -0.08562242, -0.08868644, 0.30707374, 0.16413328));
	target3 += mul(ng1, float4x4(0.004233512, 0.02434783, -0.12356794, 0.13752618, 0.21815947, 0.16979212, 0.3382205, 0.15363333, -0.14368188, 0.10208307, 0.16594398, -0.002474651, -0.25072917, 0.19654895, 0.15537341, -0.011402132));
	target3 += mul(nh1, float4x4(0.1492285, -0.102569796, -0.15423858, 0.03359016, 0.008948687, 0.11137203, -0.0753569, -0.15314926, -0.22925344, 0.1943656, -0.4934053, 0.42356676, -0.10820874, 0.23832525, -0.4461194, 0.19386442));
	target3 += mul(ni1, float4x4(0.30649734, 0.061961878, -0.17697462, -0.29313368, 0.19318691, 0.14972912, -0.04568052, 0.123596475, -0.018475438, 0.33577895, -0.17800568, 0.12502621, 0.032249834, 0.013487416, -0.019249933, 0.004653166));
	target3 += mul(na2, float4x4(0.11560085, -0.030997908, 0.009219462, 0.05633901, -0.11158907, 0.09791856, -0.111877, -0.020388048, -0.25937706, -0.000673325, 0.106495194, 0.15643579, 0.022090284, -0.11573403, 0.123260945, -0.033783972));
	target3 += mul(nb2, float4x4(-0.061418246, 0.13925532, 0.070662834, -0.10297572, -0.08535479, 0.31824788, 0.08315885, 0.012375857, 0.04241964, 0.21071856, -0.18567438, -0.26859924, 0.09607365, -0.19106552, 0.1222843, 0.20521446));
	target3 += mul(nc2, float4x4(-0.1985242, 0.40886146, -0.03295415, 0.25985515, 0.00024564067, 0.22053646, 0.4425157, 0.030073104, 0.15870823, 0.3720021, -0.19778733, -0.11957699, 0.23951907, -0.022089735, 0.026504006, -0.1143626));
	target3 += mul(nd2, float4x4(0.07811988, 0.06360271, -0.18825488, 0.05489923, -0.316614, -0.2020329, -0.17215219, -0.1163882, 0.028907632, 0.13332835, 0.07710604, 0.15564129, -0.08207378, 0.2586524, -0.15368843, -0.026250634));
	target3 += mul(ne2, float4x4(0.1154507, 0.05374841, -0.35887244, -0.38684267, 0.024906285, -0.051356003, 0.06727699, -0.13258685, -0.04512674, -0.0630682, -0.016046045, -0.3630216, -0.10115332, 0.06723903, 0.10273197, 0.01658071));
	target3 += mul(nf2, float4x4(0.035411883, -0.10390069, 0.28300494, -0.030523226, 0.260309, -0.2897127, 0.17530721, 0.06502907, 0.10852879, 0.0101283565, 0.04377248, -0.14661616, 0.07372457, 0.029455552, -0.024029268, 0.019606834));
	target3 += mul(ng2, float4x4(0.06462741, -0.017584527, 0.05204551, 0.023974337, -0.09858389, -0.12002433, 0.051191356, -0.15688013, 0.1415572, -0.121506944, 0.4219788, -0.14832322, 0.09247079, -0.10846258, -0.030261837, -0.14657071));
	target3 += mul(nh2, float4x4(0.037952326, 0.05012869, 0.022779293, 0.0797289, 0.024931714, -0.050262492, -0.15463822, -0.023215678, 0.045349725, -0.0040035774, 0.22049266, -0.08079404, -0.0113567095, -0.00675084, 0.17475724, 0.025340058));
	target3 += mul(ni2, float4x4(-0.13610172, 0.14658909, 0.067050435, 0.12354151, 0.22096893, -0.06765668, -0.024593432, -0.03552899, 0.06936571, 0.10394856, 0.0048312224, -0.21034646, 0.037834894, -0.06692894, 0.009020093, -0.04065748));
	target3 += mul(na3, float4x4(-0.08967367, -0.14398253, -0.19402455, -0.14434609, -0.027259551, 0.1226331, 0.012233069, 0.13677149, -0.1507801, 0.14510965, 0.24108039, 0.04916487, 0.042398036, 0.09403761, -0.03958092, 0.17673557));
	target3 += mul(nb3, float4x4(-0.071569644, -0.19743139, -0.09648773, 0.038397867, 0.12506093, 0.24415006, 0.13810574, -0.23042768, 0.20971183, -0.14231962, 0.0963819, -0.07323753, -0.014360243, -0.099411555, 0.07815387, 0.09009336));
	target3 += mul(nc3, float4x4(0.14625058, -0.15307125, 0.45122483, 0.10113701, -0.12264418, 0.09390506, -0.25706926, -0.082095854, 0.11812526, 0.14046957, -0.09704567, 0.21640895, 0.20999698, -0.19149756, 0.16977966, 0.034616202));
	target3 += mul(nd3, float4x4(0.05720225, 0.0428485, -0.057531573, -0.111578174, 0.03538242, 0.033332366, -0.05961152, 0.13383748, -0.05669531, -0.047779217, 0.2760684, -0.23934118, 0.03728129, -0.15390043, 0.09151239, 0.016904302));
	target3 += mul(ne3, float4x4(0.05711261, -0.009796642, 0.1827549, -0.23561665, 0.15747361, -0.15555665, -0.03771464, -0.15358609, 0.124769196, -0.00302323, -0.1930878, -0.3193505, -0.036671866, -0.21477285, -0.0015818535, -0.054916248));
	target3 += mul(nf3, float4x4(-0.04039116, 0.022148842, 0.2527601, -0.08849551, -0.017892385, -0.01728494, -0.12817079, 0.112442665, 0.004877744, 0.08325303, 0.13601741, -0.12387854, -0.033808686, -0.07762037, -0.036944337, -0.016846744));
	target3 += mul(ng3, float4x4(0.025319673, 0.12447582, 0.06369372, 0.20814203, -0.062117852, 0.10390202, -0.030939216, 0.15888922, -0.0873872, 0.04641361, 0.13612288, -0.22024561, 0.15445144, -0.03273631, 0.18931653, 0.03979226));
	target3 += mul(nh3, float4x4(0.01642648, 0.10919636, 0.118298925, -0.052648794, 0.046562076, 0.042576727, -0.119064495, -0.10575594, -0.023527319, 0.27507904, -0.24070077, 0.037794556, 0.026340371, 0.08496194, -0.2165465, -0.10772629));
	target3 += mul(ni3, float4x4(-0.110290796, 0.23385854, 0.16042788, 0.041294437, -0.04052982, -0.030170577, 0.16566783, 0.18245162, -0.125454, 0.15547217, -0.02763223, -0.10694603, 0.12049954, -0.07608294, -0.06768503, 0.022071697));
	target3 += float4(-0.19256988, 0.07561771, 0.007950438, -0.050078563);

	float3 result = tex7.SampleLevel(sam, pos, 0).rgb;
	result += mul(e1, float4x3(0.0075503755, 0.014264192, 0.014350495, 0.013990636, -0.0011566521, -0.005510977, -0.021975616, -0.013216436, -0.012400287, 0.018202957, 0.010433842, 0.007529786));
	result += mul(e2, float4x3(0.012649671, 0.016378459, 0.009756208, 0.0023225206, -0.0038671023, -0.005242471, 0.023699954, 0.015248626, 0.011651197, 0.014677953, 0.014319745, 0.012088228));
	result += mul(e3, float4x3(-0.0030005479, 0.0052323043, 0.007744717, -0.0077438625, -0.00072459516, -0.001971826, -0.01263717, -0.009226968, -0.005661945, 0.0046659256, 0.0014185858, 0.0038442858));
	result += mul(ne1, float4x3(-0.0053241113, -0.010728358, -0.013345879, -0.000893072, 0.015531841, 0.015812417, 0.021348871, 0.015751695, 0.016067913, 0.014817982, 0.03233685, 0.031598262));
	result += mul(ne2, float4x3(0.0038391522, 0.0027406036, 0.0063517806, 0.0021543978, 0.0065204683, 0.009420363, -0.022383714, -0.012619449, -0.008763167, -0.009436604, -0.012201518, -0.0103548));
	result += mul(ne3, float4x3(-0.005432008, -0.013701671, -0.021388102, -0.001045599, -0.0032160715, -0.0036216215, 0.031028647, 0.022415614, 0.01880324, -0.004328173, -0.004780637, -0.005459752));
	result += mul(max(target1, 0), float4x3(-0.007300146, -0.0076159053, -0.0080059795, 0.005996225, 0.0057377047, 0.0059788194, -0.021563234, -0.020394823, -0.020401813, -0.030919729, -0.03150251, -0.029059272));
	result += mul(max(target2, 0), float4x3(-0.002826552, -0.0042917025, -0.0025527687, -0.0074001094, -0.006878869, -0.0062073106, 0.010867636, 0.010852139, 0.008577537, -0.01606024, -0.0143771265, -0.013291837));
	result += mul(max(target3, 0), float4x3(0.012113326, 0.014259359, 0.011284172, -3.851684e-05, -0.003696042, -0.0020337042, 0.003427011, 0.006911378, 0.008471347, 0.0063997298, 0.004651406, 0.0075980425));
	result += mul(max(-target1, 0), float4x3(-0.026621016, -0.027831081, -0.025364956, 0.022336917, 0.023742557, 0.023516335, -0.01619396, -0.01820708, -0.015288538, 0.0045815264, 0.0022230193, 0.0017512285));
	result += mul(max(-target2, 0), float4x3(0.043799683, 0.046862658, 0.041910093, -0.027854608, -0.02948632, -0.02927831, -0.051899213, -0.04971418, -0.04712937, -0.017539004, -0.0245854, -0.023040624));
	result += mul(max(-target3, 0), float4x3(0.022317344, 0.021462968, 0.02187171, 0.0530127, 0.054741293, 0.052202478, 0.029963326, 0.0298772, 0.025601966, 0.027699472, 0.031187871, 0.02950236));
	result += float3(-0.0071146404, 0.005606682, 0.010180816);

	result += INPUT.SampleLevel(sam, pos, 0).rgb;
	OUTPUT[gxy] = float4(result, 1);
}
