// This file is generated by the scripts available at https://github.com/hauuau/magpie-prescalers
// Please don't edit this file directly.
// Generated by: nnedi3.py --nns 128 --win 8x4 --use-compute-shader --use-magpie
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//!MAGPIE EFFECT
//!VERSION 4
//!SORT_NAME NNEDI3_128_4

//!TEXTURE
Texture2D INPUT;

//!SAMPLER
//!FILTER POINT
SamplerState sam_INPUT;

//!TEXTURE
//!WIDTH  INPUT_WIDTH * 1 * 2
//!HEIGHT INPUT_HEIGHT * 2 * 1
Texture2D OUTPUT;

//!SAMPLER
//!FILTER LINEAR
SamplerState sam_INPUT_LINEAR;

//!TEXTURE
//!FORMAT R16_FLOAT
//!WIDTH  INPUT_WIDTH * 1
//!HEIGHT INPUT_HEIGHT * 2
Texture2D temp;

//!SAMPLER
//!FILTER POINT
SamplerState sam_temp;

//!COMMON
#include "prescalers.hlsli"

#define LAST_PASS 2

//!PASS 1
//!DESC NNEDI3 (double_y, nns128, win8x4)
//!IN INPUT
//!OUT temp
//!BLOCK_SIZE 32, 16
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[8]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 8; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 32.0;
	float mstd1 = sumsq / 32.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 = W(0, -1106336704, -1104338237, 1041734649, -1112016931)
		 + W(1, -1134422686, -1108550970, -1135080854, -1117701445)
		 + W(2, -1097058997, 1036063029, 1053379177, -1099451832)
		 + W(3, -1096794255, 1068454954, 1068510503, -1092648385)
		 + W(4, -1096428577, 1045547931, -1114733521, -1101312270)
		 + W(5, -1108910446, -1102009308, -1146436468, -1118387353)
		 + W(6, -1110459731, -1122481515, -1107441476, -1118789516)
		 + W(7, -1101174078, 1017740065, -1113618698, -1107281979);
	sum2 = W(0, -1107960738, 1034572820, -1105088633, -1147785184)
		 + W(1, 1022891960, 1003346080, -1103397515, 1035529310)
		 + W(2, -1112828174, -1096749055, 1056062200, -1105585021)
		 + W(3, -1099542471, 1067566060, -1127174872, 1034766166)
		 + W(4, 1028527356, -1090311143, 1048792675, -1117109292)
		 + W(5, -1124169384, 1028295012, -1106700271, -1116900804)
		 + W(6, 1003609248, -1101382023, 1033154740, -1121486356)
		 + W(7, 1019646072, -1102277943, 1037356874, -1114899026);
	WS(-1075683047, -1087125913);
	sum1 = W(0, 1042687663, 1052977914, -1087267578, 1041384601) + W(1, 1034752002, 1046022844, -1097639380, 1034807969)
		 + W(2, 1020877136, 1051043629, -1087388173, 1037740431) + W(3, 1043598702, 1049374510, -1095656786, 1044538321)
		 + W(4, 1032834596, 1044576234, -1108370107, -1113942663)
		 + W(5, 1049059763, -1108783446, -1101488315, 1043415765)
		 + W(6, 1041786741, -1105784362, -1111228387, 1011031587)
		 + W(7, 1050972591, -1089957133, -1108747496, 1034104676);
	sum2 = W(0, -1129327146, -1112916736, -1109246006, -1168639863)
		 + W(1, -1149557934, -1120018795, 1012425107, -1122303521)
		 + W(2, 1027469999, -1105442406, 1044505132, -1114911422)
		 + W(3, -1116270499, 1056936993, 1054092693, -1109477794)
		 + W(4, -1107094547, 1036431709, 1015080154, -1122292075)
		 + W(5, -1114668504, 1029410453, -1102188513, 1038663029)
		 + W(6, -1136313139, -1126491682, -1123974759, -1124857486)
		 + W(7, -1115408970, -1112281372, -1115235380, 1004657207);
	WS(1042212664, -1102203684);
	sum1 = W(0, -1140902818, 1040147851, 1035472140, -1111794429)
		 + W(1, 1019874102, -1104962202, 1045102086, 1033944684)
		 + W(2, -1138465404, -1102798136, 1044852023, -1122108180)
		 + W(3, 1041713132, -1085739950, 1052255697, 1042129278) + W(4, 1031911135, -1090423514, 1050093153, 1026181805)
		 + W(5, 1032244040, -1096835716, -1114874577, 1045351411)
		 + W(6, -1122713961, 1015091005, -1125530488, 1045226448)
		 + W(7, 1032066151, -1100137137, 1025859399, 1037723887);
	sum2 = W(0, 1025219442, -1109152196, 1026944460, -1136900198)
		 + W(1, -1119436548, -1122141349, 1040314652, -1112897189)
		 + W(2, 1041363772, 1032935700, -1124096755, -1144192892)
		 + W(3, 1026037858, -1095545125, -1132954458, 1046665648)
		 + W(4, -1106963956, 1029288712, 1063106013, -1112667488)
		 + W(5, -1148187164, 1048235476, 1044093468, -1091150222)
		 + W(6, -1115265228, 1017807431, -1119277141, -1098670428)
		 + W(7, 1027834104, -1124373883, -1115291573, -1099776205);
	WS(-1106435384, 1038338229);
	sum1 = W(0, 1040095954, 1057302312, -1085504617, 1038469973) + W(1, 1019822615, 1048464174, -1109673285, 1008999077)
		 + W(2, 1037825128, 1048602738, -1088007186, 1047759857) + W(3, 1041126536, 1046177110, -1089584127, 1042217259)
		 + W(4, 1042659628, -1113571175, -1112427435, -1122205838)
		 + W(5, 1046281616, 1010729037, -1099904421, 1042535855) + W(6, 1025627498, -1116720143, 985851280, 1020820192)
		 + W(7, 1052688116, -1090676327, -1109333660, 1034203799);
	sum2 = W(0, 1016257202, 1059204215, 1078138204, 1045786159) + W(1, 1025056091, 1059357388, 1057901024, -1115583727)
		 + W(2, -1123344133, -1096239491, -1075026282, 1040463834)
		 + W(3, -1117490597, -1080318626, -1073900782, 1043123901)
		 + W(4, -1139226916, -1097775023, 1041808545, 1021989454)
		 + W(5, -1121712633, -1121076469, 1040778731, -1105966927)
		 + W(6, 1032149092, -1108589001, 1040543247, 1015040126)
		 + W(7, 1018740994, 1042934709, 1013253724, -1147555881);
	WS(-1079558823, -1098708322);
	sum1 = W(0, -1107155318, -1102044491, -1157836704, 1018716763)
		 + W(1, 1025234303, -1098872409, 1050456336, 1032647774) + W(2, 1015859078, -1087610848, 1055919296, 1043448582)
		 + W(3, 1036194249, -1086405173, 1051086989, 1041211303) + W(4, -1109510417, 1049149960, 1049231261, 1032229161)
		 + W(5, -1106597869, -1113006787, 1047976577, -1113988824)
		 + W(6, -1106784003, 1034815041, 1037659280, -1114873522)
		 + W(7, -1107821257, -1109243348, 1045770027, -1115826050);
	sum2 = W(0, -1115121954, 1038073794, -1128914993, -1116577465)
		 + W(1, 1012713185, -1114116718, 1041575276, -1124395325)
		 + W(2, -1120959275, 1048906430, 1074552079, 1055266270) + W(3, 979525395, -1089285214, -1076455267, 1060162115)
		 + W(4, 1031308048, 1044939824, -1081125046, -1098098687) + W(5, 1023425822, 960279117, -1109266711, 1021768571)
		 + W(6, 1008898041, -1114246838, 1028966618, -1124862202)
		 + W(7, 1015643115, -1116674868, -1116558128, 1013382601);
	WS(1045132600, -1120782135);
	sum1 = W(0, -1105751784, 1057393815, -1105555137, -1117651397)
		 + W(1, -1105178898, 1048859946, -1097544977, 1030868229)
		 + W(2, -1104184899, 1059464001, -1093321826, -1113548192)
		 + W(3, -1114219853, 1046945589, -1096850414, -1114482291)
		 + W(4, -1110381909, -1115358437, 1045680426, -1100710867)
		 + W(5, 1038688878, -1101266388, 1054674458, -1101910270)
		 + W(6, -1129240105, 1006928425, 1040711722, -1109195062)
		 + W(7, 1028338913, 1001553277, 1051440502, -1106616547);
	sum2 =
		W(0, 1017265392, 1041015042, -1100279165, 1015388608) + W(1, -1109811903, 1031690548, -1110095441, -1118750728)
		+ W(2, 1023756444, 1041543835, -1121800962, 1018680528) + W(3, -1113627340, 1061785433, 1052269299, -1143924414)
		+ W(4, 1014378799, -1112539854, 1027655784, -1099334823)
		+ W(5, -1145950526, 1033767962, -1103181542, 1020584168)
		+ W(6, -1129429444, -1111764061, -1110834939, -1108053853)
		+ W(7, 1013677319, -1098545742, -1106577514, 1036964648);
	WS(1052573852, -1122511817);
	sum1 =
		W(0, -1122539822, -1107197216, -1123108403, 1051517474) + W(1, 1036520122, -1104137920, 1038549849, 1023654291)
		+ W(2, -1150669710, -1095755763, 1032946604, 1039184399)
		+ W(3, -1131456914, -1089160552, 1050538028, 1041388597)
		+ W(4, 1027717464, -1090293588, 1052989852, -1168884669) + W(5, 1032118773, -1090056564, 1057974832, 1033029075)
		+ W(6, 1021054902, -1092174087, 1053464075, 1028526105) + W(7, 1030809195, -1086001910, 1057808582, 1041880934);
	sum2 = W(0, -1085894681, -1108201039, 1070882268, -1081052443)
		 + W(1, 1038192816, -1090848333, -1093216289, -1102549623)
		 + W(2, -1098445483, 1052221636, 1067999858, -1087793608)
		 + W(3, -1102898046, 1071505414, 1073865984, -1090403840)
		 + W(4, 1008806191, -1098981857, 1058878464, -1095780376)
		 + W(5, 1050638036, -1086351349, -1083525828, 1055133376)
		 + W(6, -1102617523, -1096799400, -1107159037, -1096503933)
		 + W(7, 1057325981, -1088620184, -1083206959, 1053790412);
	WS(-1073219892, -1080326418);
	sum1 = W(0, -1114077580, -1101602915, 1057495924, -1151047116)
		 + W(1, -1142635506, -1103425331, 1053716920, -1114784094)
		 + W(2, -1142955026, -1090278522, 1055741332, -1111276924)
		 + W(3, -1123237842, -1092662145, 1051447237, -1121668701)
		 + W(4, 1038107057, -1091646784, 1052494629, 1000704387)
		 + W(5, -1103324917, -1114692451, 1049044089, -1109204280)
		 + W(6, 1026598572, -1101848592, 1043005848, 1010568075)
		 + W(7, -1095875035, 1038718196, 1047828379, -1156952092);
	sum2 =
		W(0, -1121663397, -1095443331, -1067370736, 1005231721) + W(1, -1116542136, 1050195534, -1071776975, 974104521)
		+ W(2, 1042431779, -1123573301, 1068672794, -1111985184) + W(3, 1037730633, -1100504352, 1077012119, 1047585075)
		+ W(4, 1010053773, 1043186658, 1070664889, 1016528922) + W(5, -1137348615, -1102861372, 1045361006, -1109020232)
		+ W(6, 1028087910, -1110454800, -1123945395, 1037668055)
		+ W(7, -1119025600, 1040229501, 1027642294, -1117277443);
	WS(-1130027456, 1047744266);
	sum1 =
		W(0, 1030328637, -1103440100, 1050534604, -1130350917) + W(1, -1100312969, 1043447132, 1038395889, -1105733872)
		+ W(2, 1036569044, -1096543805, 1037345619, 1043114871) + W(3, 1044449278, -1093151398, -1106526388, 1022399622)
		+ W(4, -1106699970, 1024264999, -1115006287, 1020228332) + W(5, 1046212150, -1115860524, 1035372917, 1024836117)
		+ W(6, -1104762293, 1041344218, 980910400, -1123108872)
		+ W(7, -1124975021, 1032410566, 1044066628, -1112803412);
	sum2 =
		W(0, 1029880722, 1033391383, -1137819024, -1114516031) + W(1, -1098453144, 1041649400, -1137377888, 1025620716)
		+ W(2, 1029103498, -1095624145, 1040796761, 1035240799) + W(3, 1067660000, -1082091368, -1080643124, 1066795978)
		+ W(4, -1094604015, 1056223691, -1102259819, -1098376459)
		+ W(5, 1046293202, 1027973488, -1121978412, 1036814117)
		+ W(6, -1104816365, 1034193475, -1148596400, -1107858514)
		+ W(7, -1117927817, 1034286113, 1041009105, -1114981924);
	WS(1049012636, 1037011386);
	sum1 = W(0, -1108102978, -1097922903, 1049818257, 1041216474)
		 + W(1, 1042768739, -1089977373, 1052134241, -1106782690)
		 + W(2, 1036457352, -1083790961, 1059747641, -1120768141) + W(3, -1105146600, 1050515995, 1062551839, 975424142)
		 + W(4, -1100621772, 1053649082, -1088576433, 1042971413)
		 + W(5, -1100160944, 1044221701, -1093385002, 1047421135)
		 + W(6, -1149100234, 1020595485, -1108848982, -1142399358)
		 + W(7, -1116535239, -1110188826, -1147628986, 1034144007);
	sum2 = W(0, -1130376652, -1109271051, -1098570547, 1029552052)
		 + W(1, -1109307779, 1040605589, -1097221185, -1097745138)
		 + W(2, 998991648, -1117670218, -1087670872, -1101762859)
		 + W(3, -1105231849, 1068278024, 1068017963, -1100990121)
		 + W(4, -1124853008, -1099193318, -1103240593, -1094879980)
		 + W(5, -1110904873, 1035466738, 1049832589, -1119653306)
		 + W(6, 1033926100, -1111928806, 1018913792, -1099498770)
		 + W(7, 1012787248, 1025845624, 1035573068, 1046656503);
	WS(-1099128120, 1074104605);
	sum1 =
		W(0, 1001695642, 1031876531, -1106225286, 1039516460) + W(1, -1114738061, 1036082771, -1127447088, 1037331996)
		+ W(2, -1137881464, 1049670772, -1114090766, 1048871226) + W(3, 1035838167, 1045634202, -1084335000, 1024672505)
		+ W(4, 1036976671, 1039176783, -1092101927, -1111706306) + W(5, 1043227732, 1044499416, -1106295064, 1040216275)
		+ W(6, 1024532056, -1115296143, -1108352670, 1018355325)
		+ W(7, 1041576607, 1036111714, -1103209586, -1129216251);
	sum2 =
		W(0, -1125983803, 1057121124, -1097673861, -1097055530) + W(1, 1026289226, 1048908439, -1081617292, -1105528539)
		+ W(2, 1003361806, 1042597022, -1083990029, -1094090339) + W(3, 1036989304, -1101738899, 1066557847, 1060807350)
		+ W(4, -1121376018, -1101518001, 1050089807, 1045798092)
		+ W(5, -1127516251, -1114490175, 1021212715, 1007168711) + W(6, 999276462, 1032222895, -1107462587, 1021142275)
		+ W(7, 1020382491, -1111061815, 1048167829, 1024157832);
	WS(1043392312, -1114334171);
	sum1 =
		W(0, 1041086874, 1046571639, -1101297859, -1108043111) + W(1, 1027676176, 1051603231, -1100311555, 1031499310)
		+ W(2, 1029494548, -1114765098, -1090719068, -1123479337)
		+ W(3, 1038182418, 1063881062, -1092551191, 1047470620) + W(4, 1033375641, 1036439434, -1093343060, 1029157954)
		+ W(5, 1014428948, 1039261900, -1095549099, -1113522785) + W(6, 1016176348, 1049353410, -1102133676, 1032866554)
		+ W(7, 1036956537, 1039119196, -1097401399, -1108903402);
	sum2 = W(0, 1032922039, -1110774431, 1024080221, -1111786600) + W(1, 1034144522, 1041464609, 1024001520, 1038622987)
		 + W(2, 1035186417, -1089347840, -1102975683, -1098326560)
		 + W(3, -1106146153, 1063858171, 1062496232, -1094555153)
		 + W(4, 995983013, -1103182741, -1104694448, -1110476474)
		 + W(5, 1014708981, -1105498679, 1034761930, -1107944280)
		 + W(6, -1118508182, 1046443094, -1113235807, 1045574278)
		 + W(7, -1122673776, -1107403517, -1126790312, -1119406695);
	WS(1055141020, 1060902337);
	sum1 =
		W(0, 1034435725, 1057965143, -1123568702, -1104499136) + W(1, -1133288704, 1052483105, -1121795134, 1006999415)
		+ W(2, 1026181508, 1052696320, -1094115828, -1153162900)
		+ W(3, 1033934442, -1122504460, -1084201687, 1029709087) + W(4, 1030709219, 1052884304, -1093347107, 1036285529)
		+ W(5, -1118188821, 1049027177, -1096042081, -1155692311)
		+ W(6, 1027652318, 1046782257, -1098441692, 1013713298)
		+ W(7, 1035419593, 1045790650, -1101051195, -1111952258);
	sum2 = W(0, 1043194323, -1070666261, -1098866335, -1101126135)
		 + W(1, 1017945729, -1075189642, -1106608294, 1010301074) + W(2, 992756489, 1068575013, 1051129947, -1107911121)
		 + W(3, -1117717167, 1076566585, 1049134123, 1046700061) + W(4, 1023440269, 1056539999, 1047751107, 1020103457)
		 + W(5, -1108161809, -1098049115, -1097073139, 1026363561)
		 + W(6, 1034607052, 1036076910, 1011007330, 1035420194)
		 + W(7, -1115924363, -1112346970, 1016205049, -1137869730);
	WS(-1090579868, 1070279725);
	sum1 = W(0, 1032329895, 1048430680, -1101560157, -1129281319)
		 + W(1, -1102328821, 1050349544, -1091335294, 1012204235)
		 + W(2, -1113203900, 1052980239, 1039656780, 1033674783)
		 + W(3, -1098061089, 1057014372, -1084573078, -1115372202)
		 + W(4, -1105344998, 1057962188, -1103450436, -1108117804)
		 + W(5, 1034205973, 1038273502, 1043587871, -1111454739)
		 + W(6, -1106552005, 1046276062, -1098888483, -1115265901)
		 + W(7, 1041435478, 1049777060, 1002064136, -1109943484);
	sum2 = W(0, 987673807, 1027892228, -1103141235, 1005138532) + W(1, 1036995374, -1102736131, 1049007178, 1028221332)
		 + W(2, -1095509641, 1034852634, -1090760003, -1123669832)
		 + W(3, -1094252408, 1059241808, 1060311666, -1128511149)
		 + W(4, -1119095571, -1103859919, -1129798465, 1032914452)
		 + W(5, -1103179232, 1043446486, -1100012675, 1006285508)
		 + W(6, 1040985329, -1109795439, 1051746582, -1122773902)
		 + W(7, -1114181285, 1004807604, -1113144024, 987177167);
	WS(1058381774, -1086956646);
	sum1 =
		W(0, 1005434106, -1096145742, 1046241393, 1026532260) + W(1, -1149835360, -1100460324, 1039571170, -1120107684)
		+ W(2, 1034370117, -1096424577, 1054608457, -1107524072)
		+ W(3, 1036055789, 1033532617, -1110152984, -1123297125) + W(4, 1007595428, 1049990129, -1100950084, 1032832748)
		+ W(5, -1173712576, 1042033667, -1103984787, 1041584782)
		+ W(6, -1122685332, -1147483724, -1122634471, -1111048693)
		+ W(7, -1119060568, 1021597150, 1016207588, 1023439817);
	sum2 = W(0, 1073050559, 1049113865, 1048373410, -1123382260) + W(1, 1069067455, 1035642194, -1101089925, 1035361564)
		 + W(2, -1096535796, -1105600932, 1050248373, -1105239942)
		 + W(3, -1073893027, -1114871718, -1113393188, 1000972215)
		 + W(4, -1077684470, -1104998692, 1015693919, -1112223483) + W(5, 1038335059, 1034875990, 1032989733, 987872957)
		 + W(6, 994568047, 1004288083, 1024635942, 1016564448) + W(7, -1109196141, 1019116562, 1041247426, 1019016937);
	WS(1051792028, 1027146209);
	sum1 =
		W(0, -1173418992, -1096555104, 1048715847, 1037767898) + W(1, 1031492470, -1099279313, 1043543405, 1032372106)
		+ W(2, 1030866682, -1102472206, 1045948678, 1031937048) + W(3, -1111745573, -1086728512, 1048944276, 1030986133)
		+ W(4, 1037975597, -1098029143, 1053562136, 1035090980) + W(5, 1032231158, -1099704976, 1041023999, 1038793940)
		+ W(6, 1021051177, -1107704157, 1031959404, 1031982829) + W(7, 1029296729, -1088435526, 1046674105, 1043937550);
	sum2 =
		W(0, 1076285256, -1071495861, -1089164092, 1024798548) + W(1, 1067013205, -1080654015, 1044446905, -1130255717)
		+ W(2, 1054912747, -1092768710, -1089831336, -1111620633)
		+ W(3, -1103468782, 1053690657, 1049463752, -1129289568)
		+ W(4, -1082179927, 1062196550, -1116071286, 1022374674)
		+ W(5, -1086354611, 1059230433, 1055604285, -1147177200)
		+ W(6, -1086555076, 1065208788, -1102169042, 1008723412) + W(7, -1077304359, 1069826015, 1049830695, 990531682);
	WS(-1116843232, 1041538044);
	sum1 =
		W(0, 1038718416, 1050813118, -1091780513, -1107356403) + W(1, 1041393778, 1048646402, -1107072481, 1032833522)
		+ W(2, 1023355030, 1043671731, -1097953353, -1126022145)
		+ W(3, 1040958951, 1037057641, -1088265503, -1185162751) + W(4, 1040537034, 1050123337, -1105750724, 1038008293)
		+ W(5, -1112360254, 1052799074, -1091053114, -1123581176)
		+ W(6, 1043346413, 1037436293, -1121572392, 1033129910)
		+ W(7, 1047211822, 1042212684, -1091261766, -1116284746);
	sum2 =
		W(0, -1127892588, -1090048491, -1076486023, 1071993665) + W(1, 1025248710, -1124324076, -1080184847, 1067215194)
		+ W(2, -1127740272, -1092974499, -1080442855, 1068762214)
		+ W(3, -1114879615, 1047668544, 1048567939, 1014309155) + W(4, -1125515678, 1042122418, 1066323214, -1079656754)
		+ W(5, -1135605467, 1052455522, 1068938556, -1077318729)
		+ W(6, 1015277154, -1102075660, 1066205534, -1083078137)
		+ W(7, -1118452308, 1052515578, 1058048535, -1086246531);
	WS(1045082936, 1047750074);
	sum1 = W(0, 1017867382, 1038967959, -1107005280, -1117189504)
		 + W(1, -1105827232, 1036533543, -1101431328, 1000061951)
		 + W(2, -1139557912, 1048524561, 1044741561, 1034808454)
		 + W(3, -1098507795, 1057427781, -1099209723, -1102176472)
		 + W(4, -1112138258, 1057555836, -1103886606, -1102736460)
		 + W(5, -1113781499, 1044700722, -1117912777, -1102956733)
		 + W(6, -1117154624, 1037485187, -1108908881, -1113728179)
		 + W(7, 1024003356, 1046059755, 1024367918, -1108156515);
	sum2 = W(0, 1003184961, 1024857236, -1114215978, 1037587704) + W(1, 971431442, -1109323954, 1030818718, -1121823736)
		 + W(2, -1131894760, 1026446282, 1031262679, 1045339410)
		 + W(3, -1133283297, -1105665514, 1056963612, -1107079097)
		 + W(4, 984723076, -1116186208, 1055283667, -1090072253) + W(5, 1031831407, 1024492508, 975724297, -1102678968)
		 + W(6, -1125590160, -1121629964, -1116339968, -1103014356)
		 + W(7, 1031681833, -1148808497, 1026784592, -1123463096);
	WS(1059869006, 1015916977);
	sum1 =
		W(0, -1111801867, -1103727218, 1051877295, -1115491581) + W(1, 1039164638, -1102716146, 1051739903, -1106752078)
		+ W(2, 1023424768, -1089648586, 1057614174, -1104830517)
		+ W(3, -1118862224, -1092420393, 1055627629, -1112797325)
		+ W(4, -1114194639, 1049092536, -1096079006, 1038662167) + W(5, -1099094340, 1052180160, 1008315659, 1030088557)
		+ W(6, -1118811114, 1032231232, -1121275805, -1131680577)
		+ W(7, -1096321008, 1046058153, 1039975892, -1175801754);
	sum2 =
		W(0, -1113427160, -1090644207, 1034414883, 1038986783)
		+ W(1, -1104433368, -1091764889, -1120815960, -1135559136)
		+ W(2, -1104169884, -1109333336, 995253792, 1033390214) + W(3, -1117600576, 1065407690, 1059846520, -1120264784)
		+ W(4, -1102319880, -1098732665, 1048874179, -1104270640)
		+ W(5, 1039627671, -1109931470, 1008884504, 1019376128) + W(6, -1097619580, 1043714297, 1021072320, -1111461786)
		+ W(7, 1047721667, 1041133481, -1103318888, -1142244432);
	WS(1054131356, -1077482588);
	sum1 = W(0, -1100136045, -1101215881, 1045307006, 1047064142)
		 + W(1, 989703980, -1100083265, 1039854844, -1120855287)
		 + W(2, -1114161471, -1091699940, 1051542530, 1042850313)
		 + W(3, -1117800461, -1088812180, 1056393300, -1122501592)
		 + W(4, 1013262449, -1095974704, 1053327664, -1118254671)
		 + W(5, -1112319975, 1033042241, 1059113280, -1111473941)
		 + W(6, 1027862775, -1095224480, 1049428707, -1119385054)
		 + W(7, -1103330903, -1102789769, 1055440053, -1109190398);
	sum2 = W(0, -1098032416, 1063396296, 1043414797, -1093635160) + W(1, 1055692800, 1024719031, 1032661901, 1049215120)
		 + W(2, -1101668743, 1065491656, 1058961916, -1090478816)
		 + W(3, -1100435053, 1073645059, 1063424749, 1050905898)
		 + W(4, -1089098280, 1060161647, -1096580753, -1135528507)
		 + W(5, -1094416925, -1074198531, -1098776178, 1042380471)
		 + W(6, -1099202751, -1081296593, -1115458644, 1032695397)
		 + W(7, -1104551065, -1083400329, -1092624053, 1054277265);
	WS(-1082679118, -1072338335);
	sum1 =
		W(0, -1126832308, -1092407662, 1041636256, 1032452512) + W(1, 998650886, -1099976035, 1035459839, -1118647007)
		+ W(2, 1029713605, -1098757312, 1053507448, -1113994637) + W(3, 1045660229, 1049242330, -1097348797, 1019901759)
		+ W(4, -1125245511, 1052609817, -1097111418, 1026546307) + W(5, 1001090478, 1049104969, -1099322690, 1041545965)
		+ W(6, -1126242526, 958956607, -1116731426, -1113342195)
		+ W(7, -1128346278, -1170516592, 1009511091, 1027607012);
	sum2 = W(0, -1069228184, -1099529380, -1112044089, -1144476451)
		 + W(1, -1073602631, 1043301860, 1041147606, -1112019052)
		 + W(2, 1021776922, 1054858487, -1119872164, 1036271953) + W(3, 1076866983, 1044685536, -1106846135, 1018899191)
		 + W(4, 1069809281, 1062109344, 1042271976, -1114284680)
		 + W(5, -1101499289, -1097491140, 1035368326, -1126672913)
		 + W(6, 1013617559, -1149319294, 1025827813, -1112053703)
		 + W(7, 1036050969, -1113127688, -1115137330, -1146921887);
	WS(-1125906880, 1029353026);
	sum1 =
		W(0, 1052620124, -1082830235, 1044570800, 1033131793) + W(1, 1040928385, -1087911853, 1048894344, 1031982257)
		+ W(2, 1053619569, -1088553290, 1054767249, -1118254573) + W(3, 1034478636, -1115166792, 1052323270, 1037418321)
		+ W(4, -1149501032, -1104403058, -1096342700, 1045103465)
		+ W(5, 1027228408, 1046902211, -1092690897, 1053685367) + W(6, 1033816441, -1140598044, -1112660402, 1032758420)
		+ W(7, -1143379631, -1115398454, -1089842615, 1056771243);
	sum2 = W(0, 1052242091, -1123374674, -1088438592, -1109756837)
		 + W(1, -1105901664, 1032004261, -1109896025, -1117902306)
		 + W(2, 1041713460, 1057464262, -1106721416, -1106560728)
		 + W(3, -1098081544, 1055897675, 1057898227, -1101499608)
		 + W(4, -1101414896, -1108453649, 1044097375, -1114554169)
		 + W(5, -1140318759, -1099401944, 1041656473, 1042131382)
		 + W(6, -1123485994, 1039811869, 1042751001, -1104786072)
		 + W(7, -1108472633, -1092934450, 1033994653, 1048148308);
	WS(-1080878567, 1068324028);
	sum1 = W(0, -1115471279, -1095139206, 1057833304, 1032811018)
		 + W(1, 1019310859, -1103458412, 1049561152, -1118469827)
		 + W(2, -1121098697, -1090917913, 1058273109, -1107876783)
		 + W(3, -1115193805, -1094785898, 1054221326, -1109399058)
		 + W(4, -1153442440, -1100131090, 1050583410, -1121957752)
		 + W(5, -1104713039, -1118370765, 1048985266, -1109945243)
		 + W(6, 1023975060, -1102569730, 1041261354, -1125987028)
		 + W(7, -1094675607, 1044057356, 1045920684, -1144681671);
	sum2 = W(0, -1122597644, 1052263517, 1084267296, 1037076324) + W(1, 1032420914, -1132353885, 1077171750, 1017945885)
		 + W(2, -1109997244, -1113437764, -1076080701, 1045994672)
		 + W(3, 1029919127, -1086124512, -1066836895, -1105598049)
		 + W(4, -1129031901, -1134522929, -1073829589, -1115453382)
		 + W(5, 1025876905, -1137529969, -1128728545, 1027437378)
		 + W(6, -1121404056, 1041285329, -1128683125, -1112127416)
		 + W(7, 1025649559, -1111439550, -1109934248, 1032857588);
	WS(-1106960696, -1099012034);
	sum1 = W(0, -1114528403, -1099071342, 1055554285, -1109121109)
		 + W(1, -1119077260, -1099370430, 1049964157, -1115766890)
		 + W(2, -1143558020, -1089278443, 1061104081, -1114965299)
		 + W(3, -1119877760, -1086538844, 1056629915, -1120868875)
		 + W(4, -1109244232, 1010994112, 1049997315, 1034547527)
		 + W(5, -1096650748, 1041376829, 1042073805, -1114495407)
		 + W(6, -1112604445, 1042854492, 1031563405, -1139584324)
		 + W(7, -1100402892, 1049345155, -1123516568, -1118254096);
	sum2 = W(0, -1116593925, 1027806287, 1032648371, 1024756439)
		 + W(1, 1028908115, -1136470458, 1006654490, -1116529299) + W(2, 999050165, 1039840949, 1052059722, -1107372324)
		 + W(3, 1037914955, -1122048333, 1057985079, -1128153177)
		 + W(4, -1106109711, 1057135276, -1090440242, -1142966917)
		 + W(5, -1105957739, -1105275062, -1131926605, -1123338691)
		 + W(6, -1123834115, -1096566133, 1018741845, 1013415162)
		 + W(7, -1113783754, -1105721601, -1124260101, 1018182189);
	WS(-1103089976, 1059868827);
	sum1 = W(0, 1026631887, -1091300264, 1056895190, 1031003956)
		 + W(1, 1033737723, -1096562704, 1050565142, -1140469197)
		 + W(2, 1034000797, -1087537316, 1059766350, -1108911023)
		 + W(3, -1130496915, -1094386976, 1053939124, 1032926090)
		 + W(4, -1106694966, 1044429902, -1108577640, -1120892680)
		 + W(5, -1105866475, 1045093007, -1109922270, 1034482579)
		 + W(6, -1106727101, 1040636078, -1122075862, -1136817768)
		 + W(7, -1098705919, 1044615672, -1100982776, 1045052014);
	sum2 =
		W(0, -1114832682, 1044376552, 1052671036, -1084839384) + W(1, 1038307608, -1101986459, -1094811671, -1076225566)
		+ W(2, -1109268272, 1025272345, -1106762472, -1074779618)
		+ W(3, 1031259614, -1112738770, 1052706603, -1088390497) + W(4, -1136199018, 1014008179, 1040752903, 1066038403)
		+ W(5, -1118450441, 1042085570, -1100877636, 1071357616) + W(6, 1025376385, -1110075404, 1051973899, 1068318141)
		+ W(7, -1125957173, 1027010884, 1036345951, 1050587817);
	WS(-1089897038, 998399462);
	sum1 = W(0, -1100326508, -1114312802, 1049930251, -1141222070)
		 + W(1, -1099771006, -1109889234, 1047140918, -1114407115)
		 + W(2, -1103969415, -1092992143, 1060325312, -1106384368)
		 + W(3, 1030998252, -1098209637, 1062808044, 1017922927)
		 + W(4, -1111096702, -1116385180, -1128865717, 1023432554)
		 + W(5, -1129527451, -1096464604, 1048691588, -1125954964)
		 + W(6, -1115021151, -1111889198, -1137813989, -1121716413)
		 + W(7, -1124899748, -1109224641, 1043572929, 1020452535);
	sum2 =
		W(0, -1094975511, -1113696880, 1023473326, 1029862812) + W(1, -1089233591, 1032844980, 1036803698, -1117299445)
		+ W(2, -1089977002, 1066397244, -1129026618, 1025970568) + W(3, 1033778332, 1037917830, -1104280508, 1031377784)
		+ W(4, 1006981461, 1039504138, 1024702770, -1122944997) + W(5, -1137053176, 1032622380, -1121975322, 1022461928)
		+ W(6, -1125132764, 1021506052, 974010432, -1130740686) + W(7, 979684320, -1119563165, -1138205260, 1024270227);
	WS(-1096120220, -1099720911);
	sum1 = W(0, 1052677544, -1105594052, -1101878153, 990296621) + W(1, 1027883172, 1050583742, -1120505890, 1026529890)
		 + W(2, 1046184634, 1030711656, -1094174707, 1039246623) + W(3, 1036941212, 1050761182, -1087347673, 1031039363)
		 + W(4, 1037786724, 1044997418, -1091299260, 1038193547) + W(5, 1039372749, 1051859318, -1092171165, 1036921611)
		 + W(6, 992842790, 1041579690, -1105854769, -1115076484)
		 + W(7, 1040590154, 1052858474, -1087724293, 1007468831);
	sum2 =
		W(0, 1040381409, 1023777345, -1110031849, 1022623295) + W(1, -1131846701, -1095435966, -1146822820, -1096899181)
		+ W(2, 1030695069, -1111411494, -1089001391, 1049343346)
		+ W(3, 1015259161, -1085163747, -1074171332, -1107180310)
		+ W(4, 1026868853, -1100600319, -1078760233, 1043071461) + W(5, -1164136976, 1052695808, 1048168469, 1020495459)
		+ W(6, -1121164685, 1041440525, 1074132102, 1017314953) + W(7, -1109936403, 1051545155, 1072577306, 1050115198);
	WS(-1080112807, -1111145054);
	sum1 = W(0, -1103297132, 1049824404, -1133975251, 1026400021)
		 + W(1, -1106341774, 1049617192, -1122989109, 1042898005)
		 + W(2, -1098278655, 1059552348, -1086286580, 1041608840)
		 + W(3, 1024154699, 1031972225, -1137351813, -1145221295)
		 + W(4, 1037514093, -1085661228, 1056970252, -1102084285) + W(5, 1034961350, -1097823136, 992708574, 1041904442)
		 + W(6, -1125780682, -1114326813, 1021582000, 1038246926)
		 + W(7, -1109009483, -1119831648, 1040424089, 1042525799);
	sum2 =
		W(0, 1041258750, 989910477, -1134607603, -1109794979) + W(1, -1109734283, -1100922013, 1016064722, 1041809078)
		+ W(2, -1123542769, -1096844113, 1041392492, -1126381362) + W(3, -1113561957, 1051742866, 1057819912, 982123162)
		+ W(4, -1110564237, -1100235579, 1047439582, -1119465765)
		+ W(5, 1026811493, -1105813951, -1113868277, 1026735929)
		+ W(6, -1130694514, -1151284621, -1118083589, 1019553626)
		+ W(7, 1024057869, -1136706867, -1114600003, -1114678252);
	WS(1043409720, -1105036943);
	sum1 =
		W(0, 1040191749, -1096303173, -1115184605, 1041655059) + W(1, 1033970558, -1095924673, 1041748910, 1041917006)
		+ W(2, 1042494496, -1093807736, 1044442592, -1160531625) + W(3, 1046767380, -1092831585, 1042876074, 1039311757)
		+ W(4, 972615552, -1096756208, -1140612185, 1020654492) + W(5, 1032778168, -1126846855, 1018241414, 1043700571)
		+ W(6, 1032217109, -1115229280, 1027878365, 1034107952) + W(7, 1032356247, -1098580285, 1034858676, 1036396440);
	sum2 = W(0, 1027808259, -1139047739, 986751832, -1095774205) + W(1, 1010119787, 1043340308, 1026247831, -1093511024)
		 + W(2, -1111510504, -1106790738, 1065364148, -1089533357)
		 + W(3, -1113418759, -1096910874, 1040723354, 1053173071)
		 + W(4, 1032132185, 1040059331, 1038861011, -1106558855)
		 + W(5, -1121052855, -1115460243, -1113647147, 1027584935)
		 + W(6, 1014515195, 1017581734, 1041604470, -1121443175)
		 + W(7, 1010692603, -1120741339, -1135975307, 1014681515);
	WS(1035857520, 1029952289);
	sum1 =
		W(0, -1143077795, 1037051011, -1110400621, -1121149466) + W(1, -1105351783, 1029971495, -1106469910, 1043652126)
		+ W(2, -1113811952, 1049064844, -1094483622, 1027875988) + W(3, -1106526780, 1035603988, 1058276716, 1035104701)
		+ W(4, 1035289215, -1083894414, 1056346487, -1114346217) + W(5, 999420801, -1098557596, 1050633420, -1123554317)
		+ W(6, -1129002434, -1111645039, 1042325343, -1130799743)
		+ W(7, -1113970285, -1130790920, 1026109447, 1025377311);
	sum2 = W(0, -1118517607, 1026484093, 1039465846, 1008581907)
		 + W(1, -1101077931, 1046485772, 1030900361, -1114630284)
		 + W(2, 1029148161, -1098019518, 1048118782, -1106945018)
		 + W(3, -1087996420, 1071267691, 1064954318, -1097625455)
		 + W(4, 1047526016, -1082674625, -1084489705, -1156379726)
		 + W(5, -1108756119, 1032470282, -1118487613, 1024110641)
		 + W(6, 1038718292, -1106613565, -1112021711, 1020048570)
		 + W(7, 1024464693, -1113199029, -1120012731, 1036291722);
	WS(1058189134, 1034857672);
	sum1 =
		W(0, -1171748679, 1031241360, -1100969760, 987174985) + W(1, -1105475825, 1044072484, -1094075536, 1045893176)
		+ W(2, -1097172873, 1057114388, -1082247827, 1042860595) + W(3, -1108837708, 1051374554, 1060030327, 1031954257)
		+ W(4, 1038034707, -1083662360, 1058651386, -1120638978)
		+ W(5, -1131134898, -1099379283, 1046921459, -1137288661)
		+ W(6, -1113151849, -1121036423, 1041721673, 1037681908)
		+ W(7, -1119273967, 1018101850, 1036514264, 1029972391);
	sum2 =
		W(0, 1003810984, 1020569783, -1128982694, 1043745048) + W(1, 1036204547, -1114489126, -1099380876, -1104004872)
		+ W(2, -1101998989, -1121260135, -1101918458, -1104165612)
		+ W(3, 1041029203, 1052640914, 1059611184, -1121067579) + W(4, -1098215637, 1059150102, 1040381797, -1100369008)
		+ W(5, 1044393168, -1098121773, -1094102036, 1032515174)
		+ W(6, -1110527635, 1037147118, 1028175839, -1114899975)
		+ W(7, 1027560485, -1110248773, -1113935142, 1000033398);
	WS(-1107450480, 1040804833);
	sum1 = W(0, 1040192716, 1040473489, -1095196747, -1124855402)
		 + W(1, 1022226221, 1047969017, -1098407451, 1020416041)
		 + W(2, 1002013395, 1044185574, -1087290490, -1160070647)
		 + W(3, -1117682794, 1060667554, -1089168888, 1045737613)
		 + W(4, 1001040843, 1057909434, -1111951852, -1101676720)
		 + W(5, 1000424795, 1049088596, -1119291421, -1103624738)
		 + W(6, -1120982404, 1038016429, 1031577591, -1104451167)
		 + W(7, 1025306833, 1042416864, -1112956481, -1115902938);
	sum2 = W(0, 1014727333, -1124633329, 1026257754, -1111611661)
		 + W(1, -1117243126, -1107065949, -1111801245, -1136702760)
		 + W(2, 1029406572, 1041729284, -1084100906, -1103677442)
		 + W(3, 1027900147, -1094200388, 1052541581, 1050798725)
		 + W(4, -1112527674, -1104959017, 1070744988, -1105828213)
		 + W(5, -1114664521, 1040214496, -1111707080, -1111536822)
		 + W(6, -1111634336, 1005029260, -1127513012, -1106506739)
		 + W(7, -1107116047, 1049039902, -1107038609, -1140667375);
	WS(-1113867888, 1064515135);
	sum1 = W(0, -1113562537, 1048061265, 1011269086, -1105945126)
		 + W(1, -1107046062, 1043460993, -1098944190, -1148623547)
		 + W(2, -1103978495, 1060048584, -1107431310, -1111558073)
		 + W(3, -1098739202, 1062873548, 1045822761, -1114838028)
		 + W(4, -1122423580, -1119786749, 1025265092, -1101841139)
		 + W(5, 1019693149, 1023528257, -1112998912, -1117915947)
		 + W(6, -1116789880, -1106657727, -1142662356, -1106868487)
		 + W(7, 1020558520, -1137576074, -1104660585, -1122252061);
	sum2 = W(0, -1145158406, 1022878354, -1111624996, 1010204019)
		 + W(1, 1012385731, -1129472106, 1015658802, -1123973089)
		 + W(2, 1016118130, 1044961455, 1040055751, -1157676569) + W(3, 1024197601, 1049544336, 1057430996, 1022031298)
		 + W(4, -1112179804, 1030346877, -1114498280, -1124728962)
		 + W(5, -1119519161, -1131221354, 1020564842, 1023003938)
		 + W(6, -1127326042, -1095482557, -1112131584, -1121117277)
		 + W(7, -1113792718, -1093377057, 1019749938, -1141925830);
	WS(1051333020, -1087054195);
	sum1 =
		W(0, -1112042433, -1104387605, 1052246829, -1113527444) + W(1, 1019002067, -1096771599, 1048899277, -1098301717)
		+ W(2, -1115058903, -1102529947, 1054136106, -1095193948)
		+ W(3, 1046618143, -1093976551, 1044227957, 1044013586)
		+ W(4, -1107874438, -1089735051, 1060328029, -1107288943)
		+ W(5, -1148774132, -1129150690, 1046377228, 1038700845) + W(6, 1036768028, -1101876091, 1045160291, 1024370318)
		+ W(7, -1154881470, -1098135714, 1045432325, 1019966234);
	sum2 =
		W(0, -1114066012, 1041392892, 1044719218, -1097547793) + W(1, 1029900262, -1112610934, 1046575198, -1095644935)
		+ W(2, -1114806697, 1041587346, 1050162797, -1102972970)
		+ W(3, -1110038644, 1025557898, 1055420600, -1095936036) + W(4, 1036646832, 1055783298, -1099287148, 1028020818)
		+ W(5, -1110070018, -1102485451, -1100701871, -1113902766)
		+ W(6, 1020625547, 988088600, 1033323822, -1135974783) + W(7, 987867800, 1039502616, -1119304428, 1018696751);
	WS(-1120103648, -1090070191);
	sum1 =
		W(0, -1117418940, 1049030490, -1112262737, -1114427969) + W(1, 1024592611, 1050801054, -1094705236, 1032013281)
		+ W(2, 1040968250, -1111205267, 1042055990, -1110419822)
		+ W(3, 1049918615, -1116228463, -1085341341, 1047944497)
		+ W(4, 1034410595, 1050512309, -1106227665, -1132367051) + W(5, 1035134604, -1102511675, 1036298997, 1025392341)
		+ W(6, -1119948353, 1034763283, -1138448657, -1111046724)
		+ W(7, -1144523437, 1039656998, -1110564136, -1120201127);
	sum2 =
		W(0, -1122606938, 1046354401, -1124762815, -1118515993) + W(1, -1141997982, 1040228902, -1102583710, 1036845124)
		+ W(2, 1027805544, -1143835982, 1052785838, -1106443071) + W(3, -1120462650, 1061896257, 1059397472, 1043676745)
		+ W(4, -1100560083, -1080731069, -1120768779, 995709275)
		+ W(5, -1105726471, -1098049024, -1126645315, -1128858827)
		+ W(6, 1025575588, 1026943708, 1011421951, -1112152255)
		+ W(7, -1113668318, 1032253740, -1122685018, -1127110207);
	WS(1060158670, 1068766623);
	sum1 =
		W(0, -1116432453, 1056712636, -1087151539, 1040295867) + W(1, -1131098839, 1049784895, -1102593034, 1033948341)
		+ W(2, -1099753724, 1057908127, -1089291740, 1031077093) + W(3, 1034945056, 1044163070, -1094800699, 1027113355)
		+ W(4, -1122123599, 1028198895, 1036808107, -1132674679)
		+ W(5, 1040823512, -1122504371, -1120242995, -1117547229)
		+ W(6, 1040184285, -1123329903, -1127465369, 1040274980)
		+ W(7, 1050332416, -1096645803, -1132187055, -1137741501);
	sum2 =
		W(0, 1036379663, -1098232449, -1128107780, -1120677803) + W(1, -1108907739, 1058983203, 1035811659, -1120240179)
		+ W(2, 1070189048, 1016986873, 1040144345, 1029686139) + W(3, 1073213180, 1047923452, -1105399966, -1109097268)
		+ W(4, 1065321765, 1033582270, -1110681209, 1041308319) + W(5, -1076673488, 1031365639, 1039880527, -1109042515)
		+ W(6, -1079893128, 1038048757, -1116001167, 1034493417)
		+ W(7, -1072585926, -1107019906, 1018297481, -1131123922);
	WS(-1112459888, 1031046963);
	sum1 = W(0, -1112719265, -1128634346, 1043326546, -1115081924)
		 + W(1, -1129483154, -1120462421, -1103778738, -1114915140)
		 + W(2, -1103727283, -1112785958, 1050524372, -1104237825)
		 + W(3, -1091575740, 1056781779, 1067939282, -1096588493)
		 + W(4, -1104335643, -1153409228, 1048587330, -1108534894)
		 + W(5, -1155155940, -1108013960, -1132710977, -1114726045)
		 + W(6, -1114094348, -1118230989, -1109505653, 991235804)
		 + W(7, -1105426861, 1027667442, 1036777787, -1111746006);
	sum2 =
		W(0, -1119086167, 1037241732, -1114652243, -1131518324) + W(1, 1013020612, -1129818230, 1028260797, -1115730540)
		+ W(2, -1141008560, 1029187991, -1112264831, 1036245214)
		+ W(3, -1108719150, -1074141953, 1072760747, 1034705438) + W(4, 1023891147, 1019083994, 1042535682, -1119172530)
		+ W(5, -1145112744, -1124211508, -1131878972, -1133917220)
		+ W(6, 1018251990, -1122886966, 1037493286, -1114007324)
		+ W(7, -1116478859, 1027168441, -1129254230, 1018465006);
	WS(-1086783566, -1086791567);
	sum1 = W(0, -1115195632, -1095708330, -1123676804, 1041725033)
		 + W(1, -1153026662, -1093442522, 1018199561, -1121101892)
		 + W(2, -1134496297, -1098161001, 1037878573, 1034570216)
		 + W(3, -1108787789, 1044632085, 1064261167, -1103584185)
		 + W(4, -1119803561, -1091375169, 1057417647, -1108866704)
		 + W(5, -1145121243, -1107384199, 1052226946, -1122033784)
		 + W(6, -1131708777, -1100078210, 1046948682, -1117964907)
		 + W(7, -1110064394, -1104664012, 1047330733, 1022321300);
	sum2 = W(0, 1031515378, -1077397139, -1134939312, -1112896962)
		 + W(1, -1121810184, -1079753374, -1097085111, 1035985281)
		 + W(2, 1010081392, 1044674665, 1052841311, -1105060263) + W(3, -1119765868, 1073378801, 1007836336, 1031953140)
		 + W(4, 1035546479, 1056367001, 1044809025, 1022446080)
		 + W(5, -1106495935, -1109376902, -1118570548, 1031289566) + W(6, 1028378344, 1035615024, 992033726, 1032016077)
		 + W(7, 1003402623, -1118889676, 1010750288, -1150317246);
	WS(-1096711324, -1080143969);
	sum1 = W(0, -1135181951, -1095339398, 1050582337, 1026786373)
		 + W(1, 1025399430, -1094144146, 1049483953, -1123204644)
		 + W(2, 1033906501, -1093853897, 1045129706, 1006467326) + W(3, 1041786535, -1089314149, 1046728732, 1031608549)
		 + W(4, -1133559462, -1089126233, 1045641984, -1135165794)
		 + W(5, 1003671004, -1110956839, 1051092970, 1017185520) + W(6, -1123695637, -1129083412, 1049638101, 996324016)
		 + W(7, -1105366874, -1113909272, 1057307443, 1009923752);
	sum2 =
		W(0, 1023911567, -1108118447, 1044892126, -1112738860) + W(1, 1004932796, -1134375038, -1138359022, 1020475455)
		+ W(2, -1119124867, 1035251904, 1063133445, -1102926770) + W(3, 1022775023, 1037995724, 1074655410, 1047698054)
		+ W(4, 1011639102, 1050162042, 1070062472, -1113839430) + W(5, 1036397588, 1037707684, -1083132698, -1117927031)
		+ W(6, 999444348, -1111062570, -1073510095, 1017195567)
		+ W(7, -1106309084, -1101285996, -1073687480, 1041743674);
	WS(-1089880270, 1068594400);
	sum1 =
		W(0, -1114467040, -1104513741, 1050219169, -1118490053) + W(1, 1023170830, -1091458130, 1042545281, -1120682309)
		+ W(2, 1036273894, 1034367029, 1048674674, 1031296832) + W(3, -1107800974, -1100997781, 1042739212, -1110241363)
		+ W(4, 1029867434, -1095286649, 1053624831, 1034289100) + W(5, -1106779367, 1047811540, 1034908007, -1107012174)
		+ W(6, 1024593089, -1096228817, 1034674708, 1021221591)
		+ W(7, -1110449433, -1109179032, 1049808694, -1126204757);
	sum2 = W(0, 1030004067, -1133064657, 1024174065, -1119836251)
		 + W(1, -1117028113, -1134091777, -1113615539, 1025775761)
		 + W(2, -1105887481, 1045929484, 1032698350, -1118489229)
		 + W(3, -1066126465, 1081917443, -1097201480, 1041573100)
		 + W(4, -1104777348, 1043726141, 1033613382, -1124268877)
		 + W(5, -1122550707, 1028310407, -1107697461, 1030764051)
		 + W(6, -1130918117, 1016764395, 1029778305, -1116797441)
		 + W(7, 1023720579, -1116064873, 1018371831, 1018350967);
	WS(1067475431, -1126058166);
	sum1 =
		W(0, -1108052732, -1097851361, 1049362324, 1040199303) + W(1, 1043040440, -1108210069, 1048929252, -1109622414)
		+ W(2, 1048922396, -1084429932, 1054104112, 1041203782) + W(3, -1097574342, 1055911149, 1047147106, -1104274751)
		+ W(4, -1119673025, 1041902328, -1085779789, 1047880876)
		+ W(5, -1101774749, 1035827603, 1049622021, -1116198608)
		+ W(6, 1019400344, -1115594513, 1019477630, -1107876353)
		+ W(7, 1007801026, -1107003538, 1037086373, 1036701569);
	sum2 =
		W(0, 1013753738, 1020731454, -1120697178, 1009873360) + W(1, -1113150555, 1046742995, 1034035253, -1099358283)
		+ W(2, 1015248850, 1045156685, -1094710566, 1039470065) + W(3, 1042650722, -1104352239, -1128318417, 1046693145)
		+ W(4, 1040818978, -1089864705, 1045040370, 1036008061) + W(5, -1105652199, 1045331461, 1025091411, 1030627793)
		+ W(6, 1033430289, -1109224259, -1106535436, 1017876415)
		+ W(7, -1120377801, 1016214593, 1019751894, -1132110931);
	WS(1060496974, -1099362699);
	sum1 = W(0, 1054706808, -1109706041, -1098091909, -1129324363)
		 + W(1, 1036662868, 1041317773, -1123237413, 1015757258) + W(2, 1045895019, 1051554925, -1091928498, 1021341985)
		 + W(3, 1033303646, 1049334366, -1083798889, -1112852963)
		 + W(4, 1044095763, 1051166813, -1095315343, 1041804248)
		 + W(5, -1130190200, 1053590462, -1087007295, -1127492145)
		 + W(6, 1035564779, 1049285205, -1097088265, 1039262630)
		 + W(7, 1040746168, 1055551482, -1094550458, -1114905285);
	sum2 = W(0, -1073385920, 1077926840, 1032559783, -1094451238)
		 + W(1, -1084887580, 1058818874, -1089669880, -1121878040)
		 + W(2, -1083140914, 1060159151, 1045764296, -1173171215)
		 + W(3, -1081800202, 1074845707, 1059775011, -1120435570)
		 + W(4, -1085954594, 1061906872, -1103860568, -1115590029)
		 + W(5, 1037413129, -1084431515, -1094536545, 1053315192)
		 + W(6, -1096433065, -1126824848, -1133232881, -1107838893)
		 + W(7, 1054210787, -1087315344, -1099186518, 1052978812);
	WS(-1078369703, 1041267413);
	sum1 = W(0, 1024386586, 1041630887, -1102607056, 1016693023)
		 + W(1, -1098405416, -1112635974, 1051293608, 1018393854)
		 + W(2, 1044040033, -1132435208, -1094040968, 1046099151)
		 + W(3, -1098286219, 1041292515, 1052507157, -1095618428)
		 + W(4, -1130684104, -1091497929, 1056853585, 1018959206)
		 + W(5, 1045750173, 1016159377, -1105775474, -1117949682)
		 + W(6, -1098338270, -1139597330, 1049412460, -1118540325)
		 + W(7, 1041584973, -1101611546, 1026100205, 1040982949);
	sum2 = W(0, 1035615459, -1097925659, 1043665288, 1020457849) + W(1, 1028814353, 1038714809, 1033337220, -1103657321)
		 + W(2, 1062855981, -1077657685, 1051048913, -1109823715)
		 + W(3, 1052250964, -1101970047, -1113114333, 1058024935)
		 + W(4, 1056109526, -1098468896, -1085664062, 1056999181)
		 + W(5, -1106019250, -1114182260, 1040975429, -1105846491)
		 + W(6, 1048995011, -1104046747, -1109605260, 1042595027)
		 + W(7, -1115640692, -1130122971, 1034778788, -1112374505);
	WS(1049151900, -1114127847);
	sum1 = W(0, 1050216581, 1044969414, -1106856243, -1099359923)
		 + W(1, 1000015204, 1047621718, -1112471205, -1148711507)
		 + W(2, -1136218178, 1057314961, -1091938023, -1133921207)
		 + W(3, 1023136961, 1055877843, -1092033343, -1112054390)
		 + W(4, -1130455775, 1054358666, -1099719178, 1034273823)
		 + W(5, -1133465094, 1052966059, -1089783713, -1122838974)
		 + W(6, -1160090192, 1045850836, -1099053307, 1019980258)
		 + W(7, 1035991733, 1052491071, -1087984664, -1112322824);
	sum2 = W(0, -1105478410, 1011113448, 1068049752, -1082501551)
		 + W(1, 1039552519, 1050864081, -1103020148, 1059003564)
		 + W(2, -1131405058, -1125310098, 1066695202, -1098156272)
		 + W(3, -1099466970, 1043215106, 1074596924, 1039344435) + W(4, 1049027924, 1034334973, 1067601936, -1099880092)
		 + W(5, -1115050596, -1095883745, -1084539788, -1107282542)
		 + W(6, -1129231446, 1036178144, -1075514015, -1097076855)
		 + W(7, 1049583286, -1088635155, -1074115054, 1042018058);
	WS(-1081332839, -1093454830);
	sum1 = W(0, -1109709318, 1035356975, 1039420520, -1111308088)
		 + W(1, -1104916884, 1037116623, -1122158672, 1014687039)
		 + W(2, -1108177419, -1125155242, 1053028347, -1112931654)
		 + W(3, -1117212646, 1030327966, -1104761999, 1020526050)
		 + W(4, -1119705461, 1050241163, 1032136206, -1119448076)
		 + W(5, 1032417267, -1103907222, -1115200780, -1112611266)
		 + W(6, -1118748528, 1046095669, -1115609017, -1136487898)
		 + W(7, 987327371, 1033262333, 1029855614, -1104533373);
	sum2 = W(0, 1013207527, -1118344664, -1124997045, 1036829905)
		 + W(1, -1127355075, 1028266047, -1117884424, 1016171285)
		 + W(2, -1103159789, 1043690369, -1116887196, 1024917624) + W(3, 1040955478, 1051132935, 1047094008, 1041601336)
		 + W(4, 1008876024, -1108842627, 1057384051, -1127506713)
		 + W(5, -1116686760, 1041402295, -1100609336, 1033786361)
		 + W(6, 1035764738, -1105537330, -1098518151, -1114313206)
		 + W(7, -1154118338, -1128237045, -1089828796, -1102385561);
	WS(1063446990, 1030048893);
	sum1 = W(0, -1131562670, 1043069042, -1108681470, -1108650254)
		 + W(1, -1099483503, 1049571969, -1106599551, -1106453175)
		 + W(2, -1106193120, 1061428532, -1097709592, 1008661917)
		 + W(3, -1102405700, 1053095529, 1046689338, -1102088711)
		 + W(4, 1021119810, -1115069793, 1029025472, -1123233168)
		 + W(5, -1113568905, -1119868742, 1006738196, -1104754348)
		 + W(6, 1009340592, 1027160065, -1120287391, -1136963210)
		 + W(7, 1030255032, 1043118346, -1111789333, -1114502129);
	sum2 = W(0, 1012371361, 1017109065, -1110016822, -1103671135)
		 + W(1, -1149491589, -1115161102, -1109821790, -1097972516)
		 + W(2, 1023756477, 1012418345, 1060485172, -1094449842)
		 + W(3, -1165255819, -1111308586, 1031379047, 1049769129) + W(4, -1111467932, 1015942947, 1046805034, 999148403)
		 + W(5, 1019335917, -1106016138, -1114576028, 1022790203)
		 + W(6, -1140694601, 1015823021, 1024897044, 1032463998)
		 + W(7, 1010513313, 1026481588, -1114618076, -1146831635);
	WS(1060385486, 1040268319);
	sum1 = W(0, -1115333181, -1105770459, 1048230464, 1022495614)
		 + W(1, -1113839600, -1104706211, -1122113023, -1115044751)
		 + W(2, 1026945989, -1085502934, 1051932092, 997701279) + W(3, 1041834949, -1112644646, 1065603891, 1044329112)
		 + W(4, -1100015113, -1102865873, -1105250533, 1038196649)
		 + W(5, 1010458454, -1112283012, 1054415097, -1113673817)
		 + W(6, -1113704543, -1108020290, -1122402466, -1105082025)
		 + W(7, -1110169699, -1115522389, 1046973419, -1115640050);
	sum2 = W(0, -1115664423, 1041813775, -1142717933, -1120925434)
		 + W(1, -1122287706, 1041645390, -1094011677, -1119842210)
		 + W(2, 1044568139, -1087138046, -1124627987, -1120985148)
		 + W(3, -1099350461, 1067461852, 1027339570, -1113918825)
		 + W(4, -1102715015, -1116572542, 1045144111, -1100833175)
		 + W(5, 1042022920, -1109622665, 1054026149, -1101147879)
		 + W(6, 1031291077, -1113357449, -1122353792, -1112018489)
		 + W(7, 1032474264, -1110133469, 1047364150, -1109170005);
	WS(1049043868, 1050086952);
	sum1 = W(0, -1127858130, -1091279607, 1054362490, 1028884238)
		 + W(1, 1025810768, -1101354119, 1044465651, 1022883995) + W(2, 1034666762, -1089232423, 1050465752, 1032068165)
		 + W(3, 989092984, -1092016019, 1058690160, 1005443958) + W(4, -1115481017, -1089729669, 1053482909, 1007092039)
		 + W(5, -1119959429, -1104525366, 1051092259, -1149438996)
		 + W(6, 1012364567, -1121438163, 1019953121, -1137072337)
		 + W(7, -1097661520, -1160888088, 1051219071, 1017307814);
	sum2 =
		W(0, 1030282550, -1099759289, 1070065566, -1078832473) + W(1, 1012065197, 1050936278, 1068820850, -1076346523)
		+ W(2, 1049708534, 1018991152, 1068572253, -1075628240) + W(3, -1101566471, 1050588571, 1075164582, -1072955990)
		+ W(4, 1043525707, -1112383125, 1046261639, -1093459475)
		+ W(5, 1038111746, -1121285468, 1053555382, -1088795804) + W(6, 1040589253, 1039884984, 1040055978, -1099780818)
		+ W(7, -1106531005, -1113841779, 1058828770, -1090423367);
	WS(-1083655502, 1074535575);
	sum1 = W(0, 973651072, -1100106921, 1049212555, -1122472503) + W(1, 1028862937, -1096173461, 1052529147, 996549482)
		 + W(2, 1029517469, -1088250868, 1057957824, -1111380529)
		 + W(3, -1111330742, -1101351113, 1060855844, -1125410415)
		 + W(4, 1043404639, -1092528244, 1050267538, -1109626381)
		 + W(5, -1105397947, 1034877328, -1104065896, -1122247818)
		 + W(6, -1129726574, -1113904430, 1041335934, -1108333759)
		 + W(7, -1099887737, -1118418050, 1047916353, 1037233742);
	sum2 = W(0, 1037582341, -1116649305, -1107051108, 1040538112)
		 + W(1, 1032149251, -1112916551, 1041643977, -1112067691)
		 + W(2, -1135487115, 1044443302, 1030763641, 1036263743)
		 + W(3, -1107247151, -1117703407, 1053360182, -1115814520)
		 + W(4, 1053968825, 1049963138, -1087331905, 1035849297)
		 + W(5, -1096732175, 1042101117, -1089009482, -1104153316)
		 + W(6, 1034930229, 1046616621, -1110671517, -1104877620)
		 + W(7, -1094249638, -1127010106, 1059951262, -1116847106);
	WS(-1132786560, 1056578758);
	sum1 = W(0, 1031072232, 1043718831, -1098888378, -1123786893)
		 + W(1, 1019453021, 1050053971, -1104586611, 1030360908)
		 + W(2, -1112153353, 1057505465, -1090760605, -1123598824)
		 + W(3, -1127115205, 1049535379, -1081773448, 1035671447)
		 + W(4, -1153314582, 1052394474, -1106021324, 1044649456)
		 + W(5, -1105591705, 1045418390, -1120283669, -1105554848) + W(6, 986346381, 1044283028, 1036365944, 1033186457)
		 + W(7, 1024604121, 1048806335, -1103287167, -1108912601);
	sum2 =
		W(0, 1040658557, 1011638864, 1041865287, -1109113498) + W(1, -1106354313, 1020064744, -1103147627, 1033931950)
		+ W(2, 1027144364, 1049840877, 1026998340, -1120927100) + W(3, -1103628435, 1050147177, 1053587315, -1102211113)
		+ W(4, -1123462592, -1117174472, -1118058864, 1033328738)
		+ W(5, -1130705048, -1105120318, 1036775410, -1101351534)
		+ W(6, -1126068784, -1113970774, -1104140895, 1028877580)
		+ W(7, 1016031184, -1135769248, 1030416564, -1112076066);
	WS(1062711758, -1109562142);
	sum1 = W(0, -1107075140, -1100622401, 1053288051, 1017596397)
		 + W(1, -1125545776, -1104747337, 1049612355, 1007433175)
		 + W(2, -1121788380, -1103229831, 1059638178, -1120034657)
		 + W(3, -1112684886, -1083301774, 1048337697, -1098025711)
		 + W(4, -1128625782, 1050510715, 1052952654, -1112854653)
		 + W(5, -1102890883, -1097610180, 1051307580, -1108240645)
		 + W(6, -1129119788, -1109077454, 1041285742, 1022176121)
		 + W(7, -1102110160, 1030737729, 1049115768, 1020667959);
	sum2 = W(0, 1022257834, 977550902, -1113927342, 1036504102) + W(1, 1033804876, -1105772859, 1042844173, -1107093105)
		 + W(2, 1033963400, -1098748483, -1096777339, 1028160469)
		 + W(3, -1113268759, 1063293804, 1059312088, -1089861840)
		 + W(4, -1123922685, -1090033704, -1134320563, -1101525036)
		 + W(5, 1029999681, 1051039483, 1037687330, 1017532722) + W(6, 1015463858, -1104977553, 1024487701, -1122996995)
		 + W(7, -1125618402, 1022914778, 1004875175, -1116068477);
	WS(1046002488, -1083997249);
	sum1 = W(0, -1116203964, -1099156844, 1050076828, 1025075217) + W(1, 1044431961, 1028498222, 1049400252, 1035032656)
		 + W(2, 1041235242, -1096363997, 1050263757, 1032516798) + W(3, 1046371486, -1079124621, 1020370202, 1050189128)
		 + W(4, -1106267745, -1088685662, 1048790666, 1042510329)
		 + W(5, -1117705943, -1103556299, 1053355933, 1039724554) + W(6, -1122870401, 999993136, 1034829570, 1027729159)
		 + W(7, -1109240562, -1106798659, 1037276039, 1037249299);
	sum2 = W(0, -1094982381, 1041875660, 1017839086, 1045890174)
		 + W(1, 1024745423, -1091311273, 1044409386, -1107764806) + W(2, -1097113645, 1042706326, 974632891, 1048260200)
		 + W(3, 1017043870, -1148119319, 1061393923, -1118443235)
		 + W(4, 1052555320, -1098101314, 1043955676, -1097368628)
		 + W(5, -1107563793, 1010824956, -1098402228, 1041238578)
		 + W(6, 1049262968, -1094774489, 1042935118, -1116185663)
		 + W(7, -1118735987, 1030619863, -1094515595, 1042214090);
	WS(-1083255246, -1075588436);
	sum1 =
		W(0, -1154522904, 1026375684, -1099839750, 1037990411) + W(1, -1106371438, 1036249778, -1113752075, -1119606102)
		+ W(2, -1105464695, 1056687627, -1092436626, 1043935324) + W(3, 1036086422, -1097055709, 1050924256, 1036476796)
		+ W(4, 1023783355, -1088556578, 1056650964, -1111337285)
		+ W(5, -1127243930, -1108055408, 1045926824, -1110940389)
		+ W(6, 1030176790, -1105944807, 1039385437, -1124332025)
		+ W(7, 1031412139, -1123388097, 1041066449, 1021333175);
	sum2 = W(0, -1117330831, 1032531181, 1043756688, 1060766869) + W(1, 1023708058, -1114369361, 1031926890, 1067300065)
		 + W(2, -1133288218, 1017487862, -1104593512, -1105945514)
		 + W(3, -1122435213, 1047518334, 1043258354, -1075696003)
		 + W(4, -1139180683, -1122916014, -1096895795, -1102393264)
		 + W(5, 1020252429, 1027012545, 1049767697, -1106946489) + W(6, 1025188082, -1103557501, 1019544307, 1020047431)
		 + W(7, -1109968059, 1046855474, -1112657711, -1113285900);
	WS(1056055196, 1023945849);
	sum1 =
		W(0, -1104545849, 1036175954, 1032040419, -1111539988) + W(1, -1139517988, -1138851412, 1009002268, 1026875367)
		+ W(2, -1101013315, 1048468083, 1040659763, -1104005681)
		+ W(3, -1136100212, -1097789539, 1059870683, -1112873620)
		+ W(4, -1148373856, -1096999890, 1039368714, -1135793772)
		+ W(5, 1013350648, -1097071058, 1053644410, -1132670698) + W(6, -1120654743, 995622088, -1122818538, 1028030253)
		+ W(7, -1108930702, -1128233700, 1033002810, -1133516850);
	sum2 = W(0, 1033182461, -1110992702, 1011638125, -1116812221)
		 + W(1, -1135790885, 1041801313, 976542168, -1135785781)
		 + W(2, 1036058972, -1115959119, -1106760241, 1013579453)
		 + W(3, -1145806187, -1083556559, -1068720208, 1034110873)
		 + W(4, 1026470367, 1047402951, 1080067579, 1048786168) + W(5, -1125994579, 1026458945, 1043021822, -1124564059)
		 + W(6, -1123856921, 1021989349, -1118809257, -1115658442)
		 + W(7, -1152817846, 1029289545, 1027196491, -1110636256);
	WS(1047050040, 1036867972);
	sum1 = W(0, 1031952202, 1041031945, -1098508279, -1117663192)
		 + W(1, 1040033213, 1050476745, -1097704487, 1033331580) + W(2, 1049413776, 1016870010, -1091275871, 1012948685)
		 + W(3, 1052329098, 1054273441, -1087382286, 1043041286)
		 + W(4, -1134253939, 1041748879, -1095309386, -1131302504)
		 + W(5, 1023712847, 1035493153, -1117526273, -1125396951)
		 + W(6, -1129317744, 1041656495, -1112254893, -1153578470)
		 + W(7, 1023414180, 1041394937, -1108492595, -1112644847);
	sum2 = W(0, -1120609508, -1138324119, -1110367912, 1021280635)
		 + W(1, -1098653081, 1042859622, 1038385587, 1026624912) + W(2, -1074671298, 1072071026, 1026263792, 1026288466)
		 + W(3, -1081276780, 1068070176, -1107049493, -1122098825)
		 + W(4, -1097107702, 1044485226, 1024907208, 1040255596)
		 + W(5, -1110118090, 1040658983, -1122488627, -1152233050)
		 + W(6, -1137118351, -1118978815, 1038809437, -1126727249)
		 + W(7, -1119823807, 1035453187, -1111098449, 1006813455);
	WS(1047287096, 1059538103);
	sum1 = W(0, 1030804480, 1034749929, -1102474905, 1013951379)
		 + W(1, -1111595219, 1051408038, -1094490621, 1039425378)
		 + W(2, -1123153834, 1049213285, -1099609086, -1112788128)
		 + W(3, -1098057279, 1057344539, 1048597242, -1098419769)
		 + W(4, 1007980582, 1048793645, -1094890059, -1118093753)
		 + W(5, 1018775223, -1106759404, 1046324795, -1108341356)
		 + W(6, 1036089754, -1115115061, 1003815995, -1120388747)
		 + W(7, 1030691489, 1033654600, -1126686757, -1135294247);
	sum2 = W(0, -1112864979, 1024004698, 1034996841, 1004307827)
		 + W(1, 1034721747, -1109416755, 1041661735, -1116757818) + W(2, -1108077379, 988806988, 1041642045, 1037366938)
		 + W(3, 1023366533, 1058238498, 1008174217, -1107547239)
		 + W(4, 1021246669, -1115279539, -1122858630, -1108868659)
		 + W(5, 1032508120, 1041332549, -1089151778, -1128614293)
		 + W(6, -1113986367, 1033457886, -1130797677, -1130732717)
		 + W(7, -1153257254, 1018109285, -1111548255, -1122125438);
	WS(1066216871, -1084582294);
	sum1 =
		W(0, 1009745022, -1095963722, 1050775177, 1027534757) + W(1, 1023325836, -1096473834, 1046303345, -1126933960)
		+ W(2, 1034246149, -1087129751, 1057767679, -1118146623)
		+ W(3, -1103455511, -1142570129, 1064400323, -1103828265)
		+ W(4, 1025953385, -1094684497, 1038452388, 1018950609) + W(5, -1105242559, -1107829831, 992534739, 1030437560)
		+ W(6, 988118663, -1107520037, 1025316967, 1020674901) + W(7, -1107601837, -1117719279, 1044853309, 1033139589);
	sum2 =
		W(0, -1127013105, 1031626404, 1029958550, 1017794797) + W(1, 1018526115, -1117975133, -1113082476, 1023300847)
		+ W(2, -1123587641, 1062148372, 1035325186, -1145491637) + W(3, 1052346460, 1074624908, -1130733653, 1041942663)
		+ W(4, -1098654594, -1090512380, 1046581721, -1113152926)
		+ W(5, 1029804743, -1070854231, -1113725416, -1139181075)
		+ W(6, -1118240305, -1095518794, 1031776819, -1120299385)
		+ W(7, 1030491706, 1041467716, -1115594754, -1142763637);
	WS(1033725552, -1082653885);
	sum1 = W(0, 1027658456, -1091894661, 1054730080, 1024810077) + W(1, 1033791775, -1094613753, 1052727904, 1020875129)
		 + W(2, 1038169633, -1085886368, 1060322284, -1114253244)
		 + W(3, -1130834725, -1094605577, 1054915405, 1021660859)
		 + W(4, -1105755912, 1049096200, -1115316932, 1010914050)
		 + W(5, -1107114253, 1038006563, -1113871235, 1032412472)
		 + W(6, -1106878767, 1040399888, -1114082704, 1016596422)
		 + W(7, -1102176852, 1038046228, -1098681477, 1044096992);
	sum2 =
		W(0, -1126607908, -1109006144, -1093467963, 1059727060) + W(1, -1111819446, 1050929158, 1063076656, 1073053378)
		+ W(2, 1032709615, 1025316173, 1048889614, 1073749745) + W(3, -1119610542, -1107176811, -1090320472, 1058093447)
		+ W(4, 1027594385, -1123863107, 1046933317, -1079533534)
		+ W(5, 1029384695, -1122531221, 1051206364, -1073154062) + W(6, -1115269200, 1026796828, 997945380, -1075936158)
		+ W(7, 1032209203, -1115616555, -1109796884, -1088004581);
	WS(-1087442510, 1045166814);
	sum1 =
		W(0, -1106921670, 1032009478, 1041337656, -1110338367) + W(1, 1032907600, -1127325529, -1100890040, 1042108264)
		+ W(2, -1111070674, -1106321881, 1060092296, -1105899594)
		+ W(3, 1047421629, -1085655355, 1044767811, 1027442111) + W(4, -1094092352, 1057239638, 1040377247, -1105935775)
		+ W(5, 1031075349, -1098381173, 1037296628, 1037469097)
		+ W(6, -1136240762, -1128650952, -1131454723, 1027139781)
		+ W(7, -1129052086, -1107389381, 1037463686, 991481919);
	sum2 = W(0, -1119426781, 1040351141, -1104019881, 1015410156)
		 + W(1, -1109786529, 1043540747, -1106797782, 1043466418)
		 + W(2, 1041819143, -1105926532, -1098594115, 1048709183)
		 + W(3, 1018220925, -1133247980, 1066013053, -1092013542)
		 + W(4, -1103055916, -1096724541, -1136157126, -1109288787)
		 + W(5, -1124599508, 1038612076, -1097021086, 1027934232) + W(6, 986571056, 1019567362, 1025702119, -1140871148)
		 + W(7, 1024618671, -1143357456, 1008181894, 1027080058);
	WS(1059279054, 1041683061);
	sum1 = W(0, 1028823114, -1096417644, 1041071884, 1040139175)
		 + W(1, 1033060856, -1095251776, 1051348966, -1133443258)
		 + W(2, -1136683218, -1096755466, -1106154521, 1027763154)
		 + W(3, 1041097809, -1095420880, 1062896338, 1037083176)
		 + W(4, -1108712682, -1087904547, 1057053635, -1109247178)
		 + W(5, -1099515041, -1117180600, 1050313119, -1169250436)
		 + W(6, -1114499693, -1113115866, 1041134484, 1007514196)
		 + W(7, -1105525449, -1121084634, 1043053335, 1031868218);
	sum2 =
		W(0, -1104031080, 1039900182, 1028023758, -1125301559) + W(1, -1113246189, 1044206765, -1122555834, 1027754708)
		+ W(2, -1124792744, 1043086617, 1041018096, -1129842792)
		+ W(3, -1107688308, 1057123143, -1100462314, 1022410763)
		+ W(4, -1084040655, 1066602722, -1123151815, 1034604384) + W(5, -1089958554, 1037219700, 1032289221, 1029558442)
		+ W(6, -1098618924, -1111210157, 1028867168, -1139711519)
		+ W(7, -1098033920, 1036938090, -1143651414, -1122704124);
	WS(-1093886876, -1092780259);
	sum1 = W(0, 1031521076, 1034696971, -1098366291, 991412379) + W(1, 1040859655, 1027092583, -1107551117, 1023411481)
		 + W(2, -1123954783, 1057011018, -1084481759, 1037665034)
		 + W(3, -1115369432, 1055452141, -1086775792, 1037775165)
		 + W(4, 1027325374, 1055461116, 1050583573, -1102735091)
		 + W(5, -1130075936, 1043845385, -1098824964, -1106471523)
		 + W(6, 1017430099, 1041326696, 1032795870, -1113156096)
		 + W(7, 1005655277, 1045628689, -1110858724, -1108701199);
	sum2 = W(0, -1099549152, -1115620025, 1042476476, -1128057356)
		 + W(1, -1101982776, -1110046443, -1138118945, -1104607948)
		 + W(2, 1039636960, 1067650764, 1056117723, -1129519972)
		 + W(3, 1065032135, -1096892917, -1084935200, 1039009532)
		 + W(4, 1046191187, -1084058149, 1043334912, 1042222420)
		 + W(5, -1112740199, -1089814493, -1116550886, -1114781123)
		 + W(6, -1120755726, 1022618460, 1030169574, 1023299940)
		 + W(7, -1138571865, -1106519005, -1123579094, 1029490149);
	WS(-1103384376, 1050555318);
	sum1 =
		W(0, 990997212, 1056616014, -1113359817, -1104278389) + W(1, -1104723373, 1049493908, -1101985253, -1112669305)
		+ W(2, -1102560870, 1060440249, -1095607555, -1117918862)
		+ W(3, -1110645588, 1063537686, -1091747296, -1124628967)
		+ W(4, -1114771100, 1049398171, -1098384586, -1120789735)
		+ W(5, 1006886950, -1123261404, -1094355067, 1020875660) + W(6, 1011892746, 1042753094, -1098733239, 1029891897)
		+ W(7, 1041403778, 1041297647, -1099641616, -1143354303);
	sum2 =
		W(0, -1097904627, 1056762738, 1033294591, -1113205081) + W(1, -1102268820, 998260703, -1102966386, -1105114179)
		+ W(2, -1101696600, 1049156882, 1040206209, 1028552759) + W(3, -1102083058, 1055125136, 1048772561, 1023069474)
		+ W(4, -1100977750, 1040009482, 1004029807, -1108173489) + W(5, 1022682138, -1099421122, 1040485303, 1040370279)
		+ W(6, -1105396681, -1114104451, -1118051402, -1109779069)
		+ W(7, 1035758392, -1112582051, 1040482786, -1135668672);
	WS(1042369848, -1095650924);
	sum1 =
		W(0, 1032801852, 1060985291, -1088222536, -1154392525) + W(1, -1124780413, 1056066249, -1093287088, 1017158008)
		+ W(2, -1142443027, 1059062488, -1089766974, 1041310978)
		+ W(3, 1031124370, 1046815795, -1084610255, -1111535759)
		+ W(4, 1024489633, 1051554984, -1096293908, -1118760812) + W(5, 1037041722, 1026983110, 1035048291, -1118618480)
		+ W(6, -1157391942, 1037131073, -1113190096, 1032589425)
		+ W(7, 1048283534, 1028118439, -1107690581, -1101944856);
	sum2 = W(0, 1056251107, -1084477192, -1077785336, 1053829707)
		 + W(1, -1118435725, 1041984407, -1086371528, -1113013425)
		 + W(2, -1111043713, -1093515412, -1093010832, 1046411943)
		 + W(3, -1090037466, 1073185178, 1074151927, -1090694669)
		 + W(4, -1129656805, 1051712939, 1054463958, -1095714333)
		 + W(5, -1093926860, 1053076395, -1094829660, -1103046632)
		 + W(6, 1052716525, -1096065312, -1090812268, 1035367276)
		 + W(7, -1083761792, 1066458198, 1063500158, -1087950464);
	WS(-1081634407, -1072784825);
	sum1 = W(0, -1102740818, 1024862651, 1056867014, 1016622683)
		 + W(1, -1115394775, 1046040367, 1027952685, -1112643478)
		 + W(2, -1101924733, -1109613465, 1058509811, -1096240139)
		 + W(3, -1100839185, -1115978107, 1050187219, -1101581667)
		 + W(4, -1123768914, 1049722038, -1098437541, 1008822020)
		 + W(5, -1140848016, -1098661743, 1033615035, 1023463264)
		 + W(6, -1118249725, -1138059466, -1143195264, -1116668435)
		 + W(7, -1116477425, 1025943000, -1132571500, 1036595961);
	sum2 =
		W(0, -1139809909, 1046126277, -1119940899, 1040903120) + W(1, -1126178115, -1111752353, 1055245806, -1104413152)
		+ W(2, 1032546581, 1034216546, -1088954301, 1019748625) + W(3, -1097752958, 1042101074, 1058677046, -1089277711)
		+ W(4, 1042272246, 1043290796, -1087007443, 1028591970)
		+ W(5, -1118367610, -1112722386, 1048637958, -1139620757)
		+ W(6, -1138081685, 1034532478, -1140548675, 1017306737) + W(7, 1017774855, 1030093406, 1029648824, 1033828758);
	WS(1050645916, 1033550915);
	sum1 = W(0, -1118556120, -1107219907, 1039060494, 1030703933)
		 + W(1, -1108262319, 1043545243, -1145250020, -1110184190)
		 + W(2, 1043230361, -1086762442, 1059123936, -1110311564)
		 + W(3, -1094947334, -1104041435, 1057758321, -1100512367)
		 + W(4, -1103841584, 1058293794, -1096913490, 1044416908)
		 + W(5, 1018079143, -1097977901, 1039599795, -1132472896)
		 + W(6, 1032598742, 1041130248, -1151122424, -1147952664)
		 + W(7, 1008731683, -1123331655, -1123961290, 1022228292);
	sum2 = W(0, 1040267615, -1112791644, 1010515766, 1024308395) + W(1, 1048409433, -1110540665, 1032365064, 1041630361)
		 + W(2, -1107165984, -1088877638, -1090038325, 1040244783)
		 + W(3, -1086251247, 1053330884, 1049266570, 1037513285)
		 + W(4, -1113957324, 1057377190, 1028890653, -1098504745)
		 + W(5, -1107976602, 1057673067, -1103454662, 1039941233)
		 + W(6, -1122078587, 1024512949, 1041725883, -1103661415)
		 + W(7, -1111525785, 1042772014, -1143554104, 1024552651);
	WS(1051978908, -1102077462);
	sum1 =
		W(0, -1132165009, 1045761591, 1013540534, -1106078467) + W(1, -1117187439, 1051430047, -1096198150, 1014010165)
		+ W(2, -1108837850, 1060286099, -1130717861, -1121999817)
		+ W(3, 1037183202, 1046972447, -1085387922, 1030141582) + W(4, 1028473682, -1128782822, -1105434962, 1008925446)
		+ W(5, 1045655273, 1028047735, -1101497054, 1018887490)
		+ W(6, 1025240990, -1178179968, -1110960744, -1122721428)
		+ W(7, 1033734537, 1035331372, -1102517015, 1026996307);
	sum2 = W(0, 1023072493, 974611657, -1101792417, -1112121991) + W(1, -1125531833, 1047662948, 1051899312, 1037288067)
		 + W(2, 1030396885, 1035351326, 1080526024, 1042102238)
		 + W(3, -1118880502, -1090109833, -1069022098, -1113214479)
		 + W(4, 1027419877, -1110942359, -1087739606, 1032127295)
		 + W(5, -1161271853, 1033315833, 1036440530, -1143368203)
		 + W(6, 1019485964, 1010290822, -1124554651, -1132377096)
		 + W(7, 1028708277, -1156901930, -1114394737, -1141169667);
	WS(1058455886, -1096183470);
	sum1 = W(0, -1105360672, -1112611850, 1060616064, -1104075433)
		 + W(1, -1112035684, 1032735242, 1033545283, -1111940643)
		 + W(2, -1105059667, 1048808633, 1051085625, -1115570744)
		 + W(3, -1103063975, 1042817013, -1097442806, -1097216429)
		 + W(4, -1112638549, 1058906409, -1102188695, -1107200030)
		 + W(5, -1104182327, 1047248804, -1103229812, -1108265532)
		 + W(6, -1106250503, 1047193699, -1106970890, -1119499692)
		 + W(7, -1103319623, 1057710235, -1109193562, -1106901731);
	sum2 = W(0, -1135393651, -1114274101, -1117767149, -1110403581)
		 + W(1, -1131009665, 1016197705, -1130986601, -1136444051)
		 + W(2, 1004138181, -1143366053, 1026922589, -1112183743)
		 + W(3, -1111055824, 1051632163, 1048764370, -1121253595)
		 + W(4, -1134829555, -1111579981, 1036257166, 1009689523)
		 + W(5, -1127256265, 1038147066, -1112945554, 989872074)
		 + W(6, -1113946573, 1025185617, -1143942149, -1123668797)
		 + W(7, 1010148467, -1137859715, -1123068365, -1123716033);
	WS(-1103618872, 1023577831);
	sum1 = W(0, 1041702149, 1057806109, -1091063799, 1022049043) + W(1, 1032268701, 997904496, -1106010126, -1102660926)
		 + W(2, 1021026046, 1057675340, -1090884608, 1046995709)
		 + W(3, 1032012647, -1129702414, -1094077941, -1100395542)
		 + W(4, 1023662430, 1056283152, -1094732237, 1050214494)
		 + W(5, -1111766616, 1039716321, -1100869456, -1096243374)
		 + W(6, -1112590149, 1049875952, -1105996279, 1047647816)
		 + W(7, 1042231991, 1054291708, -1098425069, -1100607928);
	sum2 = W(0, 1073849383, -1072987051, 1040644897, 1022236877)
		 + W(1, 1069429154, -1080077361, -1098556311, -1128073567)
		 + W(2, 1070121938, -1076996297, -1124122091, -1118780260)
		 + W(3, 1066905653, -1086754234, -1095882058, 1027638421)
		 + W(4, -1087755842, 1060194671, -1096747545, 1012182550)
		 + W(5, -1080359597, 1067521081, 1048551041, -1129108935)
		 + W(6, -1073496568, 1074652354, -1092793409, -1130588931)
		 + W(7, -1070245916, 1075883836, 1058695504, 1001812541);
	WS(1010873216, -1100304815);
	sum1 =
		W(0, -1154187044, 1045945805, -1102222630, -1113759340) + W(1, 1028741017, 1051026373, -1103217414, 1022415534)
		+ W(2, -1114247598, 1058185854, -1097780567, -1105383733)
		+ W(3, -1099084427, 1059904750, -1091550752, -1111624796)
		+ W(4, -1104966895, 1052860588, -1108718914, -1114326870)
		+ W(5, 994968800, 1038231664, -1110664976, -1110217221) + W(6, -1113228468, 1040557287, 1017403508, -1108875519)
		+ W(7, 1028263947, 1032103905, 1017865354, -1109350878);
	sum2 = W(0, -1114639192, -1100331344, 1035901690, 1012858414)
		 + W(1, 1039210963, 1069298433, 1043940791, -1126620651) + W(2, 1047528380, 1080352854, 1030733380, 1036529177)
		 + W(3, -1099502544, -1067747068, -1084572959, -1099630936)
		 + W(4, 1041344628, -1080996124, 1003800555, 1043527822)
		 + W(5, -1108972702, 1032407437, 1045939813, -1119860547)
		 + W(6, 1021595805, -1121090437, -1121287047, -1145664907)
		 + W(7, -1116883371, 1016604711, -1122259179, 1034105585);
	WS(1044302648, -1104457270);
	sum1 = W(0, -1115179413, 1029190781, -1108944696, -1115207128)
		 + W(1, -1101763748, 1045938783, -1102720380, 1013266237) + W(2, 999269803, 1034810490, 1038235218, 1025157307)
		 + W(3, -1106420033, 1055724168, -1101615303, -1105407492)
		 + W(4, 1041707045, 1053359959, -1094303566, 1045691477)
		 + W(5, -1128885581, -1100033022, 1043259278, -1113033137)
		 + W(6, -1110751840, 1037908026, 1011056201, -1114066571)
		 + W(7, 1029110244, 1035419021, -1123807773, -1113282394);
	sum2 =
		W(0, -1117238549, -1109414288, -1115125848, 1023475415)
		+ W(1, -1115295266, -1128441429, -1121954754, 1024122972)
		+ W(2, 1033754662, -1104877135, 1018153798, 1002646200) + W(3, -1095438097, 1053172955, 1038786210, -1106263750)
		+ W(4, -1106855439, 1056926069, -1104082080, 1034246226) + W(5, 1011060498, -1108715476, 1043675119, 1025499367)
		+ W(6, -1117460606, 1036225840, 1008366234, -1107090094)
		+ W(7, 1032653312, -1114450934, 1018894269, 1013321052);
	WS(1068015911, 1043072951);
	sum1 =
		W(0, -1127841379, -1101991257, 1041159238, 1035382295) + W(1, 1035792844, -1091973141, 1040826438, -1098419575)
		+ W(2, -1155603908, -1110119406, 1052691071, 1043898844) + W(3, 1018341976, -1095315357, 1053842800, 1030324599)
		+ W(4, -1111053022, -1107228151, 1042506601, -1108241413)
		+ W(5, 1044403491, -1111437840, 1050221764, 1043481954)
		+ W(6, -1112313859, -1097295811, 1030249017, -1098652336)
		+ W(7, 1005208661, -1103670736, 1046985745, 1032196534);
	sum2 = W(0, -1134315530, -1125722365, -1135384490, -1118933131)
		 + W(1, 1033824390, 1019923991, 998580556, 1027495017) + W(2, -1112867968, 1039464885, -1093291922, 1045077367)
		 + W(3, 1039862799, -1087456726, -1061395777, 1087627027)
		 + W(4, 1005143468, -1119378177, -1106942114, 1034637079)
		 + W(5, -1114969920, 1042059959, -1121281813, -1148550692)
		 + W(6, 1030354102, -1113780490, 1034179020, -1118611519)
		 + W(7, -1131720457, 1009971850, 1032010553, -1117397469);
	WS(1060186318, -1131602669);
	sum1 = W(0, 1022422466, 1050205114, -1099402401, -1112848707)
		 + W(1, -1102049002, 1052887138, -1102238785, -1106285089)
		 + W(2, 1050775273, 1052456073, -1100510367, 1039607513)
		 + W(3, -1097141731, 1049038746, -1088759247, -1098786589)
		 + W(4, 1056872997, 1040490435, -1122526498, 1048305743)
		 + W(5, -1099566807, 1039690728, -1099089908, -1104192622)
		 + W(6, 1025667942, 1043457059, -1102859210, 1032266998)
		 + W(7, 1032894309, 1045856748, -1106963501, -1118572779);
	sum2 =
		W(0, 989650422, -1120410947, 1047633630, -1081060940) + W(1, -1108234271, 1050158699, 1066272871, -1074101109)
		+ W(2, -1120122674, -1092804082, 1075424781, -1079387458) + W(3, 1045260201, 1024838498, 1061734347, 1050344942)
		+ W(4, -1114112879, -1125280065, -1091697647, 1043540897)
		+ W(5, 1037831837, -1119936776, 1003481288, 1039609275)
		+ W(6, -1117501250, -1114421818, 1011848513, -1131708367)
		+ W(7, 1024132690, 1035095434, -1106020023, 1026462111);
	WS(1057810382, 986287880);
	sum1 = W(0, -1105255365, -1110142276, 1041191503, 1050176972)
		 + W(1, 1027767677, -1106138450, 1031406779, -1130243957)
		 + W(2, 1037147968, -1092238936, 1027980992, 1041310918) + W(3, 1038550632, -1090210593, 1049547413, 1041377527)
		 + W(4, -1136315263, -1089134184, 1052451129, -1115128119)
		 + W(5, 1035749561, -1093055129, 1057536820, 1033537239)
		 + W(6, -1115075413, -1097497096, 1050343212, -1127231554)
		 + W(7, 1028257967, -1089420006, 1058108487, 1031965752);
	sum2 =
		W(0, -1099824579, 1070708271, 1075074245, -1097074436) + W(1, -1113793286, -1104040400, -1084124078, 1023561426)
		+ W(2, 1053512844, -1091831853, -1082668198, 1039380165)
		+ W(3, -1112943238, -1072548459, -1072503695, 1009216489)
		+ W(4, 1041834894, -1093778092, 1056090411, 1043969626) + W(5, -1099992002, 1057576575, 1053907302, -1107563771)
		+ W(6, -1120789532, 1064181862, 1058602971, 1034348623) + W(7, 1024916046, 1051972140, 1054786345, -1106961801);
	WS(-1075707047, 1038147646);
	sum1 =
		W(0, 1038492938, 1050722763, -1095596015, 1040870942) + W(1, -1115961531, 1026800423, -1103730686, -1122935577)
		+ W(2, 1036899040, 1055626176, -1091210886, 1047700685) + W(3, 1041066756, 1052178217, -1090286882, 1036539085)
		+ W(4, 1038870159, 1027667391, -1094135001, -1102625947) + W(5, 1045702796, 1053246416, -1095582752, 1048523811)
		+ W(6, 1022987667, -1100305296, -1109653838, -1105859960)
		+ W(7, 1044017707, 1049962981, -1093296229, -1117734303);
	sum2 =
		W(0, -1145353723, 1027969677, -1115030411, 1052090154) + W(1, -1113260796, -1095928859, 1031463199, -1110261785)
		+ W(2, -1112198364, 1052169305, -1108227013, 1041877601)
		+ W(3, -1113367096, 1052353113, 1051016428, -1099630700)
		+ W(4, 1007958125, -1129450520, 1041462653, -1087173862) + W(5, 1047146251, 1051473061, 1045242344, -1102681887)
		+ W(6, -1122974002, -1091037095, 1032341221, -1095485390)
		+ W(7, 1021064313, 1050393555, 1020102815, -1111896409);
	WS(-1102302520, 1068562064);
	sum1 = W(0, -1130894152, -1101486038, 1044130034, 1031789673)
		 + W(1, 1029216267, -1094978851, 1029251017, -1102217970)
		 + W(2, 1029150351, -1104755260, 1053252560, 1042516209) + W(3, 1029804895, -1093484995, 1050941559, 1040658618)
		 + W(4, -1108054071, -1110271975, 1036880709, -1113036417)
		 + W(5, 1046304488, -1106599349, 1050863202, 1041743615)
		 + W(6, -1107326720, -1102131284, -1128083416, -1102226940)
		 + W(7, 1018120580, -1102274525, 1047248574, 1032422999);
	sum2 =
		W(0, 1019111797, 1022527979, -1131519898, 1029130971) + W(1, -1123809812, -1111065998, 1023737355, -1117143513)
		+ W(2, 1006739898, 1031759809, 1045357020, -1106220344) + W(3, 1041109085, -1095097056, 1082939698, -1064938697)
		+ W(4, -1126211453, 1034613952, 1027342607, -1122955245)
		+ W(5, 1028972357, -1107360163, 1033832936, -1112280546)
		+ W(6, -1118372569, 1033659253, -1112248823, 1032152906)
		+ W(7, 1025713585, -1118642675, -1118824157, 1028082979);
	WS(1066566439, -1125753148);
	sum1 = W(0, 1020091828, -1096367972, 1038767583, 1030663671) + W(1, 1041951168, -1098758994, 1048997640, 1025331919)
		 + W(2, -1130301450, -1093467737, -1130818632, -1108818909)
		 + W(3, 1052053147, -1089881409, 1064063659, 1044746920)
		 + W(4, -1131231944, -1092544881, -1116991019, 1022962726)
		 + W(5, 1033588155, -1098181717, 1042770882, 1041997189) + W(6, 1009411772, -1110070786, 1046860728, 1018371147)
		 + W(7, -1116682291, -1096392077, 1027361773, 1038578846);
	sum2 = W(0, -1105507764, 1019815533, -1136431769, 1024962860)
		 + W(1, -1149004498, 1047279899, -1121679526, 1041000955)
		 + W(2, -1098298748, -1106660204, -1096656341, -1107413740)
		 + W(3, -1115729482, 1058550934, 1058580319, 1027135608)
		 + W(4, -1094576030, 1031191852, -1098228632, -1101441076)
		 + W(5, -1111478010, 1032716298, 1041490224, 1035067556)
		 + W(6, -1129010369, -1117054989, 1047791827, -1123460834)
		 + W(7, 1018600957, 1019851909, -1106522387, 1005788722);
	WS(1050996380, 1066787661);
	sum1 = W(0, 1042843177, -1109518091, -1098674409, -1112832565)
		 + W(1, -1120310187, 1043911830, -1097687209, -1133582755)
		 + W(2, 1033453959, 1059519229, -1096304487, -1116528532)
		 + W(3, -1107450543, 1061971625, -1098011863, -1105396874)
		 + W(4, 1017862620, 1051823058, -1095767039, 1033796902) + W(5, -1134072575, 1046601317, -1095249970, 999923683)
		 + W(6, 1025308393, 1042112788, -1098354285, 1030029487)
		 + W(7, 1033769739, 1046863997, -1098417599, -1109771063);
	sum2 =
		W(0, -1103321099, -1087654445, -1098379129, 1013739975) + W(1, 1033376724, -1114493691, -1096458683, 1015354012)
		+ W(2, -1108916223, 1049058628, 1036368268, -1121134774) + W(3, 1033194077, 1065240604, 1054396447, -1115257551)
		+ W(4, 1038197771, -1128335788, 1049730119, -1129699908)
		+ W(5, 1032881798, -1094150295, -1108472207, 1021079748) + W(6, 1017830932, 1006224046, 1031462702, -1117224382)
		+ W(7, -1138730935, -1112103411, -1102017203, 1038189385);
	WS(1027314912, -1081149641);
	sum1 = W(0, -1109480125, 1051429188, -1118844062, -1097611416)
		 + W(1, -1114947760, 1053252314, -1094077252, 1034118735)
		 + W(2, -1101195017, 1058130398, -1113091794, -1104617542)
		 + W(3, -1132100201, 1061393767, -1085308129, 1035982720)
		 + W(4, -1103759537, 1057940398, -1102037735, -1114189097)
		 + W(5, 1044342469, -1104522586, -1094497965, 1036294793)
		 + W(6, -1111893319, 1055491172, -1103334896, -1128796810)
		 + W(7, 1051194426, -1120202825, -1094870250, 1030785028);
	sum2 = W(0, -1131039707, -1098833779, -1147567565, 1035790053)
		 + W(1, 1024995350, -1124760267, 1057070390, 995065627)
		 + W(2, -1104486127, -1078713050, -1091843304, 1037354874)
		 + W(3, 1015537291, -1065942779, -1081156610, -1154356731)
		 + W(4, 1053996441, 1047686732, -1094140189, -1107145709)
		 + W(5, -1103676904, 1084085461, 1060423478, 1026796886) + W(6, 1047124046, 1064521940, 1046849692, -1108476011)
		 + W(7, -1111129691, -1093915430, 1018309905, 1038591472);
	WS(-1081542375, 1044780323);
	sum1 = W(0, 1026864081, 1046719985, -1098857847, -1114219435)
		 + W(1, -1100303790, 1054288460, -1108679899, -1104586877)
		 + W(2, 1048337215, 1054459103, -1098101851, 1041408644)
		 + W(3, -1098110473, 1048901488, -1093175556, -1098306531)
		 + W(4, 1054474587, 1041639871, -1104037973, 1046672715)
		 + W(5, -1099969099, 1034589376, -1107626335, -1104199322)
		 + W(6, 1023999910, 1043694031, -1101510966, 1022681657)
		 + W(7, 1028627178, 1046235480, -1106600025, -1126646775);
	sum2 =
		W(0, 1017985090, 1024212320, -1099849981, 1067245211) + W(1, 1027847194, -1098721130, -1081468176, 1074345814)
		+ W(2, 1036519222, 1050387030, -1070464929, 1070597407)
		+ W(3, -1113167123, -1094712479, -1096550174, -1088417301)
		+ W(4, 1037009826, -1100822056, 1057690620, -1104880956)
		+ W(5, -1113380621, 1028269032, 1042714784, -1102737214) + W(6, 1031131596, 1009055356, -1145638655, 1000105719)
		+ W(7, -1115360802, -1113841920, 1046010973, -1112342255);
	WS(1059294542, 1020616832);
	sum1 =
		W(0, -1157534552, -1096856701, 1050532499, -1112831597) + W(1, 1039080142, 1044861738, 1041652423, 1046540791)
		+ W(2, -1097783100, -1089052876, 1057029426, -1098369827)
		+ W(3, 1031217968, -1085780263, 1047119538, 1040272239) + W(4, -1164216296, 1044573672, 1039715347, 1024931118)
		+ W(5, -1138897989, -1097342660, 1043073721, -1103025619) + W(6, 1026686634, 1041475528, 1040308239, 1045404192)
		+ W(7, -1105498094, -1105558033, 1048391538, -1114523696);
	sum2 = W(0, -1106291706, 1040318024, -1114208076, -1142193319)
		 + W(1, 1001372950, -1105705183, -1116263519, -1145917455)
		 + W(2, -1099590495, 1045484852, -1108179199, 1036599633)
		 + W(3, -1093748925, 1061316313, 1049891427, -1108356360)
		 + W(4, 1015225205, -1098311584, 1040668388, -1148092276)
		 + W(5, -1105937891, 1041085521, -1111581107, 1032743264)
		 + W(6, -1112612361, 1028378294, -1115787941, 1021281994)
		 + W(7, 995169980, 1035732349, -1113959318, 1024794158);
	WS(1059376718, -1137270291);
	sum1 =
		W(0, -1118257199, 1043258576, -1114290826, -1112002778) + W(1, 1037392427, -1106073464, -1124279079, 1022160871)
		+ W(2, -1097794403, 1054680411, -1115190716, 1045843716) + W(3, 1035766677, -1099046488, 1052189312, 1011458515)
		+ W(4, 1026067385, -1088020070, 1054691490, -1110958220) + W(5, 1032186693, 1041392887, -1097245116, 1046761570)
		+ W(6, -1108679762, -1113652045, 1025610423, -1117145658)
		+ W(7, -1139304576, -1111666975, -1123561026, 1032305501);
	sum2 =
		W(0, 1025244035, 1033595807, 1016573022, 1002397687) + W(1, -1122852568, -1087687504, 1048825911, -1104089806)
		+ W(2, -1092220395, 1066421651, 1058107887, -1130145014)
		+ W(3, 1038019467, 1047700223, -1089540205, -1111655831) + W(4, 1048072683, -1084925862, 1045215493, 1032935415)
		+ W(5, -1113553750, 1050883425, -1098430697, 1015641098)
		+ W(6, -1119930901, -1105555859, 1041208433, 1001885951)
		+ W(7, -1139793711, -1146566911, -1124843514, -1131703250);
	WS(1058596686, 1013962118);
	sum1 =
		W(0, 1000024554, 1052551424, -1088298614, 1039656505) + W(1, -1127551432, 1049056438, -1098656348, 1034731345)
		+ W(2, -1100000762, 1057499982, -1090756927, 1019232187) + W(3, 1035333436, 1036076760, -1097067922, 1033429441)
		+ W(4, -1122612871, -1127972943, 1040213184, -1125045580)
		+ W(5, 1044766998, -1116046252, 1015197910, -1113717771)
		+ W(6, 1041477861, -1118015335, -1123679237, 1037833508)
		+ W(7, 1051562743, -1099275107, -1122278672, -1122272135);
	sum2 =
		W(0, -1104434141, 1048601996, 1033271157, 1004930429) + W(1, 1029025211, -1091369704, -1119340081, 1028438774)
		+ W(2, -1078497608, 1052827694, 1025214064, -1106316897)
		+ W(3, -1079110377, -1106615386, -1109539756, 1034989376)
		+ W(4, -1085502108, -1115334546, 1050957039, -1108631008)
		+ W(5, 1066279808, 1037382016, -1106594885, 1023198169) + W(6, 1062913146, -1122817088, 1036274829, -1134348613)
		+ W(7, 1068620036, 1048688798, -1118139306, -1139733884);
	WS(1044771128, 1023341948);
	sum1 =
		W(0, -1156220044, -1092336191, 1051560294, 1036528391) + W(1, 1034545464, -1098819215, 1044146859, 1029114797)
		+ W(2, 1033488922, -1096491302, 1051910286, 1022761170) + W(3, -1111313058, -1086850728, 1045449190, 1029767950)
		+ W(4, 1038420969, -1102939421, 1053458817, 1041877300) + W(5, 1008511890, -1100928894, 1038883707, 1034675856)
		+ W(6, 1013986230, -1115524377, 1012126018, 1037411178) + W(7, 1011084871, -1089482302, 1046748951, 1043196317);
	sum2 =
		W(0, -1071004894, 1076503146, 1057610169, -1122913984) + W(1, -1080574884, 1066884159, -1107351326, -1130255370)
		+ W(2, -1089987082, 1058011283, 1054000347, 1038970611) + W(3, 1049506323, -1098882467, -1090234844, 1014162118)
		+ W(4, 1065282653, -1084978169, 1030898490, -1114000490)
		+ W(5, 1062249589, -1088626314, -1090230279, 1022492087)
		+ W(6, 1060165079, -1082249713, 1044380003, -1131621088)
		+ W(7, 1070844945, -1077734377, -1096516163, 1013009282);
	WS(-1111817840, -1134998409);
	sum1 = W(0, 1022731056, -1102901203, 1029699069, 1021112442)
		 + W(1, 1045262352, -1094315057, 1052915216, -1107194439)
		 + W(2, 1044888721, -1085070720, 1058770140, -1097785743)
		 + W(3, 1029818259, -1111793509, 1057078063, -1117717150)
		 + W(4, -1105915720, 1055206544, -1095183540, 1040740592)
		 + W(5, -1114660906, 1046806370, -1097451385, 1036425016)
		 + W(6, 1027479949, -1123039746, -1112670352, 1005586201)
		 + W(7, 991785104, -1136267423, -1114500629, 1016465988);
	sum2 = W(0, -1129690332, -1113356803, 997943457, 1015499837)
		 + W(1, 1030842707, 1026318374, -1119512995, -1180561029)
		 + W(2, -1123486113, 1041923626, 1037525758, -1144014736)
		 + W(3, 1054087898, -1089332833, -1088292904, 1037328869)
		 + W(4, -1105176966, 1068558125, 1040210770, -1107365912)
		 + W(5, -1097205966, -1141184456, 1050151959, -1114055561)
		 + W(6, -1098021434, -1107728348, 1018682892, 1009592392)
		 + W(7, -1106929221, -1104288342, 1006954668, 1013301204);
	WS(-1100650808, 1043653943);
	sum1 = W(0, 1038392637, 1044290651, -1095199164, 1033771919) + W(1, 1032036848, 1040683515, -1115398639, 1038316223)
		 + W(2, -1120772452, -1106266873, -1094097345, 1042896310)
		 + W(3, 1043637149, -1090111931, -1097393337, 1045751664)
		 + W(4, 1040259489, -1133467790, -1104941765, -1159203906)
		 + W(5, 1047398869, 1044787930, -1101572298, 1015063331) + W(6, 1038054351, 1023591523, 1016760834, 1030908740)
		 + W(7, 1050576478, 1037223428, -1102689443, -1125005703);
	sum2 = W(0, 1018053796, 1046306039, -1101305605, 1031448374) + W(1, 1000548496, 1043541862, 1029064982, -1112893849)
		 + W(2, 1049079603, 1010667960, -1116813778, 1021972628) + W(3, 1039189619, 1064529690, 1038487223, -1105518867)
		 + W(4, -1128574308, 1047996002, -1100258391, 1037842238)
		 + W(5, -1118597354, -1087406141, 1048794746, 1033382833)
		 + W(6, -1106984497, -1095617964, -1114392997, 1021089548)
		 + W(7, -1104543855, -1086946593, 1045938007, -1140458600);
	WS(-1121537248, 1047151836);
	sum1 = W(0, -1096325448, 1052654400, 1000450324, -1116556387)
		 + W(1, -1113135282, 1035132488, -1110395025, 1023519458)
		 + W(2, -1098188693, 1046868890, -1139200797, -1111260975)
		 + W(3, -1112146268, -1134150082, 1049727010, -1110207458)
		 + W(4, -1108791588, -1129891280, 1041189572, -1104838938)
		 + W(5, -1117696601, -1098847494, 1056884317, -1098805187)
		 + W(6, -1123869651, 1032919412, 1041128337, -1146298440)
		 + W(7, -1114157115, -1107856679, 1058220805, -1103148146);
	sum2 = W(0, -1142864271, 1043572739, -1125571574, -1107989855)
		 + W(1, 1021304865, 1026011378, 1028667063, -1140649559) + W(2, 1043366966, -1102859954, 1022196210, 1020722946)
		 + W(3, -1107584343, -1080136051, -1072538638, -1132367054)
		 + W(4, 1014758407, -1103597159, -1076945816, 1041979768)
		 + W(5, -1130465374, -1115654645, 1048815254, -1126224006)
		 + W(6, -1120740451, 1046511165, 1072551214, 1027667511) + W(7, 1000478551, 1053224660, 1074776028, 1048839210);
	WS(-1086568910, 969651201);
	sum1 = W(0, -1128189323, -1096064919, 1047521403, 1043461231)
		 + W(1, 1044154939, -1089612648, 1054908701, -1099266659)
		 + W(2, 1043534732, -1084798775, 1056987371, -1113308531)
		 + W(3, -1114366976, 1053159863, 1057685165, -1152040120)
		 + W(4, -1098469330, 1053431542, -1089249613, 1042761408)
		 + W(5, -1101372520, 1050787607, -1090701774, 1049635020)
		 + W(6, -1123038043, 1036747448, -1105030179, 1010635844)
		 + W(7, -1132910587, -1116020373, 1027268120, 1018344000);
	sum2 = W(0, 1042932965, -1103892922, -1104364155, -1139842168)
		 + W(1, -1103428495, 1060495074, 1060109323, -1118896922) + W(2, 1039997403, 1052448567, 1064108701, 991756114)
		 + W(3, -1093583228, -1075640666, -1073056297, -1097481656)
		 + W(4, 1044856824, 1057723154, 1055665788, 1040659602) + W(5, -1121819542, 1057002090, 1060503917, -1099984054)
		 + W(6, -1177180368, -1112150955, -1116550688, 1034919451)
		 + W(7, 1028413178, -1118134166, -1110515035, 1041069777);
	WS(-1084093518, -1116656412);
	sum1 = W(0, 1002008836, 1058416208, -1096672513, -1112390467) + W(1, 959481663, 1026388179, -1109778819, 1023428581)
		 + W(2, -1104590931, 1059097973, -1088144465, -1112632704)
		 + W(3, 1050696243, 1042079029, -1096264126, 1040470858)
		 + W(4, -1106608235, 1041679827, -1101432288, -1102954054)
		 + W(5, 1047962207, 1049127990, -1100480244, 1047012782)
		 + W(6, 1030562773, 1031439243, -1113594772, -1112144502)
		 + W(7, 1015783795, 1042535660, -1093923750, -1145396437);
	sum2 = W(0, 1007960967, 1027407916, -1129957403, -1132155403)
		 + W(1, -1110192070, 1010716935, 1018303319, -1121935910)
		 + W(2, 1049899326, -1097456083, 1037417999, -1137993343)
		 + W(3, 1056650247, -1070859565, -1094713389, -1142796285)
		 + W(4, 1078512141, -1068241064, -1096379657, 1039214170)
		 + W(5, 1081472440, -1079514242, 1043613542, -1111213656)
		 + W(6, 1058404171, -1094427160, 1025537830, 1032528613) + W(7, 999915485, 1030657127, -1116925932, 1024356221);
	WS(1052225948, 1018668194);
	sum1 = W(0, -1120453498, 1051775516, -1117579103, -1107074656)
		 + W(1, -1123160289, 1048325451, -1111291056, -1112742544)
		 + W(2, -1108654867, 1058214550, -1093397513, -1147977428)
		 + W(3, -1104839613, 1064670427, -1091445969, -1119335936)
		 + W(4, 1041378113, -1126638409, -1092047898, -1109154218)
		 + W(5, 1036965515, 1049967085, -1099225050, 1034167881)
		 + W(6, 1044186084, -1096299613, -1112850625, -1138567959)
		 + W(7, 1034438594, -1128237844, -1112057991, 1019177609);
	sum2 = W(0, -1121001958, -1117606942, -1103097305, -1130038396)
		 + W(1, -1148685985, -1111847761, 1021935234, -1112487949)
		 + W(2, 1018483434, -1120566718, 1049895592, 1038078839)
		 + W(3, 1021815720, -1076982600, -1081972918, -1125812992)
		 + W(4, 1049361594, 1074852012, 1051964198, -1152546434)
		 + W(5, -1108634723, 1048076514, 1040925857, -1104919092)
		 + W(6, -1132118692, -1102180777, 1017568960, 1026180028)
		 + W(7, -1105580672, -1116866514, 1040155911, -1123068468);
	WS(-1096382876, -1091051652);
	sum1 = W(0, -1116126267, 1057278592, -1096000788, -1116910752)
		 + W(1, -1113197617, 1048826126, -1097274020, -1140807037)
		 + W(2, -1112424211, 1058810754, -1088739494, 1039925053)
		 + W(3, -1124324715, 1056304110, -1091311905, -1132679170)
		 + W(4, -1136579346, 1041995897, -1114916522, -1107191661)
		 + W(5, 1040875430, 1016295122, 1038826452, -1119450067)
		 + W(6, -1113905512, 1024916389, -1128507781, 1023437062)
		 + W(7, 1017323784, 1042534003, 1017648027, -1098370349);
	sum2 = W(0, -1120311657, 1025682064, 1036682152, -1108273289)
		 + W(1, 1036113080, -1107470193, -1108061877, 1012612647)
		 + W(2, -1109045199, 1035621932, 1051542033, -1101063214)
		 + W(3, 1029662296, -1118009189, -1101792442, -1076098595)
		 + W(4, -1122358251, 1045290388, -1093646778, -1080861029)
		 + W(5, -1114085873, 1009830751, 1056395710, 1039398973) + W(6, 1016737279, 1035169596, -1091719234, 1065137390)
		 + W(7, -1115835645, 1030264440, 1052430993, 1072502688);
	WS(1040082544, -1114755812);
	sum1 = W(0, 1017784372, -1110974758, 1040296296, 1024480479)
		 + W(1, 1037505264, -1108514902, 1041424680, -1104471944)
		 + W(2, 1045745417, -1095324708, 1054913780, -1106439461)
		 + W(3, 1019379817, 1052579502, -1106396419, -1115066496)
		 + W(4, -1109308706, 1058051822, -1087512533, 1040857799)
		 + W(5, -1124056118, 1046163210, -1093666877, 1001482384) + W(6, 1025470519, 1038459986, -1106674096, 995688529)
		 + W(7, 1039469090, 998280780, -1109356390, -1108404770);
	sum2 = W(0, -1162396366, 1045315846, 1034748092, 1035646876)
		 + W(1, -1117720653, -1118054954, 1034773210, -1100298043)
		 + W(2, -1104226850, 1057942904, 1043388435, -1097646834)
		 + W(3, -1105580348, 1059476362, 1067689202, -1093789486)
		 + W(4, -1105643813, -1090022037, -1083232471, 1040357620)
		 + W(5, 1031813906, 1045409162, -1101262587, -1113573448)
		 + W(6, 1011045214, -1106412098, -1124577575, 1012935222)
		 + W(7, 1018164327, 1023977529, -1102021751, 1024454049);
	WS(1036525168, -1082462584);
	sum1 = W(0, -1116308971, -1085123800, 1057675329, 1019612704)
		 + W(1, 1037298441, -1087372070, 1051660338, 1027541711)
		 + W(2, 1027885589, -1086414101, 1059597873, -1109257541)
		 + W(3, -1122874917, -1096064460, 1059581688, 1041073820)
		 + W(4, -1154089797, -1099879381, 1052784510, 1028059367)
		 + W(5, -1108384819, -1104319094, -1117339864, 1045372305)
		 + W(6, 1028179743, -1127380522, 1039251609, 1031554934)
		 + W(7, 1003463273, -1096394215, -1110971807, 1053758651);
	sum2 =
		W(0, 1060691160, -1081285622, -1080809247, 1052276353) + W(1, -1103295177, -1090050073, 1050684042, -1106187369)
		+ W(2, 1035985281, -1102851017, -1087522637, 1048638013)
		+ W(3, -1085964582, 1072728426, 1060852217, -1090587145) + W(4, -1105398566, 1060511611, 1058511518, 1029176048)
		+ W(5, -1107551093, 1033954581, 1041242888, -1094879840) + W(6, 1049030608, -1086630634, 1028348456, 1046256182)
		+ W(7, -1090293163, 1058069039, 1062481845, -1087039462);
	WS(-1074352935, 1040600857);
	sum1 =
		W(0, 1042034194, 1057627204, -1090157751, 1024364622) + W(1, 1028652336, 1025049468, -1105875707, -1105990299)
		+ W(2, 1024054004, 1057567995, -1088931067, 1048022018) + W(3, 1030695172, 1022098295, -1095088235, -1100928004)
		+ W(4, 1029627411, 1052602222, -1094832321, 1049957878)
		+ W(5, -1117605317, 1039437212, -1104356174, -1095846092)
		+ W(6, -1114002447, 1049556590, -1107260676, 1047165477)
		+ W(7, 1041624512, 1053416947, -1101255271, -1098759166);
	sum2 = W(0, -1075440350, 1073165865, -1112383192, -1148975848)
		 + W(1, -1079714919, 1065983198, 1048707236, -1115591486)
		 + W(2, -1079134350, 1068716226, -1135853868, 1038054064)
		 + W(3, -1081735031, 1066499710, -1098543278, -1125971282)
		 + W(4, 1055569671, -1095308006, 1021808504, 1040311395)
		 + W(5, 1066585571, -1080754250, -1108920844, -1110109816)
		 + W(6, 1071644179, -1074800849, 1050977418, 1035370814)
		 + W(7, 1075476470, -1073191304, -1090378667, -1120408347);
	WS(1041022776, 1033480094);
	sum1 =
		W(0, -1132576057, 1026327841, -1110434490, -1119031508) + W(1, -1123321429, 1042302896, -1109312954, 1021323174)
		+ W(2, 1028959481, 1052457903, -1089918670, 1029242558) + W(3, -1104176578, 1063677500, 1025377120, -1118638740)
		+ W(4, 1046472198, -1097607903, -1090934974, 1013298461)
		+ W(5, -1121060138, -1123802109, 1046523967, -1106699146)
		+ W(6, 1027556403, -1118671609, -1112257611, 1030036314)
		+ W(7, -1115611836, 1039698959, 1000531209, -1116635705);
	sum2 =
		W(0, -1106027239, 1049930690, -1110218398, 1034564779) + W(1, -1122286155, -1127267122, -1108798456, 1018367610)
		+ W(2, -1102546078, 1041115945, 1058786995, -1095860458) + W(3, 1055155948, -1091935564, 1075372513, 1043590800)
		+ W(4, -1096754888, 1052250618, -1071163371, -1112711414)
		+ W(5, 1032068992, -1103388917, -1123143101, -1119323979)
		+ W(6, -1121774513, 1038737216, -1121707895, 1016553114)
		+ W(7, 1036170969, -1108790214, 1032355550, 1017858173);
	WS(1055618972, -1117202987);
	sum1 =
		W(0, 1030962480, 1039894129, -1101932469, 1031993659) + W(1, -1101414710, 1053882576, -1089999221, 1048656807)
		+ W(2, -1098100923, 1057347458, -1085784352, 1043352452) + W(3, -1111740150, 1049814740, 1051098296, 1031031542)
		+ W(4, 1036980413, -1090053902, 1056052448, -1104607674)
		+ W(5, 1041005827, -1088233382, 1051763396, -1119077705) + W(6, 1021681163, -1105970903, 1044301630, 1022017143)
		+ W(7, -1112834597, -1117339136, 1032801282, 1039235901);
	sum2 = W(0, -1114659327, -1101541229, -1107338771, 1039378885)
		 + W(1, -1123577690, 1043634319, 1057974128, -1111523166) + W(2, 1042921002, 1066882360, 1050113378, 1040130625)
		 + W(3, -1105097716, -1077668162, -1080704784, -1104122760)
		 + W(4, 1042773509, 1037629509, 1051155360, 1012227066) + W(5, -1093975266, 1058638399, 1052705661, -1110420726)
		 + W(6, 1032061179, -1108208741, 1008396554, -1125218199)
		 + W(7, 1000405669, -1131856909, -1111189711, 1025207949);
	WS(-1091387548, -1116324289);
	sum1 = W(0, 1026642697, -1112220622, 1049897926, 1027958127)
		 + W(1, 1044682252, -1093973688, 1047211372, -1098544270)
		 + W(2, 1041967213, 1046046637, 1050365286, -1112662293)
		 + W(3, 1032214050, -1086442024, -1112122925, -1106755108)
		 + W(4, -1131062694, -1099996941, 1046223135, -1116559746)
		 + W(5, 1015214154, 1053177927, -1132096750, 1034258897)
		 + W(6, -1137069945, -1098783494, 1024489425, -1111108842)
		 + W(7, -1110158325, 1037567917, 1042021623, 1031638516);
	sum2 =
		W(0, -1108095393, 1011776651, -1101257730, 1019145070) + W(1, 1016776222, 1024100809, -1105403134, 1032882678)
		+ W(2, 977935538, -1097248934, -1101986254, -1124027994)
		+ W(3, -1122468710, 1057627889, 1060632600, -1103033100) + W(4, 1019959206, 1042194141, -1090719303, 1039533068)
		+ W(5, 1030099429, -1117226417, 1037412790, -1110127978)
		+ W(6, -1104930054, 1051928720, -1109292621, -1125661478)
		+ W(7, 1002749526, 1041814459, -1115385474, -1108291818);
	WS(1057965518, -1118811194);
	sum1 =
		W(0, -1104352985, -1106566686, 1052732873, -1107147458) + W(1, 1038892389, -1112643723, 1003767366, -1114250980)
		+ W(2, -1105058276, 1026830542, 1060358287, -1096574819) + W(3, 1042490232, -1091938531, 1019887594, 1048844541)
		+ W(4, -1121521774, 1058056073, -1118338013, 1024329053)
		+ W(5, -1099594944, -1101314965, 1042464324, -1107780158)
		+ W(6, 1033536020, -1098044778, 1024562028, 1032778872)
		+ W(7, -1095161930, 1039936570, 1046000094, -1107207172);
	sum2 =
		W(0, -1116205334, 993944814, 1032713731, -1106373772) + W(1, 1042905425, -1113078065, -1104977559, 1039619019)
		+ W(2, -1109155755, 1044406596, 1048672381, -1115343154) + W(3, 1044205280, 1040105843, -1104277422, 1048332350)
		+ W(4, 1035597621, 1043112037, -1103087244, 999501191) + W(5, 1008636092, -1123380436, -1153474446, -1106439836)
		+ W(6, 1036458751, -1105268129, 1015784078, 1021528398)
		+ W(7, -1092853308, 1005260887, 1036094123, -1106473413);
	WS(1053420700, 1049909457);
	sum1 = W(0, -1115258034, -1106165874, 1050401361, -1113250117)
		 + W(1, 1034071238, -1089903413, 1041332866, 1023742249) + W(2, 1027276239, 1036166247, 1049384898, -1130552842)
		 + W(3, -1115686559, -1100423414, 1037380859, -1120158506)
		 + W(4, 1041096236, -1093491554, 1052388787, 1037333727)
		 + W(5, -1102788144, 1049835542, 1034784425, -1103514783)
		 + W(6, 1034068157, -1095323722, 1031952854, 1037170040)
		 + W(7, -1107460367, -1110396954, 1050882791, -1114330639);
	sum2 = W(0, -1112500393, 1024557142, -1136367764, 1020782048)
		 + W(1, 1028289272, -1165623582, 1035333264, -1122738507)
		 + W(2, 1049127312, -1095250820, -1114028070, 1025362120)
		 + W(3, 1086771603, -1062269001, -1087155359, 1034731082)
		 + W(4, 1048088739, -1095068995, 1022077560, -1125007838) + W(5, 1020087240, 999933935, 1034746908, -1120796207)
		 + W(6, 1014851096, -1135945992, -1120864651, 1026594640)
		 + W(7, -1146529543, 1025716258, -1127622484, -1128255426);
	WS(1063806286, 1027083983);
	sum1 = W(0, -1114823180, 1045480194, -1118427516, -1109705966)
		 + W(1, 1030313470, 1039206373, -1106496703, 1020453816)
		 + W(2, -1111791457, 1061885616, 1010686340, -1103432478)
		 + W(3, -1111977289, 1050451993, -1083830979, 1039658735)
		 + W(4, -1108043857, 1057912708, -1099420545, -1114670584)
		 + W(5, 1019729830, 1036575619, -1105267089, -1109909656)
		 + W(6, -1114640622, 1039765761, -1131920190, -1113587473)
		 + W(7, 1033983240, 1034424532, -1125840468, -1112770081);
	sum2 =
		W(0, 1033978022, -1122290634, 1016780797, -1164938552) + W(1, -1100194899, -1091664523, -1103111994, 1002490582)
		+ W(2, 1033701105, -1071413373, 1047766898, -1105595809) + W(3, 1050426550, 1075108998, -1096749849, 1051489664)
		+ W(4, -1104028404, 1062092502, 1027350687, -1108336227)
		+ W(5, 1034191613, -1103668501, -1131589290, 1021076655)
		+ W(6, -1141130302, 1034149895, -1131724600, -1149103768)
		+ W(7, 1010895851, -1140709165, 1027888251, -1131210373);
	WS(1058288590, 1045994186);
	sum1 = W(0, 1018135640, -1093342072, 1052167946, 1038262801)
		 + W(1, -1123855059, -1096797372, 1041780692, 1015346466)
		 + W(2, 1040223430, -1086390197, 1052872019, -1132654257)
		 + W(3, -1112801779, -1105293320, 1059840396, -1134794696)
		 + W(4, 1036317947, -1091216419, 1051866430, -1117665797)
		 + W(5, -1098800665, -1117054299, 1050341107, 1012611090)
		 + W(6, 1034707665, -1096209979, 1048652350, -1139713758)
		 + W(7, -1096517871, 1023470716, 1050625648, 1010858330);
	sum2 = W(0, 1041114210, -1099008397, -1123917868, -1125418381)
		 + W(1, -1099284356, 1047276236, -1111523652, -1120564910)
		 + W(2, 1038292116, -1081084758, 1037708884, 1020505319)
		 + W(3, -1092208278, -1071665325, -1086778305, -1100128811)
		 + W(4, 1054381469, 1054365119, -1101037019, 1024474915)
		 + W(5, -1104534119, 1081581342, 1026238413, -1125603475)
		 + W(6, 1025804573, 1062322644, -1134916894, 1025011807)
		 + W(7, 1033400256, -1093538640, 1052085127, -1103707544);
	WS(-1088887374, 1070119449);
	sum1 = W(0, 1040460421, 1052058645, -1090595183, -1105506686)
		 + W(1, 1041554590, 1048371361, -1115426747, 1029097335)
		 + W(2, 1013850612, 1048732808, -1094790815, -1129317061)
		 + W(3, 1038262022, 1042754705, -1087902678, 1001782464) + W(4, 1042710919, 1047384127, -1106656361, 1038072126)
		 + W(5, -1106869091, 1054439312, -1090477876, -1131475029)
		 + W(6, 1044864290, 1032508990, -1122940954, 1028935005)
		 + W(7, 1046057615, 1042772520, -1091795237, -1119515740);
	sum2 =
		W(0, 1024604999, 1056461606, 1071685965, -1075212110) + W(1, -1112923336, 1030035123, 1066713447, -1080779344)
		+ W(2, 1027433809, 1050727550, 1068313262, -1078194918) + W(3, 1025504127, -1090534096, 1028028856, -1153515923)
		+ W(4, 1007245204, -1105339223, -1081367671, 1068056044)
		+ W(5, -1144581942, -1095507508, -1078816510, 1069903211)
		+ W(6, -1129047399, 1043793174, -1081156501, 1064173276)
		+ W(7, 1021294865, -1095638178, -1090770344, 1060536751);
	WS(1040470840, 1011790950);
	sum1 = W(0, 1015095158, 1043725275, -1105535856, -1108386992)
		 + W(1, -1120734562, 1051465082, -1108441440, 1030149375)
		 + W(2, -1116691398, 1058372660, -1095343471, -1112701741)
		 + W(3, -1118217942, 1055309890, -1081260869, 1026499745) + W(4, 1019898057, 1046636817, 1047492563, 1032201014)
		 + W(5, -1123629847, 1044874098, -1093096561, -1115283258)
		 + W(6, 1034607368, 1043010193, -1105294873, 1028457510)
		 + W(7, 1041822001, 1040878843, -1106259483, -1112399171);
	sum2 =
		W(0, 1022830461, -1117997331, 1037270083, 1023767946) + W(1, 1021246145, -1110014342, -1125616185, -1130403951)
		+ W(2, 1015115055, -1111993293, 1044158772, 1025796328) + W(3, -1114703004, 1036613835, 1073620398, 1050812248)
		+ W(4, -1120910531, 1023720090, -1076883688, -1112499600)
		+ W(5, 1015720307, -1117604953, -1087890801, 1028283916) + W(6, 983370825, -1120463052, 1025754476, -1104874229)
		+ W(7, -1123770073, 1036937497, -1113287589, 1033737696);
	WS(1058309838, -1101980246);
	sum1 =
		W(0, -1118965337, -1110907254, 1038642111, 1028903966) + W(1, -1098779704, 1049643561, 1038999679, -1108240479)
		+ W(2, 1049071256, -1081904943, 1054751182, 1040887994) + W(3, -1113399754, 1042163763, 1056093093, -1118832415)
		+ W(4, 1026571427, 1052138696, -1083956910, 1046797612)
		+ W(5, -1110569018, -1106220306, 1050507993, -1104697276)
		+ W(6, -1131332475, 1025191299, -1146247429, -1123883748)
		+ W(7, -1128371676, -1129449041, 1030864044, 1017502086);
	sum2 = W(0, -1137655511, -1111106723, 1035105104, -1112318930)
		 + W(1, 1043191716, 1033166752, -1112822728, 1027572041)
		 + W(2, -1121349336, 1033268708, -1104857525, 1035699332)
		 + W(3, -1097517035, 1052576386, 1055574555, -1097542777)
		 + W(4, 1046822141, -1107318253, -1114990789, -1110157019)
		 + W(5, -1129223371, -1102887232, -1121581721, 1031007843)
		 + W(6, -1116759551, 1040601750, -1152414880, -1157281192)
		 + W(7, -1124684976, 993535634, -1107957817, 1025775603);
	WS(1063710542, -1111213649);
	sum1 = W(0, 1039559517, 1052251350, -1101160384, -1113889808)
		 + W(1, -1110192145, 1049489370, -1097695264, 1031901152)
		 + W(2, -1107309859, 1058328276, -1093740712, -1104513406)
		 + W(3, -1118762901, 1061120005, -1096321197, -1097003636)
		 + W(4, -1108199122, 1049656673, -1097289639, -1112381384)
		 + W(5, 1037245627, 1033876357, -1114972772, -1176476024)
		 + W(6, -1139769966, 1041987905, -1102516745, 1022802380)
		 + W(7, 1035326852, 1045428971, -1103522251, -1115185874);
	sum2 = W(0, 1026803387, -1115186477, 999853755, -1112425236) + W(1, 1021750253, 1031459540, 1031446318, -1106593609)
		 + W(2, 1040812059, -1116326399, 1058720440, -1086524651)
		 + W(3, -1107480079, 1040651083, 1071698983, -1075753828)
		 + W(4, 1041131835, 1020594503, 1051128601, -1096266051)
		 + W(5, -1115082464, 1033768858, 1034660038, -1108942599)
		 + W(6, 1006187407, -1132516997, 1027131696, -1123360193)
		 + W(7, 1001155939, 1015478283, 1041372466, -1104453127);
	WS(1039772272, -1082982873);
	sum1 = W(0, 1039127452, 1049032497, -1098139952, -1155633625)
		 + W(1, -1106264016, 1053169593, -1088020664, 1043520647)
		 + W(2, -1104546353, 1060522592, -1087153807, 1040400554)
		 + W(3, -1145518233, 1056693961, 1038834197, -1139907193)
		 + W(4, 1041713673, -1095982984, 1053429837, -1104883452)
		 + W(5, 1044410893, -1088607916, 1048228018, -1103034636)
		 + W(6, 1039725795, -1099512929, 1030077856, -1134131855)
		 + W(7, 1007790526, -1120546088, -1130616150, 1012687882);
	sum2 =
		W(0, 1032987173, -1092902636, 1027660911, 1032111389) + W(1, -1102803435, 1037122437, 1039508875, -1101516234)
		+ W(2, -1097110538, -1083842457, -1115097563, 1001644292)
		+ W(3, -1101871105, 1067610414, 1067552095, -1104358647)
		+ W(4, -1101555589, 1033006847, -1096151174, -1145661076)
		+ W(5, -1123533577, 1041814167, 1026567371, -1104681426)
		+ W(6, -1098769512, 1045724867, -1107225085, 1020958965) + W(7, 1048796624, 999019252, -1105667947, 1028203943);
	WS(-1101412664, 1073047832);
	sum1 = W(0, -1113880945, 1059007377, -1091904865, -1133362719)
		 + W(1, -1123950537, 1047579477, -1097814305, -1131741454)
		 + W(2, -1109995975, 1060416389, -1087199740, 1032803377)
		 + W(3, -1123565085, 1056063051, -1092124214, -1113780884)
		 + W(4, -1123728428, 1046383171, -1099567891, -1113889390)
		 + W(5, 1035385983, 1040643140, 1038341800, -1126485237)
		 + W(6, -1115318676, 1033389702, -1119557930, 1012558775)
		 + W(7, 1010675502, 1041003725, 1042882861, -1096461162);
	sum2 = W(0, 1013686761, 1030949359, -1109223248, -1132915573) + W(1, -1123503757, 1039110679, 1035635962, 996209923)
		 + W(2, 1035262859, -1105775253, -1106751414, 1029135163)
		 + W(3, -1115490710, 1027204409, 1057425426, 1070858778) + W(4, 1025861040, 1019519396, 1043312829, 1067133266)
		 + W(5, 980681483, -1111394964, -1098000154, -1098902818)
		 + W(6, -1125276038, 1024413043, 1051287795, -1083268694)
		 + W(7, -1129892230, -1126757058, -1103421662, -1073095921);
	WS(-1103532344, -1105840701);
	sum1 =
		W(0, -1106756472, -1105825052, 1050195304, 1044840709) + W(1, -1106322913, 1053932942, 1007328528, -1104890465)
		+ W(2, 1029810954, -1086676361, 1057202097, -1144507642)
		+ W(3, -1096389739, -1098358914, 1054492326, -1098185309)
		+ W(4, -1116067305, 1054020609, -1093369370, 1032208700) + W(5, 1035916925, -1096691570, 1012599092, 1048715303)
		+ W(6, -1105566449, 1051257001, 1027855335, -1100267787)
		+ W(7, 1034505108, 1026552303, -1101687900, 1050640157);
	sum2 = W(0, -1111707317, -1101137684, -1116414033, -1103752872)
		 + W(1, -1119262447, -1109186725, -1107841286, 1034593530)
		 + W(2, 1037989791, 1049211868, 1056722210, -1110917586)
		 + W(3, 1056036881, -1099242284, -1094543747, 1049861706)
		 + W(4, -1105645897, 1038198606, 1053421235, 1030171051)
		 + W(5, 1006194414, -1118866635, -1104714858, -1103907620)
		 + W(6, -1146663095, -1109483964, -1120693058, 1032413269)
		 + W(7, -1129479912, -1114787638, -1115357885, 1029169157);
	WS(1045178680, -1115117954);
	sum1 = W(0, -1102680211, 1048681528, 1019008549, 1008490315)
		 + W(1, -1123018420, -1113607536, 1040296293, 1012835273)
		 + W(2, -1116849368, -1092105355, 1035615004, 1027033246)
		 + W(3, 1024407336, -1093530556, 1061339424, -1128145511)
		 + W(4, -1107241006, -1096193779, 1057711678, -1103222073)
		 + W(5, 1026392201, -1102060551, 1055864515, -1110547491)
		 + W(6, -1107918421, -1102337510, 1045891981, -1110097884)
		 + W(7, -1123314455, -1095199752, 1052562824, 1020395952);
	sum2 = W(0, -1108321996, -1096948503, -1112108000, 1026091852)
		 + W(1, -1115537892, -1104693583, -1112710060, 1022753169)
		 + W(2, -1106228104, 1047339287, -1126080161, -1120501740)
		 + W(3, 998645667, 1055675007, 1051246853, -1105262859) + W(4, -1112292909, 1049114511, 1041989299, -1123292948)
		 + W(5, 1035781218, -1100682049, 1025978716, -1139782977)
		 + W(6, -1111036660, 1032758858, 1034053890, -1111667328)
		 + W(7, 1018530825, -1113969306, -1113712936, 1033000622);
	WS(1044590904, 1058699692);
	sum1 = W(0, 985175380, -1092606720, 1051210502, 1009220799) + W(1, 1034192409, -1090621088, 1050384326, -1109361592)
		 + W(2, 1020554347, -1093618783, 1055009987, -1117059707)
		 + W(3, 1024014533, -1113905855, 1062574818, -1128567457)
		 + W(4, -1115433194, -1096920415, 1054554325, 1015981863)
		 + W(5, -1128687821, -1112503613, 1031218808, 1039114097)
		 + W(6, 1008304190, -1100279725, -1105751509, -1127205548)
		 + W(7, -1115445028, -1101027255, -1144235755, 1035507338);
	sum2 = W(0, 1036009101, -1108619644, 1010492213, -1131279719)
		 + W(1, -1117283755, 1041337919, -1100684466, 1035041542)
		 + W(2, 1033667347, 1012813669, 1015579759, -1124020763) + W(3, -1107239966, 1053310286, 1056064408, 1025470531)
		 + W(4, 1034685217, -1103814148, 1050883237, 1032198922)
		 + W(5, -1128406639, 1029066827, -1113069964, -1104788458)
		 + W(6, -1123321687, -1109499964, -1098878001, 1024066141)
		 + W(7, -1125402335, -1123197815, -1096911819, -1108347132);
	WS(1044030776, -1089132931);
	sum1 = W(0, 1034269487, -1093699058, 1045160768, 1040395197)
		 + W(1, 1032883970, -1097458090, 1050995424, -1135242887)
		 + W(2, 1042439154, -1086092656, 1057188990, 1040422743)
		 + W(3, 1044751430, -1078975458, -1096290982, 1048952172) + W(4, 1019707982, 1035194756, 1032938655, 1042217766)
		 + W(5, 1041434446, 1038040390, 1043682915, 1043586045) + W(6, -1133288904, -1131544335, 1022768458, 1029073256)
		 + W(7, -1128708109, -1101499019, 1043305900, 1044718778);
	sum2 = W(0, 1043294282, -1107262777, -1132728616, -1112978295)
		 + W(1, -1127265324, -1107127922, -1133435576, -1101649503)
		 + W(2, 1035036911, 1048700262, -1115280193, -1142433873)
		 + W(3, 1051203976, -1114081637, 1060204569, -1138065032)
		 + W(4, -1092441683, 1027047222, -1096051714, 1049542158)
		 + W(5, 1037063919, -1087538045, 1059699424, 1027406094)
		 + W(6, -1095318743, 1043898666, -1091030613, 1036599707)
		 + W(7, -1096741875, -1114635611, 1057805441, -1117298502);
	WS(-1083489614, -1078579141);
	sum1 = W(0, -1113694287, -1091060438, 1048678744, 1022130309)
		 + W(1, 1048897616, -1104759380, 1055607032, 1045345264)
		 + W(2, -1104500498, -1089217572, 1025763911, -1098656951)
		 + W(3, 1029397720, -1096433234, 1056656214, 1045280313) + W(4, 1039983475, -1090900481, 1055730826, 1003335600)
		 + W(5, -1099529286, -1103761763, 1039576037, -1104729181)
		 + W(6, 1047818144, -1126261903, 1050842685, 1045845834)
		 + W(7, -1100400745, -1098862766, 1044462332, -1124798927);
	sum2 = W(0, 1034867092, -1113896283, -1089397746, 1053130734)
		 + W(1, 1036831152, 1008734783, -1143881728, 1048547317)
		 + W(2, -1155378720, -1107821706, -1090933436, 1050664536)
		 + W(3, 1050005016, 1036439980, 1067046868, -1081990202)
		 + W(4, -1109019109, -1105188391, 1074023168, -1073616958)
		 + W(5, -1107857756, -1103852014, 1073004488, -1073650181)
		 + W(6, 1025727369, -1113326142, 1071596064, -1078582463)
		 + W(7, -1105627363, 1036502992, 1068047188, -1079035066);
	WS(-1123566816, -1118788492);
	sum1 =
		W(0, 1034266605, -1131696345, -1102436480, 1029920799) + W(1, -1136553988, 1054570946, -1101485920, 1027694719)
		+ W(2, 1032767842, 1043367745, -1093672570, 1029228634) + W(3, -1119057557, 1057910725, -1081257723, 1038070160)
		+ W(4, 1032596498, 1051309065, -1104247863, 1041012541)
		+ W(5, -1138237144, 1050053561, -1097237249, -1104490509)
		+ W(6, 1034235800, 1044754161, -1100737384, 1036672371)
		+ W(7, 1038972738, 1047609962, -1118734125, -1101643609);
	sum2 = W(0, 1001205015, -1108935456, -1123729961, -1151981614)
		 + W(1, 1006355343, 1048575251, 1037564428, -1123825361)
		 + W(2, 1030505158, -1114918170, -1096130861, 1015236500)
		 + W(3, -1119701641, -1088419213, -1068662368, -1095410362)
		 + W(4, 1039794598, 1032736312, 1076967646, 1049774729) + W(5, -1107202062, 1045905661, 1068403675, -1105335733)
		 + W(6, 1026836118, -1116946341, -1104305708, 1050153445)
		 + W(7, -1115440174, 1003805295, -1124006983, -1103176791);
	WS(-1103567160, 1051728620);
	sum1 =
		W(0, 1022317012, 1037463598, -1094952698, 1033922872) + W(1, -1105517764, 1027268637, -1107670055, 1024776175)
		+ W(2, -1109296554, 1052072875, -1103880757, 1038888053) + W(3, 1030946149, -1094107172, 1052944567, 1043766492)
		+ W(4, 1032988986, -1087396213, 1057943536, -1110506946)
		+ W(5, -1117957958, -1098739651, 1052382091, -1108829569)
		+ W(6, 1025729823, -1104965205, 1036164793, -1132271979) + W(7, 1009731405, 1017302004, 1041821631, 1015545129);
	sum2 =
		W(0, 1031290011, -1127050317, -1113481669, -1080536402) + W(1, -1114551402, 1026829489, 1042490649, -1076466135)
		+ W(2, -1137203270, 1032334734, 1043198364, 1038797044) + W(3, 1025723227, -1098446681, -1127701979, 1074254195)
		+ W(4, 1020823723, 1041359246, 1057793899, 1035340712) + W(5, -1107112701, 1041376772, -1100591458, -1118262367)
		+ W(6, -1156747895, 1034398482, -1114292550, 1013380262)
		+ W(7, -1140368490, -1104694439, 1037536680, 1032104302);
	WS(-1106439480, 1029090439);
	sum1 =
		W(0, 1034559195, 1042655458, -1102396839, 1026400220) + W(1, -1151887836, 1030625962, -1115609614, 1035325646)
		+ W(2, 1020849475, 1059377738, -1089162129, 1042909598) + W(3, 1042053132, -1084013087, -1083731653, 1039293086)
		+ W(4, 1043127920, -1107145304, 1052971191, 1029716960) + W(5, 1043814293, 1032281331, -1107154457, 1024778063)
		+ W(6, 1037260390, 1040913704, -1113717087, 1028666946) + W(7, 1043715864, 1033172451, 1017680531, -1130742978);
	sum2 =
		W(0, -1129107524, 1021999108, 1022835844, -1129901940) + W(1, -1123636938, -1148550480, 1016982596, -1140398984)
		+ W(2, -1116921954, -1104180688, 1016773924, 1030858450) + W(3, 1035143287, 1058583951, 1054454385, -1117386658)
		+ W(4, 1036996009, -1112895549, -1097314323, -1108156993)
		+ W(5, 1026655402, -1116180274, -1099699990, -1118751234)
		+ W(6, -1117010042, -1131502740, -1132536424, 1016259828)
		+ W(7, -1126794884, -1138164712, -1129763396, -1117013506);
	WS(1048151864, 1059242544);
	sum1 =
		W(0, -1122367849, -1097114939, 1043794348, 1026875087) + W(1, -1121466768, -1097911384, 1033810391, 1014185912)
		+ W(2, 1042165293, -1085899247, 1063564267, -1106211614)
		+ W(3, -1116044868, 1042506911, 1042284551, -1111561384)
		+ W(4, -1105437493, 1056857214, -1089674786, 1040868541) + W(5, 1037358179, -1105063934, 1049648847, 1028107682)
		+ W(6, -1125163356, -1123578292, 1021855394, -1111395274)
		+ W(7, -1111398955, -1106114902, 1045389303, 1010402126);
	sum2 = W(0, -1139648101, -1110557326, -1106733442, 1039330638)
		 + W(1, -1108856547, 1041627874, -1106727608, 987619817) + W(2, 1015236663, 1032833232, 1048813377, 1025349119)
		 + W(3, -1095822659, 1054902128, 1055403310, -1095503796)
		 + W(4, -1137977893, -1098765424, -1097123375, 1050144719)
		 + W(5, 1038373686, -1121592121, 1045561320, -1108448514)
		 + W(6, 1015865663, -1106594443, -1106386080, 1041979856)
		 + W(7, 1025690243, -1117564251, 1017823319, -1105901385);
	WS(1058511566, 1043187024);
	sum1 =
		W(0, 1042620242, 1041476871, -1106861387, 1043942651) + W(1, 1027981614, 1044640335, -1120607404, 1040914531)
		+ W(2, 1037513401, 1039039385, -1101062960, 1040902562) + W(3, 1050564856, -1085132912, -1089194338, 1048598306)
		+ W(4, 1040390932, -1095196494, 1032203084, 1019897185) + W(5, 1044188393, -1116362934, -1134658518, 1032634704)
		+ W(6, 1032851398, -1107832665, 1026497359, 1027555603)
		+ W(7, 1043046140, -1105825814, -1105488567, 1032742569);
	sum2 = W(0, -1094808435, -1083260450, 1041967320, 1026111290)
		 + W(1, -1132385524, -1089624726, -1102801635, 1034887813)
		 + W(2, -1110994277, -1098133391, 1050258559, -1123786474)
		 + W(3, 1039748829, 1063143581, 1037743779, 1033106845) + W(4, 1038866141, 1043371703, 1048943341, -1110363077)
		 + W(5, 1012861192, 1040218148, -1112998265, -1121754906) + W(6, 1030487914, 1012758152, 1031702418, 1012203560)
		 + W(7, -1132742376, 1052570990, -1105604919, -1111765769);
	WS(-1087236686, 1061665912);
	sum1 = W(0, -1115274057, 1023071688, -1107980923, -1119301463)
		 + W(1, -1116162424, 1030200068, -1101866270, -1128116268)
		 + W(2, -1104461343, 1054050807, -1092884195, -1109238785)
		 + W(3, -1093387666, 1067462106, 1056570668, -1095571507)
		 + W(4, -1113556238, 1050597447, 1044256537, -1103733247)
		 + W(5, -1115159031, 1031104576, -1106234576, -1111522325)
		 + W(6, -1126942285, -1121547516, -1128835891, -1111458030)
		 + W(7, -1121543315, 1042315272, -1114796114, -1109780718);
	sum2 =
		W(0, -1127633710, 1024134807, -1114424195, -1109129714) + W(1, 1024854732, 1020748524, -1098546148, 1025355297)
		+ W(2, -1123781128, -1117094752, -1079772750, -1102118069)
		+ W(3, 1040493279, 1065417820, 1059484680, -1114766469) + W(4, -1105896535, 1047826025, -1107504040, 1033237727)
		+ W(5, 1033983514, -1102101577, 1049649199, -1154145757)
		+ W(6, -1122459292, 1040101538, -1105983778, 1012710689)
		+ W(7, -1120616672, -1124130304, 1041220419, -1123999628);
	WS(-1092106140, -1084163121);
	sum1 =
		W(0, 1036347305, 1049849489, -1101083230, -1106738110) + W(1, 1016904817, 1040213041, -1152694122, -1115216475)
		+ W(2, 1034414494, 1056746079, -1083169173, 1039797369) + W(3, 1040590819, 1048812489, -1107117385, 1022569263)
		+ W(4, 1047670567, -1084779712, 1051667767, -1112982247)
		+ W(5, 1030378702, 1040726752, -1109066592, -1125038036) + W(6, -1114654031, 1033236350, 1024925978, 1025136605)
		+ W(7, 1037868673, 1034988241, -1107106473, -1146668256);
	sum2 = W(0, -1144361879, -1111008682, -1092072719, 1021883158)
		 + W(1, -1128843246, -1134810723, -1121102479, -1116668390)
		 + W(2, 1005924247, 1041181160, 1045581242, -1109114373)
		 + W(3, -1104940693, 1054697191, 1046555600, -1113715104)
		 + W(4, -1123234701, 1052731012, -1103970223, -1128555074)
		 + W(5, 1030348431, 1042931729, -1104348933, 1032936433)
		 + W(6, 1032437115, -1112071203, -1113690885, -1136719027)
		 + W(7, 1024671661, -1111460488, -1129885552, -1114960949);
	WS(1058637774, -1109876822);
	sum1 =
		W(0, -1123254812, 1042623060, -1126486401, -1112485473) + W(1, 1041301297, -1105094644, -1111052512, 1037949088)
		+ W(2, -1108082435, 1059472952, -1094910408, 1016105496)
		+ W(3, -1113241451, 1043969956, -1094009726, 1038892497)
		+ W(4, -1110973875, -1113269955, 1058531737, -1093047519)
		+ W(5, 1027216056, 1026816394, -1100061186, 1032398170) + W(6, 1014894339, -1130602892, 1032486130, -1128303438)
		+ W(7, 1019588394, 1026167148, -1117291247, 1021704844);
	sum2 =
		W(0, 1019183838, -1103677237, 1041385745, -1115238116) + W(1, 1031923668, 1026573624, 1025625867, 1024201143)
		+ W(2, 1049015983, -1101357077, -1095136476, 1024442030)
		+ W(3, -1096362417, 1060010174, -1096248497, -1122837727)
		+ W(4, 1005830618, -1122620605, -1115221092, 1034369966) + W(5, 1036998273, -1106684685, 1049273019, 1031554545)
		+ W(6, -1119396253, 1023743335, -1112424814, 1004099770) + W(7, -1125844722, 970656667, 1011280453, 1010302645);
	WS(1068382951, -1145853862);
	sum1 = W(0, -1109092968, -1104283584, -1126224104, -1142984099)
		 + W(1, -1120835030, -1104742016, 1048835390, 1035504970)
		 + W(2, 1015957108, -1087137628, 1060142968, 1044651720) + W(3, 1033165317, -1082841532, 1050512116, 1036256010)
		 + W(4, 1015780402, 1048723479, 1050625794, 1040271692)
		 + W(5, -1098982451, -1119342334, 1046183055, -1112268532)
		 + W(6, -1106789039, 1037068029, 1033167819, -1115364877)
		 + W(7, -1105810191, 998682871, 1042826568, -1113754717);
	sum2 =
		W(0, 1042289605, -1105845074, -1105090355, 1041479887) + W(1, -1123754179, 1032442894, -1106552079, 1028813354)
		+ W(2, 1040865617, -1090127653, -1075116096, -1087510643)
		+ W(3, 1025996190, 1055606718, 1073431719, -1084272058) + W(4, -1100913998, -1104101067, 1067916428, 1045036562)
		+ W(5, -1118459936, 1026136504, 1042119939, -1131666845)
		+ W(6, -1114401734, 1031986833, -1112990087, 1021173748)
		+ W(7, -1118182115, 1045409779, 1031635830, -1131440550);
	WS(-1115823328, -1115141930);
	sum1 = W(0, 994860217, -1096937968, 1034643656, 1022968545) + W(1, 1043355533, -1093401724, 1045563268, -1100277972)
		 + W(2, 1046651158, -1082957735, 1056739037, -1106135459)
		 + W(3, 1031967699, 1057829358, 1053028032, -1113373017)
		 + W(4, -1112906011, 1054780763, -1085595451, 1036473238)
		 + W(5, -1139800861, 1049387203, -1100812438, 1042166401)
		 + W(6, 1032268536, 1029694230, -1112691098, -1109328859)
		 + W(7, 1021673189, 1032667294, -1163065290, 1026417494);
	sum2 =
		W(0, 1041009418, 1006794492, 1023178506, -1126244586) + W(1, -1106230161, 1034312638, -1120362931, 1021996758)
		+ W(2, -1113994011, -1108126219, -1105213924, -1131146954)
		+ W(3, -1100787264, 1060460225, 1054015707, 997147503) + W(4, -1102450993, -1119222967, 1053508358, -1107185372)
		+ W(5, -1114680808, -1097084093, -1133314452, -1126416406)
		+ W(6, 1031764893, -1125377404, -1141774536, -1126617106)
		+ W(7, -1145068408, -1105852265, -1120752408, -1131039214);
	WS(1044911928, 1063248560);
	sum1 =
		W(0, -1117210934, -1089987573, 1050931427, -1154913199) + W(1, 1045807559, 1006551364, 1049202419, 1049427019)
		+ W(2, -1116245664, -1085623154, 1044690392, -1098224261)
		+ W(3, -1122601008, -1098705597, 1056494849, 1043742399) + W(4, 1041679280, -1089608778, 1054654497, 1009817082)
		+ W(5, -1102494868, -1098692501, 1047881833, -1102952115) + W(6, 1044187563, 1040126000, 1043119951, 1048685800)
		+ W(7, -1101059428, -1100421777, 1043071666, -1132265536);
	sum2 = W(0, -1110897864, 1031814971, 1060526454, -1090228093)
		 + W(1, -1104703066, -1126406622, 1034850394, -1097166620)
		 + W(2, 1039476246, -1112535334, 1060516426, -1091926928)
		 + W(3, -1102025112, -1088994686, -1088701567, 1063814816)
		 + W(4, 1041770976, 1050082866, -1072347435, 1074296249) + W(5, 1044782005, 1038057456, -1075073775, 1073862535)
		 + W(6, -1112640404, 1029663347, -1077197270, 1067261757)
		 + W(7, 1045848501, -1098794387, -1081012351, 1067785227);
	WS(-1105546040, 1026157880);
	sum1 =
		W(0, 1040950836, 1040614249, -1102499357, 1036650571) + W(1, 1036866652, 1043435937, 1032157499, 1032871003)
		+ W(2, 1045419231, 1048836647, -1088963702, 1035867609) + W(3, 1057171433, -1092874056, -1078642173, 1040635958)
		+ W(4, 1039696013, 1049109967, -1094603626, 1039966133) + W(5, 1040737235, 1037560064, 999044599, 1035782037)
		+ W(6, 1031337694, 1039556030, -1107844556, 1034875342) + W(7, 1043417390, 1020658754, -1101965321, 1029450491);
	sum2 =
		W(0, 999804672, 1033414560, -1131242272, -1111239120) + W(1, 965076992, -1142972544, -1152459008, -1114613368)
		+ W(2, 1017997216, -1117537424, 1043660652, 1024438240) + W(3, -1113573416, -1080122522, 1068973644, 1009242816)
		+ W(4, 1015814944, -1116987776, -1113471168, 1026341216) + W(5, 1013150208, 1009041344, 1023678672, -1111376032)
		+ W(6, 1004325632, 1030258512, -1115573696, -1124670336)
		+ W(7, -1116017408, -1123867424, 1025739248, 1011147520);
	WS(-1081027239, 1060388068);
	sum1 =
		W(0, 1040945153, 1049191505, -1103567931, -1142725077) + W(1, 1018532824, 1052335227, -1106690587, -1126830164)
		+ W(2, 1048158700, 1053224518, -1098210230, 1044049241) + W(3, 1050078256, -1089652372, -1079677805, 1037048166)
		+ W(4, 1043330564, 1050009062, -1090769236, 1037549983) + W(5, 1045983912, 1019623144, -1102526621, -1124021470)
		+ W(6, 1034126717, 1043374892, -1113976903, 1031972104) + W(7, 1042366848, 1037373643, -1106920486, 1000910717);
	sum2 = W(0, 1029289565, -1119356133, -1126159585, -1119814653)
		 + W(1, 1023484285, 1031916514, -1111485988, -1133461586)
		 + W(2, 1041097307, -1120749829, -1121314077, -1112201820)
		 + W(3, 1044843621, 1057057740, 1024531885, 1001931237) + W(4, -1101664529, 1055633817, -1102656055, 1035253182)
		 + W(5, -1108647964, -1098024997, 1016983721, 1019582313)
		 + W(6, -1111945130, 1038083406, -1105960100, 1011319026)
		 + W(7, -1129898257, -1101101054, 1022769465, -1110859200);
	WS(-1121436896, -1083449266);
	sum1 =
		W(0, -1131437006, 1057845458, -1096100393, -1112818966) + W(1, -1126965659, 1026072602, -1106937331, 1025271436)
		+ W(2, -1106898372, 1058188821, -1089458543, -1120770471)
		+ W(3, 1049661628, 1047051462, -1093909527, 1039868950)
		+ W(4, -1110051320, 1036301673, -1105302990, -1101852248)
		+ W(5, 1048826500, 1049513187, -1097831955, 1048680544) + W(6, 1018834023, 1026266705, -1115312055, -1111779257)
		+ W(7, 1030351624, 1043516478, -1094725407, -1137214404);
	sum2 = W(0, 1025140224, -1118806788, -1126785121, 1031495588) + W(1, 1016993788, 1030590564, -1118559458, 991152164)
		 + W(2, -1106156741, 1042721449, -1106137914, 1038491925)
		 + W(3, -1085967118, 1078987048, -1100137345, 1040984057)
		 + W(4, -1070014283, 1078555235, 1044823121, -1111978905)
		 + W(5, -1066270592, 1069325982, -1105174392, 1030579932)
		 + W(6, -1089828448, 1051485796, -1121082393, -1113499951)
		 + W(7, -1115300709, 1026006822, 1011662011, -1120641633);
	WS(1060473294, -1125032523);
	sum1 = W(0, -1118381578, 1043924207, 1028842287, -1103983036)
		 + W(1, -1131528546, 1048790648, -1094915206, 1032416951)
		 + W(2, -1103035725, 1057928103, 1048586166, -1131359957)
		 + W(3, 1044891665, -1096003632, -1089668066, 1041536420)
		 + W(4, 1017562024, -1104437021, 1048997587, -1119623443)
		 + W(5, 1038728371, -1127678449, -1106021950, 1026802338)
		 + W(6, 1013193724, -1138265298, 1016196772, -1112764523)
		 + W(7, 1017619335, 1019650740, -1112334062, 1028850580);
	sum2 = W(0, -1124013145, 1023871771, 1041717973, 1027246941)
		 + W(1, -1154979909, -1104183315, -1104961174, -1105906795)
		 + W(2, -1113455493, 1024353365, -1071159846, -1114760758)
		 + W(3, 1042673063, -1099433949, 1075222357, 1048045634) + W(4, 1009341589, 1037029004, 1061754151, -1101645527)
		 + W(5, -1131887235, -1106752952, -1106459992, 1027783079)
		 + W(6, -1126494367, -1136822537, 1037905746, -1130069351)
		 + W(7, -1120394460, -1135604889, 1020599743, 1023779471);
	WS(1063175758, 1049951270);
	sum1 = W(0, 1051934199, -1084051495, 1040719576, 1028219745) + W(1, 1041620825, -1091045702, 1046456792, 1028165760)
		 + W(2, 1053157077, -1089200998, 1054477181, -1110307566)
		 + W(3, 1019501037, -1103613676, 1050464826, 1037889601)
		 + W(4, -1121035141, -1103906809, -1098419444, 1045652053)
		 + W(5, 1024394007, 1042850683, -1097805325, 1054554722) + W(6, 1034798936, -1117239270, 1011564046, 1031152711)
		 + W(7, 999909159, -1106705027, -1091232034, 1056053333);
	sum2 = W(0, -1091471926, 1062079447, 1055700238, 1015596856) + W(1, 1042259987, -1095572989, 1041645665, 1033532620)
		 + W(2, -1103057728, -1089203271, 1037140407, 1035045090)
		 + W(3, 1049412228, -1092861102, -1093629070, 1042934527)
		 + W(4, 1044973062, 1034556296, -1095940003, 1032040702)
		 + W(5, -1116401558, 1047552828, -1106623325, -1106239816)
		 + W(6, 1011000463, -1110031497, -1107294450, 1033073048)
		 + W(7, -1130123924, 1051271629, 1053844390, -1095799213);
	WS(-1085388366, -1090694979);
	sum1 = W(0, -1123787314, 1044273497, -1108110651, -1115475932)
		 + W(1, -1119481145, -1130943626, 1041576542, -1117135031)
		 + W(2, 1032777214, 1047368143, -1087220302, 1040347561)
		 + W(3, -1112850502, 1059845268, 1027588771, -1101064470)
		 + W(4, 1041751591, -1095680144, 1036323946, 1037523789)
		 + W(5, -1125429276, 1039407200, -1111657568, -1126225621)
		 + W(6, -1140788444, 990533574, 1021334836, -1134357621)
		 + W(7, -1113892940, 1032644049, -1143449895, -1109271006);
	sum2 = W(0, -1107190004, 1037736456, -1125693587, -1120404934)
		 + W(1, 1013881877, -1105376838, 1040619572, -1122228614)
		 + W(2, -1118295314, -1123416196, -1082924015, 1051908042)
		 + W(3, -1121103222, 1042717593, 1068021664, -1087341114)
		 + W(4, -1127822751, -1115549939, 1016978358, 1042189807)
		 + W(5, -1115317828, 1043660085, -1108863865, -1125959243)
		 + W(6, -1126179247, -1126402007, -1136349779, 1038966556)
		 + W(7, -1114801766, 1040920849, -1107267301, 1023515477);
	WS(1065904679, -1122628785);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[429];

#define CURRENT_PASS 1

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) { temp[pos] = (value); }

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define HOOKED_tex(pos) INPUT_tex(pos)
#define HOOKED_size INPUT_size
#define HOOKED_pt INPUT_pt

void Pass1(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 11 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 429; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 11, y = (uint)id % 11;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (3)) + 0.5, float(group_base.y + y - (1)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[8];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 11];
	samples[1][1] = inp[local_pos + 12];
	samples[1][2] = inp[local_pos + 13];
	samples[1][3] = inp[local_pos + 14];
	samples[2][0] = inp[local_pos + 22];
	samples[2][1] = inp[local_pos + 23];
	samples[2][2] = inp[local_pos + 24];
	samples[2][3] = inp[local_pos + 25];
	samples[3][0] = inp[local_pos + 33];
	samples[3][1] = inp[local_pos + 34];
	samples[3][2] = inp[local_pos + 35];
	samples[3][3] = inp[local_pos + 36];
	samples[4][0] = inp[local_pos + 44];
	samples[4][1] = inp[local_pos + 45];
	samples[4][2] = inp[local_pos + 46];
	samples[4][3] = inp[local_pos + 47];
	samples[5][0] = inp[local_pos + 55];
	samples[5][1] = inp[local_pos + 56];
	samples[5][2] = inp[local_pos + 57];
	samples[5][3] = inp[local_pos + 58];
	samples[6][0] = inp[local_pos + 66];
	samples[6][1] = inp[local_pos + 67];
	samples[6][2] = inp[local_pos + 68];
	samples[6][3] = inp[local_pos + 69];
	samples[7][0] = inp[local_pos + 77];
	samples[7][1] = inp[local_pos + 78];
	samples[7][2] = inp[local_pos + 79];
	samples[7][3] = inp[local_pos + 80];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 34];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * 2;
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2) + ivec2(0, 1), ret);
}
//!PASS 2
//!DESC NNEDI3 (double_x, nns128, win8x4)
//!IN INPUT, temp
//!OUT OUTPUT
//!BLOCK_SIZE 64, 8
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[8]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 8; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 32.0;
	float mstd1 = sumsq / 32.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 = W(0, -1106336704, -1134422686, -1097058997, -1096794255)
		 + W(1, -1096428577, -1108910446, -1110459731, -1101174078)
		 + W(2, -1104338237, -1108550970, 1036063029, 1068454954)
		 + W(3, 1045547931, -1102009308, -1122481515, 1017740065)
		 + W(4, 1041734649, -1135080854, 1053379177, 1068510503)
		 + W(5, -1114733521, -1146436468, -1107441476, -1113618698)
		 + W(6, -1112016931, -1117701445, -1099451832, -1092648385)
		 + W(7, -1101312270, -1118387353, -1118789516, -1107281979);
	sum2 = W(0, -1107960738, 1022891960, -1112828174, -1099542471)
		 + W(1, 1028527356, -1124169384, 1003609248, 1019646072) + W(2, 1034572820, 1003346080, -1096749055, 1067566060)
		 + W(3, -1090311143, 1028295012, -1101382023, -1102277943)
		 + W(4, -1105088633, -1103397515, 1056062200, -1127174872)
		 + W(5, 1048792675, -1106700271, 1033154740, 1037356874)
		 + W(6, -1147785184, 1035529310, -1105585021, 1034766166)
		 + W(7, -1117109292, -1116900804, -1121486356, -1114899026);
	WS(-1075683047, -1087125913);
	sum1 = W(0, 1042687663, 1034752002, 1020877136, 1043598702) + W(1, 1032834596, 1049059763, 1041786741, 1050972591)
		 + W(2, 1052977914, 1046022844, 1051043629, 1049374510)
		 + W(3, 1044576234, -1108783446, -1105784362, -1089957133)
		 + W(4, -1087267578, -1097639380, -1087388173, -1095656786)
		 + W(5, -1108370107, -1101488315, -1111228387, -1108747496)
		 + W(6, 1041384601, 1034807969, 1037740431, 1044538321) + W(7, -1113942663, 1043415765, 1011031587, 1034104676);
	sum2 = W(0, -1129327146, -1149557934, 1027469999, -1116270499)
		 + W(1, -1107094547, -1114668504, -1136313139, -1115408970)
		 + W(2, -1112916736, -1120018795, -1105442406, 1056936993)
		 + W(3, 1036431709, 1029410453, -1126491682, -1112281372)
		 + W(4, -1109246006, 1012425107, 1044505132, 1054092693)
		 + W(5, 1015080154, -1102188513, -1123974759, -1115235380)
		 + W(6, -1168639863, -1122303521, -1114911422, -1109477794)
		 + W(7, -1122292075, 1038663029, -1124857486, 1004657207);
	WS(1042212664, -1102203684);
	sum1 =
		W(0, -1140902818, 1019874102, -1138465404, 1041713132) + W(1, 1031911135, 1032244040, -1122713961, 1032066151)
		+ W(2, 1040147851, -1104962202, -1102798136, -1085739950)
		+ W(3, -1090423514, -1096835716, 1015091005, -1100137137) + W(4, 1035472140, 1045102086, 1044852023, 1052255697)
		+ W(5, 1050093153, -1114874577, -1125530488, 1025859399)
		+ W(6, -1111794429, 1033944684, -1122108180, 1042129278) + W(7, 1026181805, 1045351411, 1045226448, 1037723887);
	sum2 =
		W(0, 1025219442, -1119436548, 1041363772, 1026037858) + W(1, -1106963956, -1148187164, -1115265228, 1027834104)
		+ W(2, -1109152196, -1122141349, 1032935700, -1095545125)
		+ W(3, 1029288712, 1048235476, 1017807431, -1124373883) + W(4, 1026944460, 1040314652, -1124096755, -1132954458)
		+ W(5, 1063106013, 1044093468, -1119277141, -1115291573)
		+ W(6, -1136900198, -1112897189, -1144192892, 1046665648)
		+ W(7, -1112667488, -1091150222, -1098670428, -1099776205);
	WS(-1106435384, 1038338229);
	sum1 = W(0, 1040095954, 1019822615, 1037825128, 1041126536) + W(1, 1042659628, 1046281616, 1025627498, 1052688116)
		 + W(2, 1057302312, 1048464174, 1048602738, 1046177110)
		 + W(3, -1113571175, 1010729037, -1116720143, -1090676327)
		 + W(4, -1085504617, -1109673285, -1088007186, -1089584127)
		 + W(5, -1112427435, -1099904421, 985851280, -1109333660) + W(6, 1038469973, 1008999077, 1047759857, 1042217259)
		 + W(7, -1122205838, 1042535855, 1020820192, 1034203799);
	sum2 = W(0, 1016257202, 1025056091, -1123344133, -1117490597)
		 + W(1, -1139226916, -1121712633, 1032149092, 1018740994)
		 + W(2, 1059204215, 1059357388, -1096239491, -1080318626)
		 + W(3, -1097775023, -1121076469, -1108589001, 1042934709)
		 + W(4, 1078138204, 1057901024, -1075026282, -1073900782) + W(5, 1041808545, 1040778731, 1040543247, 1013253724)
		 + W(6, 1045786159, -1115583727, 1040463834, 1043123901)
		 + W(7, 1021989454, -1105966927, 1015040126, -1147555881);
	WS(-1079558823, -1098708322);
	sum1 =
		W(0, -1107155318, 1025234303, 1015859078, 1036194249) + W(1, -1109510417, -1106597869, -1106784003, -1107821257)
		+ W(2, -1102044491, -1098872409, -1087610848, -1086405173)
		+ W(3, 1049149960, -1113006787, 1034815041, -1109243348) + W(4, -1157836704, 1050456336, 1055919296, 1051086989)
		+ W(5, 1049231261, 1047976577, 1037659280, 1045770027) + W(6, 1018716763, 1032647774, 1043448582, 1041211303)
		+ W(7, 1032229161, -1113988824, -1114873522, -1115826050);
	sum2 = W(0, -1115121954, 1012713185, -1120959275, 979525395) + W(1, 1031308048, 1023425822, 1008898041, 1015643115)
		 + W(2, 1038073794, -1114116718, 1048906430, -1089285214)
		 + W(3, 1044939824, 960279117, -1114246838, -1116674868)
		 + W(4, -1128914993, 1041575276, 1074552079, -1076455267)
		 + W(5, -1081125046, -1109266711, 1028966618, -1116558128)
		 + W(6, -1116577465, -1124395325, 1055266270, 1060162115)
		 + W(7, -1098098687, 1021768571, -1124862202, 1013382601);
	WS(1045132600, -1120782135);
	sum1 = W(0, -1105751784, -1105178898, -1104184899, -1114219853)
		 + W(1, -1110381909, 1038688878, -1129240105, 1028338913) + W(2, 1057393815, 1048859946, 1059464001, 1046945589)
		 + W(3, -1115358437, -1101266388, 1006928425, 1001553277)
		 + W(4, -1105555137, -1097544977, -1093321826, -1096850414)
		 + W(5, 1045680426, 1054674458, 1040711722, 1051440502)
		 + W(6, -1117651397, 1030868229, -1113548192, -1114482291)
		 + W(7, -1100710867, -1101910270, -1109195062, -1106616547);
	sum2 = W(0, 1017265392, -1109811903, 1023756444, -1113627340)
		 + W(1, 1014378799, -1145950526, -1129429444, 1013677319) + W(2, 1041015042, 1031690548, 1041543835, 1061785433)
		 + W(3, -1112539854, 1033767962, -1111764061, -1098545742)
		 + W(4, -1100279165, -1110095441, -1121800962, 1052269299)
		 + W(5, 1027655784, -1103181542, -1110834939, -1106577514)
		 + W(6, 1015388608, -1118750728, 1018680528, -1143924414)
		 + W(7, -1099334823, 1020584168, -1108053853, 1036964648);
	WS(1052573852, -1122511817);
	sum1 = W(0, -1122539822, 1036520122, -1150669710, -1131456914)
		 + W(1, 1027717464, 1032118773, 1021054902, 1030809195)
		 + W(2, -1107197216, -1104137920, -1095755763, -1089160552)
		 + W(3, -1090293588, -1090056564, -1092174087, -1086001910)
		 + W(4, -1123108403, 1038549849, 1032946604, 1050538028) + W(5, 1052989852, 1057974832, 1053464075, 1057808582)
		 + W(6, 1051517474, 1023654291, 1039184399, 1041388597) + W(7, -1168884669, 1033029075, 1028526105, 1041880934);
	sum2 = W(0, -1085894681, 1038192816, -1098445483, -1102898046)
		 + W(1, 1008806191, 1050638036, -1102617523, 1057325981)
		 + W(2, -1108201039, -1090848333, 1052221636, 1071505414)
		 + W(3, -1098981857, -1086351349, -1096799400, -1088620184)
		 + W(4, 1070882268, -1093216289, 1067999858, 1073865984)
		 + W(5, 1058878464, -1083525828, -1107159037, -1083206959)
		 + W(6, -1081052443, -1102549623, -1087793608, -1090403840)
		 + W(7, -1095780376, 1055133376, -1096503933, 1053790412);
	WS(-1073219892, -1080326418);
	sum1 = W(0, -1114077580, -1142635506, -1142955026, -1123237842)
		 + W(1, 1038107057, -1103324917, 1026598572, -1095875035)
		 + W(2, -1101602915, -1103425331, -1090278522, -1092662145)
		 + W(3, -1091646784, -1114692451, -1101848592, 1038718196)
		 + W(4, 1057495924, 1053716920, 1055741332, 1051447237) + W(5, 1052494629, 1049044089, 1043005848, 1047828379)
		 + W(6, -1151047116, -1114784094, -1111276924, -1121668701)
		 + W(7, 1000704387, -1109204280, 1010568075, -1156952092);
	sum2 =
		W(0, -1121663397, -1116542136, 1042431779, 1037730633) + W(1, 1010053773, -1137348615, 1028087910, -1119025600)
		+ W(2, -1095443331, 1050195534, -1123573301, -1100504352)
		+ W(3, 1043186658, -1102861372, -1110454800, 1040229501)
		+ W(4, -1067370736, -1071776975, 1068672794, 1077012119) + W(5, 1070664889, 1045361006, -1123945395, 1027642294)
		+ W(6, 1005231721, 974104521, -1111985184, 1047585075) + W(7, 1016528922, -1109020232, 1037668055, -1117277443);
	WS(-1130027456, 1047744266);
	sum1 = W(0, 1030328637, -1100312969, 1036569044, 1044449278)
		 + W(1, -1106699970, 1046212150, -1104762293, -1124975021)
		 + W(2, -1103440100, 1043447132, -1096543805, -1093151398)
		 + W(3, 1024264999, -1115860524, 1041344218, 1032410566) + W(4, 1050534604, 1038395889, 1037345619, -1106526388)
		 + W(5, -1115006287, 1035372917, 980910400, 1044066628) + W(6, -1130350917, -1105733872, 1043114871, 1022399622)
		 + W(7, 1020228332, 1024836117, -1123108872, -1112803412);
	sum2 = W(0, 1029880722, -1098453144, 1029103498, 1067660000)
		 + W(1, -1094604015, 1046293202, -1104816365, -1117927817)
		 + W(2, 1033391383, 1041649400, -1095624145, -1082091368) + W(3, 1056223691, 1027973488, 1034193475, 1034286113)
		 + W(4, -1137819024, -1137377888, 1040796761, -1080643124)
		 + W(5, -1102259819, -1121978412, -1148596400, 1041009105)
		 + W(6, -1114516031, 1025620716, 1035240799, 1066795978)
		 + W(7, -1098376459, 1036814117, -1107858514, -1114981924);
	WS(1049012636, 1037011386);
	sum1 = W(0, -1108102978, 1042768739, 1036457352, -1105146600)
		 + W(1, -1100621772, -1100160944, -1149100234, -1116535239)
		 + W(2, -1097922903, -1089977373, -1083790961, 1050515995)
		 + W(3, 1053649082, 1044221701, 1020595485, -1110188826) + W(4, 1049818257, 1052134241, 1059747641, 1062551839)
		 + W(5, -1088576433, -1093385002, -1108848982, -1147628986)
		 + W(6, 1041216474, -1106782690, -1120768141, 975424142)
		 + W(7, 1042971413, 1047421135, -1142399358, 1034144007);
	sum2 = W(0, -1130376652, -1109307779, 998991648, -1105231849)
		 + W(1, -1124853008, -1110904873, 1033926100, 1012787248)
		 + W(2, -1109271051, 1040605589, -1117670218, 1068278024)
		 + W(3, -1099193318, 1035466738, -1111928806, 1025845624)
		 + W(4, -1098570547, -1097221185, -1087670872, 1068017963)
		 + W(5, -1103240593, 1049832589, 1018913792, 1035573068)
		 + W(6, 1029552052, -1097745138, -1101762859, -1100990121)
		 + W(7, -1094879980, -1119653306, -1099498770, 1046656503);
	WS(-1099128120, 1074104605);
	sum1 = W(0, 1001695642, -1114738061, -1137881464, 1035838167) + W(1, 1036976671, 1043227732, 1024532056, 1041576607)
		 + W(2, 1031876531, 1036082771, 1049670772, 1045634202) + W(3, 1039176783, 1044499416, -1115296143, 1036111714)
		 + W(4, -1106225286, -1127447088, -1114090766, -1084335000)
		 + W(5, -1092101927, -1106295064, -1108352670, -1103209586)
		 + W(6, 1039516460, 1037331996, 1048871226, 1024672505)
		 + W(7, -1111706306, 1040216275, 1018355325, -1129216251);
	sum2 = W(0, -1125983803, 1026289226, 1003361806, 1036989304) + W(1, -1121376018, -1127516251, 999276462, 1020382491)
		 + W(2, 1057121124, 1048908439, 1042597022, -1101738899)
		 + W(3, -1101518001, -1114490175, 1032222895, -1111061815)
		 + W(4, -1097673861, -1081617292, -1083990029, 1066557847)
		 + W(5, 1050089807, 1021212715, -1107462587, 1048167829)
		 + W(6, -1097055530, -1105528539, -1094090339, 1060807350)
		 + W(7, 1045798092, 1007168711, 1021142275, 1024157832);
	WS(1043392312, -1114334171);
	sum1 = W(0, 1041086874, 1027676176, 1029494548, 1038182418) + W(1, 1033375641, 1014428948, 1016176348, 1036956537)
		 + W(2, 1046571639, 1051603231, -1114765098, 1063881062) + W(3, 1036439434, 1039261900, 1049353410, 1039119196)
		 + W(4, -1101297859, -1100311555, -1090719068, -1092551191)
		 + W(5, -1093343060, -1095549099, -1102133676, -1097401399)
		 + W(6, -1108043111, 1031499310, -1123479337, 1047470620)
		 + W(7, 1029157954, -1113522785, 1032866554, -1108903402);
	sum2 = W(0, 1032922039, 1034144522, 1035186417, -1106146153) + W(1, 995983013, 1014708981, -1118508182, -1122673776)
		 + W(2, -1110774431, 1041464609, -1089347840, 1063858171)
		 + W(3, -1103182741, -1105498679, 1046443094, -1107403517)
		 + W(4, 1024080221, 1024001520, -1102975683, 1062496232)
		 + W(5, -1104694448, 1034761930, -1113235807, -1126790312)
		 + W(6, -1111786600, 1038622987, -1098326560, -1094555153)
		 + W(7, -1110476474, -1107944280, 1045574278, -1119406695);
	WS(1055141020, 1060902337);
	sum1 = W(0, 1034435725, -1133288704, 1026181508, 1033934442) + W(1, 1030709219, -1118188821, 1027652318, 1035419593)
		 + W(2, 1057965143, 1052483105, 1052696320, -1122504460) + W(3, 1052884304, 1049027177, 1046782257, 1045790650)
		 + W(4, -1123568702, -1121795134, -1094115828, -1084201687)
		 + W(5, -1093347107, -1096042081, -1098441692, -1101051195)
		 + W(6, -1104499136, 1006999415, -1153162900, 1029709087)
		 + W(7, 1036285529, -1155692311, 1013713298, -1111952258);
	sum2 = W(0, 1043194323, 1017945729, 992756489, -1117717167) + W(1, 1023440269, -1108161809, 1034607052, -1115924363)
		 + W(2, -1070666261, -1075189642, 1068575013, 1076566585)
		 + W(3, 1056539999, -1098049115, 1036076910, -1112346970)
		 + W(4, -1098866335, -1106608294, 1051129947, 1049134123)
		 + W(5, 1047751107, -1097073139, 1011007330, 1016205049)
		 + W(6, -1101126135, 1010301074, -1107911121, 1046700061)
		 + W(7, 1020103457, 1026363561, 1035420194, -1137869730);
	WS(-1090579868, 1070279725);
	sum1 = W(0, 1032329895, -1102328821, -1113203900, -1098061089)
		 + W(1, -1105344998, 1034205973, -1106552005, 1041435478) + W(2, 1048430680, 1050349544, 1052980239, 1057014372)
		 + W(3, 1057962188, 1038273502, 1046276062, 1049777060)
		 + W(4, -1101560157, -1091335294, 1039656780, -1084573078)
		 + W(5, -1103450436, 1043587871, -1098888483, 1002064136)
		 + W(6, -1129281319, 1012204235, 1033674783, -1115372202)
		 + W(7, -1108117804, -1111454739, -1115265901, -1109943484);
	sum2 =
		W(0, 987673807, 1036995374, -1095509641, -1094252408) + W(1, -1119095571, -1103179232, 1040985329, -1114181285)
		+ W(2, 1027892228, -1102736131, 1034852634, 1059241808) + W(3, -1103859919, 1043446486, -1109795439, 1004807604)
		+ W(4, -1103141235, 1049007178, -1090760003, 1060311666)
		+ W(5, -1129798465, -1100012675, 1051746582, -1113144024)
		+ W(6, 1005138532, 1028221332, -1123669832, -1128511149) + W(7, 1032914452, 1006285508, -1122773902, 987177167);
	WS(1058381774, -1086956646);
	sum1 = W(0, 1005434106, -1149835360, 1034370117, 1036055789)
		 + W(1, 1007595428, -1173712576, -1122685332, -1119060568)
		 + W(2, -1096145742, -1100460324, -1096424577, 1033532617)
		 + W(3, 1049990129, 1042033667, -1147483724, 1021597150) + W(4, 1046241393, 1039571170, 1054608457, -1110152984)
		 + W(5, -1100950084, -1103984787, -1122634471, 1016207588)
		 + W(6, 1026532260, -1120107684, -1107524072, -1123297125)
		 + W(7, 1032832748, 1041584782, -1111048693, 1023439817);
	sum2 =
		W(0, 1073050559, 1069067455, -1096535796, -1073893027) + W(1, -1077684470, 1038335059, 994568047, -1109196141)
		+ W(2, 1049113865, 1035642194, -1105600932, -1114871718) + W(3, -1104998692, 1034875990, 1004288083, 1019116562)
		+ W(4, 1048373410, -1101089925, 1050248373, -1113393188) + W(5, 1015693919, 1032989733, 1024635942, 1041247426)
		+ W(6, -1123382260, 1035361564, -1105239942, 1000972215) + W(7, -1112223483, 987872957, 1016564448, 1019016937);
	WS(1051792028, 1027146209);
	sum1 = W(0, -1173418992, 1031492470, 1030866682, -1111745573) + W(1, 1037975597, 1032231158, 1021051177, 1029296729)
		 + W(2, -1096555104, -1099279313, -1102472206, -1086728512)
		 + W(3, -1098029143, -1099704976, -1107704157, -1088435526)
		 + W(4, 1048715847, 1043543405, 1045948678, 1048944276) + W(5, 1053562136, 1041023999, 1031959404, 1046674105)
		 + W(6, 1037767898, 1032372106, 1031937048, 1030986133) + W(7, 1035090980, 1038793940, 1031982829, 1043937550);
	sum2 = W(0, 1076285256, 1067013205, 1054912747, -1103468782)
		 + W(1, -1082179927, -1086354611, -1086555076, -1077304359)
		 + W(2, -1071495861, -1080654015, -1092768710, 1053690657)
		 + W(3, 1062196550, 1059230433, 1065208788, 1069826015) + W(4, -1089164092, 1044446905, -1089831336, 1049463752)
		 + W(5, -1116071286, 1055604285, -1102169042, 1049830695)
		 + W(6, 1024798548, -1130255717, -1111620633, -1129289568)
		 + W(7, 1022374674, -1147177200, 1008723412, 990531682);
	WS(-1116843232, 1041538044);
	sum1 = W(0, 1038718416, 1041393778, 1023355030, 1040958951) + W(1, 1040537034, -1112360254, 1043346413, 1047211822)
		 + W(2, 1050813118, 1048646402, 1043671731, 1037057641) + W(3, 1050123337, 1052799074, 1037436293, 1042212684)
		 + W(4, -1091780513, -1107072481, -1097953353, -1088265503)
		 + W(5, -1105750724, -1091053114, -1121572392, -1091261766)
		 + W(6, -1107356403, 1032833522, -1126022145, -1185162751)
		 + W(7, 1038008293, -1123581176, 1033129910, -1116284746);
	sum2 = W(0, -1127892588, 1025248710, -1127740272, -1114879615)
		 + W(1, -1125515678, -1135605467, 1015277154, -1118452308)
		 + W(2, -1090048491, -1124324076, -1092974499, 1047668544)
		 + W(3, 1042122418, 1052455522, -1102075660, 1052515578)
		 + W(4, -1076486023, -1080184847, -1080442855, 1048567939)
		 + W(5, 1066323214, 1068938556, 1066205534, 1058048535) + W(6, 1071993665, 1067215194, 1068762214, 1014309155)
		 + W(7, -1079656754, -1077318729, -1083078137, -1086246531);
	WS(1045082936, 1047750074);
	sum1 = W(0, 1017867382, -1105827232, -1139557912, -1098507795)
		 + W(1, -1112138258, -1113781499, -1117154624, 1024003356)
		 + W(2, 1038967959, 1036533543, 1048524561, 1057427781) + W(3, 1057555836, 1044700722, 1037485187, 1046059755)
		 + W(4, -1107005280, -1101431328, 1044741561, -1099209723)
		 + W(5, -1103886606, -1117912777, -1108908881, 1024367918)
		 + W(6, -1117189504, 1000061951, 1034808454, -1102176472)
		 + W(7, -1102736460, -1102956733, -1113728179, -1108156515);
	sum2 = W(0, 1003184961, 971431442, -1131894760, -1133283297) + W(1, 984723076, 1031831407, -1125590160, 1031681833)
		 + W(2, 1024857236, -1109323954, 1026446282, -1105665514)
		 + W(3, -1116186208, 1024492508, -1121629964, -1148808497)
		 + W(4, -1114215978, 1030818718, 1031262679, 1056963612) + W(5, 1055283667, 975724297, -1116339968, 1026784592)
		 + W(6, 1037587704, -1121823736, 1045339410, -1107079097)
		 + W(7, -1090072253, -1102678968, -1103014356, -1123463096);
	WS(1059869006, 1015916977);
	sum1 = W(0, -1111801867, 1039164638, 1023424768, -1118862224)
		 + W(1, -1114194639, -1099094340, -1118811114, -1096321008)
		 + W(2, -1103727218, -1102716146, -1089648586, -1092420393)
		 + W(3, 1049092536, 1052180160, 1032231232, 1046058153) + W(4, 1051877295, 1051739903, 1057614174, 1055627629)
		 + W(5, -1096079006, 1008315659, -1121275805, 1039975892)
		 + W(6, -1115491581, -1106752078, -1104830517, -1112797325)
		 + W(7, 1038662167, 1030088557, -1131680577, -1175801754);
	sum2 = W(0, -1113427160, -1104433368, -1104169884, -1117600576)
		 + W(1, -1102319880, 1039627671, -1097619580, 1047721667)
		 + W(2, -1090644207, -1091764889, -1109333336, 1065407690)
		 + W(3, -1098732665, -1109931470, 1043714297, 1041133481) + W(4, 1034414883, -1120815960, 995253792, 1059846520)
		 + W(5, 1048874179, 1008884504, 1021072320, -1103318888)
		 + W(6, 1038986783, -1135559136, 1033390214, -1120264784)
		 + W(7, -1104270640, 1019376128, -1111461786, -1142244432);
	WS(1054131356, -1077482588);
	sum1 =
		W(0, -1100136045, 989703980, -1114161471, -1117800461) + W(1, 1013262449, -1112319975, 1027862775, -1103330903)
		+ W(2, -1101215881, -1100083265, -1091699940, -1088812180)
		+ W(3, -1095974704, 1033042241, -1095224480, -1102789769) + W(4, 1045307006, 1039854844, 1051542530, 1056393300)
		+ W(5, 1053327664, 1059113280, 1049428707, 1055440053) + W(6, 1047064142, -1120855287, 1042850313, -1122501592)
		+ W(7, -1118254671, -1111473941, -1119385054, -1109190398);
	sum2 = W(0, -1098032416, 1055692800, -1101668743, -1100435053)
		 + W(1, -1089098280, -1094416925, -1099202751, -1104551065)
		 + W(2, 1063396296, 1024719031, 1065491656, 1073645059)
		 + W(3, 1060161647, -1074198531, -1081296593, -1083400329)
		 + W(4, 1043414797, 1032661901, 1058961916, 1063424749)
		 + W(5, -1096580753, -1098776178, -1115458644, -1092624053)
		 + W(6, -1093635160, 1049215120, -1090478816, 1050905898)
		 + W(7, -1135528507, 1042380471, 1032695397, 1054277265);
	WS(-1082679118, -1072338335);
	sum1 = W(0, -1126832308, 998650886, 1029713605, 1045660229)
		 + W(1, -1125245511, 1001090478, -1126242526, -1128346278)
		 + W(2, -1092407662, -1099976035, -1098757312, 1049242330)
		 + W(3, 1052609817, 1049104969, 958956607, -1170516592) + W(4, 1041636256, 1035459839, 1053507448, -1097348797)
		 + W(5, -1097111418, -1099322690, -1116731426, 1009511091)
		 + W(6, 1032452512, -1118647007, -1113994637, 1019901759)
		 + W(7, 1026546307, 1041545965, -1113342195, 1027607012);
	sum2 = W(0, -1069228184, -1073602631, 1021776922, 1076866983)
		 + W(1, 1069809281, -1101499289, 1013617559, 1036050969) + W(2, -1099529380, 1043301860, 1054858487, 1044685536)
		 + W(3, 1062109344, -1097491140, -1149319294, -1113127688)
		 + W(4, -1112044089, 1041147606, -1119872164, -1106846135)
		 + W(5, 1042271976, 1035368326, 1025827813, -1115137330)
		 + W(6, -1144476451, -1112019052, 1036271953, 1018899191)
		 + W(7, -1114284680, -1126672913, -1112053703, -1146921887);
	WS(-1125906880, 1029353026);
	sum1 = W(0, 1052620124, 1040928385, 1053619569, 1034478636) + W(1, -1149501032, 1027228408, 1033816441, -1143379631)
		 + W(2, -1082830235, -1087911853, -1088553290, -1115166792)
		 + W(3, -1104403058, 1046902211, -1140598044, -1115398454)
		 + W(4, 1044570800, 1048894344, 1054767249, 1052323270)
		 + W(5, -1096342700, -1092690897, -1112660402, -1089842615)
		 + W(6, 1033131793, 1031982257, -1118254573, 1037418321) + W(7, 1045103465, 1053685367, 1032758420, 1056771243);
	sum2 = W(0, 1052242091, -1105901664, 1041713460, -1098081544)
		 + W(1, -1101414896, -1140318759, -1123485994, -1108472633)
		 + W(2, -1123374674, 1032004261, 1057464262, 1055897675)
		 + W(3, -1108453649, -1099401944, 1039811869, -1092934450)
		 + W(4, -1088438592, -1109896025, -1106721416, 1057898227)
		 + W(5, 1044097375, 1041656473, 1042751001, 1033994653)
		 + W(6, -1109756837, -1117902306, -1106560728, -1101499608)
		 + W(7, -1114554169, 1042131382, -1104786072, 1048148308);
	WS(-1080878567, 1068324028);
	sum1 = W(0, -1115471279, 1019310859, -1121098697, -1115193805)
		 + W(1, -1153442440, -1104713039, 1023975060, -1094675607)
		 + W(2, -1095139206, -1103458412, -1090917913, -1094785898)
		 + W(3, -1100131090, -1118370765, -1102569730, 1044057356)
		 + W(4, 1057833304, 1049561152, 1058273109, 1054221326) + W(5, 1050583410, 1048985266, 1041261354, 1045920684)
		 + W(6, 1032811018, -1118469827, -1107876783, -1109399058)
		 + W(7, -1121957752, -1109945243, -1125987028, -1144681671);
	sum2 = W(0, -1122597644, 1032420914, -1109997244, 1029919127)
		 + W(1, -1129031901, 1025876905, -1121404056, 1025649559)
		 + W(2, 1052263517, -1132353885, -1113437764, -1086124512)
		 + W(3, -1134522929, -1137529969, 1041285329, -1111439550)
		 + W(4, 1084267296, 1077171750, -1076080701, -1066836895)
		 + W(5, -1073829589, -1128728545, -1128683125, -1109934248)
		 + W(6, 1037076324, 1017945885, 1045994672, -1105598049)
		 + W(7, -1115453382, 1027437378, -1112127416, 1032857588);
	WS(-1106960696, -1099012034);
	sum1 = W(0, -1114528403, -1119077260, -1143558020, -1119877760)
		 + W(1, -1109244232, -1096650748, -1112604445, -1100402892)
		 + W(2, -1099071342, -1099370430, -1089278443, -1086538844)
		 + W(3, 1010994112, 1041376829, 1042854492, 1049345155) + W(4, 1055554285, 1049964157, 1061104081, 1056629915)
		 + W(5, 1049997315, 1042073805, 1031563405, -1123516568)
		 + W(6, -1109121109, -1115766890, -1114965299, -1120868875)
		 + W(7, 1034547527, -1114495407, -1139584324, -1118254096);
	sum2 =
		W(0, -1116593925, 1028908115, 999050165, 1037914955) + W(1, -1106109711, -1105957739, -1123834115, -1113783754)
		+ W(2, 1027806287, -1136470458, 1039840949, -1122048333)
		+ W(3, 1057135276, -1105275062, -1096566133, -1105721601) + W(4, 1032648371, 1006654490, 1052059722, 1057985079)
		+ W(5, -1090440242, -1131926605, 1018741845, -1124260101)
		+ W(6, 1024756439, -1116529299, -1107372324, -1128153177)
		+ W(7, -1142966917, -1123338691, 1013415162, 1018182189);
	WS(-1103089976, 1059868827);
	sum1 = W(0, 1026631887, 1033737723, 1034000797, -1130496915)
		 + W(1, -1106694966, -1105866475, -1106727101, -1098705919)
		 + W(2, -1091300264, -1096562704, -1087537316, -1094386976)
		 + W(3, 1044429902, 1045093007, 1040636078, 1044615672) + W(4, 1056895190, 1050565142, 1059766350, 1053939124)
		 + W(5, -1108577640, -1109922270, -1122075862, -1100982776)
		 + W(6, 1031003956, -1140469197, -1108911023, 1032926090)
		 + W(7, -1120892680, 1034482579, -1136817768, 1045052014);
	sum2 =
		W(0, -1114832682, 1038307608, -1109268272, 1031259614) + W(1, -1136199018, -1118450441, 1025376385, -1125957173)
		+ W(2, 1044376552, -1101986459, 1025272345, -1112738770) + W(3, 1014008179, 1042085570, -1110075404, 1027010884)
		+ W(4, 1052671036, -1094811671, -1106762472, 1052706603) + W(5, 1040752903, -1100877636, 1051973899, 1036345951)
		+ W(6, -1084839384, -1076225566, -1074779618, -1088390497)
		+ W(7, 1066038403, 1071357616, 1068318141, 1050587817);
	WS(-1089897038, 998399462);
	sum1 = W(0, -1100326508, -1099771006, -1103969415, 1030998252)
		 + W(1, -1111096702, -1129527451, -1115021151, -1124899748)
		 + W(2, -1114312802, -1109889234, -1092992143, -1098209637)
		 + W(3, -1116385180, -1096464604, -1111889198, -1109224641)
		 + W(4, 1049930251, 1047140918, 1060325312, 1062808044) + W(5, -1128865717, 1048691588, -1137813989, 1043572929)
		 + W(6, -1141222070, -1114407115, -1106384368, 1017922927)
		 + W(7, 1023432554, -1125954964, -1121716413, 1020452535);
	sum2 = W(0, -1094975511, -1089233591, -1089977002, 1033778332)
		 + W(1, 1006981461, -1137053176, -1125132764, 979684320) + W(2, -1113696880, 1032844980, 1066397244, 1037917830)
		 + W(3, 1039504138, 1032622380, 1021506052, -1119563165)
		 + W(4, 1023473326, 1036803698, -1129026618, -1104280508)
		 + W(5, 1024702770, -1121975322, 974010432, -1138205260) + W(6, 1029862812, -1117299445, 1025970568, 1031377784)
		 + W(7, -1122944997, 1022461928, -1130740686, 1024270227);
	WS(-1096120220, -1099720911);
	sum1 = W(0, 1052677544, 1027883172, 1046184634, 1036941212) + W(1, 1037786724, 1039372749, 992842790, 1040590154)
		 + W(2, -1105594052, 1050583742, 1030711656, 1050761182) + W(3, 1044997418, 1051859318, 1041579690, 1052858474)
		 + W(4, -1101878153, -1120505890, -1094174707, -1087347673)
		 + W(5, -1091299260, -1092171165, -1105854769, -1087724293)
		 + W(6, 990296621, 1026529890, 1039246623, 1031039363) + W(7, 1038193547, 1036921611, -1115076484, 1007468831);
	sum2 =
		W(0, 1040381409, -1131846701, 1030695069, 1015259161) + W(1, 1026868853, -1164136976, -1121164685, -1109936403)
		+ W(2, 1023777345, -1095435966, -1111411494, -1085163747)
		+ W(3, -1100600319, 1052695808, 1041440525, 1051545155)
		+ W(4, -1110031849, -1146822820, -1089001391, -1074171332)
		+ W(5, -1078760233, 1048168469, 1074132102, 1072577306) + W(6, 1022623295, -1096899181, 1049343346, -1107180310)
		+ W(7, 1043071461, 1020495459, 1017314953, 1050115198);
	WS(-1080112807, -1111145054);
	sum1 = W(0, -1103297132, -1106341774, -1098278655, 1024154699)
		 + W(1, 1037514093, 1034961350, -1125780682, -1109009483) + W(2, 1049824404, 1049617192, 1059552348, 1031972225)
		 + W(3, -1085661228, -1097823136, -1114326813, -1119831648)
		 + W(4, -1133975251, -1122989109, -1086286580, -1137351813)
		 + W(5, 1056970252, 992708574, 1021582000, 1040424089) + W(6, 1026400021, 1042898005, 1041608840, -1145221295)
		 + W(7, -1102084285, 1041904442, 1038246926, 1042525799);
	sum2 = W(0, 1041258750, -1109734283, -1123542769, -1113561957)
		 + W(1, -1110564237, 1026811493, -1130694514, 1024057869)
		 + W(2, 989910477, -1100922013, -1096844113, 1051742866)
		 + W(3, -1100235579, -1105813951, -1151284621, -1136706867)
		 + W(4, -1134607603, 1016064722, 1041392492, 1057819912)
		 + W(5, 1047439582, -1113868277, -1118083589, -1114600003)
		 + W(6, -1109794979, 1041809078, -1126381362, 982123162)
		 + W(7, -1119465765, 1026735929, 1019553626, -1114678252);
	WS(1043409720, -1105036943);
	sum1 = W(0, 1040191749, 1033970558, 1042494496, 1046767380) + W(1, 972615552, 1032778168, 1032217109, 1032356247)
		 + W(2, -1096303173, -1095924673, -1093807736, -1092831585)
		 + W(3, -1096756208, -1126846855, -1115229280, -1098580285)
		 + W(4, -1115184605, 1041748910, 1044442592, 1042876074) + W(5, -1140612185, 1018241414, 1027878365, 1034858676)
		 + W(6, 1041655059, 1041917006, -1160531625, 1039311757) + W(7, 1020654492, 1043700571, 1034107952, 1036396440);
	sum2 = W(0, 1027808259, 1010119787, -1111510504, -1113418759)
		 + W(1, 1032132185, -1121052855, 1014515195, 1010692603)
		 + W(2, -1139047739, 1043340308, -1106790738, -1096910874)
		 + W(3, 1040059331, -1115460243, 1017581734, -1120741339) + W(4, 986751832, 1026247831, 1065364148, 1040723354)
		 + W(5, 1038861011, -1113647147, 1041604470, -1135975307)
		 + W(6, -1095774205, -1093511024, -1089533357, 1053173071)
		 + W(7, -1106558855, 1027584935, -1121443175, 1014681515);
	WS(1035857520, 1029952289);
	sum1 = W(0, -1143077795, -1105351783, -1113811952, -1106526780)
		 + W(1, 1035289215, 999420801, -1129002434, -1113970285) + W(2, 1037051011, 1029971495, 1049064844, 1035603988)
		 + W(3, -1083894414, -1098557596, -1111645039, -1130790920)
		 + W(4, -1110400621, -1106469910, -1094483622, 1058276716)
		 + W(5, 1056346487, 1050633420, 1042325343, 1026109447) + W(6, -1121149466, 1043652126, 1027875988, 1035104701)
		 + W(7, -1114346217, -1123554317, -1130799743, 1025377311);
	sum2 = W(0, -1118517607, -1101077931, 1029148161, -1087996420)
		 + W(1, 1047526016, -1108756119, 1038718292, 1024464693) + W(2, 1026484093, 1046485772, -1098019518, 1071267691)
		 + W(3, -1082674625, 1032470282, -1106613565, -1113199029)
		 + W(4, 1039465846, 1030900361, 1048118782, 1064954318)
		 + W(5, -1084489705, -1118487613, -1112021711, -1120012731)
		 + W(6, 1008581907, -1114630284, -1106945018, -1097625455)
		 + W(7, -1156379726, 1024110641, 1020048570, 1036291722);
	WS(1058189134, 1034857672);
	sum1 =
		W(0, -1171748679, -1105475825, -1097172873, -1108837708)
		+ W(1, 1038034707, -1131134898, -1113151849, -1119273967) + W(2, 1031241360, 1044072484, 1057114388, 1051374554)
		+ W(3, -1083662360, -1099379283, -1121036423, 1018101850)
		+ W(4, -1100969760, -1094075536, -1082247827, 1060030327) + W(5, 1058651386, 1046921459, 1041721673, 1036514264)
		+ W(6, 987174985, 1045893176, 1042860595, 1031954257) + W(7, -1120638978, -1137288661, 1037681908, 1029972391);
	sum2 = W(0, 1003810984, 1036204547, -1101998989, 1041029203)
		 + W(1, -1098215637, 1044393168, -1110527635, 1027560485)
		 + W(2, 1020569783, -1114489126, -1121260135, 1052640914)
		 + W(3, 1059150102, -1098121773, 1037147118, -1110248773)
		 + W(4, -1128982694, -1099380876, -1101918458, 1059611184)
		 + W(5, 1040381797, -1094102036, 1028175839, -1113935142)
		 + W(6, 1043745048, -1104004872, -1104165612, -1121067579)
		 + W(7, -1100369008, 1032515174, -1114899975, 1000033398);
	WS(-1107450480, 1040804833);
	sum1 = W(0, 1040192716, 1022226221, 1002013395, -1117682794) + W(1, 1001040843, 1000424795, -1120982404, 1025306833)
		 + W(2, 1040473489, 1047969017, 1044185574, 1060667554) + W(3, 1057909434, 1049088596, 1038016429, 1042416864)
		 + W(4, -1095196747, -1098407451, -1087290490, -1089168888)
		 + W(5, -1111951852, -1119291421, 1031577591, -1112956481)
		 + W(6, -1124855402, 1020416041, -1160070647, 1045737613)
		 + W(7, -1101676720, -1103624738, -1104451167, -1115902938);
	sum2 =
		W(0, 1014727333, -1117243126, 1029406572, 1027900147) + W(1, -1112527674, -1114664521, -1111634336, -1107116047)
		+ W(2, -1124633329, -1107065949, 1041729284, -1094200388)
		+ W(3, -1104959017, 1040214496, 1005029260, 1049039902) + W(4, 1026257754, -1111801245, -1084100906, 1052541581)
		+ W(5, 1070744988, -1111707080, -1127513012, -1107038609)
		+ W(6, -1111611661, -1136702760, -1103677442, 1050798725)
		+ W(7, -1105828213, -1111536822, -1106506739, -1140667375);
	WS(-1113867888, 1064515135);
	sum1 = W(0, -1113562537, -1107046062, -1103978495, -1098739202)
		 + W(1, -1122423580, 1019693149, -1116789880, 1020558520) + W(2, 1048061265, 1043460993, 1060048584, 1062873548)
		 + W(3, -1119786749, 1023528257, -1106657727, -1137576074)
		 + W(4, 1011269086, -1098944190, -1107431310, 1045822761)
		 + W(5, 1025265092, -1112998912, -1142662356, -1104660585)
		 + W(6, -1105945126, -1148623547, -1111558073, -1114838028)
		 + W(7, -1101841139, -1117915947, -1106868487, -1122252061);
	sum2 =
		W(0, -1145158406, 1012385731, 1016118130, 1024197601) + W(1, -1112179804, -1119519161, -1127326042, -1113792718)
		+ W(2, 1022878354, -1129472106, 1044961455, 1049544336)
		+ W(3, 1030346877, -1131221354, -1095482557, -1093377057)
		+ W(4, -1111624996, 1015658802, 1040055751, 1057430996) + W(5, -1114498280, 1020564842, -1112131584, 1019749938)
		+ W(6, 1010204019, -1123973089, -1157676569, 1022031298)
		+ W(7, -1124728962, 1023003938, -1121117277, -1141925830);
	WS(1051333020, -1087054195);
	sum1 = W(0, -1112042433, 1019002067, -1115058903, 1046618143)
		 + W(1, -1107874438, -1148774132, 1036768028, -1154881470)
		 + W(2, -1104387605, -1096771599, -1102529947, -1093976551)
		 + W(3, -1089735051, -1129150690, -1101876091, -1098135714)
		 + W(4, 1052246829, 1048899277, 1054136106, 1044227957) + W(5, 1060328029, 1046377228, 1045160291, 1045432325)
		 + W(6, -1113527444, -1098301717, -1095193948, 1044013586)
		 + W(7, -1107288943, 1038700845, 1024370318, 1019966234);
	sum2 = W(0, -1114066012, 1029900262, -1114806697, -1110038644)
		 + W(1, 1036646832, -1110070018, 1020625547, 987867800) + W(2, 1041392892, -1112610934, 1041587346, 1025557898)
		 + W(3, 1055783298, -1102485451, 988088600, 1039502616) + W(4, 1044719218, 1046575198, 1050162797, 1055420600)
		 + W(5, -1099287148, -1100701871, 1033323822, -1119304428)
		 + W(6, -1097547793, -1095644935, -1102972970, -1095936036)
		 + W(7, 1028020818, -1113902766, -1135974783, 1018696751);
	WS(-1120103648, -1090070191);
	sum1 =
		W(0, -1117418940, 1024592611, 1040968250, 1049918615) + W(1, 1034410595, 1035134604, -1119948353, -1144523437)
		+ W(2, 1049030490, 1050801054, -1111205267, -1116228463) + W(3, 1050512309, -1102511675, 1034763283, 1039656998)
		+ W(4, -1112262737, -1094705236, 1042055990, -1085341341)
		+ W(5, -1106227665, 1036298997, -1138448657, -1110564136)
		+ W(6, -1114427969, 1032013281, -1110419822, 1047944497)
		+ W(7, -1132367051, 1025392341, -1111046724, -1120201127);
	sum2 = W(0, -1122606938, -1141997982, 1027805544, -1120462650)
		 + W(1, -1100560083, -1105726471, 1025575588, -1113668318)
		 + W(2, 1046354401, 1040228902, -1143835982, 1061896257)
		 + W(3, -1080731069, -1098049024, 1026943708, 1032253740)
		 + W(4, -1124762815, -1102583710, 1052785838, 1059397472)
		 + W(5, -1120768779, -1126645315, 1011421951, -1122685018)
		 + W(6, -1118515993, 1036845124, -1106443071, 1043676745)
		 + W(7, 995709275, -1128858827, -1112152255, -1127110207);
	WS(1060158670, 1068766623);
	sum1 =
		W(0, -1116432453, -1131098839, -1099753724, 1034945056) + W(1, -1122123599, 1040823512, 1040184285, 1050332416)
		+ W(2, 1056712636, 1049784895, 1057908127, 1044163070) + W(3, 1028198895, -1122504371, -1123329903, -1096645803)
		+ W(4, -1087151539, -1102593034, -1089291740, -1094800699)
		+ W(5, 1036808107, -1120242995, -1127465369, -1132187055) + W(6, 1040295867, 1033948341, 1031077093, 1027113355)
		+ W(7, -1132674679, -1117547229, 1040274980, -1137741501);
	sum2 = W(0, 1036379663, -1108907739, 1070189048, 1073213180)
		 + W(1, 1065321765, -1076673488, -1079893128, -1072585926)
		 + W(2, -1098232449, 1058983203, 1016986873, 1047923452) + W(3, 1033582270, 1031365639, 1038048757, -1107019906)
		 + W(4, -1128107780, 1035811659, 1040144345, -1105399966)
		 + W(5, -1110681209, 1039880527, -1116001167, 1018297481)
		 + W(6, -1120677803, -1120240179, 1029686139, -1109097268)
		 + W(7, 1041308319, -1109042515, 1034493417, -1131123922);
	WS(-1112459888, 1031046963);
	sum1 = W(0, -1112719265, -1129483154, -1103727283, -1091575740)
		 + W(1, -1104335643, -1155155940, -1114094348, -1105426861)
		 + W(2, -1128634346, -1120462421, -1112785958, 1056781779)
		 + W(3, -1153409228, -1108013960, -1118230989, 1027667442)
		 + W(4, 1043326546, -1103778738, 1050524372, 1067939282)
		 + W(5, 1048587330, -1132710977, -1109505653, 1036777787)
		 + W(6, -1115081924, -1114915140, -1104237825, -1096588493)
		 + W(7, -1108534894, -1114726045, 991235804, -1111746006);
	sum2 = W(0, -1119086167, 1013020612, -1141008560, -1108719150)
		 + W(1, 1023891147, -1145112744, 1018251990, -1116478859)
		 + W(2, 1037241732, -1129818230, 1029187991, -1074141953)
		 + W(3, 1019083994, -1124211508, -1122886966, 1027168441)
		 + W(4, -1114652243, 1028260797, -1112264831, 1072760747)
		 + W(5, 1042535682, -1131878972, 1037493286, -1129254230)
		 + W(6, -1131518324, -1115730540, 1036245214, 1034705438)
		 + W(7, -1119172530, -1133917220, -1114007324, 1018465006);
	WS(-1086783566, -1086791567);
	sum1 = W(0, -1115195632, -1153026662, -1134496297, -1108787789)
		 + W(1, -1119803561, -1145121243, -1131708777, -1110064394)
		 + W(2, -1095708330, -1093442522, -1098161001, 1044632085)
		 + W(3, -1091375169, -1107384199, -1100078210, -1104664012)
		 + W(4, -1123676804, 1018199561, 1037878573, 1064261167) + W(5, 1057417647, 1052226946, 1046948682, 1047330733)
		 + W(6, 1041725033, -1121101892, 1034570216, -1103584185)
		 + W(7, -1108866704, -1122033784, -1117964907, 1022321300);
	sum2 = W(0, 1031515378, -1121810184, 1010081392, -1119765868)
		 + W(1, 1035546479, -1106495935, 1028378344, 1003402623)
		 + W(2, -1077397139, -1079753374, 1044674665, 1073378801)
		 + W(3, 1056367001, -1109376902, 1035615024, -1118889676)
		 + W(4, -1134939312, -1097085111, 1052841311, 1007836336) + W(5, 1044809025, -1118570548, 992033726, 1010750288)
		 + W(6, -1112896962, 1035985281, -1105060263, 1031953140)
		 + W(7, 1022446080, 1031289566, 1032016077, -1150317246);
	WS(-1096711324, -1080143969);
	sum1 = W(0, -1135181951, 1025399430, 1033906501, 1041786535)
		 + W(1, -1133559462, 1003671004, -1123695637, -1105366874)
		 + W(2, -1095339398, -1094144146, -1093853897, -1089314149)
		 + W(3, -1089126233, -1110956839, -1129083412, -1113909272)
		 + W(4, 1050582337, 1049483953, 1045129706, 1046728732) + W(5, 1045641984, 1051092970, 1049638101, 1057307443)
		 + W(6, 1026786373, -1123204644, 1006467326, 1031608549) + W(7, -1135165794, 1017185520, 996324016, 1009923752);
	sum2 = W(0, 1023911567, 1004932796, -1119124867, 1022775023) + W(1, 1011639102, 1036397588, 999444348, -1106309084)
		 + W(2, -1108118447, -1134375038, 1035251904, 1037995724)
		 + W(3, 1050162042, 1037707684, -1111062570, -1101285996)
		 + W(4, 1044892126, -1138359022, 1063133445, 1074655410)
		 + W(5, 1070062472, -1083132698, -1073510095, -1073687480)
		 + W(6, -1112738860, 1020475455, -1102926770, 1047698054)
		 + W(7, -1113839430, -1117927031, 1017195567, 1041743674);
	WS(-1089880270, 1068594400);
	sum1 =
		W(0, -1114467040, 1023170830, 1036273894, -1107800974) + W(1, 1029867434, -1106779367, 1024593089, -1110449433)
		+ W(2, -1104513741, -1091458130, 1034367029, -1100997781)
		+ W(3, -1095286649, 1047811540, -1096228817, -1109179032) + W(4, 1050219169, 1042545281, 1048674674, 1042739212)
		+ W(5, 1053624831, 1034908007, 1034674708, 1049808694) + W(6, -1118490053, -1120682309, 1031296832, -1110241363)
		+ W(7, 1034289100, -1107012174, 1021221591, -1126204757);
	sum2 =
		W(0, 1030004067, -1117028113, -1105887481, -1066126465)
		+ W(1, -1104777348, -1122550707, -1130918117, 1023720579)
		+ W(2, -1133064657, -1134091777, 1045929484, 1081917443) + W(3, 1043726141, 1028310407, 1016764395, -1116064873)
		+ W(4, 1024174065, -1113615539, 1032698350, -1097201480) + W(5, 1033613382, -1107697461, 1029778305, 1018371831)
		+ W(6, -1119836251, 1025775761, -1118489229, 1041573100)
		+ W(7, -1124268877, 1030764051, -1116797441, 1018350967);
	WS(1067475431, -1126058166);
	sum1 =
		W(0, -1108052732, 1043040440, 1048922396, -1097574342) + W(1, -1119673025, -1101774749, 1019400344, 1007801026)
		+ W(2, -1097851361, -1108210069, -1084429932, 1055911149)
		+ W(3, 1041902328, 1035827603, -1115594513, -1107003538) + W(4, 1049362324, 1048929252, 1054104112, 1047147106)
		+ W(5, -1085779789, 1049622021, 1019477630, 1037086373) + W(6, 1040199303, -1109622414, 1041203782, -1104274751)
		+ W(7, 1047880876, -1116198608, -1107876353, 1036701569);
	sum2 =
		W(0, 1013753738, -1113150555, 1015248850, 1042650722) + W(1, 1040818978, -1105652199, 1033430289, -1120377801)
		+ W(2, 1020731454, 1046742995, 1045156685, -1104352239) + W(3, -1089864705, 1045331461, -1109224259, 1016214593)
		+ W(4, -1120697178, 1034035253, -1094710566, -1128318417)
		+ W(5, 1045040370, 1025091411, -1106535436, 1019751894) + W(6, 1009873360, -1099358283, 1039470065, 1046693145)
		+ W(7, 1036008061, 1030627793, 1017876415, -1132110931);
	WS(1060496974, -1099362699);
	sum1 = W(0, 1054706808, 1036662868, 1045895019, 1033303646) + W(1, 1044095763, -1130190200, 1035564779, 1040746168)
		 + W(2, -1109706041, 1041317773, 1051554925, 1049334366) + W(3, 1051166813, 1053590462, 1049285205, 1055551482)
		 + W(4, -1098091909, -1123237413, -1091928498, -1083798889)
		 + W(5, -1095315343, -1087007295, -1097088265, -1094550458)
		 + W(6, -1129324363, 1015757258, 1021341985, -1112852963)
		 + W(7, 1041804248, -1127492145, 1039262630, -1114905285);
	sum2 = W(0, -1073385920, -1084887580, -1083140914, -1081800202)
		 + W(1, -1085954594, 1037413129, -1096433065, 1054210787) + W(2, 1077926840, 1058818874, 1060159151, 1074845707)
		 + W(3, 1061906872, -1084431515, -1126824848, -1087315344)
		 + W(4, 1032559783, -1089669880, 1045764296, 1059775011)
		 + W(5, -1103860568, -1094536545, -1133232881, -1099186518)
		 + W(6, -1094451238, -1121878040, -1173171215, -1120435570)
		 + W(7, -1115590029, 1053315192, -1107838893, 1052978812);
	WS(-1078369703, 1041267413);
	sum1 = W(0, 1024386586, -1098405416, 1044040033, -1098286219)
		 + W(1, -1130684104, 1045750173, -1098338270, 1041584973)
		 + W(2, 1041630887, -1112635974, -1132435208, 1041292515)
		 + W(3, -1091497929, 1016159377, -1139597330, -1101611546)
		 + W(4, -1102607056, 1051293608, -1094040968, 1052507157)
		 + W(5, 1056853585, -1105775474, 1049412460, 1026100205) + W(6, 1016693023, 1018393854, 1046099151, -1095618428)
		 + W(7, 1018959206, -1117949682, -1118540325, 1040982949);
	sum2 = W(0, 1035615459, 1028814353, 1062855981, 1052250964) + W(1, 1056109526, -1106019250, 1048995011, -1115640692)
		 + W(2, -1097925659, 1038714809, -1077657685, -1101970047)
		 + W(3, -1098468896, -1114182260, -1104046747, -1130122971)
		 + W(4, 1043665288, 1033337220, 1051048913, -1113114333)
		 + W(5, -1085664062, 1040975429, -1109605260, 1034778788)
		 + W(6, 1020457849, -1103657321, -1109823715, 1058024935)
		 + W(7, 1056999181, -1105846491, 1042595027, -1112374505);
	WS(1049151900, -1114127847);
	sum1 = W(0, 1050216581, 1000015204, -1136218178, 1023136961)
		 + W(1, -1130455775, -1133465094, -1160090192, 1035991733)
		 + W(2, 1044969414, 1047621718, 1057314961, 1055877843) + W(3, 1054358666, 1052966059, 1045850836, 1052491071)
		 + W(4, -1106856243, -1112471205, -1091938023, -1092033343)
		 + W(5, -1099719178, -1089783713, -1099053307, -1087984664)
		 + W(6, -1099359923, -1148711507, -1133921207, -1112054390)
		 + W(7, 1034273823, -1122838974, 1019980258, -1112322824);
	sum2 =
		W(0, -1105478410, 1039552519, -1131405058, -1099466970) + W(1, 1049027924, -1115050596, -1129231446, 1049583286)
		+ W(2, 1011113448, 1050864081, -1125310098, 1043215106) + W(3, 1034334973, -1095883745, 1036178144, -1088635155)
		+ W(4, 1068049752, -1103020148, 1066695202, 1074596924)
		+ W(5, 1067601936, -1084539788, -1075514015, -1074115054)
		+ W(6, -1082501551, 1059003564, -1098156272, 1039344435)
		+ W(7, -1099880092, -1107282542, -1097076855, 1042018058);
	WS(-1081332839, -1093454830);
	sum1 = W(0, -1109709318, -1104916884, -1108177419, -1117212646)
		 + W(1, -1119705461, 1032417267, -1118748528, 987327371) + W(2, 1035356975, 1037116623, -1125155242, 1030327966)
		 + W(3, 1050241163, -1103907222, 1046095669, 1033262333)
		 + W(4, 1039420520, -1122158672, 1053028347, -1104761999)
		 + W(5, 1032136206, -1115200780, -1115609017, 1029855614)
		 + W(6, -1111308088, 1014687039, -1112931654, 1020526050)
		 + W(7, -1119448076, -1112611266, -1136487898, -1104533373);
	sum2 =
		W(0, 1013207527, -1127355075, -1103159789, 1040955478) + W(1, 1008876024, -1116686760, 1035764738, -1154118338)
		+ W(2, -1118344664, 1028266047, 1043690369, 1051132935)
		+ W(3, -1108842627, 1041402295, -1105537330, -1128237045)
		+ W(4, -1124997045, -1117884424, -1116887196, 1047094008)
		+ W(5, 1057384051, -1100609336, -1098518151, -1089828796) + W(6, 1036829905, 1016171285, 1024917624, 1041601336)
		+ W(7, -1127506713, 1033786361, -1114313206, -1102385561);
	WS(1063446990, 1030048893);
	sum1 = W(0, -1131562670, -1099483503, -1106193120, -1102405700)
		 + W(1, 1021119810, -1113568905, 1009340592, 1030255032) + W(2, 1043069042, 1049571969, 1061428532, 1053095529)
		 + W(3, -1115069793, -1119868742, 1027160065, 1043118346)
		 + W(4, -1108681470, -1106599551, -1097709592, 1046689338)
		 + W(5, 1029025472, 1006738196, -1120287391, -1111789333)
		 + W(6, -1108650254, -1106453175, 1008661917, -1102088711)
		 + W(7, -1123233168, -1104754348, -1136963210, -1114502129);
	sum2 =
		W(0, 1012371361, -1149491589, 1023756477, -1165255819) + W(1, -1111467932, 1019335917, -1140694601, 1010513313)
		+ W(2, 1017109065, -1115161102, 1012418345, -1111308586) + W(3, 1015942947, -1106016138, 1015823021, 1026481588)
		+ W(4, -1110016822, -1109821790, 1060485172, 1031379047)
		+ W(5, 1046805034, -1114576028, 1024897044, -1114618076)
		+ W(6, -1103671135, -1097972516, -1094449842, 1049769129)
		+ W(7, 999148403, 1022790203, 1032463998, -1146831635);
	WS(1060385486, 1040268319);
	sum1 = W(0, -1115333181, -1113839600, 1026945989, 1041834949)
		 + W(1, -1100015113, 1010458454, -1113704543, -1110169699)
		 + W(2, -1105770459, -1104706211, -1085502934, -1112644646)
		 + W(3, -1102865873, -1112283012, -1108020290, -1115522389)
		 + W(4, 1048230464, -1122113023, 1051932092, 1065603891)
		 + W(5, -1105250533, 1054415097, -1122402466, 1046973419) + W(6, 1022495614, -1115044751, 997701279, 1044329112)
		 + W(7, 1038196649, -1113673817, -1105082025, -1115640050);
	sum2 = W(0, -1115664423, -1122287706, 1044568139, -1099350461)
		 + W(1, -1102715015, 1042022920, 1031291077, 1032474264) + W(2, 1041813775, 1041645390, -1087138046, 1067461852)
		 + W(3, -1116572542, -1109622665, -1113357449, -1110133469)
		 + W(4, -1142717933, -1094011677, -1124627987, 1027339570)
		 + W(5, 1045144111, 1054026149, -1122353792, 1047364150)
		 + W(6, -1120925434, -1119842210, -1120985148, -1113918825)
		 + W(7, -1100833175, -1101147879, -1112018489, -1109170005);
	WS(1049043868, 1050086952);
	sum1 =
		W(0, -1127858130, 1025810768, 1034666762, 989092984) + W(1, -1115481017, -1119959429, 1012364567, -1097661520)
		+ W(2, -1091279607, -1101354119, -1089232423, -1092016019)
		+ W(3, -1089729669, -1104525366, -1121438163, -1160888088)
		+ W(4, 1054362490, 1044465651, 1050465752, 1058690160) + W(5, 1053482909, 1051092259, 1019953121, 1051219071)
		+ W(6, 1028884238, 1022883995, 1032068165, 1005443958) + W(7, 1007092039, -1149438996, -1137072337, 1017307814);
	sum2 = W(0, 1030282550, 1012065197, 1049708534, -1101566471) + W(1, 1043525707, 1038111746, 1040589253, -1106531005)
		 + W(2, -1099759289, 1050936278, 1018991152, 1050588571)
		 + W(3, -1112383125, -1121285468, 1039884984, -1113841779)
		 + W(4, 1070065566, 1068820850, 1068572253, 1075164582) + W(5, 1046261639, 1053555382, 1040055978, 1058828770)
		 + W(6, -1078832473, -1076346523, -1075628240, -1072955990)
		 + W(7, -1093459475, -1088795804, -1099780818, -1090423367);
	WS(-1083655502, 1074535575);
	sum1 =
		W(0, 973651072, 1028862937, 1029517469, -1111330742) + W(1, 1043404639, -1105397947, -1129726574, -1099887737)
		+ W(2, -1100106921, -1096173461, -1088250868, -1101351113)
		+ W(3, -1092528244, 1034877328, -1113904430, -1118418050) + W(4, 1049212555, 1052529147, 1057957824, 1060855844)
		+ W(5, 1050267538, -1104065896, 1041335934, 1047916353) + W(6, -1122472503, 996549482, -1111380529, -1125410415)
		+ W(7, -1109626381, -1122247818, -1108333759, 1037233742);
	sum2 = W(0, 1037582341, 1032149251, -1135487115, -1107247151)
		 + W(1, 1053968825, -1096732175, 1034930229, -1094249638)
		 + W(2, -1116649305, -1112916551, 1044443302, -1117703407)
		 + W(3, 1049963138, 1042101117, 1046616621, -1127010106) + W(4, -1107051108, 1041643977, 1030763641, 1053360182)
		 + W(5, -1087331905, -1089009482, -1110671517, 1059951262)
		 + W(6, 1040538112, -1112067691, 1036263743, -1115814520)
		 + W(7, 1035849297, -1104153316, -1104877620, -1116847106);
	WS(-1132786560, 1056578758);
	sum1 = W(0, 1031072232, 1019453021, -1112153353, -1127115205)
		 + W(1, -1153314582, -1105591705, 986346381, 1024604121) + W(2, 1043718831, 1050053971, 1057505465, 1049535379)
		 + W(3, 1052394474, 1045418390, 1044283028, 1048806335)
		 + W(4, -1098888378, -1104586611, -1090760605, -1081773448)
		 + W(5, -1106021324, -1120283669, 1036365944, -1103287167)
		 + W(6, -1123786893, 1030360908, -1123598824, 1035671447)
		 + W(7, 1044649456, -1105554848, 1033186457, -1108912601);
	sum2 =
		W(0, 1040658557, -1106354313, 1027144364, -1103628435) + W(1, -1123462592, -1130705048, -1126068784, 1016031184)
		+ W(2, 1011638864, 1020064744, 1049840877, 1050147177)
		+ W(3, -1117174472, -1105120318, -1113970774, -1135769248)
		+ W(4, 1041865287, -1103147627, 1026998340, 1053587315) + W(5, -1118058864, 1036775410, -1104140895, 1030416564)
		+ W(6, -1109113498, 1033931950, -1120927100, -1102211113)
		+ W(7, 1033328738, -1101351534, 1028877580, -1112076066);
	WS(1062711758, -1109562142);
	sum1 = W(0, -1107075140, -1125545776, -1121788380, -1112684886)
		 + W(1, -1128625782, -1102890883, -1129119788, -1102110160)
		 + W(2, -1100622401, -1104747337, -1103229831, -1083301774)
		 + W(3, 1050510715, -1097610180, -1109077454, 1030737729) + W(4, 1053288051, 1049612355, 1059638178, 1048337697)
		 + W(5, 1052952654, 1051307580, 1041285742, 1049115768) + W(6, 1017596397, 1007433175, -1120034657, -1098025711)
		 + W(7, -1112854653, -1108240645, 1022176121, 1020667959);
	sum2 =
		W(0, 1022257834, 1033804876, 1033963400, -1113268759) + W(1, -1123922685, 1029999681, 1015463858, -1125618402)
		+ W(2, 977550902, -1105772859, -1098748483, 1063293804) + W(3, -1090033704, 1051039483, -1104977553, 1022914778)
		+ W(4, -1113927342, 1042844173, -1096777339, 1059312088) + W(5, -1134320563, 1037687330, 1024487701, 1004875175)
		+ W(6, 1036504102, -1107093105, 1028160469, -1089861840)
		+ W(7, -1101525036, 1017532722, -1122996995, -1116068477);
	WS(1046002488, -1083997249);
	sum1 = W(0, -1116203964, 1044431961, 1041235242, 1046371486)
		 + W(1, -1106267745, -1117705943, -1122870401, -1109240562)
		 + W(2, -1099156844, 1028498222, -1096363997, -1079124621)
		 + W(3, -1088685662, -1103556299, 999993136, -1106798659) + W(4, 1050076828, 1049400252, 1050263757, 1020370202)
		 + W(5, 1048790666, 1053355933, 1034829570, 1037276039) + W(6, 1025075217, 1035032656, 1032516798, 1050189128)
		 + W(7, 1042510329, 1039724554, 1027729159, 1037249299);
	sum2 = W(0, -1094982381, 1024745423, -1097113645, 1017043870)
		 + W(1, 1052555320, -1107563793, 1049262968, -1118735987)
		 + W(2, 1041875660, -1091311273, 1042706326, -1148119319)
		 + W(3, -1098101314, 1010824956, -1094774489, 1030619863) + W(4, 1017839086, 1044409386, 974632891, 1061393923)
		 + W(5, 1043955676, -1098402228, 1042935118, -1094515595)
		 + W(6, 1045890174, -1107764806, 1048260200, -1118443235)
		 + W(7, -1097368628, 1041238578, -1116185663, 1042214090);
	WS(-1083255246, -1075588436);
	sum1 = W(0, -1154522904, -1106371438, -1105464695, 1036086422)
		 + W(1, 1023783355, -1127243930, 1030176790, 1031412139) + W(2, 1026375684, 1036249778, 1056687627, -1097055709)
		 + W(3, -1088556578, -1108055408, -1105944807, -1123388097)
		 + W(4, -1099839750, -1113752075, -1092436626, 1050924256)
		 + W(5, 1056650964, 1045926824, 1039385437, 1041066449) + W(6, 1037990411, -1119606102, 1043935324, 1036476796)
		 + W(7, -1111337285, -1110940389, -1124332025, 1021333175);
	sum2 =
		W(0, -1117330831, 1023708058, -1133288218, -1122435213) + W(1, -1139180683, 1020252429, 1025188082, -1109968059)
		+ W(2, 1032531181, -1114369361, 1017487862, 1047518334) + W(3, -1122916014, 1027012545, -1103557501, 1046855474)
		+ W(4, 1043756688, 1031926890, -1104593512, 1043258354) + W(5, -1096895795, 1049767697, 1019544307, -1112657711)
		+ W(6, 1060766869, 1067300065, -1105945514, -1075696003)
		+ W(7, -1102393264, -1106946489, 1020047431, -1113285900);
	WS(1056055196, 1023945849);
	sum1 = W(0, -1104545849, -1139517988, -1101013315, -1136100212)
		 + W(1, -1148373856, 1013350648, -1120654743, -1108930702)
		 + W(2, 1036175954, -1138851412, 1048468083, -1097789539)
		 + W(3, -1096999890, -1097071058, 995622088, -1128233700) + W(4, 1032040419, 1009002268, 1040659763, 1059870683)
		 + W(5, 1039368714, 1053644410, -1122818538, 1033002810)
		 + W(6, -1111539988, 1026875367, -1104005681, -1112873620)
		 + W(7, -1135793772, -1132670698, 1028030253, -1133516850);
	sum2 =
		W(0, 1033182461, -1135790885, 1036058972, -1145806187) + W(1, 1026470367, -1125994579, -1123856921, -1152817846)
		+ W(2, -1110992702, 1041801313, -1115959119, -1083556559) + W(3, 1047402951, 1026458945, 1021989349, 1029289545)
		+ W(4, 1011638125, 976542168, -1106760241, -1068720208) + W(5, 1080067579, 1043021822, -1118809257, 1027196491)
		+ W(6, -1116812221, -1135785781, 1013579453, 1034110873)
		+ W(7, 1048786168, -1124564059, -1115658442, -1110636256);
	WS(1047050040, 1036867972);
	sum1 = W(0, 1031952202, 1040033213, 1049413776, 1052329098) + W(1, -1134253939, 1023712847, -1129317744, 1023414180)
		 + W(2, 1041031945, 1050476745, 1016870010, 1054273441) + W(3, 1041748879, 1035493153, 1041656495, 1041394937)
		 + W(4, -1098508279, -1097704487, -1091275871, -1087382286)
		 + W(5, -1095309386, -1117526273, -1112254893, -1108492595)
		 + W(6, -1117663192, 1033331580, 1012948685, 1043041286)
		 + W(7, -1131302504, -1125396951, -1153578470, -1112644847);
	sum2 = W(0, -1120609508, -1098653081, -1074671298, -1081276780)
		 + W(1, -1097107702, -1110118090, -1137118351, -1119823807)
		 + W(2, -1138324119, 1042859622, 1072071026, 1068070176) + W(3, 1044485226, 1040658983, -1118978815, 1035453187)
		 + W(4, -1110367912, 1038385587, 1026263792, -1107049493)
		 + W(5, 1024907208, -1122488627, 1038809437, -1111098449)
		 + W(6, 1021280635, 1026624912, 1026288466, -1122098825)
		 + W(7, 1040255596, -1152233050, -1126727249, 1006813455);
	WS(1047287096, 1059538103);
	sum1 = W(0, 1030804480, -1111595219, -1123153834, -1098057279)
		 + W(1, 1007980582, 1018775223, 1036089754, 1030691489) + W(2, 1034749929, 1051408038, 1049213285, 1057344539)
		 + W(3, 1048793645, -1106759404, -1115115061, 1033654600)
		 + W(4, -1102474905, -1094490621, -1099609086, 1048597242)
		 + W(5, -1094890059, 1046324795, 1003815995, -1126686757)
		 + W(6, 1013951379, 1039425378, -1112788128, -1098419769)
		 + W(7, -1118093753, -1108341356, -1120388747, -1135294247);
	sum2 = W(0, -1112864979, 1034721747, -1108077379, 1023366533)
		 + W(1, 1021246669, 1032508120, -1113986367, -1153257254) + W(2, 1024004698, -1109416755, 988806988, 1058238498)
		 + W(3, -1115279539, 1041332549, 1033457886, 1018109285) + W(4, 1034996841, 1041661735, 1041642045, 1008174217)
		 + W(5, -1122858630, -1089151778, -1130797677, -1111548255)
		 + W(6, 1004307827, -1116757818, 1037366938, -1107547239)
		 + W(7, -1108868659, -1128614293, -1130732717, -1122125438);
	WS(1066216871, -1084582294);
	sum1 = W(0, 1009745022, 1023325836, 1034246149, -1103455511) + W(1, 1025953385, -1105242559, 988118663, -1107601837)
		 + W(2, -1095963722, -1096473834, -1087129751, -1142570129)
		 + W(3, -1094684497, -1107829831, -1107520037, -1117719279)
		 + W(4, 1050775177, 1046303345, 1057767679, 1064400323) + W(5, 1038452388, 992534739, 1025316967, 1044853309)
		 + W(6, 1027534757, -1126933960, -1118146623, -1103828265)
		 + W(7, 1018950609, 1030437560, 1020674901, 1033139589);
	sum2 =
		W(0, -1127013105, 1018526115, -1123587641, 1052346460) + W(1, -1098654594, 1029804743, -1118240305, 1030491706)
		+ W(2, 1031626404, -1117975133, 1062148372, 1074624908)
		+ W(3, -1090512380, -1070854231, -1095518794, 1041467716)
		+ W(4, 1029958550, -1113082476, 1035325186, -1130733653)
		+ W(5, 1046581721, -1113725416, 1031776819, -1115594754) + W(6, 1017794797, 1023300847, -1145491637, 1041942663)
		+ W(7, -1113152926, -1139181075, -1120299385, -1142763637);
	WS(1033725552, -1082653885);
	sum1 = W(0, 1027658456, 1033791775, 1038169633, -1130834725)
		 + W(1, -1105755912, -1107114253, -1106878767, -1102176852)
		 + W(2, -1091894661, -1094613753, -1085886368, -1094605577)
		 + W(3, 1049096200, 1038006563, 1040399888, 1038046228) + W(4, 1054730080, 1052727904, 1060322284, 1054915405)
		 + W(5, -1115316932, -1113871235, -1114082704, -1098681477)
		 + W(6, 1024810077, 1020875129, -1114253244, 1021660859) + W(7, 1010914050, 1032412472, 1016596422, 1044096992);
	sum2 = W(0, -1126607908, -1111819446, 1032709615, -1119610542)
		 + W(1, 1027594385, 1029384695, -1115269200, 1032209203)
		 + W(2, -1109006144, 1050929158, 1025316173, -1107176811)
		 + W(3, -1123863107, -1122531221, 1026796828, -1115616555)
		 + W(4, -1093467963, 1063076656, 1048889614, -1090320472) + W(5, 1046933317, 1051206364, 997945380, -1109796884)
		 + W(6, 1059727060, 1073053378, 1073749745, 1058093447)
		 + W(7, -1079533534, -1073154062, -1075936158, -1088004581);
	WS(-1087442510, 1045166814);
	sum1 =
		W(0, -1106921670, 1032907600, -1111070674, 1047421629) + W(1, -1094092352, 1031075349, -1136240762, -1129052086)
		+ W(2, 1032009478, -1127325529, -1106321881, -1085655355)
		+ W(3, 1057239638, -1098381173, -1128650952, -1107389381)
		+ W(4, 1041337656, -1100890040, 1060092296, 1044767811) + W(5, 1040377247, 1037296628, -1131454723, 1037463686)
		+ W(6, -1110338367, 1042108264, -1105899594, 1027442111) + W(7, -1105935775, 1037469097, 1027139781, 991481919);
	sum2 =
		W(0, -1119426781, -1109786529, 1041819143, 1018220925) + W(1, -1103055916, -1124599508, 986571056, 1024618671)
		+ W(2, 1040351141, 1043540747, -1105926532, -1133247980)
		+ W(3, -1096724541, 1038612076, 1019567362, -1143357456)
		+ W(4, -1104019881, -1106797782, -1098594115, 1066013053)
		+ W(5, -1136157126, -1097021086, 1025702119, 1008181894) + W(6, 1015410156, 1043466418, 1048709183, -1092013542)
		+ W(7, -1109288787, 1027934232, -1140871148, 1027080058);
	WS(1059279054, 1041683061);
	sum1 = W(0, 1028823114, 1033060856, -1136683218, 1041097809)
		 + W(1, -1108712682, -1099515041, -1114499693, -1105525449)
		 + W(2, -1096417644, -1095251776, -1096755466, -1095420880)
		 + W(3, -1087904547, -1117180600, -1113115866, -1121084634)
		 + W(4, 1041071884, 1051348966, -1106154521, 1062896338) + W(5, 1057053635, 1050313119, 1041134484, 1043053335)
		 + W(6, 1040139175, -1133443258, 1027763154, 1037083176)
		 + W(7, -1109247178, -1169250436, 1007514196, 1031868218);
	sum2 = W(0, -1104031080, -1113246189, -1124792744, -1107688308)
		 + W(1, -1084040655, -1089958554, -1098618924, -1098033920)
		 + W(2, 1039900182, 1044206765, 1043086617, 1057123143) + W(3, 1066602722, 1037219700, -1111210157, 1036938090)
		 + W(4, 1028023758, -1122555834, 1041018096, -1100462314)
		 + W(5, -1123151815, 1032289221, 1028867168, -1143651414)
		 + W(6, -1125301559, 1027754708, -1129842792, 1022410763)
		 + W(7, 1034604384, 1029558442, -1139711519, -1122704124);
	WS(-1093886876, -1092780259);
	sum1 = W(0, 1031521076, 1040859655, -1123954783, -1115369432)
		 + W(1, 1027325374, -1130075936, 1017430099, 1005655277) + W(2, 1034696971, 1027092583, 1057011018, 1055452141)
		 + W(3, 1055461116, 1043845385, 1041326696, 1045628689)
		 + W(4, -1098366291, -1107551117, -1084481759, -1086775792)
		 + W(5, 1050583573, -1098824964, 1032795870, -1110858724) + W(6, 991412379, 1023411481, 1037665034, 1037775165)
		 + W(7, -1102735091, -1106471523, -1113156096, -1108701199);
	sum2 = W(0, -1099549152, -1101982776, 1039636960, 1065032135)
		 + W(1, 1046191187, -1112740199, -1120755726, -1138571865)
		 + W(2, -1115620025, -1110046443, 1067650764, -1096892917)
		 + W(3, -1084058149, -1089814493, 1022618460, -1106519005)
		 + W(4, 1042476476, -1138118945, 1056117723, -1084935200)
		 + W(5, 1043334912, -1116550886, 1030169574, -1123579094)
		 + W(6, -1128057356, -1104607948, -1129519972, 1039009532)
		 + W(7, 1042222420, -1114781123, 1023299940, 1029490149);
	WS(-1103384376, 1050555318);
	sum1 = W(0, 990997212, -1104723373, -1102560870, -1110645588)
		 + W(1, -1114771100, 1006886950, 1011892746, 1041403778) + W(2, 1056616014, 1049493908, 1060440249, 1063537686)
		 + W(3, 1049398171, -1123261404, 1042753094, 1041297647)
		 + W(4, -1113359817, -1101985253, -1095607555, -1091747296)
		 + W(5, -1098384586, -1094355067, -1098733239, -1099641616)
		 + W(6, -1104278389, -1112669305, -1117918862, -1124628967)
		 + W(7, -1120789735, 1020875660, 1029891897, -1143354303);
	sum2 = W(0, -1097904627, -1102268820, -1101696600, -1102083058)
		 + W(1, -1100977750, 1022682138, -1105396681, 1035758392) + W(2, 1056762738, 998260703, 1049156882, 1055125136)
		 + W(3, 1040009482, -1099421122, -1114104451, -1112582051)
		 + W(4, 1033294591, -1102966386, 1040206209, 1048772561) + W(5, 1004029807, 1040485303, -1118051402, 1040482786)
		 + W(6, -1113205081, -1105114179, 1028552759, 1023069474)
		 + W(7, -1108173489, 1040370279, -1109779069, -1135668672);
	WS(1042369848, -1095650924);
	sum1 = W(0, 1032801852, -1124780413, -1142443027, 1031124370)
		 + W(1, 1024489633, 1037041722, -1157391942, 1048283534) + W(2, 1060985291, 1056066249, 1059062488, 1046815795)
		 + W(3, 1051554984, 1026983110, 1037131073, 1028118439)
		 + W(4, -1088222536, -1093287088, -1089766974, -1084610255)
		 + W(5, -1096293908, 1035048291, -1113190096, -1107690581)
		 + W(6, -1154392525, 1017158008, 1041310978, -1111535759)
		 + W(7, -1118760812, -1118618480, 1032589425, -1101944856);
	sum2 = W(0, 1056251107, -1118435725, -1111043713, -1090037466)
		 + W(1, -1129656805, -1093926860, 1052716525, -1083761792)
		 + W(2, -1084477192, 1041984407, -1093515412, 1073185178)
		 + W(3, 1051712939, 1053076395, -1096065312, 1066458198)
		 + W(4, -1077785336, -1086371528, -1093010832, 1074151927)
		 + W(5, 1054463958, -1094829660, -1090812268, 1063500158)
		 + W(6, 1053829707, -1113013425, 1046411943, -1090694669)
		 + W(7, -1095714333, -1103046632, 1035367276, -1087950464);
	WS(-1081634407, -1072784825);
	sum1 = W(0, -1102740818, -1115394775, -1101924733, -1100839185)
		 + W(1, -1123768914, -1140848016, -1118249725, -1116477425)
		 + W(2, 1024862651, 1046040367, -1109613465, -1115978107)
		 + W(3, 1049722038, -1098661743, -1138059466, 1025943000) + W(4, 1056867014, 1027952685, 1058509811, 1050187219)
		 + W(5, -1098437541, 1033615035, -1143195264, -1132571500)
		 + W(6, 1016622683, -1112643478, -1096240139, -1101581667)
		 + W(7, 1008822020, 1023463264, -1116668435, 1036595961);
	sum2 = W(0, -1139809909, -1126178115, 1032546581, -1097752958)
		 + W(1, 1042272246, -1118367610, -1138081685, 1017774855)
		 + W(2, 1046126277, -1111752353, 1034216546, 1042101074) + W(3, 1043290796, -1112722386, 1034532478, 1030093406)
		 + W(4, -1119940899, 1055245806, -1088954301, 1058677046)
		 + W(5, -1087007443, 1048637958, -1140548675, 1029648824)
		 + W(6, 1040903120, -1104413152, 1019748625, -1089277711)
		 + W(7, 1028591970, -1139620757, 1017306737, 1033828758);
	WS(1050645916, 1033550915);
	sum1 =
		W(0, -1118556120, -1108262319, 1043230361, -1094947334) + W(1, -1103841584, 1018079143, 1032598742, 1008731683)
		+ W(2, -1107219907, 1043545243, -1086762442, -1104041435)
		+ W(3, 1058293794, -1097977901, 1041130248, -1123331655) + W(4, 1039060494, -1145250020, 1059123936, 1057758321)
		+ W(5, -1096913490, 1039599795, -1151122424, -1123961290)
		+ W(6, 1030703933, -1110184190, -1110311564, -1100512367)
		+ W(7, 1044416908, -1132472896, -1147952664, 1022228292);
	sum2 = W(0, 1040267615, 1048409433, -1107165984, -1086251247)
		 + W(1, -1113957324, -1107976602, -1122078587, -1111525785)
		 + W(2, -1112791644, -1110540665, -1088877638, 1053330884)
		 + W(3, 1057377190, 1057673067, 1024512949, 1042772014) + W(4, 1010515766, 1032365064, -1090038325, 1049266570)
		 + W(5, 1028890653, -1103454662, 1041725883, -1143554104) + W(6, 1024308395, 1041630361, 1040244783, 1037513285)
		 + W(7, -1098504745, 1039941233, -1103661415, 1024552651);
	WS(1051978908, -1102077462);
	sum1 = W(0, -1132165009, -1117187439, -1108837850, 1037183202)
		 + W(1, 1028473682, 1045655273, 1025240990, 1033734537) + W(2, 1045761591, 1051430047, 1060286099, 1046972447)
		 + W(3, -1128782822, 1028047735, -1178179968, 1035331372)
		 + W(4, 1013540534, -1096198150, -1130717861, -1085387922)
		 + W(5, -1105434962, -1101497054, -1110960744, -1102517015)
		 + W(6, -1106078467, 1014010165, -1121999817, 1030141582)
		 + W(7, 1008925446, 1018887490, -1122721428, 1026996307);
	sum2 = W(0, 1023072493, -1125531833, 1030396885, -1118880502)
		 + W(1, 1027419877, -1161271853, 1019485964, 1028708277) + W(2, 974611657, 1047662948, 1035351326, -1090109833)
		 + W(3, -1110942359, 1033315833, 1010290822, -1156901930)
		 + W(4, -1101792417, 1051899312, 1080526024, -1069022098)
		 + W(5, -1087739606, 1036440530, -1124554651, -1114394737)
		 + W(6, -1112121991, 1037288067, 1042102238, -1113214479)
		 + W(7, 1032127295, -1143368203, -1132377096, -1141169667);
	WS(1058455886, -1096183470);
	sum1 = W(0, -1105360672, -1112035684, -1105059667, -1103063975)
		 + W(1, -1112638549, -1104182327, -1106250503, -1103319623)
		 + W(2, -1112611850, 1032735242, 1048808633, 1042817013) + W(3, 1058906409, 1047248804, 1047193699, 1057710235)
		 + W(4, 1060616064, 1033545283, 1051085625, -1097442806)
		 + W(5, -1102188695, -1103229812, -1106970890, -1109193562)
		 + W(6, -1104075433, -1111940643, -1115570744, -1097216429)
		 + W(7, -1107200030, -1108265532, -1119499692, -1106901731);
	sum2 = W(0, -1135393651, -1131009665, 1004138181, -1111055824)
		 + W(1, -1134829555, -1127256265, -1113946573, 1010148467)
		 + W(2, -1114274101, 1016197705, -1143366053, 1051632163)
		 + W(3, -1111579981, 1038147066, 1025185617, -1137859715)
		 + W(4, -1117767149, -1130986601, 1026922589, 1048764370)
		 + W(5, 1036257166, -1112945554, -1143942149, -1123068365)
		 + W(6, -1110403581, -1136444051, -1112183743, -1121253595)
		 + W(7, 1009689523, 989872074, -1123668797, -1123716033);
	WS(-1103618872, 1023577831);
	sum1 = W(0, 1041702149, 1032268701, 1021026046, 1032012647) + W(1, 1023662430, -1111766616, -1112590149, 1042231991)
		 + W(2, 1057806109, 997904496, 1057675340, -1129702414) + W(3, 1056283152, 1039716321, 1049875952, 1054291708)
		 + W(4, -1091063799, -1106010126, -1090884608, -1094077941)
		 + W(5, -1094732237, -1100869456, -1105996279, -1098425069)
		 + W(6, 1022049043, -1102660926, 1046995709, -1100395542)
		 + W(7, 1050214494, -1096243374, 1047647816, -1100607928);
	sum2 =
		W(0, 1073849383, 1069429154, 1070121938, 1066905653) + W(1, -1087755842, -1080359597, -1073496568, -1070245916)
		+ W(2, -1072987051, -1080077361, -1076996297, -1086754234)
		+ W(3, 1060194671, 1067521081, 1074652354, 1075883836) + W(4, 1040644897, -1098556311, -1124122091, -1095882058)
		+ W(5, -1096747545, 1048551041, -1092793409, 1058695504)
		+ W(6, 1022236877, -1128073567, -1118780260, 1027638421)
		+ W(7, 1012182550, -1129108935, -1130588931, 1001812541);
	WS(1010873216, -1100304815);
	sum1 = W(0, -1154187044, 1028741017, -1114247598, -1099084427)
		 + W(1, -1104966895, 994968800, -1113228468, 1028263947) + W(2, 1045945805, 1051026373, 1058185854, 1059904750)
		 + W(3, 1052860588, 1038231664, 1040557287, 1032103905)
		 + W(4, -1102222630, -1103217414, -1097780567, -1091550752)
		 + W(5, -1108718914, -1110664976, 1017403508, 1017865354)
		 + W(6, -1113759340, 1022415534, -1105383733, -1111624796)
		 + W(7, -1114326870, -1110217221, -1108875519, -1109350878);
	sum2 =
		W(0, -1114639192, 1039210963, 1047528380, -1099502544) + W(1, 1041344628, -1108972702, 1021595805, -1116883371)
		+ W(2, -1100331344, 1069298433, 1080352854, -1067747068)
		+ W(3, -1080996124, 1032407437, -1121090437, 1016604711) + W(4, 1035901690, 1043940791, 1030733380, -1084572959)
		+ W(5, 1003800555, 1045939813, -1121287047, -1122259179)
		+ W(6, 1012858414, -1126620651, 1036529177, -1099630936)
		+ W(7, 1043527822, -1119860547, -1145664907, 1034105585);
	WS(1044302648, -1104457270);
	sum1 = W(0, -1115179413, -1101763748, 999269803, -1106420033)
		 + W(1, 1041707045, -1128885581, -1110751840, 1029110244) + W(2, 1029190781, 1045938783, 1034810490, 1055724168)
		 + W(3, 1053359959, -1100033022, 1037908026, 1035419021)
		 + W(4, -1108944696, -1102720380, 1038235218, -1101615303)
		 + W(5, -1094303566, 1043259278, 1011056201, -1123807773)
		 + W(6, -1115207128, 1013266237, 1025157307, -1105407492)
		 + W(7, 1045691477, -1113033137, -1114066571, -1113282394);
	sum2 =
		W(0, -1117238549, -1115295266, 1033754662, -1095438097) + W(1, -1106855439, 1011060498, -1117460606, 1032653312)
		+ W(2, -1109414288, -1128441429, -1104877135, 1053172955)
		+ W(3, 1056926069, -1108715476, 1036225840, -1114450934)
		+ W(4, -1115125848, -1121954754, 1018153798, 1038786210) + W(5, -1104082080, 1043675119, 1008366234, 1018894269)
		+ W(6, 1023475415, 1024122972, 1002646200, -1106263750) + W(7, 1034246226, 1025499367, -1107090094, 1013321052);
	WS(1068015911, 1043072951);
	sum1 = W(0, -1127841379, 1035792844, -1155603908, 1018341976)
		 + W(1, -1111053022, 1044403491, -1112313859, 1005208661)
		 + W(2, -1101991257, -1091973141, -1110119406, -1095315357)
		 + W(3, -1107228151, -1111437840, -1097295811, -1103670736)
		 + W(4, 1041159238, 1040826438, 1052691071, 1053842800) + W(5, 1042506601, 1050221764, 1030249017, 1046985745)
		 + W(6, 1035382295, -1098419575, 1043898844, 1030324599)
		 + W(7, -1108241413, 1043481954, -1098652336, 1032196534);
	sum2 =
		W(0, -1134315530, 1033824390, -1112867968, 1039862799) + W(1, 1005143468, -1114969920, 1030354102, -1131720457)
		+ W(2, -1125722365, 1019923991, 1039464885, -1087456726)
		+ W(3, -1119378177, 1042059959, -1113780490, 1009971850)
		+ W(4, -1135384490, 998580556, -1093291922, -1061395777)
		+ W(5, -1106942114, -1121281813, 1034179020, 1032010553) + W(6, -1118933131, 1027495017, 1045077367, 1087627027)
		+ W(7, 1034637079, -1148550692, -1118611519, -1117397469);
	WS(1060186318, -1131602669);
	sum1 = W(0, 1022422466, -1102049002, 1050775273, -1097141731)
		 + W(1, 1056872997, -1099566807, 1025667942, 1032894309) + W(2, 1050205114, 1052887138, 1052456073, 1049038746)
		 + W(3, 1040490435, 1039690728, 1043457059, 1045856748)
		 + W(4, -1099402401, -1102238785, -1100510367, -1088759247)
		 + W(5, -1122526498, -1099089908, -1102859210, -1106963501)
		 + W(6, -1112848707, -1106285089, 1039607513, -1098786589)
		 + W(7, 1048305743, -1104192622, 1032266998, -1118572779);
	sum2 = W(0, 989650422, -1108234271, -1120122674, 1045260201)
		 + W(1, -1114112879, 1037831837, -1117501250, 1024132690)
		 + W(2, -1120410947, 1050158699, -1092804082, 1024838498)
		 + W(3, -1125280065, -1119936776, -1114421818, 1035095434)
		 + W(4, 1047633630, 1066272871, 1075424781, 1061734347) + W(5, -1091697647, 1003481288, 1011848513, -1106020023)
		 + W(6, -1081060940, -1074101109, -1079387458, 1050344942)
		 + W(7, 1043540897, 1039609275, -1131708367, 1026462111);
	WS(1057810382, 986287880);
	sum1 = W(0, -1105255365, 1027767677, 1037147968, 1038550632)
		 + W(1, -1136315263, 1035749561, -1115075413, 1028257967)
		 + W(2, -1110142276, -1106138450, -1092238936, -1090210593)
		 + W(3, -1089134184, -1093055129, -1097497096, -1089420006)
		 + W(4, 1041191503, 1031406779, 1027980992, 1049547413) + W(5, 1052451129, 1057536820, 1050343212, 1058108487)
		 + W(6, 1050176972, -1130243957, 1041310918, 1041377527)
		 + W(7, -1115128119, 1033537239, -1127231554, 1031965752);
	sum2 = W(0, -1099824579, -1113793286, 1053512844, -1112943238)
		 + W(1, 1041834894, -1099992002, -1120789532, 1024916046)
		 + W(2, 1070708271, -1104040400, -1091831853, -1072548459)
		 + W(3, -1093778092, 1057576575, 1064181862, 1051972140)
		 + W(4, 1075074245, -1084124078, -1082668198, -1072503695)
		 + W(5, 1056090411, 1053907302, 1058602971, 1054786345) + W(6, -1097074436, 1023561426, 1039380165, 1009216489)
		 + W(7, 1043969626, -1107563771, 1034348623, -1106961801);
	WS(-1075707047, 1038147646);
	sum1 = W(0, 1038492938, -1115961531, 1036899040, 1041066756) + W(1, 1038870159, 1045702796, 1022987667, 1044017707)
		 + W(2, 1050722763, 1026800423, 1055626176, 1052178217) + W(3, 1027667391, 1053246416, -1100305296, 1049962981)
		 + W(4, -1095596015, -1103730686, -1091210886, -1090286882)
		 + W(5, -1094135001, -1095582752, -1109653838, -1093296229)
		 + W(6, 1040870942, -1122935577, 1047700685, 1036539085)
		 + W(7, -1102625947, 1048523811, -1105859960, -1117734303);
	sum2 = W(0, -1145353723, -1113260796, -1112198364, -1113367096)
		 + W(1, 1007958125, 1047146251, -1122974002, 1021064313) + W(2, 1027969677, -1095928859, 1052169305, 1052353113)
		 + W(3, -1129450520, 1051473061, -1091037095, 1050393555)
		 + W(4, -1115030411, 1031463199, -1108227013, 1051016428) + W(5, 1041462653, 1045242344, 1032341221, 1020102815)
		 + W(6, 1052090154, -1110261785, 1041877601, -1099630700)
		 + W(7, -1087173862, -1102681887, -1095485390, -1111896409);
	WS(-1102302520, 1068562064);
	sum1 = W(0, -1130894152, 1029216267, 1029150351, 1029804895)
		 + W(1, -1108054071, 1046304488, -1107326720, 1018120580)
		 + W(2, -1101486038, -1094978851, -1104755260, -1093484995)
		 + W(3, -1110271975, -1106599349, -1102131284, -1102274525)
		 + W(4, 1044130034, 1029251017, 1053252560, 1050941559) + W(5, 1036880709, 1050863202, -1128083416, 1047248574)
		 + W(6, 1031789673, -1102217970, 1042516209, 1040658618)
		 + W(7, -1113036417, 1041743615, -1102226940, 1032422999);
	sum2 =
		W(0, 1019111797, -1123809812, 1006739898, 1041109085) + W(1, -1126211453, 1028972357, -1118372569, 1025713585)
		+ W(2, 1022527979, -1111065998, 1031759809, -1095097056)
		+ W(3, 1034613952, -1107360163, 1033659253, -1118642675) + W(4, -1131519898, 1023737355, 1045357020, 1082939698)
		+ W(5, 1027342607, 1033832936, -1112248823, -1118824157)
		+ W(6, 1029130971, -1117143513, -1106220344, -1064938697)
		+ W(7, -1122955245, -1112280546, 1032152906, 1028082979);
	WS(1066566439, -1125753148);
	sum1 = W(0, 1020091828, 1041951168, -1130301450, 1052053147)
		 + W(1, -1131231944, 1033588155, 1009411772, -1116682291)
		 + W(2, -1096367972, -1098758994, -1093467737, -1089881409)
		 + W(3, -1092544881, -1098181717, -1110070786, -1096392077)
		 + W(4, 1038767583, 1048997640, -1130818632, 1064063659) + W(5, -1116991019, 1042770882, 1046860728, 1027361773)
		 + W(6, 1030663671, 1025331919, -1108818909, 1044746920) + W(7, 1022962726, 1041997189, 1018371147, 1038578846);
	sum2 = W(0, -1105507764, -1149004498, -1098298748, -1115729482)
		 + W(1, -1094576030, -1111478010, -1129010369, 1018600957)
		 + W(2, 1019815533, 1047279899, -1106660204, 1058550934) + W(3, 1031191852, 1032716298, -1117054989, 1019851909)
		 + W(4, -1136431769, -1121679526, -1096656341, 1058580319)
		 + W(5, -1098228632, 1041490224, 1047791827, -1106522387)
		 + W(6, 1024962860, 1041000955, -1107413740, 1027135608)
		 + W(7, -1101441076, 1035067556, -1123460834, 1005788722);
	WS(1050996380, 1066787661);
	sum1 = W(0, 1042843177, -1120310187, 1033453959, -1107450543)
		 + W(1, 1017862620, -1134072575, 1025308393, 1033769739) + W(2, -1109518091, 1043911830, 1059519229, 1061971625)
		 + W(3, 1051823058, 1046601317, 1042112788, 1046863997)
		 + W(4, -1098674409, -1097687209, -1096304487, -1098011863)
		 + W(5, -1095767039, -1095249970, -1098354285, -1098417599)
		 + W(6, -1112832565, -1133582755, -1116528532, -1105396874)
		 + W(7, 1033796902, 999923683, 1030029487, -1109771063);
	sum2 = W(0, -1103321099, 1033376724, -1108916223, 1033194077)
		 + W(1, 1038197771, 1032881798, 1017830932, -1138730935)
		 + W(2, -1087654445, -1114493691, 1049058628, 1065240604)
		 + W(3, -1128335788, -1094150295, 1006224046, -1112103411)
		 + W(4, -1098379129, -1096458683, 1036368268, 1054396447)
		 + W(5, 1049730119, -1108472207, 1031462702, -1102017203)
		 + W(6, 1013739975, 1015354012, -1121134774, -1115257551)
		 + W(7, -1129699908, 1021079748, -1117224382, 1038189385);
	WS(1027314912, -1081149641);
	sum1 = W(0, -1109480125, -1114947760, -1101195017, -1132100201)
		 + W(1, -1103759537, 1044342469, -1111893319, 1051194426) + W(2, 1051429188, 1053252314, 1058130398, 1061393767)
		 + W(3, 1057940398, -1104522586, 1055491172, -1120202825)
		 + W(4, -1118844062, -1094077252, -1113091794, -1085308129)
		 + W(5, -1102037735, -1094497965, -1103334896, -1094870250)
		 + W(6, -1097611416, 1034118735, -1104617542, 1035982720)
		 + W(7, -1114189097, 1036294793, -1128796810, 1030785028);
	sum2 = W(0, -1131039707, 1024995350, -1104486127, 1015537291)
		 + W(1, 1053996441, -1103676904, 1047124046, -1111129691)
		 + W(2, -1098833779, -1124760267, -1078713050, -1065942779)
		 + W(3, 1047686732, 1084085461, 1064521940, -1093915430)
		 + W(4, -1147567565, 1057070390, -1091843304, -1081156610)
		 + W(5, -1094140189, 1060423478, 1046849692, 1018309905) + W(6, 1035790053, 995065627, 1037354874, -1154356731)
		 + W(7, -1107145709, 1026796886, -1108476011, 1038591472);
	WS(-1081542375, 1044780323);
	sum1 = W(0, 1026864081, -1100303790, 1048337215, -1098110473)
		 + W(1, 1054474587, -1099969099, 1023999910, 1028627178) + W(2, 1046719985, 1054288460, 1054459103, 1048901488)
		 + W(3, 1041639871, 1034589376, 1043694031, 1046235480)
		 + W(4, -1098857847, -1108679899, -1098101851, -1093175556)
		 + W(5, -1104037973, -1107626335, -1101510966, -1106600025)
		 + W(6, -1114219435, -1104586877, 1041408644, -1098306531)
		 + W(7, 1046672715, -1104199322, 1022681657, -1126646775);
	sum2 = W(0, 1017985090, 1027847194, 1036519222, -1113167123)
		 + W(1, 1037009826, -1113380621, 1031131596, -1115360802)
		 + W(2, 1024212320, -1098721130, 1050387030, -1094712479)
		 + W(3, -1100822056, 1028269032, 1009055356, -1113841920)
		 + W(4, -1099849981, -1081468176, -1070464929, -1096550174)
		 + W(5, 1057690620, 1042714784, -1145638655, 1046010973) + W(6, 1067245211, 1074345814, 1070597407, -1088417301)
		 + W(7, -1104880956, -1102737214, 1000105719, -1112342255);
	WS(1059294542, 1020616832);
	sum1 = W(0, -1157534552, 1039080142, -1097783100, 1031217968)
		 + W(1, -1164216296, -1138897989, 1026686634, -1105498094)
		 + W(2, -1096856701, 1044861738, -1089052876, -1085780263)
		 + W(3, 1044573672, -1097342660, 1041475528, -1105558033) + W(4, 1050532499, 1041652423, 1057029426, 1047119538)
		 + W(5, 1039715347, 1043073721, 1040308239, 1048391538) + W(6, -1112831597, 1046540791, -1098369827, 1040272239)
		 + W(7, 1024931118, -1103025619, 1045404192, -1114523696);
	sum2 = W(0, -1106291706, 1001372950, -1099590495, -1093748925)
		 + W(1, 1015225205, -1105937891, -1112612361, 995169980) + W(2, 1040318024, -1105705183, 1045484852, 1061316313)
		 + W(3, -1098311584, 1041085521, 1028378294, 1035732349)
		 + W(4, -1114208076, -1116263519, -1108179199, 1049891427)
		 + W(5, 1040668388, -1111581107, -1115787941, -1113959318)
		 + W(6, -1142193319, -1145917455, 1036599633, -1108356360)
		 + W(7, -1148092276, 1032743264, 1021281994, 1024794158);
	WS(1059376718, -1137270291);
	sum1 =
		W(0, -1118257199, 1037392427, -1097794403, 1035766677) + W(1, 1026067385, 1032186693, -1108679762, -1139304576)
		+ W(2, 1043258576, -1106073464, 1054680411, -1099046488)
		+ W(3, -1088020070, 1041392887, -1113652045, -1111666975)
		+ W(4, -1114290826, -1124279079, -1115190716, 1052189312)
		+ W(5, 1054691490, -1097245116, 1025610423, -1123561026) + W(6, -1112002778, 1022160871, 1045843716, 1011458515)
		+ W(7, -1110958220, 1046761570, -1117145658, 1032305501);
	sum2 =
		W(0, 1025244035, -1122852568, -1092220395, 1038019467) + W(1, 1048072683, -1113553750, -1119930901, -1139793711)
		+ W(2, 1033595807, -1087687504, 1066421651, 1047700223)
		+ W(3, -1084925862, 1050883425, -1105555859, -1146566911)
		+ W(4, 1016573022, 1048825911, 1058107887, -1089540205) + W(5, 1045215493, -1098430697, 1041208433, -1124843514)
		+ W(6, 1002397687, -1104089806, -1130145014, -1111655831)
		+ W(7, 1032935415, 1015641098, 1001885951, -1131703250);
	WS(1058596686, 1013962118);
	sum1 = W(0, 1000024554, -1127551432, -1100000762, 1035333436)
		 + W(1, -1122612871, 1044766998, 1041477861, 1051562743) + W(2, 1052551424, 1049056438, 1057499982, 1036076760)
		 + W(3, -1127972943, -1116046252, -1118015335, -1099275107)
		 + W(4, -1088298614, -1098656348, -1090756927, -1097067922)
		 + W(5, 1040213184, 1015197910, -1123679237, -1122278672) + W(6, 1039656505, 1034731345, 1019232187, 1033429441)
		 + W(7, -1125045580, -1113717771, 1037833508, -1122272135);
	sum2 =
		W(0, -1104434141, 1029025211, -1078497608, -1079110377) + W(1, -1085502108, 1066279808, 1062913146, 1068620036)
		+ W(2, 1048601996, -1091369704, 1052827694, -1106615386)
		+ W(3, -1115334546, 1037382016, -1122817088, 1048688798)
		+ W(4, 1033271157, -1119340081, 1025214064, -1109539756)
		+ W(5, 1050957039, -1106594885, 1036274829, -1118139306) + W(6, 1004930429, 1028438774, -1106316897, 1034989376)
		+ W(7, -1108631008, 1023198169, -1134348613, -1139733884);
	WS(1044771128, 1023341948);
	sum1 = W(0, -1156220044, 1034545464, 1033488922, -1111313058) + W(1, 1038420969, 1008511890, 1013986230, 1011084871)
		 + W(2, -1092336191, -1098819215, -1096491302, -1086850728)
		 + W(3, -1102939421, -1100928894, -1115524377, -1089482302)
		 + W(4, 1051560294, 1044146859, 1051910286, 1045449190) + W(5, 1053458817, 1038883707, 1012126018, 1046748951)
		 + W(6, 1036528391, 1029114797, 1022761170, 1029767950) + W(7, 1041877300, 1034675856, 1037411178, 1043196317);
	sum2 = W(0, -1071004894, -1080574884, -1089987082, 1049506323)
		 + W(1, 1065282653, 1062249589, 1060165079, 1070844945) + W(2, 1076503146, 1066884159, 1058011283, -1098882467)
		 + W(3, -1084978169, -1088626314, -1082249713, -1077734377)
		 + W(4, 1057610169, -1107351326, 1054000347, -1090234844)
		 + W(5, 1030898490, -1090230279, 1044380003, -1096516163)
		 + W(6, -1122913984, -1130255370, 1038970611, 1014162118)
		 + W(7, -1114000490, 1022492087, -1131621088, 1013009282);
	WS(-1111817840, -1134998409);
	sum1 = W(0, 1022731056, 1045262352, 1044888721, 1029818259) + W(1, -1105915720, -1114660906, 1027479949, 991785104)
		 + W(2, -1102901203, -1094315057, -1085070720, -1111793509)
		 + W(3, 1055206544, 1046806370, -1123039746, -1136267423) + W(4, 1029699069, 1052915216, 1058770140, 1057078063)
		 + W(5, -1095183540, -1097451385, -1112670352, -1114500629)
		 + W(6, 1021112442, -1107194439, -1097785743, -1117717150)
		 + W(7, 1040740592, 1036425016, 1005586201, 1016465988);
	sum2 = W(0, -1129690332, 1030842707, -1123486113, 1054087898)
		 + W(1, -1105176966, -1097205966, -1098021434, -1106929221)
		 + W(2, -1113356803, 1026318374, 1041923626, -1089332833)
		 + W(3, 1068558125, -1141184456, -1107728348, -1104288342)
		 + W(4, 997943457, -1119512995, 1037525758, -1088292904) + W(5, 1040210770, 1050151959, 1018682892, 1006954668)
		 + W(6, 1015499837, -1180561029, -1144014736, 1037328869)
		 + W(7, -1107365912, -1114055561, 1009592392, 1013301204);
	WS(-1100650808, 1043653943);
	sum1 =
		W(0, 1038392637, 1032036848, -1120772452, 1043637149) + W(1, 1040259489, 1047398869, 1038054351, 1050576478)
		+ W(2, 1044290651, 1040683515, -1106266873, -1090111931) + W(3, -1133467790, 1044787930, 1023591523, 1037223428)
		+ W(4, -1095199164, -1115398639, -1094097345, -1097393337)
		+ W(5, -1104941765, -1101572298, 1016760834, -1102689443) + W(6, 1033771919, 1038316223, 1042896310, 1045751664)
		+ W(7, -1159203906, 1015063331, 1030908740, -1125005703);
	sum2 =
		W(0, 1018053796, 1000548496, 1049079603, 1039189619) + W(1, -1128574308, -1118597354, -1106984497, -1104543855)
		+ W(2, 1046306039, 1043541862, 1010667960, 1064529690) + W(3, 1047996002, -1087406141, -1095617964, -1086946593)
		+ W(4, -1101305605, 1029064982, -1116813778, 1038487223)
		+ W(5, -1100258391, 1048794746, -1114392997, 1045938007)
		+ W(6, 1031448374, -1112893849, 1021972628, -1105518867)
		+ W(7, 1037842238, 1033382833, 1021089548, -1140458600);
	WS(-1121537248, 1047151836);
	sum1 = W(0, -1096325448, -1113135282, -1098188693, -1112146268)
		 + W(1, -1108791588, -1117696601, -1123869651, -1114157115)
		 + W(2, 1052654400, 1035132488, 1046868890, -1134150082)
		 + W(3, -1129891280, -1098847494, 1032919412, -1107856679)
		 + W(4, 1000450324, -1110395025, -1139200797, 1049727010) + W(5, 1041189572, 1056884317, 1041128337, 1058220805)
		 + W(6, -1116556387, 1023519458, -1111260975, -1110207458)
		 + W(7, -1104838938, -1098805187, -1146298440, -1103148146);
	sum2 =
		W(0, -1142864271, 1021304865, 1043366966, -1107584343) + W(1, 1014758407, -1130465374, -1120740451, 1000478551)
		+ W(2, 1043572739, 1026011378, -1102859954, -1080136051)
		+ W(3, -1103597159, -1115654645, 1046511165, 1053224660)
		+ W(4, -1125571574, 1028667063, 1022196210, -1072538638) + W(5, -1076945816, 1048815254, 1072551214, 1074776028)
		+ W(6, -1107989855, -1140649559, 1020722946, -1132367054)
		+ W(7, 1041979768, -1126224006, 1027667511, 1048839210);
	WS(-1086568910, 969651201);
	sum1 = W(0, -1128189323, 1044154939, 1043534732, -1114366976)
		 + W(1, -1098469330, -1101372520, -1123038043, -1132910587)
		 + W(2, -1096064919, -1089612648, -1084798775, 1053159863)
		 + W(3, 1053431542, 1050787607, 1036747448, -1116020373) + W(4, 1047521403, 1054908701, 1056987371, 1057685165)
		 + W(5, -1089249613, -1090701774, -1105030179, 1027268120)
		 + W(6, 1043461231, -1099266659, -1113308531, -1152040120)
		 + W(7, 1042761408, 1049635020, 1010635844, 1018344000);
	sum2 = W(0, 1042932965, -1103428495, 1039997403, -1093583228)
		 + W(1, 1044856824, -1121819542, -1177180368, 1028413178)
		 + W(2, -1103892922, 1060495074, 1052448567, -1075640666)
		 + W(3, 1057723154, 1057002090, -1112150955, -1118134166)
		 + W(4, -1104364155, 1060109323, 1064108701, -1073056297)
		 + W(5, 1055665788, 1060503917, -1116550688, -1110515035)
		 + W(6, -1139842168, -1118896922, 991756114, -1097481656)
		 + W(7, 1040659602, -1099984054, 1034919451, 1041069777);
	WS(-1084093518, -1116656412);
	sum1 = W(0, 1002008836, 959481663, -1104590931, 1050696243) + W(1, -1106608235, 1047962207, 1030562773, 1015783795)
		 + W(2, 1058416208, 1026388179, 1059097973, 1042079029) + W(3, 1041679827, 1049127990, 1031439243, 1042535660)
		 + W(4, -1096672513, -1109778819, -1088144465, -1096264126)
		 + W(5, -1101432288, -1100480244, -1113594772, -1093923750)
		 + W(6, -1112390467, 1023428581, -1112632704, 1040470858)
		 + W(7, -1102954054, 1047012782, -1112144502, -1145396437);
	sum2 = W(0, 1007960967, -1110192070, 1049899326, 1056650247) + W(1, 1078512141, 1081472440, 1058404171, 999915485)
		 + W(2, 1027407916, 1010716935, -1097456083, -1070859565)
		 + W(3, -1068241064, -1079514242, -1094427160, 1030657127)
		 + W(4, -1129957403, 1018303319, 1037417999, -1094713389)
		 + W(5, -1096379657, 1043613542, 1025537830, -1116925932)
		 + W(6, -1132155403, -1121935910, -1137993343, -1142796285)
		 + W(7, 1039214170, -1111213656, 1032528613, 1024356221);
	WS(1052225948, 1018668194);
	sum1 = W(0, -1120453498, -1123160289, -1108654867, -1104839613)
		 + W(1, 1041378113, 1036965515, 1044186084, 1034438594) + W(2, 1051775516, 1048325451, 1058214550, 1064670427)
		 + W(3, -1126638409, 1049967085, -1096299613, -1128237844)
		 + W(4, -1117579103, -1111291056, -1093397513, -1091445969)
		 + W(5, -1092047898, -1099225050, -1112850625, -1112057991)
		 + W(6, -1107074656, -1112742544, -1147977428, -1119335936)
		 + W(7, -1109154218, 1034167881, -1138567959, 1019177609);
	sum2 = W(0, -1121001958, -1148685985, 1018483434, 1021815720)
		 + W(1, 1049361594, -1108634723, -1132118692, -1105580672)
		 + W(2, -1117606942, -1111847761, -1120566718, -1076982600)
		 + W(3, 1074852012, 1048076514, -1102180777, -1116866514)
		 + W(4, -1103097305, 1021935234, 1049895592, -1081972918) + W(5, 1051964198, 1040925857, 1017568960, 1040155911)
		 + W(6, -1130038396, -1112487949, 1038078839, -1125812992)
		 + W(7, -1152546434, -1104919092, 1026180028, -1123068468);
	WS(-1096382876, -1091051652);
	sum1 = W(0, -1116126267, -1113197617, -1112424211, -1124324715)
		 + W(1, -1136579346, 1040875430, -1113905512, 1017323784) + W(2, 1057278592, 1048826126, 1058810754, 1056304110)
		 + W(3, 1041995897, 1016295122, 1024916389, 1042534003)
		 + W(4, -1096000788, -1097274020, -1088739494, -1091311905)
		 + W(5, -1114916522, 1038826452, -1128507781, 1017648027)
		 + W(6, -1116910752, -1140807037, 1039925053, -1132679170)
		 + W(7, -1107191661, -1119450067, 1023437062, -1098370349);
	sum2 = W(0, -1120311657, 1036113080, -1109045199, 1029662296)
		 + W(1, -1122358251, -1114085873, 1016737279, -1115835645)
		 + W(2, 1025682064, -1107470193, 1035621932, -1118009189) + W(3, 1045290388, 1009830751, 1035169596, 1030264440)
		 + W(4, 1036682152, -1108061877, 1051542033, -1101792442)
		 + W(5, -1093646778, 1056395710, -1091719234, 1052430993)
		 + W(6, -1108273289, 1012612647, -1101063214, -1076098595)
		 + W(7, -1080861029, 1039398973, 1065137390, 1072502688);
	WS(1040082544, -1114755812);
	sum1 = W(0, 1017784372, 1037505264, 1045745417, 1019379817) + W(1, -1109308706, -1124056118, 1025470519, 1039469090)
		 + W(2, -1110974758, -1108514902, -1095324708, 1052579502) + W(3, 1058051822, 1046163210, 1038459986, 998280780)
		 + W(4, 1040296296, 1041424680, 1054913780, -1106396419)
		 + W(5, -1087512533, -1093666877, -1106674096, -1109356390)
		 + W(6, 1024480479, -1104471944, -1106439461, -1115066496)
		 + W(7, 1040857799, 1001482384, 995688529, -1108404770);
	sum2 = W(0, -1162396366, -1117720653, -1104226850, -1105580348)
		 + W(1, -1105643813, 1031813906, 1011045214, 1018164327) + W(2, 1045315846, -1118054954, 1057942904, 1059476362)
		 + W(3, -1090022037, 1045409162, -1106412098, 1023977529) + W(4, 1034748092, 1034773210, 1043388435, 1067689202)
		 + W(5, -1083232471, -1101262587, -1124577575, -1102021751)
		 + W(6, 1035646876, -1100298043, -1097646834, -1093789486)
		 + W(7, 1040357620, -1113573448, 1012935222, 1024454049);
	WS(1036525168, -1082462584);
	sum1 = W(0, -1116308971, 1037298441, 1027885589, -1122874917)
		 + W(1, -1154089797, -1108384819, 1028179743, 1003463273)
		 + W(2, -1085123800, -1087372070, -1086414101, -1096064460)
		 + W(3, -1099879381, -1104319094, -1127380522, -1096394215)
		 + W(4, 1057675329, 1051660338, 1059597873, 1059581688) + W(5, 1052784510, -1117339864, 1039251609, -1110971807)
		 + W(6, 1019612704, 1027541711, -1109257541, 1041073820) + W(7, 1028059367, 1045372305, 1031554934, 1053758651);
	sum2 =
		W(0, 1060691160, -1103295177, 1035985281, -1085964582) + W(1, -1105398566, -1107551093, 1049030608, -1090293163)
		+ W(2, -1081285622, -1090050073, -1102851017, 1072728426)
		+ W(3, 1060511611, 1033954581, -1086630634, 1058069039) + W(4, -1080809247, 1050684042, -1087522637, 1060852217)
		+ W(5, 1058511518, 1041242888, 1028348456, 1062481845) + W(6, 1052276353, -1106187369, 1048638013, -1090587145)
		+ W(7, 1029176048, -1094879840, 1046256182, -1087039462);
	WS(-1074352935, 1040600857);
	sum1 = W(0, 1042034194, 1028652336, 1024054004, 1030695172) + W(1, 1029627411, -1117605317, -1114002447, 1041624512)
		 + W(2, 1057627204, 1025049468, 1057567995, 1022098295) + W(3, 1052602222, 1039437212, 1049556590, 1053416947)
		 + W(4, -1090157751, -1105875707, -1088931067, -1095088235)
		 + W(5, -1094832321, -1104356174, -1107260676, -1101255271)
		 + W(6, 1024364622, -1105990299, 1048022018, -1100928004)
		 + W(7, 1049957878, -1095846092, 1047165477, -1098759166);
	sum2 = W(0, -1075440350, -1079714919, -1079134350, -1081735031)
		 + W(1, 1055569671, 1066585571, 1071644179, 1075476470) + W(2, 1073165865, 1065983198, 1068716226, 1066499710)
		 + W(3, -1095308006, -1080754250, -1074800849, -1073191304)
		 + W(4, -1112383192, 1048707236, -1135853868, -1098543278)
		 + W(5, 1021808504, -1108920844, 1050977418, -1090378667)
		 + W(6, -1148975848, -1115591486, 1038054064, -1125971282)
		 + W(7, 1040311395, -1110109816, 1035370814, -1120408347);
	WS(1041022776, 1033480094);
	sum1 = W(0, -1132576057, -1123321429, 1028959481, -1104176578)
		 + W(1, 1046472198, -1121060138, 1027556403, -1115611836) + W(2, 1026327841, 1042302896, 1052457903, 1063677500)
		 + W(3, -1097607903, -1123802109, -1118671609, 1039698959)
		 + W(4, -1110434490, -1109312954, -1089918670, 1025377120)
		 + W(5, -1090934974, 1046523967, -1112257611, 1000531209)
		 + W(6, -1119031508, 1021323174, 1029242558, -1118638740)
		 + W(7, 1013298461, -1106699146, 1030036314, -1116635705);
	sum2 = W(0, -1106027239, -1122286155, -1102546078, 1055155948)
		 + W(1, -1096754888, 1032068992, -1121774513, 1036170969)
		 + W(2, 1049930690, -1127267122, 1041115945, -1091935564)
		 + W(3, 1052250618, -1103388917, 1038737216, -1108790214)
		 + W(4, -1110218398, -1108798456, 1058786995, 1075372513)
		 + W(5, -1071163371, -1123143101, -1121707895, 1032355550)
		 + W(6, 1034564779, 1018367610, -1095860458, 1043590800)
		 + W(7, -1112711414, -1119323979, 1016553114, 1017858173);
	WS(1055618972, -1117202987);
	sum1 = W(0, 1030962480, -1101414710, -1098100923, -1111740150)
		 + W(1, 1036980413, 1041005827, 1021681163, -1112834597) + W(2, 1039894129, 1053882576, 1057347458, 1049814740)
		 + W(3, -1090053902, -1088233382, -1105970903, -1117339136)
		 + W(4, -1101932469, -1089999221, -1085784352, 1051098296)
		 + W(5, 1056052448, 1051763396, 1044301630, 1032801282) + W(6, 1031993659, 1048656807, 1043352452, 1031031542)
		 + W(7, -1104607674, -1119077705, 1022017143, 1039235901);
	sum2 =
		W(0, -1114659327, -1123577690, 1042921002, -1105097716) + W(1, 1042773509, -1093975266, 1032061179, 1000405669)
		+ W(2, -1101541229, 1043634319, 1066882360, -1077668162)
		+ W(3, 1037629509, 1058638399, -1108208741, -1131856909)
		+ W(4, -1107338771, 1057974128, 1050113378, -1080704784) + W(5, 1051155360, 1052705661, 1008396554, -1111189711)
		+ W(6, 1039378885, -1111523166, 1040130625, -1104122760)
		+ W(7, 1012227066, -1110420726, -1125218199, 1025207949);
	WS(-1091387548, -1116324289);
	sum1 = W(0, 1026642697, 1044682252, 1041967213, 1032214050)
		 + W(1, -1131062694, 1015214154, -1137069945, -1110158325)
		 + W(2, -1112220622, -1093973688, 1046046637, -1086442024)
		 + W(3, -1099996941, 1053177927, -1098783494, 1037567917)
		 + W(4, 1049897926, 1047211372, 1050365286, -1112122925) + W(5, 1046223135, -1132096750, 1024489425, 1042021623)
		 + W(6, 1027958127, -1098544270, -1112662293, -1106755108)
		 + W(7, -1116559746, 1034258897, -1111108842, 1031638516);
	sum2 = W(0, -1108095393, 1016776222, 977935538, -1122468710) + W(1, 1019959206, 1030099429, -1104930054, 1002749526)
		 + W(2, 1011776651, 1024100809, -1097248934, 1057627889) + W(3, 1042194141, -1117226417, 1051928720, 1041814459)
		 + W(4, -1101257730, -1105403134, -1101986254, 1060632600)
		 + W(5, -1090719303, 1037412790, -1109292621, -1115385474)
		 + W(6, 1019145070, 1032882678, -1124027994, -1103033100)
		 + W(7, 1039533068, -1110127978, -1125661478, -1108291818);
	WS(1057965518, -1118811194);
	sum1 = W(0, -1104352985, 1038892389, -1105058276, 1042490232)
		 + W(1, -1121521774, -1099594944, 1033536020, -1095161930)
		 + W(2, -1106566686, -1112643723, 1026830542, -1091938531)
		 + W(3, 1058056073, -1101314965, -1098044778, 1039936570) + W(4, 1052732873, 1003767366, 1060358287, 1019887594)
		 + W(5, -1118338013, 1042464324, 1024562028, 1046000094)
		 + W(6, -1107147458, -1114250980, -1096574819, 1048844541)
		 + W(7, 1024329053, -1107780158, 1032778872, -1107207172);
	sum2 = W(0, -1116205334, 1042905425, -1109155755, 1044205280)
		 + W(1, 1035597621, 1008636092, 1036458751, -1092853308) + W(2, 993944814, -1113078065, 1044406596, 1040105843)
		 + W(3, 1043112037, -1123380436, -1105268129, 1005260887)
		 + W(4, 1032713731, -1104977559, 1048672381, -1104277422)
		 + W(5, -1103087244, -1153474446, 1015784078, 1036094123)
		 + W(6, -1106373772, 1039619019, -1115343154, 1048332350)
		 + W(7, 999501191, -1106439836, 1021528398, -1106473413);
	WS(1053420700, 1049909457);
	sum1 =
		W(0, -1115258034, 1034071238, 1027276239, -1115686559) + W(1, 1041096236, -1102788144, 1034068157, -1107460367)
		+ W(2, -1106165874, -1089903413, 1036166247, -1100423414)
		+ W(3, -1093491554, 1049835542, -1095323722, -1110396954) + W(4, 1050401361, 1041332866, 1049384898, 1037380859)
		+ W(5, 1052388787, 1034784425, 1031952854, 1050882791) + W(6, -1113250117, 1023742249, -1130552842, -1120158506)
		+ W(7, 1037333727, -1103514783, 1037170040, -1114330639);
	sum2 = W(0, -1112500393, 1028289272, 1049127312, 1086771603) + W(1, 1048088739, 1020087240, 1014851096, -1146529543)
		 + W(2, 1024557142, -1165623582, -1095250820, -1062269001)
		 + W(3, -1095068995, 999933935, -1135945992, 1025716258)
		 + W(4, -1136367764, 1035333264, -1114028070, -1087155359)
		 + W(5, 1022077560, 1034746908, -1120864651, -1127622484)
		 + W(6, 1020782048, -1122738507, 1025362120, 1034731082)
		 + W(7, -1125007838, -1120796207, 1026594640, -1128255426);
	WS(1063806286, 1027083983);
	sum1 = W(0, -1114823180, 1030313470, -1111791457, -1111977289)
		 + W(1, -1108043857, 1019729830, -1114640622, 1033983240) + W(2, 1045480194, 1039206373, 1061885616, 1050451993)
		 + W(3, 1057912708, 1036575619, 1039765761, 1034424532)
		 + W(4, -1118427516, -1106496703, 1010686340, -1083830979)
		 + W(5, -1099420545, -1105267089, -1131920190, -1125840468)
		 + W(6, -1109705966, 1020453816, -1103432478, 1039658735)
		 + W(7, -1114670584, -1109909656, -1113587473, -1112770081);
	sum2 = W(0, 1033978022, -1100194899, 1033701105, 1050426550)
		 + W(1, -1104028404, 1034191613, -1141130302, 1010895851)
		 + W(2, -1122290634, -1091664523, -1071413373, 1075108998)
		 + W(3, 1062092502, -1103668501, 1034149895, -1140709165)
		 + W(4, 1016780797, -1103111994, 1047766898, -1096749849)
		 + W(5, 1027350687, -1131589290, -1131724600, 1027888251)
		 + W(6, -1164938552, 1002490582, -1105595809, 1051489664)
		 + W(7, -1108336227, 1021076655, -1149103768, -1131210373);
	WS(1058288590, 1045994186);
	sum1 =
		W(0, 1018135640, -1123855059, 1040223430, -1112801779) + W(1, 1036317947, -1098800665, 1034707665, -1096517871)
		+ W(2, -1093342072, -1096797372, -1086390197, -1105293320)
		+ W(3, -1091216419, -1117054299, -1096209979, 1023470716) + W(4, 1052167946, 1041780692, 1052872019, 1059840396)
		+ W(5, 1051866430, 1050341107, 1048652350, 1050625648) + W(6, 1038262801, 1015346466, -1132654257, -1134794696)
		+ W(7, -1117665797, 1012611090, -1139713758, 1010858330);
	sum2 = W(0, 1041114210, -1099284356, 1038292116, -1092208278)
		 + W(1, 1054381469, -1104534119, 1025804573, 1033400256)
		 + W(2, -1099008397, 1047276236, -1081084758, -1071665325)
		 + W(3, 1054365119, 1081581342, 1062322644, -1093538640)
		 + W(4, -1123917868, -1111523652, 1037708884, -1086778305)
		 + W(5, -1101037019, 1026238413, -1134916894, 1052085127)
		 + W(6, -1125418381, -1120564910, 1020505319, -1100128811)
		 + W(7, 1024474915, -1125603475, 1025011807, -1103707544);
	WS(-1088887374, 1070119449);
	sum1 = W(0, 1040460421, 1041554590, 1013850612, 1038262022) + W(1, 1042710919, -1106869091, 1044864290, 1046057615)
		 + W(2, 1052058645, 1048371361, 1048732808, 1042754705) + W(3, 1047384127, 1054439312, 1032508990, 1042772520)
		 + W(4, -1090595183, -1115426747, -1094790815, -1087902678)
		 + W(5, -1106656361, -1090477876, -1122940954, -1091795237)
		 + W(6, -1105506686, 1029097335, -1129317061, 1001782464)
		 + W(7, 1038072126, -1131475029, 1028935005, -1119515740);
	sum2 =
		W(0, 1024604999, -1112923336, 1027433809, 1025504127) + W(1, 1007245204, -1144581942, -1129047399, 1021294865)
		+ W(2, 1056461606, 1030035123, 1050727550, -1090534096)
		+ W(3, -1105339223, -1095507508, 1043793174, -1095638178) + W(4, 1071685965, 1066713447, 1068313262, 1028028856)
		+ W(5, -1081367671, -1078816510, -1081156501, -1090770344)
		+ W(6, -1075212110, -1080779344, -1078194918, -1153515923)
		+ W(7, 1068056044, 1069903211, 1064173276, 1060536751);
	WS(1040470840, 1011790950);
	sum1 = W(0, 1015095158, -1120734562, -1116691398, -1118217942)
		 + W(1, 1019898057, -1123629847, 1034607368, 1041822001) + W(2, 1043725275, 1051465082, 1058372660, 1055309890)
		 + W(3, 1046636817, 1044874098, 1043010193, 1040878843)
		 + W(4, -1105535856, -1108441440, -1095343471, -1081260869)
		 + W(5, 1047492563, -1093096561, -1105294873, -1106259483)
		 + W(6, -1108386992, 1030149375, -1112701741, 1026499745)
		 + W(7, 1032201014, -1115283258, 1028457510, -1112399171);
	sum2 = W(0, 1022830461, 1021246145, 1015115055, -1114703004) + W(1, -1120910531, 1015720307, 983370825, -1123770073)
		 + W(2, -1117997331, -1110014342, -1111993293, 1036613835)
		 + W(3, 1023720090, -1117604953, -1120463052, 1036937497)
		 + W(4, 1037270083, -1125616185, 1044158772, 1073620398)
		 + W(5, -1076883688, -1087890801, 1025754476, -1113287589)
		 + W(6, 1023767946, -1130403951, 1025796328, 1050812248)
		 + W(7, -1112499600, 1028283916, -1104874229, 1033737696);
	WS(1058309838, -1101980246);
	sum1 = W(0, -1118965337, -1098779704, 1049071256, -1113399754)
		 + W(1, 1026571427, -1110569018, -1131332475, -1128371676)
		 + W(2, -1110907254, 1049643561, -1081904943, 1042163763)
		 + W(3, 1052138696, -1106220306, 1025191299, -1129449041) + W(4, 1038642111, 1038999679, 1054751182, 1056093093)
		 + W(5, -1083956910, 1050507993, -1146247429, 1030864044)
		 + W(6, 1028903966, -1108240479, 1040887994, -1118832415)
		 + W(7, 1046797612, -1104697276, -1123883748, 1017502086);
	sum2 = W(0, -1137655511, 1043191716, -1121349336, -1097517035)
		 + W(1, 1046822141, -1129223371, -1116759551, -1124684976)
		 + W(2, -1111106723, 1033166752, 1033268708, 1052576386) + W(3, -1107318253, -1102887232, 1040601750, 993535634)
		 + W(4, 1035105104, -1112822728, -1104857525, 1055574555)
		 + W(5, -1114990789, -1121581721, -1152414880, -1107957817)
		 + W(6, -1112318930, 1027572041, 1035699332, -1097542777)
		 + W(7, -1110157019, 1031007843, -1157281192, 1025775603);
	WS(1063710542, -1111213649);
	sum1 = W(0, 1039559517, -1110192145, -1107309859, -1118762901)
		 + W(1, -1108199122, 1037245627, -1139769966, 1035326852) + W(2, 1052251350, 1049489370, 1058328276, 1061120005)
		 + W(3, 1049656673, 1033876357, 1041987905, 1045428971)
		 + W(4, -1101160384, -1097695264, -1093740712, -1096321197)
		 + W(5, -1097289639, -1114972772, -1102516745, -1103522251)
		 + W(6, -1113889808, 1031901152, -1104513406, -1097003636)
		 + W(7, -1112381384, -1176476024, 1022802380, -1115185874);
	sum2 = W(0, 1026803387, 1021750253, 1040812059, -1107480079) + W(1, 1041131835, -1115082464, 1006187407, 1001155939)
		 + W(2, -1115186477, 1031459540, -1116326399, 1040651083)
		 + W(3, 1020594503, 1033768858, -1132516997, 1015478283) + W(4, 999853755, 1031446318, 1058720440, 1071698983)
		 + W(5, 1051128601, 1034660038, 1027131696, 1041372466)
		 + W(6, -1112425236, -1106593609, -1086524651, -1075753828)
		 + W(7, -1096266051, -1108942599, -1123360193, -1104453127);
	WS(1039772272, -1082982873);
	sum1 = W(0, 1039127452, -1106264016, -1104546353, -1145518233)
		 + W(1, 1041713673, 1044410893, 1039725795, 1007790526) + W(2, 1049032497, 1053169593, 1060522592, 1056693961)
		 + W(3, -1095982984, -1088607916, -1099512929, -1120546088)
		 + W(4, -1098139952, -1088020664, -1087153807, 1038834197)
		 + W(5, 1053429837, 1048228018, 1030077856, -1130616150)
		 + W(6, -1155633625, 1043520647, 1040400554, -1139907193)
		 + W(7, -1104883452, -1103034636, -1134131855, 1012687882);
	sum2 = W(0, 1032987173, -1102803435, -1097110538, -1101871105)
		 + W(1, -1101555589, -1123533577, -1098769512, 1048796624)
		 + W(2, -1092902636, 1037122437, -1083842457, 1067610414) + W(3, 1033006847, 1041814167, 1045724867, 999019252)
		 + W(4, 1027660911, 1039508875, -1115097563, 1067552095)
		 + W(5, -1096151174, 1026567371, -1107225085, -1105667947)
		 + W(6, 1032111389, -1101516234, 1001644292, -1104358647)
		 + W(7, -1145661076, -1104681426, 1020958965, 1028203943);
	WS(-1101412664, 1073047832);
	sum1 = W(0, -1113880945, -1123950537, -1109995975, -1123565085)
		 + W(1, -1123728428, 1035385983, -1115318676, 1010675502) + W(2, 1059007377, 1047579477, 1060416389, 1056063051)
		 + W(3, 1046383171, 1040643140, 1033389702, 1041003725)
		 + W(4, -1091904865, -1097814305, -1087199740, -1092124214)
		 + W(5, -1099567891, 1038341800, -1119557930, 1042882861)
		 + W(6, -1133362719, -1131741454, 1032803377, -1113780884)
		 + W(7, -1113889390, -1126485237, 1012558775, -1096461162);
	sum2 = W(0, 1013686761, -1123503757, 1035262859, -1115490710)
		 + W(1, 1025861040, 980681483, -1125276038, -1129892230) + W(2, 1030949359, 1039110679, -1105775253, 1027204409)
		 + W(3, 1019519396, -1111394964, 1024413043, -1126757058)
		 + W(4, -1109223248, 1035635962, -1106751414, 1057425426)
		 + W(5, 1043312829, -1098000154, 1051287795, -1103421662) + W(6, -1132915573, 996209923, 1029135163, 1070858778)
		 + W(7, 1067133266, -1098902818, -1083268694, -1073095921);
	WS(-1103532344, -1105840701);
	sum1 = W(0, -1106756472, -1106322913, 1029810954, -1096389739)
		 + W(1, -1116067305, 1035916925, -1105566449, 1034505108)
		 + W(2, -1105825052, 1053932942, -1086676361, -1098358914)
		 + W(3, 1054020609, -1096691570, 1051257001, 1026552303) + W(4, 1050195304, 1007328528, 1057202097, 1054492326)
		 + W(5, -1093369370, 1012599092, 1027855335, -1101687900)
		 + W(6, 1044840709, -1104890465, -1144507642, -1098185309)
		 + W(7, 1032208700, 1048715303, -1100267787, 1050640157);
	sum2 = W(0, -1111707317, -1119262447, 1037989791, 1056036881)
		 + W(1, -1105645897, 1006194414, -1146663095, -1129479912)
		 + W(2, -1101137684, -1109186725, 1049211868, -1099242284)
		 + W(3, 1038198606, -1118866635, -1109483964, -1114787638)
		 + W(4, -1116414033, -1107841286, 1056722210, -1094543747)
		 + W(5, 1053421235, -1104714858, -1120693058, -1115357885)
		 + W(6, -1103752872, 1034593530, -1110917586, 1049861706)
		 + W(7, 1030171051, -1103907620, 1032413269, 1029169157);
	WS(1045178680, -1115117954);
	sum1 = W(0, -1102680211, -1123018420, -1116849368, 1024407336)
		 + W(1, -1107241006, 1026392201, -1107918421, -1123314455)
		 + W(2, 1048681528, -1113607536, -1092105355, -1093530556)
		 + W(3, -1096193779, -1102060551, -1102337510, -1095199752)
		 + W(4, 1019008549, 1040296293, 1035615004, 1061339424) + W(5, 1057711678, 1055864515, 1045891981, 1052562824)
		 + W(6, 1008490315, 1012835273, 1027033246, -1128145511)
		 + W(7, -1103222073, -1110547491, -1110097884, 1020395952);
	sum2 =
		W(0, -1108321996, -1115537892, -1106228104, 998645667) + W(1, -1112292909, 1035781218, -1111036660, 1018530825)
		+ W(2, -1096948503, -1104693583, 1047339287, 1055675007)
		+ W(3, 1049114511, -1100682049, 1032758858, -1113969306)
		+ W(4, -1112108000, -1112710060, -1126080161, 1051246853)
		+ W(5, 1041989299, 1025978716, 1034053890, -1113712936) + W(6, 1026091852, 1022753169, -1120501740, -1105262859)
		+ W(7, -1123292948, -1139782977, -1111667328, 1033000622);
	WS(1044590904, 1058699692);
	sum1 = W(0, 985175380, 1034192409, 1020554347, 1024014533) + W(1, -1115433194, -1128687821, 1008304190, -1115445028)
		 + W(2, -1092606720, -1090621088, -1093618783, -1113905855)
		 + W(3, -1096920415, -1112503613, -1100279725, -1101027255)
		 + W(4, 1051210502, 1050384326, 1055009987, 1062574818) + W(5, 1054554325, 1031218808, -1105751509, -1144235755)
		 + W(6, 1009220799, -1109361592, -1117059707, -1128567457)
		 + W(7, 1015981863, 1039114097, -1127205548, 1035507338);
	sum2 = W(0, 1036009101, -1117283755, 1033667347, -1107239966)
		 + W(1, 1034685217, -1128406639, -1123321687, -1125402335)
		 + W(2, -1108619644, 1041337919, 1012813669, 1053310286)
		 + W(3, -1103814148, 1029066827, -1109499964, -1123197815)
		 + W(4, 1010492213, -1100684466, 1015579759, 1056064408)
		 + W(5, 1050883237, -1113069964, -1098878001, -1096911819)
		 + W(6, -1131279719, 1035041542, -1124020763, 1025470531)
		 + W(7, 1032198922, -1104788458, 1024066141, -1108347132);
	WS(1044030776, -1089132931);
	sum1 = W(0, 1034269487, 1032883970, 1042439154, 1044751430) + W(1, 1019707982, 1041434446, -1133288904, -1128708109)
		 + W(2, -1093699058, -1097458090, -1086092656, -1078975458)
		 + W(3, 1035194756, 1038040390, -1131544335, -1101499019)
		 + W(4, 1045160768, 1050995424, 1057188990, -1096290982) + W(5, 1032938655, 1043682915, 1022768458, 1043305900)
		 + W(6, 1040395197, -1135242887, 1040422743, 1048952172) + W(7, 1042217766, 1043586045, 1029073256, 1044718778);
	sum2 = W(0, 1043294282, -1127265324, 1035036911, 1051203976)
		 + W(1, -1092441683, 1037063919, -1095318743, -1096741875)
		 + W(2, -1107262777, -1107127922, 1048700262, -1114081637)
		 + W(3, 1027047222, -1087538045, 1043898666, -1114635611)
		 + W(4, -1132728616, -1133435576, -1115280193, 1060204569)
		 + W(5, -1096051714, 1059699424, -1091030613, 1057805441)
		 + W(6, -1112978295, -1101649503, -1142433873, -1138065032)
		 + W(7, 1049542158, 1027406094, 1036599707, -1117298502);
	WS(-1083489614, -1078579141);
	sum1 = W(0, -1113694287, 1048897616, -1104500498, 1029397720)
		 + W(1, 1039983475, -1099529286, 1047818144, -1100400745)
		 + W(2, -1091060438, -1104759380, -1089217572, -1096433234)
		 + W(3, -1090900481, -1103761763, -1126261903, -1098862766)
		 + W(4, 1048678744, 1055607032, 1025763911, 1056656214) + W(5, 1055730826, 1039576037, 1050842685, 1044462332)
		 + W(6, 1022130309, 1045345264, -1098656951, 1045280313)
		 + W(7, 1003335600, -1104729181, 1045845834, -1124798927);
	sum2 = W(0, 1034867092, 1036831152, -1155378720, 1050005016)
		 + W(1, -1109019109, -1107857756, 1025727369, -1105627363)
		 + W(2, -1113896283, 1008734783, -1107821706, 1036439980)
		 + W(3, -1105188391, -1103852014, -1113326142, 1036502992)
		 + W(4, -1089397746, -1143881728, -1090933436, 1067046868)
		 + W(5, 1074023168, 1073004488, 1071596064, 1068047188) + W(6, 1053130734, 1048547317, 1050664536, -1081990202)
		 + W(7, -1073616958, -1073650181, -1078582463, -1079035066);
	WS(-1123566816, -1118788492);
	sum1 =
		W(0, 1034266605, -1136553988, 1032767842, -1119057557) + W(1, 1032596498, -1138237144, 1034235800, 1038972738)
		+ W(2, -1131696345, 1054570946, 1043367745, 1057910725) + W(3, 1051309065, 1050053561, 1044754161, 1047609962)
		+ W(4, -1102436480, -1101485920, -1093672570, -1081257723)
		+ W(5, -1104247863, -1097237249, -1100737384, -1118734125)
		+ W(6, 1029920799, 1027694719, 1029228634, 1038070160) + W(7, 1041012541, -1104490509, 1036672371, -1101643609);
	sum2 = W(0, 1001205015, 1006355343, 1030505158, -1119701641)
		 + W(1, 1039794598, -1107202062, 1026836118, -1115440174)
		 + W(2, -1108935456, 1048575251, -1114918170, -1088419213)
		 + W(3, 1032736312, 1045905661, -1116946341, 1003805295)
		 + W(4, -1123729961, 1037564428, -1096130861, -1068662368)
		 + W(5, 1076967646, 1068403675, -1104305708, -1124006983)
		 + W(6, -1151981614, -1123825361, 1015236500, -1095410362)
		 + W(7, 1049774729, -1105335733, 1050153445, -1103176791);
	WS(-1103567160, 1051728620);
	sum1 = W(0, 1022317012, -1105517764, -1109296554, 1030946149)
		 + W(1, 1032988986, -1117957958, 1025729823, 1009731405) + W(2, 1037463598, 1027268637, 1052072875, -1094107172)
		 + W(3, -1087396213, -1098739651, -1104965205, 1017302004)
		 + W(4, -1094952698, -1107670055, -1103880757, 1052944567)
		 + W(5, 1057943536, 1052382091, 1036164793, 1041821631) + W(6, 1033922872, 1024776175, 1038888053, 1043766492)
		 + W(7, -1110506946, -1108829569, -1132271979, 1015545129);
	sum2 =
		W(0, 1031290011, -1114551402, -1137203270, 1025723227) + W(1, 1020823723, -1107112701, -1156747895, -1140368490)
		+ W(2, -1127050317, 1026829489, 1032334734, -1098446681) + W(3, 1041359246, 1041376772, 1034398482, -1104694439)
		+ W(4, -1113481669, 1042490649, 1043198364, -1127701979)
		+ W(5, 1057793899, -1100591458, -1114292550, 1037536680)
		+ W(6, -1080536402, -1076466135, 1038797044, 1074254195)
		+ W(7, 1035340712, -1118262367, 1013380262, 1032104302);
	WS(-1106439480, 1029090439);
	sum1 = W(0, 1034559195, -1151887836, 1020849475, 1042053132) + W(1, 1043127920, 1043814293, 1037260390, 1043715864)
		 + W(2, 1042655458, 1030625962, 1059377738, -1084013087) + W(3, -1107145304, 1032281331, 1040913704, 1033172451)
		 + W(4, -1102396839, -1115609614, -1089162129, -1083731653)
		 + W(5, 1052971191, -1107154457, -1113717087, 1017680531) + W(6, 1026400220, 1035325646, 1042909598, 1039293086)
		 + W(7, 1029716960, 1024778063, 1028666946, -1130742978);
	sum2 = W(0, -1129107524, -1123636938, -1116921954, 1035143287)
		 + W(1, 1036996009, 1026655402, -1117010042, -1126794884)
		 + W(2, 1021999108, -1148550480, -1104180688, 1058583951)
		 + W(3, -1112895549, -1116180274, -1131502740, -1138164712)
		 + W(4, 1022835844, 1016982596, 1016773924, 1054454385)
		 + W(5, -1097314323, -1099699990, -1132536424, -1129763396)
		 + W(6, -1129901940, -1140398984, 1030858450, -1117386658)
		 + W(7, -1108156993, -1118751234, 1016259828, -1117013506);
	WS(1048151864, 1059242544);
	sum1 = W(0, -1122367849, -1121466768, 1042165293, -1116044868)
		 + W(1, -1105437493, 1037358179, -1125163356, -1111398955)
		 + W(2, -1097114939, -1097911384, -1085899247, 1042506911)
		 + W(3, 1056857214, -1105063934, -1123578292, -1106114902)
		 + W(4, 1043794348, 1033810391, 1063564267, 1042284551) + W(5, -1089674786, 1049648847, 1021855394, 1045389303)
		 + W(6, 1026875087, 1014185912, -1106211614, -1111561384)
		 + W(7, 1040868541, 1028107682, -1111395274, 1010402126);
	sum2 = W(0, -1139648101, -1108856547, 1015236663, -1095822659)
		 + W(1, -1137977893, 1038373686, 1015865663, 1025690243) + W(2, -1110557326, 1041627874, 1032833232, 1054902128)
		 + W(3, -1098765424, -1121592121, -1106594443, -1117564251)
		 + W(4, -1106733442, -1106727608, 1048813377, 1055403310)
		 + W(5, -1097123375, 1045561320, -1106386080, 1017823319) + W(6, 1039330638, 987619817, 1025349119, -1095503796)
		 + W(7, 1050144719, -1108448514, 1041979856, -1105901385);
	WS(1058511566, 1043187024);
	sum1 = W(0, 1042620242, 1027981614, 1037513401, 1050564856) + W(1, 1040390932, 1044188393, 1032851398, 1043046140)
		 + W(2, 1041476871, 1044640335, 1039039385, -1085132912)
		 + W(3, -1095196494, -1116362934, -1107832665, -1105825814)
		 + W(4, -1106861387, -1120607404, -1101062960, -1089194338)
		 + W(5, 1032203084, -1134658518, 1026497359, -1105488567) + W(6, 1043942651, 1040914531, 1040902562, 1048598306)
		 + W(7, 1019897185, 1032634704, 1027555603, 1032742569);
	sum2 =
		W(0, -1094808435, -1132385524, -1110994277, 1039748829) + W(1, 1038866141, 1012861192, 1030487914, -1132742376)
		+ W(2, -1083260450, -1089624726, -1098133391, 1063143581) + W(3, 1043371703, 1040218148, 1012758152, 1052570990)
		+ W(4, 1041967320, -1102801635, 1050258559, 1037743779) + W(5, 1048943341, -1112998265, 1031702418, -1105604919)
		+ W(6, 1026111290, 1034887813, -1123786474, 1033106845)
		+ W(7, -1110363077, -1121754906, 1012203560, -1111765769);
	WS(-1087236686, 1061665912);
	sum1 = W(0, -1115274057, -1116162424, -1104461343, -1093387666)
		 + W(1, -1113556238, -1115159031, -1126942285, -1121543315)
		 + W(2, 1023071688, 1030200068, 1054050807, 1067462106) + W(3, 1050597447, 1031104576, -1121547516, 1042315272)
		 + W(4, -1107980923, -1101866270, -1092884195, 1056570668)
		 + W(5, 1044256537, -1106234576, -1128835891, -1114796114)
		 + W(6, -1119301463, -1128116268, -1109238785, -1095571507)
		 + W(7, -1103733247, -1111522325, -1111458030, -1109780718);
	sum2 =
		W(0, -1127633710, 1024854732, -1123781128, 1040493279) + W(1, -1105896535, 1033983514, -1122459292, -1120616672)
		+ W(2, 1024134807, 1020748524, -1117094752, 1065417820) + W(3, 1047826025, -1102101577, 1040101538, -1124130304)
		+ W(4, -1114424195, -1098546148, -1079772750, 1059484680)
		+ W(5, -1107504040, 1049649199, -1105983778, 1041220419)
		+ W(6, -1109129714, 1025355297, -1102118069, -1114766469)
		+ W(7, 1033237727, -1154145757, 1012710689, -1123999628);
	WS(-1092106140, -1084163121);
	sum1 = W(0, 1036347305, 1016904817, 1034414494, 1040590819) + W(1, 1047670567, 1030378702, -1114654031, 1037868673)
		 + W(2, 1049849489, 1040213041, 1056746079, 1048812489) + W(3, -1084779712, 1040726752, 1033236350, 1034988241)
		 + W(4, -1101083230, -1152694122, -1083169173, -1107117385)
		 + W(5, 1051667767, -1109066592, 1024925978, -1107106473)
		 + W(6, -1106738110, -1115216475, 1039797369, 1022569263)
		 + W(7, -1112982247, -1125038036, 1025136605, -1146668256);
	sum2 = W(0, -1144361879, -1128843246, 1005924247, -1104940693)
		 + W(1, -1123234701, 1030348431, 1032437115, 1024671661)
		 + W(2, -1111008682, -1134810723, 1041181160, 1054697191)
		 + W(3, 1052731012, 1042931729, -1112071203, -1111460488)
		 + W(4, -1092072719, -1121102479, 1045581242, 1046555600)
		 + W(5, -1103970223, -1104348933, -1113690885, -1129885552)
		 + W(6, 1021883158, -1116668390, -1109114373, -1113715104)
		 + W(7, -1128555074, 1032936433, -1136719027, -1114960949);
	WS(1058637774, -1109876822);
	sum1 =
		W(0, -1123254812, 1041301297, -1108082435, -1113241451) + W(1, -1110973875, 1027216056, 1014894339, 1019588394)
		+ W(2, 1042623060, -1105094644, 1059472952, 1043969956) + W(3, -1113269955, 1026816394, -1130602892, 1026167148)
		+ W(4, -1126486401, -1111052512, -1094910408, -1094009726)
		+ W(5, 1058531737, -1100061186, 1032486130, -1117291247) + W(6, -1112485473, 1037949088, 1016105496, 1038892497)
		+ W(7, -1093047519, 1032398170, -1128303438, 1021704844);
	sum2 =
		W(0, 1019183838, 1031923668, 1049015983, -1096362417) + W(1, 1005830618, 1036998273, -1119396253, -1125844722)
		+ W(2, -1103677237, 1026573624, -1101357077, 1060010174) + W(3, -1122620605, -1106684685, 1023743335, 970656667)
		+ W(4, 1041385745, 1025625867, -1095136476, -1096248497)
		+ W(5, -1115221092, 1049273019, -1112424814, 1011280453)
		+ W(6, -1115238116, 1024201143, 1024442030, -1122837727) + W(7, 1034369966, 1031554545, 1004099770, 1010302645);
	WS(1068382951, -1145853862);
	sum1 = W(0, -1109092968, -1120835030, 1015957108, 1033165317)
		 + W(1, 1015780402, -1098982451, -1106789039, -1105810191)
		 + W(2, -1104283584, -1104742016, -1087137628, -1082841532)
		 + W(3, 1048723479, -1119342334, 1037068029, 998682871) + W(4, -1126224104, 1048835390, 1060142968, 1050512116)
		 + W(5, 1050625794, 1046183055, 1033167819, 1042826568) + W(6, -1142984099, 1035504970, 1044651720, 1036256010)
		 + W(7, 1040271692, -1112268532, -1115364877, -1113754717);
	sum2 =
		W(0, 1042289605, -1123754179, 1040865617, 1025996190) + W(1, -1100913998, -1118459936, -1114401734, -1118182115)
		+ W(2, -1105845074, 1032442894, -1090127653, 1055606718) + W(3, -1104101067, 1026136504, 1031986833, 1045409779)
		+ W(4, -1105090355, -1106552079, -1075116096, 1073431719)
		+ W(5, 1067916428, 1042119939, -1112990087, 1031635830) + W(6, 1041479887, 1028813354, -1087510643, -1084272058)
		+ W(7, 1045036562, -1131666845, 1021173748, -1131440550);
	WS(-1115823328, -1115141930);
	sum1 = W(0, 994860217, 1043355533, 1046651158, 1031967699) + W(1, -1112906011, -1139800861, 1032268536, 1021673189)
		 + W(2, -1096937968, -1093401724, -1082957735, 1057829358)
		 + W(3, 1054780763, 1049387203, 1029694230, 1032667294) + W(4, 1034643656, 1045563268, 1056739037, 1053028032)
		 + W(5, -1085595451, -1100812438, -1112691098, -1163065290)
		 + W(6, 1022968545, -1100277972, -1106135459, -1113373017)
		 + W(7, 1036473238, 1042166401, -1109328859, 1026417494);
	sum2 = W(0, 1041009418, -1106230161, -1113994011, -1100787264)
		 + W(1, -1102450993, -1114680808, 1031764893, -1145068408)
		 + W(2, 1006794492, 1034312638, -1108126219, 1060460225)
		 + W(3, -1119222967, -1097084093, -1125377404, -1105852265)
		 + W(4, 1023178506, -1120362931, -1105213924, 1054015707)
		 + W(5, 1053508358, -1133314452, -1141774536, -1120752408)
		 + W(6, -1126244586, 1021996758, -1131146954, 997147503)
		 + W(7, -1107185372, -1126416406, -1126617106, -1131039214);
	WS(1044911928, 1063248560);
	sum1 =
		W(0, -1117210934, 1045807559, -1116245664, -1122601008) + W(1, 1041679280, -1102494868, 1044187563, -1101059428)
		+ W(2, -1089987573, 1006551364, -1085623154, -1098705597)
		+ W(3, -1089608778, -1098692501, 1040126000, -1100421777) + W(4, 1050931427, 1049202419, 1044690392, 1056494849)
		+ W(5, 1054654497, 1047881833, 1043119951, 1043071666) + W(6, -1154913199, 1049427019, -1098224261, 1043742399)
		+ W(7, 1009817082, -1102952115, 1048685800, -1132265536);
	sum2 = W(0, -1110897864, -1104703066, 1039476246, -1102025112)
		 + W(1, 1041770976, 1044782005, -1112640404, 1045848501)
		 + W(2, 1031814971, -1126406622, -1112535334, -1088994686)
		 + W(3, 1050082866, 1038057456, 1029663347, -1098794387) + W(4, 1060526454, 1034850394, 1060516426, -1088701567)
		 + W(5, -1072347435, -1075073775, -1077197270, -1081012351)
		 + W(6, -1090228093, -1097166620, -1091926928, 1063814816)
		 + W(7, 1074296249, 1073862535, 1067261757, 1067785227);
	WS(-1105546040, 1026157880);
	sum1 = W(0, 1040950836, 1036866652, 1045419231, 1057171433) + W(1, 1039696013, 1040737235, 1031337694, 1043417390)
		 + W(2, 1040614249, 1043435937, 1048836647, -1092874056) + W(3, 1049109967, 1037560064, 1039556030, 1020658754)
		 + W(4, -1102499357, 1032157499, -1088963702, -1078642173)
		 + W(5, -1094603626, 999044599, -1107844556, -1101965321) + W(6, 1036650571, 1032871003, 1035867609, 1040635958)
		 + W(7, 1039966133, 1035782037, 1034875342, 1029450491);
	sum2 = W(0, 999804672, 965076992, 1017997216, -1113573416) + W(1, 1015814944, 1013150208, 1004325632, -1116017408)
		 + W(2, 1033414560, -1142972544, -1117537424, -1080122522)
		 + W(3, -1116987776, 1009041344, 1030258512, -1123867424)
		 + W(4, -1131242272, -1152459008, 1043660652, 1068973644)
		 + W(5, -1113471168, 1023678672, -1115573696, 1025739248)
		 + W(6, -1111239120, -1114613368, 1024438240, 1009242816)
		 + W(7, 1026341216, -1111376032, -1124670336, 1011147520);
	WS(-1081027239, 1060388068);
	sum1 = W(0, 1040945153, 1018532824, 1048158700, 1050078256) + W(1, 1043330564, 1045983912, 1034126717, 1042366848)
		 + W(2, 1049191505, 1052335227, 1053224518, -1089652372) + W(3, 1050009062, 1019623144, 1043374892, 1037373643)
		 + W(4, -1103567931, -1106690587, -1098210230, -1079677805)
		 + W(5, -1090769236, -1102526621, -1113976903, -1106920486)
		 + W(6, -1142725077, -1126830164, 1044049241, 1037048166)
		 + W(7, 1037549983, -1124021470, 1031972104, 1000910717);
	sum2 = W(0, 1029289565, 1023484285, 1041097307, 1044843621)
		 + W(1, -1101664529, -1108647964, -1111945130, -1129898257)
		 + W(2, -1119356133, 1031916514, -1120749829, 1057057740)
		 + W(3, 1055633817, -1098024997, 1038083406, -1101101054)
		 + W(4, -1126159585, -1111485988, -1121314077, 1024531885)
		 + W(5, -1102656055, 1016983721, -1105960100, 1022769465)
		 + W(6, -1119814653, -1133461586, -1112201820, 1001931237)
		 + W(7, 1035253182, 1019582313, 1011319026, -1110859200);
	WS(-1121436896, -1083449266);
	sum1 = W(0, -1131437006, -1126965659, -1106898372, 1049661628)
		 + W(1, -1110051320, 1048826500, 1018834023, 1030351624) + W(2, 1057845458, 1026072602, 1058188821, 1047051462)
		 + W(3, 1036301673, 1049513187, 1026266705, 1043516478)
		 + W(4, -1096100393, -1106937331, -1089458543, -1093909527)
		 + W(5, -1105302990, -1097831955, -1115312055, -1094725407)
		 + W(6, -1112818966, 1025271436, -1120770471, 1039868950)
		 + W(7, -1101852248, 1048680544, -1111779257, -1137214404);
	sum2 = W(0, 1025140224, 1016993788, -1106156741, -1085967118)
		 + W(1, -1070014283, -1066270592, -1089828448, -1115300709)
		 + W(2, -1118806788, 1030590564, 1042721449, 1078987048) + W(3, 1078555235, 1069325982, 1051485796, 1026006822)
		 + W(4, -1126785121, -1118559458, -1106137914, -1100137345)
		 + W(5, 1044823121, -1105174392, -1121082393, 1011662011) + W(6, 1031495588, 991152164, 1038491925, 1040984057)
		 + W(7, -1111978905, 1030579932, -1113499951, -1120641633);
	WS(1060473294, -1125032523);
	sum1 = W(0, -1118381578, -1131528546, -1103035725, 1044891665)
		 + W(1, 1017562024, 1038728371, 1013193724, 1017619335) + W(2, 1043924207, 1048790648, 1057928103, -1096003632)
		 + W(3, -1104437021, -1127678449, -1138265298, 1019650740)
		 + W(4, 1028842287, -1094915206, 1048586166, -1089668066)
		 + W(5, 1048997587, -1106021950, 1016196772, -1112334062)
		 + W(6, -1103983036, 1032416951, -1131359957, 1041536420)
		 + W(7, -1119623443, 1026802338, -1112764523, 1028850580);
	sum2 = W(0, -1124013145, -1154979909, -1113455493, 1042673063)
		 + W(1, 1009341589, -1131887235, -1126494367, -1120394460)
		 + W(2, 1023871771, -1104183315, 1024353365, -1099433949)
		 + W(3, 1037029004, -1106752952, -1136822537, -1135604889)
		 + W(4, 1041717973, -1104961174, -1071159846, 1075222357)
		 + W(5, 1061754151, -1106459992, 1037905746, 1020599743)
		 + W(6, 1027246941, -1105906795, -1114760758, 1048045634)
		 + W(7, -1101645527, 1027783079, -1130069351, 1023779471);
	WS(1063175758, 1049951270);
	sum1 = W(0, 1051934199, 1041620825, 1053157077, 1019501037) + W(1, -1121035141, 1024394007, 1034798936, 999909159)
		 + W(2, -1084051495, -1091045702, -1089200998, -1103613676)
		 + W(3, -1103906809, 1042850683, -1117239270, -1106705027)
		 + W(4, 1040719576, 1046456792, 1054477181, 1050464826)
		 + W(5, -1098419444, -1097805325, 1011564046, -1091232034)
		 + W(6, 1028219745, 1028165760, -1110307566, 1037889601) + W(7, 1045652053, 1054554722, 1031152711, 1056053333);
	sum2 =
		W(0, -1091471926, 1042259987, -1103057728, 1049412228) + W(1, 1044973062, -1116401558, 1011000463, -1130123924)
		+ W(2, 1062079447, -1095572989, -1089203271, -1092861102)
		+ W(3, 1034556296, 1047552828, -1110031497, 1051271629) + W(4, 1055700238, 1041645665, 1037140407, -1093629070)
		+ W(5, -1095940003, -1106623325, -1107294450, 1053844390) + W(6, 1015596856, 1033532620, 1035045090, 1042934527)
		+ W(7, 1032040702, -1106239816, 1033073048, -1095799213);
	WS(-1085388366, -1090694979);
	sum1 = W(0, -1123787314, -1119481145, 1032777214, -1112850502)
		 + W(1, 1041751591, -1125429276, -1140788444, -1113892940)
		 + W(2, 1044273497, -1130943626, 1047368143, 1059845268) + W(3, -1095680144, 1039407200, 990533574, 1032644049)
		 + W(4, -1108110651, 1041576542, -1087220302, 1027588771)
		 + W(5, 1036323946, -1111657568, 1021334836, -1143449895)
		 + W(6, -1115475932, -1117135031, 1040347561, -1101064470)
		 + W(7, 1037523789, -1126225621, -1134357621, -1109271006);
	sum2 = W(0, -1107190004, 1013881877, -1118295314, -1121103222)
		 + W(1, -1127822751, -1115317828, -1126179247, -1114801766)
		 + W(2, 1037736456, -1105376838, -1123416196, 1042717593)
		 + W(3, -1115549939, 1043660085, -1126402007, 1040920849)
		 + W(4, -1125693587, 1040619572, -1082924015, 1068021664)
		 + W(5, 1016978358, -1108863865, -1136349779, -1107267301)
		 + W(6, -1120404934, -1122228614, 1051908042, -1087341114)
		 + W(7, 1042189807, -1125959243, 1038966556, 1023515477);
	WS(1065904679, -1122628785);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[525];

#define CURRENT_PASS 2

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) {
	float2 UV = mul(rgb2uv, INPUT.SampleLevel(sam_INPUT_LINEAR, HOOKED_map(pos), 0).rgb);
	OUTPUT[pos] = float4(mul(yuv2rgb, float3(value.x, UV)), 1.0);
}

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define temp_tex(pos) (float(texture(temp, pos).x))
static const float2 temp_size = float2(GetInputSize().x * 1, GetInputSize().y * 2);
static const float2 temp_pt = float2(1.0 / (temp_size.x), 1.0 / (temp_size.y));

#define HOOKED_tex(pos) temp_tex(pos)
#define HOOKED_size temp_size
#define HOOKED_pt temp_pt

void Pass2(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 15 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 525; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 15, y = (uint)id % 15;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (1)) + 0.5, float(group_base.y + y - (3)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[8];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 4];
	samples[1][1] = inp[local_pos + 5];
	samples[1][2] = inp[local_pos + 6];
	samples[1][3] = inp[local_pos + 7];
	samples[2][0] = inp[local_pos + 15];
	samples[2][1] = inp[local_pos + 16];
	samples[2][2] = inp[local_pos + 17];
	samples[2][3] = inp[local_pos + 18];
	samples[3][0] = inp[local_pos + 19];
	samples[3][1] = inp[local_pos + 20];
	samples[3][2] = inp[local_pos + 21];
	samples[3][3] = inp[local_pos + 22];
	samples[4][0] = inp[local_pos + 30];
	samples[4][1] = inp[local_pos + 31];
	samples[4][2] = inp[local_pos + 32];
	samples[4][3] = inp[local_pos + 33];
	samples[5][0] = inp[local_pos + 34];
	samples[5][1] = inp[local_pos + 35];
	samples[5][2] = inp[local_pos + 36];
	samples[5][3] = inp[local_pos + 37];
	samples[6][0] = inp[local_pos + 45];
	samples[6][1] = inp[local_pos + 46];
	samples[6][2] = inp[local_pos + 47];
	samples[6][3] = inp[local_pos + 48];
	samples[7][0] = inp[local_pos + 49];
	samples[7][1] = inp[local_pos + 50];
	samples[7][2] = inp[local_pos + 51];
	samples[7][3] = inp[local_pos + 52];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 18];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * 2;
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1) + ivec2(1, 0), ret);
}
